"use strict";

import {resizeContainerAndCanvas, BigSlider} from "../../modules/HTMLUtils.js";
import CtxUtils from "../../modules/Context2DUtils.js";
import V2 from "../../modules/V2.js"; 
import {cos} from "../../modules/MathUtils.js";

/**
 * Gráfica de cos(phi) el brillo especular de Phong.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    
    let alpha = 1;
    let controls = document.getElementById("ui-container");
    controls.className = "bottom-box";
    const colorsSlider = ["#4994D0", "#C6C6B2"];
    let shinines_slider = new BigSlider(controls, "α", .1, 300, updateShininess, alpha, .1, colorsSlider);

    var canvas = document.getElementById("canvas");
   
    var origin, axes;
    const NUM_POINTS_CURVE = 100;

    window.addEventListener('resize', draw);
    draw();

    function draw(){
        let scale = 250 * resizeContainerAndCanvas(canvas);
        CtxUtils.clear();
        
        let {width, height} = canvas;
        origin = new V2(.5 * width, .72 * height); 
        axes = { origin: origin, x: new V2(origin.x - scale,  origin.x + scale), y: new V2(0.74 * height, .15 * height)};
        CtxUtils.drawAxes(axes, 2);
        drawShinenessCurve(alpha, origin.x, origin.y, scale);
    }
    function drawShinenessCurve(alpha, center, height, amplitud){
        const ratio = 2/NUM_POINTS_CURVE;
        const start = -.99;
        var y_cos = height - cos(start*Math.PI/2)**alpha * amplitud;
        var x = center - amplitud;
        CtxUtils.ctx.beginPath();
        CtxUtils.ctx.lineWidth = 2.2;
        CtxUtils.ctx.strokeStyle = "green";
        for(var i = start+ratio; i<= 1; i+= ratio){
                CtxUtils.ctx.moveTo(x, y_cos);
                y_cos = height - cos(i*Math.PI/2)**alpha * amplitud;
                x= center + i * amplitud;
                CtxUtils.ctx.lineTo(x, y_cos);
            }
        CtxUtils.ctx.stroke();
        CtxUtils.ctx.strokeStyle = "black";
    };
    function updateShininess(value){
        alpha = value;
        draw();
    }
}
