"use strict";

import {Button, MathBox, resizeContainer2D} from "../../../modules/HTMLUtils.js";

/***
 * Sistema de dos ecuaciones con dos incógnitas.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

let index = 0;
let max_index;
function main(){
    //HTML CONTROLS
    let container = document.getElementById("container2D");
    let controls = document.getElementById("ui-container");
    controls.className = "vertical-up-bttns-box";
    controls.style.top = "12%";
    let image = document.getElementById("image-patch");
    
    //HTML CONTROLS
    let buttons = [ new Button(controls, upadateStep(-1), "Prev", null, true),
                    new Button(controls, upadateStep(1), "Sig"),
                    new Button(controls, reset, "Reset")];

    let description = new MathBox(container, {top:0, left:0});
    let infoByIndex = [ "\\text{Se definen los puntos de control } P^0_{ij} \\text{de un parche de}" + 
                        "\\\\ \\text{Bézier de grado } (2\\times2).", 
                        "\\text{Primero se calculan los puntos } P^1_{ij} \\text{ usando interpolación }\\\\" +
                        "\\text{bilineal entre los puntos cercanos } P^0_{ij}.",
                        "\\text{Obteniendo cuatro puntos intermedios } P^1_{ij} \\text{ con los} \\\\ \\text{cuales se " +
                        "forma un parche de grado } (1\\times1).",
                        "\\text{Se realiza una última interpolación bilineal entre los } \\\\ \\text{puntos }P^1_{ij}.",
                        "\\text{Obteniendo al punto final sobre la superficie}\\\\ P(u,v) = P^2_{00}."
                    ];
    let src_images = ["bezier-patch-22-1.svg", "bezier-patch-22-2.svg", 
                      "bezier-patch-22-3.svg", "bezier-patch-22-4.svg",
                      "bezier-patch-22-5.svg"];
    max_index = src_images.length -1;
    window.addEventListener('resize', draw);
    
    draw();

    function draw(){
        resizeContainer2D();
        image.src = src_images[index];
        description.setText(infoByIndex[index]);
    }
    function upadateStep(button){
        return function(){
            if (index + button < 0 || index + button > max_index)
                return;
            index += button;

            buttons[0].updateState(index, 1, max_index);
            buttons[1].updateState(index, 0, max_index-1);
            draw(); 
        }
    }
    function reset(){
        index = 0;
        buttons[0].updateState(index, 1, max_index);
        buttons[1].updateState(index, 0, max_index-1);
        draw();
    }
}