import * as Utils from "../../../modules/HTMLUtils.js";
import WebGL from "../../../modules/WebGLUtils.js";
import * as MU from "../../../modules/MathUtils.js";
import M3 from "../../../modules/M3.js";
import V2 from "../../../modules/V2.js";
import Grid from "../../../geometry/Grid.js";
import Vector2D from "../../../geometry/Vector2D.js";
import Figure2D from "../../../geometry/Figure2D.js";

/**
 * Descripción de un vector por desplazamiento V = Q-P.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
    
    Utils.resize(canvas);
    const unit = 40;   
    
    
    var grid = new Grid(gl, unit);
    //Color de los vectores
    const colorVector = [132, 97, 169, 255]; 
    const colorPoints = [95, 151, 163, 255]; 
    
    let p = new V2(2,2);
    let q = new V2(6,4);
    let vector = new Vector2D(gl, WebGL, p, q.sub(p), unit, 2, colorVector); 
    //Puntos de los vectores
    var paramsP = { center: p, r: 0.12, numPoints: 10};
    var paramsQ = { center: q, r: 0.12, numPoints: 10};
    let pointP = new Figure2D(gl, WebGL, 'circle', unit, colorPoints, paramsP);
    let pointQ = new Figure2D(gl, WebGL, 'circle', unit, colorPoints, paramsQ);
   
    //Etiquetas vectores
    let pLabel = Utils.createMathBox(container, {});
    let qLabel = Utils.createMathBox(container, {});
    let pqLabel = Utils.createMathBox(container, {});
    
    var time = 0; //Contador de tiempo para hacer la espera
    const wait_time = .8; //tiempo de espera
    var t = 0;
    var c = 0; //Contador auxiliar 

    window.addEventListener('resize', draw);
    requestAnimationFrame(draw);
    
    function draw(){
        Utils.resize(canvas);
        const {width, height} = gl.canvas;
        gl.viewport(0, 0, width, height);
        gl.clearColor(0, 0, 0, 0);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER);
        
        var limits = { l: -.09 * width, r: .91 * width, t: .88 * height, b:-.12 * height, 
                        width: width, height: height};
        
        var projectionMatrix = M3.projection(limits.l, limits.r, limits.t, limits.b);
        
        grid.draw(gl, limits);
        
        let lerp = MU.lerp(p, q, 1 - t);
        let pq = q.sub(lerp);
        pointQ.draw(gl, M3.identity(), projectionMatrix);        
        vector.draw(gl, projectionMatrix, null, pq, p);
        pointP.draw(gl, M3.identity(), projectionMatrix);        
        
        
        //Coordenadas (aproximadas) en la ventana
        var pCoord = MU.getPixelPosition( p, projectionMatrix, width, height, unit);
        var qCoord = MU.getPixelPosition( q, projectionMatrix, width, height, unit);

        let pLabelPosition = {top : -5 + pCoord.y, 
                             left : -25 + pCoord.x, type: 'px'};
        Utils.setElementPosition(pLabel, pLabelPosition);
        Utils.setMathBox(pLabel, "\\mathit{P}");
        
        let qLabelPosition = {top : -6 + qCoord.y, 
                             left : -22 + qCoord.x, type: 'px'};
        Utils.setElementPosition(qLabel, qLabelPosition);
        Utils.setMathBox(qLabel, "\\mathit{Q}");
        
        Utils.setMathBox(pqLabel, "");

        if(t == 1 && time <= wait_time){
            time += 0.01;
            var qCoord = MU.getPixelPosition( q.scale(.65), projectionMatrix, width, height, unit);
            let pqLabelPosition = {top : -20 + qCoord.y, 
                                  left : -22 + qCoord.x, type: 'px'};
            Utils.setElementPosition(pqLabel, pqLabelPosition);
            Utils.setMathBox(pqLabel, "\\overset{\\rarr}{PQ}");
        }
        else{
            time = 0;
            //Actualizamos t 
            c = (c + 1) % 101; // Cálculo con enteros para evitar problemas de precisión con decimales de js 
            t = c / 100;
        }
        requestAnimationFrame(draw);
    }
}