import * as Utils from "../../../modules/HTMLUtils.js";
import WebGL from "../../../modules/WebGLUtils.js";
import * as MU from "../../../modules/MathUtils.js";
import M3 from "../../../modules/M3.js";
import V2 from "../../../modules/V2.js";
import Grid from "../../../geometry/Grid.js";
import Vector2D from "../../../geometry/Vector2D.js";
import Figure2D from "../../../geometry/Figure2D.js";

/**
 * Mapas con sistemas de coordenadas usando vectores base
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
    
    Utils.resize(canvas);
    const {width, height} = gl.canvas;

    const unit = 55;   
    var basis = [{x: new V2(2,0), y: new V2(0,2)},
                 {x: new V2(2,2), y: new V2(-1,1)},
                 {x: new V2(2,-1), y: new V2(2,2)},
                 {x: new V2(2,0), y: new V2(0,-2)},
                 {x: new V2(-3,0), y: new V2(0,1)}];
    
    //Color de los vectores
    const colorBasis = [19, 41, 61, 255]; 
    
    var grid = new Grid(gl, unit, false, basis[0], [colorBasis]);
    
    let sPoint  = new V2(0,0);
    let basisVectors = [];
    for(var i= 0; i < basis.length; i++){
        basisVectors.push(new Vector2D(gl, WebGL, sPoint, basis[i].x, unit, 2, colorBasis));
        basisVectors.push(new Vector2D(gl, WebGL, sPoint, basis[i].y, unit, 2, colorBasis));
    }
    let indexBasis = 0;
    //Puntos de los vectores
    var cparams = { center: sPoint, r: 0.12, numPoints: 10};
    let centerPoint = new Figure2D(gl, WebGL, 'circle', unit, colorBasis, cparams);
    
    //Etiquetas vectores
    let xLabel = Utils.createMathBox(container, {});
    let yLabel = Utils.createMathBox(container, {});
    
    var href_div= document.getElementById("map_ref");
     
    var time = 1; //Contador de tiempo para hacer la espera
        
    window.addEventListener('resize', draw);
    requestAnimationFrame(draw);
    
    function draw(){
        Utils.resize(canvas);
        const {width, height} = gl.canvas;
        gl.viewport(0, 0, width, height);
        gl.clearColor(0, 0, 0, 0);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER);
        
        var limits = { l: -width/2, r: width/2, t: height/2, b:-height/2};
        
        var projectionMatrix = M3.projection(limits.l, limits.r, limits.t, limits.b);
        
        //Cambio de base (Animación)
        if(time == 0){
            indexBasis = (indexBasis == basisVectors.length - 2)? 0 : (indexBasis + 2);
        }
        //Resolución del mapa *
        const wr = 2452 * (width/2452);
        const hr = 1552 * (height/1552);
        //Dibuja el fondo (grid)
        grid.draw(gl, limits, basis[indexBasis/2]);
        //Se dibujan ectores base 
        basisVectors[indexBasis].draw(gl, projectionMatrix);
        basisVectors[indexBasis + 1].draw(gl, projectionMatrix);
        //Se dibuja el punto céntrico
        centerPoint.draw(gl, M3.identity(), projectionMatrix);        
        //Vectores base
        var xVectorBasis = basis[indexBasis/2].x;
        var yVectorBasis = basis[indexBasis/2].y;
        //Coordenadas (aproximadas) en la ventana
        var xCoord = MU.getPixelPosition( xVectorBasis, projectionMatrix, width, height, unit);
        var yCoord = MU.getPixelPosition( yVectorBasis, projectionMatrix, width, height, unit);

        var offsetX = (xVectorBasis.x > 0) ? -15 : -25;
        let xLabelPosition = {top : -30 + xCoord.y, 
                             left : offsetX + xCoord.x, type: 'px'};
        Utils.setElementPosition(xLabel, xLabelPosition);
        Utils.setMathBox(xLabel, "\\mathbf{x}");
        
        var offsetY = (yVectorBasis.y > 0) ? -38 : -25;
        let yLabelPosition = {top : offsetY  + yCoord.y, 
                             left : -20 + yCoord.x, type: 'px'};
        Utils.setElementPosition(yLabel, yLabelPosition);
        Utils.setMathBox(yLabel, "\\mathbf{y}");


        time = (time + 1) % 100;
        requestAnimationFrame(draw);
    }
}