import * as MU from "../../../modules/MathUtils.js";
import * as Utils from "../../../modules/HTMLUtils.js";
import WebGL from "../../../modules/WebGLUtils.js";
import M3 from "../../../modules/M3.js";
import V2 from "../../../modules/V2.js";
import Grid from "../../../geometry/Grid.js";
import Vector2D from "../../../geometry/Vector2D.js";

/**
 * Suma de dos vectores.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

var step = 0;
function main(){
    
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
    
    Utils.resize(canvas);

    const {width, height} = gl.canvas;
    var unit = 40;  
    //var grid = new Grid(gl, unit);
    //Colores
    const uColor = [19, 41, 61, 255]; 
    const vColor = [255, 0, 0, 255];
    const wColor = [46, 139, 87, 255];
    const sumColor = [255, 191, 0, 255];
    const sizeVec = 2.3;
    //Punto inicial
    let sPoint  = new V2(0,0);
    //Vector U
    let uVector  = new V2(.17*width/unit, .48*height/unit);
    let u = new Vector2D(gl, WebGL, sPoint, uVector, unit, sizeVec, uColor);
    // Vector V
    let vVector  = new V2(-.4*width/unit, .45*height/unit);
    let v = new Vector2D(gl, WebGL, uVector, vVector, unit, sizeVec, vColor);
    //Vector W
    let sWPoint = uVector.add(vVector);
    let wVector  = new V2(-.5*width/unit, -.45*height/unit);
    let w = new Vector2D(gl, WebGL, sWPoint, wVector, unit, sizeVec, wColor);
    // Vector U+V+W
    let addVector = uVector.add(vVector.add(wVector));
    let uvw = new Vector2D(gl, WebGL, sPoint, addVector, unit, sizeVec, sumColor);
   
    //Etiquetas vectores
    let uLabel = Utils.createMathBox(container, {});
    let vLabel = Utils.createMathBox(container, {});
    let wLabel = Utils.createMathBox(container, {});
    let addLabel = Utils.createMathBox(container, {});
    const constructor = {top:-100, left:-100};
   
    var time = 0; //Contador de tiempo para hacer la espera
    const wait_time = .5; //tiempo de espera

    window.addEventListener('resize', draw);
    requestAnimationFrame(draw);
    
    function draw(){
        Utils.resize(canvas);
        const {width, height} = gl.canvas;
        gl.viewport(0, 0, width, height);
        gl.clearColor(0, 0, 0, 0);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER);
        
        var limits = { l : -.75 * width, r: .25 * width, t: .95 * height, b: -.05 * height};
        var projectionMatrix = M3.projection( limits.l, limits.r, limits.t, limits.b);
        //grid.draw(gl, limits);
        
        let labelPos = MU.getVectorLabelMidPosition(projectionMatrix, width, height, unit, uVector);
        Utils.setElementPosition(uLabel,labelPos);
        Utils.setMathBox(uLabel, "\\mathbf{u}");
       
        
        Utils.setElementPosition(vLabel, constructor);
        Utils.setElementPosition(wLabel, constructor);
        Utils.setElementPosition(addLabel, constructor);

        if(step > 0 ){ // V     
            labelPos = MU.getVectorLabelMidPosition(projectionMatrix, width, height, unit, vVector, uVector);
            Utils.setElementPosition(vLabel, labelPos);
            Utils.setMathBox(vLabel, "\\mathbf{v}");

            v.draw(gl, projectionMatrix);
        }
        if(step > 1){ // W
            labelPos= MU.getVectorLabelMidPosition(projectionMatrix, width, height, unit, wVector, sWPoint);
            Utils.setElementPosition(wLabel, labelPos);
            Utils.setMathBox(wLabel, "\\mathbf{w}");
            w.draw(gl, projectionMatrix);
        }
        if(step == 3 ){ // U+V+W
            labelPos = MU.getVectorLabelMidPosition(projectionMatrix, width, height, unit, addVector);
            Utils.setElementPosition(addLabel, labelPos);
            Utils.setMathBox(addLabel, "\\mathbf{u+v+w}");
            uvw.draw(gl, projectionMatrix);
        }
        
        u.draw(gl, projectionMatrix);

        if(time <= wait_time){
            time += 0.01;
        }else{
            time = 0;
            step = (step + 1) % 4;
        }
        requestAnimationFrame(draw);
    }
}