import * as Utils from "../../modules/HTMLUtils.js";
import CtxUtils from "../../modules/Context2DUtils.js";
import V2 from "../../modules/V2.js"; 

/**
 * Un radián en un círculo unitario.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

const RADIUS_LINE = "#457b9d";
const ARC = "red";
const ANGLE = "rgba(57, 151, 147, 0.5)";
function main(){
    var canvas = document.getElementById("canvas");
    Utils.resizeContainer2D();
    Utils.resizeSquareCanvas(canvas);
   
    let {width, height} = canvas;
    
    const origin = new V2(width/2, height/2);
    const delta = 0.03 * width;
    const deltaText = 0.05 * width;
    const textPos = origin.movePoints(0.05 * width, -0.02 * width);
    
    const oneRad = -57.3*(Math.PI/180);
    const radius = width / 3;
    const innerRadius = radius/2;
    
    let oneRadS = new V2(radius*Math.cos(0), radius*Math.sin(0));
    oneRadS = origin.add(oneRadS);
    
    let oneRadE = new V2(radius*Math.cos(oneRad), radius*Math.sin(oneRad));
    oneRadE = origin.add(oneRadE);
    
    let middleS = new V2((origin.x + oneRadS.x)/2,(origin.y + oneRadS.y)/2);
    let middleE = new V2(radius*Math.cos(.5*oneRad) + delta, radius*Math.sin(.5*oneRad) - delta);
    middleE = origin.add(middleE);
    
    window.addEventListener('resize', draw);
    var time = 0; //Contador de tiempo para hacer la espera
    const wait_time = 1.51; //tiempo de espera
    var t = 0;
    var c = 0; //Contador auxiliar 
    
    requestAnimationFrame(draw);

    function draw(){
        Utils.resizeContainer2D();
        CtxUtils.clear();
        
        CtxUtils.drawCircle( origin, radius, "black", 2);
        CtxUtils.drawCircle( origin, 4, RADIUS_LINE, 1, RADIUS_LINE);
        
        CtxUtils.drawLine(origin, oneRadS, 3, RADIUS_LINE);
        CtxUtils.drawLine(origin, oneRadE, 3, RADIUS_LINE);
        CtxUtils.drawFillArc(origin, innerRadius, 0, oneRad, true, ANGLE);
        CtxUtils.putText("1rad", deltaText + "", textPos.x, textPos.y, "black");
        
        //Arco del radio
        var currPoint = CtxUtils.lerp(origin, oneRadE, t);
        var currMid = CtxUtils.lerp(middleS, middleE, t);
        CtxUtils.drawQuadBezierT(currPoint, currMid, oneRadS, 1, 30, ARC, 4);
        if(t == 1 && time <= wait_time){
            time += 0.01;
        }
        else{
            time = 0;
            //Actualizamos t 
            c = (c + 2) % 1001; // Cálculo con enteros para evitar problemas de precisión con decimales de js 
            t = c / 1000;
        }
        requestAnimationFrame(draw);
    }
}