import * as Utils from "../../modules/HTMLUtils.js";
import CtxUtils from "../../modules/Context2DUtils.js";
import V2 from "../../modules/V2.js"; 
import * as MU from "../../modules/MathUtils.js"; 

/**
 * Radianes en un círculo unitario.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

var d = 0.1;
const LINE_COLOR = "rgb(143, 143, 143)";
const LINE_CIRCLE = "black";
const LINE_ANGLE = "rgb(207, 209, 26)";
const INNER_CIRCLE = "rgba(207, 209, 26, 0.45)";
const X_COLOR = "#FF5733"; //Azul
const Y_COLOR = "#4F8BAD"; //Rojo
function main(){
    document.body.style.backgroundColor = '#ffffff';
    var canvas = document.getElementById("canvas");
    Utils.resizeContainer2D();
    Utils.resizeSquareCanvas(canvas);

    let controls = document.getElementById("ui-container");
    controls.className = "bottom-box";
    
    let container = document.getElementById("container2D");
    
    //HTML CONTROLS
    const colorsSlider = [LINE_ANGLE, "#D1D1CA"];
    let sliderD = new Utils.BigSlider(controls, "θ", 0, 2, updateD, d, 0.01, colorsSlider, " π rad");
    
    const titlePosition = { top: 0, left: 31};
    let titleLabel = Utils.createMathBox(container, titlePosition);
    Utils.setMathBox(titleLabel, "\\text{Círculo unitario}");
    
    const labelXUpPosition = {bottom: 9, left: 15};
    const labelYUpPosition = {bottom: 9, left: 53};
    let coordXUpLabel = Utils.createMathBox(container, labelXUpPosition);
    let coordYUpLabel = Utils.createMathBox(container, labelYUpPosition);


    const labelXBottomPosition = {bottom: 3, left: 19.4};
    const labelYBottomPosition = {bottom: 3, left: 57.2};
    let coordXBottomLabel = Utils.createMathBox(container, labelXBottomPosition);
    let coordYBottomLabel = Utils.createMathBox(container, labelYBottomPosition);
    
    let {width, height} = canvas;
    const origin = new V2(.5 * width, .46 * height);
    
    const axes = { origin: origin, x: new V2(.12 * width, width - 45), y: new V2(.75* height, .15 * height)};
    const radius = width / 4;
    const innerRadius = width / 12;
    let oneRad = new V2(radius*Math.cos(-180/Math.PI), radius*Math.sin(-180/Math.PI));
    oneRad = origin.add(oneRad);
   
    window.addEventListener('resize', draw);
    draw();

    function draw(){
        Utils.resizeContainer2D();
        CtxUtils.clear();
        
        CtxUtils.drawAxes(axes, 1, LINE_COLOR);
        
        // Círculo unitario
        CtxUtils.drawCircle( origin, radius, LINE_CIRCLE, 1.2);
        var angle = - d * Math.PI;
        // Árco del ángulo
        CtxUtils.drawArc( origin, innerRadius, 0, angle, LINE_ANGLE, 1, true);
        CtxUtils.drawFillArc( origin, innerRadius, 0, angle, true, INNER_CIRCLE);
        //Punto sobre la circunferencia
        var radiusPoint = new V2(radius*Math.cos(angle), radius*Math.sin(angle));
        radiusPoint = origin.add(radiusPoint);
        
        var xPoint = new V2( radiusPoint.x, origin.y);
        
        CtxUtils.drawLine(radiusPoint, xPoint, 1.5, Y_COLOR); //Y
        CtxUtils.drawLine(origin, xPoint, 1.5, X_COLOR); //X
        
        //Línea y punto
        CtxUtils.drawLine(origin, radiusPoint, 1.2 , LINE_CIRCLE);
        CtxUtils.drawCircle( radiusPoint, 4, LINE_ANGLE, 1, LINE_ANGLE);
        
        // Texto coordenadas del punto
        var cos = MU.cos(d * Math.PI).toFixed(3);
        var sin = MU.sin(d * Math.PI).toFixed(3);
        
        Utils.setMathBox(coordXUpLabel, "x = \\cos("+ d +"\\pi)");
        Utils.setMathBox(coordYUpLabel, "y = \\sin("+ d +"\\pi)");
        Utils.setMathBox(coordXBottomLabel, "= \\enspace " +  cos);
        Utils.setMathBox(coordYBottomLabel, "= \\enspace " +  sin);
        /* Texto P(x,y)
        var x = radiusPoint.x + 12;
        var y = radiusPoint.y - 22;
        CtxUtils.putText("P(x,y)", 18, x, y);   */     

    }

    function updateD(value){
        d = value;
        draw();
    }
}