import * as MU from "../../../modules/MathUtils.js";
import {resize, MathBox} from "../../../modules/HTMLUtils.js";
import WebGL from "../../../modules/WebGLUtils.js";
import M3 from "../../../modules/M3.js";
import V2 from "../../../modules/V2.js";
import Vector2D from "../../../geometry/Vector2D.js";
import Line2D from "../../../geometry/Line2D.js";
import Figure2D from "../../../geometry/Figure2D.js";
import { MouseVector, registerMouseEvents2DVec } from "../../../modules/MouseEvents.js";

/**
 * Edge equation.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    document.body.style.backgroundColor = "white"; 
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;

    let container = document.getElementById("container");
    resize(canvas);
   
    const unit = 55;   
    
    //Colores
    const basisColor = [70, 130, 180, 255]; 
    const opaqueColor = [97, 100, 112, 200]; 
    const pointColor = [63, 60, 63, 255];
    const lineColor = [100, 100, 100, 190];

    
    const {width, height} = gl.canvas;
    
    let s_point  = new V2(0,0);
    //Vectores
    let orth_vec = new V2(2.5,1.2);
    let p_vector  = orth_vec;
    var normal = new V2(-orth_vec.y, orth_vec.x);
    normal = normal.normalize().scale(1.5);
    let normalVector2D = new Vector2D(gl, WebGL, s_point, normal, unit, 2, basisColor);
    let pVector2D = new Vector2D(gl, WebGL, s_point, p_vector, unit, 1.6, pointColor);
            
    //Punto céntrico
    var eparams = { center: s_point, r: 0.1, numPoints: 10};
    let n_point = new Figure2D(gl, WebGL, 'circle', unit, basisColor, eparams);
    eparams.r = 0.08;
    let p_point = new Figure2D(gl, WebGL, 'circle', unit, pointColor, eparams);
    
    //Line
    let minus_inf = p_vector.scale(-10);
    let line = new Line2D(gl, WebGL, minus_inf, p_vector, width, unit, .6, lineColor);
    
    //Límites de la proyección
    let projectionLimits = { l: -.45, r: .55, t: .5, b: -.5};
    //Constructor auxiliar para  el manejador de eventos con el ratón
    const radius_region = 0.3;
    let mouse_vector = new MouseVector(gl, radius_region, unit, p_vector, projectionLimits);
    let mouse_vectors = [mouse_vector];

    //Circunferencia para señalar el área para mover la flecha
    var cparams = { center: s_point, r: radius_region, thickness: 0.1, numPoints: 10};
    let cRegion = new Figure2D(gl, WebGL, 'circumference', unit, opaqueColor, cparams);

    //Etiqueta vector
    let normal_label = new MathBox(container, {}, "\\mathbf{n}");
    let p_label = new MathBox(container, {}, "P");
    let eq_label = new MathBox(container, {bottom: 9, right: 15});
    
    let positive_label =  new MathBox(container, {}, "\\color{#6B8E23}(+)");
    let negative_label =  new MathBox(container, {}, "\\color{#DC143C}(-)");

    gl.clearColor(0, 0, 0, 0);
    
    draw();
    window.addEventListener('resize', draw);
    registerMouseEvents2DVec(canvas,mouse_vectors, draw);
    
    function draw(){
        resize(canvas);
        const {width, height} = gl.canvas;
        gl.viewport(0, 0, width, height);
        
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER);
        
        var projectionMatrix = M3.projection(projectionLimits.l * width, 
                                             projectionLimits.r * width, 
                                             projectionLimits.t * height, 
                                             projectionLimits.b * height);
            
        var v = mouse_vector.vector;

        let diff = {t: 0, l: -25};
        let labelPosition = MU.getVectorLabelPosition(normal, projectionMatrix, width, height, unit, diff, .5);
        normal_label.setPosition(labelPosition);

        labelPosition = MU.getVectorLabelEndPosition(projectionMatrix, width, height, unit, v);
        p_label.setPosition(labelPosition);
        
        diff = {t: -33, l: -25};
        let init_p_positon =  MU.getVectorLabelPosition(p_vector, projectionMatrix, width, height, unit, diff, .5);
        positive_label.setPosition(init_p_positon);
        diff = {t: 12.5, l: -14};
        init_p_positon =  MU.getVectorLabelPosition(p_vector, projectionMatrix, width, height, unit, diff, .5);
        negative_label.setPosition(init_p_positon);

        var eP_value = normal.dotProduct(v) + 8 - 8;
        eq_label.setText("e(P) = " + eP_value.toFixed(2));
        
        gl.depthMask(true);
        gl.disable(gl.BLEND);
    
        line.draw(gl, projectionMatrix);        
        pVector2D.draw(gl, projectionMatrix, null, v);
        normalVector2D.draw(gl, projectionMatrix);
        n_point.draw(gl, M3.identity(), projectionMatrix); 
        p_point.draw(gl, M3.identity(), projectionMatrix, v); 

         //Transparecia
        gl.enable(gl.BLEND);
        gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
        gl.depthMask(false);
        
        if(mouse_vector.showRegion)
            cRegion.draw(gl, M3.translate(v.x, v.y), projectionMatrix);
            
    }
}