"use strict";

import {resize, Button} from "../../../modules/HTMLUtils.js";
import WebGL from "../../../modules/WebGLUtils.js";
import Line from "../../../geometry/Line2D.js";
import Figure2D from "../../../geometry/Figure2D.js";
import Vector2D from "../../../geometry/Vector2D.js";
import M3 from "../../../modules/M3.js";
import V2 from "../../../modules/V2.js";
import {lineIntersection} from "../../../modules/MathUtils.js";

/**
 * Sistema de dos ecuaciones con dos incógnitas.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

const lineColor = [0.3,0.4,0.7,1];
const colorPI = [1, .9, 0, 1]
let index = 0;
let max_index = 2;
function main(){
    
    document.body.style.backgroundColor = '#FFFFFF';
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
    resize(canvas);

    const unit = 50;
    const thickness = 0.9;
    const basisColor = [0,0,0, 255];
    const size = gl.canvas.height/unit/4.5;
    let sXPoint = new V2(-size, -.2*size); 
    let sYPoint = new V2(-.1*size,-.8*size); 
    let xBasis  = new V2(2.8*size, 0);
    let yBasis  = new V2(0, 2.8*size);
    
    let x = new Vector2D(gl, WebGL, sXPoint, xBasis, unit, thickness, basisColor);
    let y = new Vector2D(gl, WebGL, sYPoint, yBasis, unit, thickness, basisColor);

    const t = 50;
    //Línea uno
    let s_line_one = [new V2(1.5*size, -size), new V2(2*size, -.3*size), new V2(1.8*size, -.6*size)];
    let dir_line_one = [new V2(-3, 4.5), new V2(-4,2.2), new V2(-3,3)];
    let lineOne = new Line(gl, WebGL, s_line_one[0], dir_line_one[0],3.5*size, t, thickness, lineColor);
    
    //Línea dos
    let s_line_two = [new V2(-1, -.8*size), new V2(2*size, .3*size), s_line_one[2]];
    let dir_line_two = [new V2(2.8, 4), new V2(-4,2.2), dir_line_one[2]];
    let lineTwo = new Line(gl, WebGL, s_line_two[0], dir_line_two[0], 3*size, t, thickness, lineColor);
    
    //Punto de intersección
    let i_point = lineIntersection(s_line_one[0], dir_line_one[0], s_line_two[0], dir_line_two[0]);
    var cparams = { center: i_point, r: 0.1, numPoints: 10};
    let iPoint = new Figure2D(gl, WebGL, 'circle', unit, colorPI, cparams);

    //HTML CONTROLS
    let controls = document.getElementById("ui-container");
    controls.className = "vertical-bttns-box";
    
    //HTML CONTROLS
    let buttons = [ new Button(controls, upadateStep(-1), "Prev", null, true),
                    new Button(controls, upadateStep(1), "Sig"),
                    new Button(controls, reset, "Reset")];

    let textInfo = document.getElementById("text-info");
    let infoByIndex = [ "Dos líneas intersecan en un punto <br>(solución única)", 
                        "Dos líneas paralelas sin ninguna intersección <br>(sin solución)", 
                        "Dos líneas que coinciden <br>(infinitas soluciones)"
                    ];
    
    window.addEventListener('resize', draw);
    
    gl.clearColor(0,0,0,0);
    
    draw();

    function draw(){
        resize(canvas);
        var {width, height} = gl.canvas;
        gl.viewport(0, 0, width, height);
        
        textInfo.innerHTML = infoByIndex[index];
        
        var limits = { l : -.41 * width, r: .59 * width, t: .64 * height, b: -.26 * height};
        var projectionMatrix = M3.projection( limits.l, limits.r, limits.t, limits.b);

        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
        
        x.draw(gl, projectionMatrix);
        y.draw(gl, projectionMatrix);
        var color = (index == 2) ? colorPI : lineColor;
        lineOne.draw(gl, projectionMatrix, null, s_line_one[index], dir_line_one[index], color);       
        lineTwo.draw(gl, projectionMatrix, null, s_line_two[index], dir_line_two[index], color); 
        if(index == 0)
            iPoint.draw(gl, M3.identity(), projectionMatrix);      
    }
    function upadateStep(button){
        return function(){
            if (index + button < 0 || index + button > max_index)
                return;
            index += button;

            buttons[0].updateState(index, 1, max_index);
            buttons[1].updateState(index, 0, max_index-1);
            draw(); 
        }
    }
    function reset(){
        index = 0;
        buttons[0].updateState(index, 1, max_index);
        buttons[1].updateState(index, 0, max_index-1);
        draw();
    }
}