import { RectangularPrism } from "./Figure.js";
import SolidColor from "../materials/SolidColor.js";
import GeometryPainter from "./GeometryPainter.js";
import M4 from "../modules/M4.js";
import V3 from "../modules/V3.js";

/**
 * Clase que renderiza una línea 3D siguiendo la definición paramétrica.
 * @author Melissa Méndez Servín.
 */
export default class Line3D{
    constructor(gl, WebGL, p0, p1, origin, thickness, color){
        this.thickness = thickness;
        this.height = 1;
        this.origin = origin;
        this.p0 = origin.add(p0);
        this.p1 = origin.add(p1);
        this.base = new V3(0,1,0);
        let lineFigure = new RectangularPrism(thickness, 1, thickness, true);
        this.line = new GeometryPainter(gl, new SolidColor(gl, WebGL, lineFigure, color));
        
    }
    draw(gl,  modelViewMatrix, projectionMatrix, curr_p0=null, curr_p1=null){
        console.log()
        let p0 = (curr_p0) ? this.origin.add(curr_p0) : this.p0;
        let p1 = (curr_p1) ? this.origin.add(curr_p1) : this.p1;
        let vector = p1.sub(p0);
        
        let height = p0.distance(p1);
        let translateToSPoint = M4.translate(p0.x, p0.y, p0.z);
        let fixHeight = M4.translate(0, height/2, 0);
        
        let axis = this.base.cross(vector).normalize();
        let theta = Math.acos(this.base.dotProduct(vector.normalize()));
        let rotateToVector = M4.rotate(axis, theta);
        
        let commonTransformation = M4.multiply(translateToSPoint, M4.multiply(rotateToVector, fixHeight));
        
        let scale = M4.scale(1, height, 1);

        let modelViewMatrixLine = M4.multiply(commonTransformation, scale); 
        modelViewMatrixLine = M4.multiply(modelViewMatrix, modelViewMatrixLine);

    
        this.line.draw(gl, modelViewMatrixLine, projectionMatrix);  
        
    }
}