/* _inputParameters: an object with different values for the model parameters */
function ch19_i01(_topFrame,_libraryPath,_codebasePath, _inputParameters) {
  var _model = EJSS_CORE.createAnimation();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = {
    showInputDialog : EJSS_INTERFACE.BoxPanel.showInputDialog,
    showOkDialog : EJSS_INTERFACE.BoxPanel.showOkDialog,
    showOkCancelDialog : EJSS_INTERFACE.BoxPanel.showOkCancelDialog
  };

  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var x; // EjsS Model.Variables.Dynamical Vars.x
  var y; // EjsS Model.Variables.Dynamical Vars.y
  var vy; // EjsS Model.Variables.Dynamical Vars.vy
  var m; // EjsS Model.Variables.Dynamical Vars.m
  var t; // EjsS Model.Variables.Dynamical Vars.t
  var dt; // EjsS Model.Variables.Dynamical Vars.dt

  var width; // EjsS Model.Variables.Display Vars.width
  var height; // EjsS Model.Variables.Display Vars.height
  var xSpace; // EjsS Model.Variables.Display Vars.xSpace
  var ySpace; // EjsS Model.Variables.Display Vars.ySpace
  var meterSize; // EjsS Model.Variables.Display Vars.meterSize
  var scale; // EjsS Model.Variables.Display Vars.scale
  var plotTitle; // EjsS Model.Variables.Display Vars.plotTitle
  var heatLabel; // EjsS Model.Variables.Display Vars.heatLabel
  var msgStr; // EjsS Model.Variables.Display Vars.msgStr

  var _privateOdesList;
  var _ODEi_evolution1;

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      x : x,
      y : y,
      vy : vy,
      m : m,
      t : t,
      dt : dt,
      width : width,
      height : height,
      xSpace : xSpace,
      ySpace : ySpace,
      meterSize : meterSize,
      scale : scale,
      plotTitle : plotTitle,
      heatLabel : heatLabel,
      msgStr : msgStr
    };
  };

  _model._readParameters = function(json) {
    if(typeof json.x != "undefined") x = json.x;
    if(typeof json.y != "undefined") y = json.y;
    if(typeof json.vy != "undefined") vy = json.vy;
    if(typeof json.m != "undefined") m = json.m;
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.dt != "undefined") dt = json.dt;
    if(typeof json.width != "undefined") width = json.width;
    if(typeof json.height != "undefined") height = json.height;
    if(typeof json.xSpace != "undefined") xSpace = json.xSpace;
    if(typeof json.ySpace != "undefined") ySpace = json.ySpace;
    if(typeof json.meterSize != "undefined") meterSize = json.meterSize;
    if(typeof json.scale != "undefined") scale = json.scale;
    if(typeof json.plotTitle != "undefined") plotTitle = json.plotTitle;
    if(typeof json.heatLabel != "undefined") heatLabel = json.heatLabel;
    if(typeof json.msgStr != "undefined") msgStr = json.msgStr;
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model._userUnserialize = function(json) {
    _model._readParameters(json);
   _resetSolvers();
   _model.update();
  };

  _model.addToReset(function() {
    __pagesEnabled["Init Page"] = true;
    __pagesEnabled["Evol Page"] = true;
    __pagesEnabled["FixRel Page"] = true;
  });

  _model.addToReset(function() {
    x = 0.0; // EjsS Model.Variables.Dynamical Vars.x
    y = 0.25; // EjsS Model.Variables.Dynamical Vars.y
    vy = 0.4; // EjsS Model.Variables.Dynamical Vars.vy
    m = 2.0; // EjsS Model.Variables.Dynamical Vars.m
    t = 0.0; // EjsS Model.Variables.Dynamical Vars.t
    dt = 0.05; // EjsS Model.Variables.Dynamical Vars.dt
  });

  _model.addToReset(function() {
    width = (_isMobile||_isEPub)?400:650; // EjsS Model.Variables.Display Vars.width
    height = 300; // EjsS Model.Variables.Display Vars.height
    xSpace = 10; // EjsS Model.Variables.Display Vars.xSpace
    ySpace = 5; // EjsS Model.Variables.Display Vars.ySpace
    meterSize = 0.8; // EjsS Model.Variables.Display Vars.meterSize
    scale = new Array(5); // EjsS Model.Variables.Display Vars.scale
    plotTitle = "Calor alto"; // EjsS Model.Variables.Display Vars.plotTitle
    heatLabel = "800 W"; // EjsS Model.Variables.Display Vars.heatLabel
    msgStr = ""; // EjsS Model.Variables.Display Vars.msgStr
  });

  if (_inputParameters) {
    if (typeof _inputParameters === 'string' || _inputParameters instanceof String) _inputParameters = JSON.parse(_inputParameters);
    _model.addToReset(function() { _model._readParameters(_inputParameters); });
  }

  _model.addToReset(function() {
    _privateOdesList=[];
    _ODEi_evolution1 = _ODE_evolution1();
    _privateOdesList.push(_ODEi_evolution1);
  });

  _model.addToReset(function() {
    _model.setAutoplay(false);
    _model.setPauseOnPageExit(true);
    _model.setFPS(20);
    _model.setStepsPerDisplay(1);
  });

  function heat1 () {  // > CustomCode.scenarios:1
    plotTitle = "High Heat";  // > CustomCode.scenarios:2
    vy=0.4;  // > CustomCode.scenarios:3
    heatLabel="800 W";  // > CustomCode.scenarios:4
    _initialize();  // > CustomCode.scenarios:5
  }  // > CustomCode.scenarios:6
  function heat2 (){  // > CustomCode.scenarios:7
    plotTitle = "Low Heat";  // > CustomCode.scenarios:8
    vy=0.2;  // > CustomCode.scenarios:9
    heatLabel="400 W";  // > CustomCode.scenarios:10
    _initialize();  // > CustomCode.scenarios:11
  }  // > CustomCode.scenarios:12

  _model.addToInitialization(function() {
    if (!__pagesEnabled["Init Page"]) return;
    t = 0.0;  // > Initialization.Init Page:1
    _view._initialize();  // > Initialization.Init Page:2
    if ( m<1.0 || m>5.0 ) {  // > Initialization.Init Page:3
      msgStr = "Mass should be between 1 and 5 kg";  // > Initialization.Init Page:4
      m=2.0;  // > Initialization.Init Page:5
    }  // > Initialization.Init Page:6
    else {  // > Initialization.Init Page:7
      msgStr="";  // > Initialization.Init Page:8
    }  // > Initialization.Init Page:9
    y=1/2.5;  // > Initialization.Init Page:10
    for (var i=0; i<5; i++) {  // > Initialization.Init Page:11
      scale[i]=(1/2.5)*(1+i)*meterSize;  // > Initialization.Init Page:12
    }  // > Initialization.Init Page:13
    _pause();  // > Initialization.Init Page:14
  });

  _model.addToInitialization(function() {
    _initializeSolvers();
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Evol Page"]) return;
    _ODEi_evolution1.step();
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["FixRel Page"]) return;
    if(t>5.0){  // > FixedRelations.FixRel Page:1
      _pause();  // > FixedRelations.FixRel Page:2
      msgStr = "End of Animation";  // > FixedRelations.FixRel Page:3
      }  // > FixedRelations.FixRel Page:4
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  function _initializeSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].initializeSolver();
  }

  function _automaticResetSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].automaticResetSolver();
  }

  _model.resetSolvers = function() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].resetSolver();
  };

  function _getODE(_odeName) {
    if (_odeName=="Evol Page") return _ODEi_evolution1;
    return null;
  }

  function _getEventSolver(_odeName) {
    var ode = _getODE(_odeName);
    if (ode===null) return null;
    return ode.getEventSolver();
  }

  function _setSolverClass(_odeName, _engine) {
    var ode = _getODE(_odeName);
    if (ode===null) return;
    if (!_engine.setODE) {
      var classname = _engine.toLowerCase();
      if      (classname.indexOf("boga")>=0)   _engine = EJSS_ODE_SOLVERS.bogackiShampine23;
      else if (classname.indexOf("cash")>=0)   _engine = EJSS_ODE_SOLVERS.cashKarp45;
      else if (classname.indexOf("dopri5")>=0) _engine = EJSS_ODE_SOLVERS.dopri5;
      else if (classname.indexOf("dopri8")>=0) _engine = EJSS_ODE_SOLVERS.dopri853;
      else if (classname.indexOf("richa")>=0)  _engine = EJSS_ODE_SOLVERS.eulerRichardson;
      else if (classname.indexOf("euler")>=0)  _engine = EJSS_ODE_SOLVERS.euler;
      else if (classname.indexOf("fehlberg87")>=0) _engine = EJSS_ODE_SOLVERS.fehlberg87;
      else if (classname.indexOf("fehlberg8")>=0)  _engine = EJSS_ODE_SOLVERS.fehlberg8;
      else if (classname.indexOf("radau")>=0)   _engine = EJSS_ODE_SOLVERS.radau5;
      else if (classname.indexOf("runge")>=0)  _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("rk4")>=0)    _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("verlet")>=0) _engine = EJSS_ODE_SOLVERS.velocityVerlet;
    }
    if (_engine) ode.setSolverClass(_engine);
  }

  function _ODE_evolution1() {
    var __odeSelf = {};
    var __eventSolver;
    var __solverClass = EJSS_ODE_SOLVERS.rungeKutta4;
    var __state=[];
    var __ignoreErrors=false;
    var __mustInitialize=true;
    var __isEnabled=true;
    var __mustUserReinitialize=false;
    var __mustReinitialize=true;


    __odeSelf.setSolverClass = function(__aSolverClass) {
      __solverClass = __aSolverClass;
      __instantiateSolver();
    };

    function __instantiateSolver() {
      __state=[];
      __pushState();
      __eventSolver = EJSS_ODE_SOLVERS.interpolatorEventSolver(__solverClass(),__odeSelf);
      __mustInitialize = true;
    }

    __odeSelf.setEnabled = function(_enabled) { __isEnabled = _enabled; };

    __odeSelf.getIndependentVariableValue = function() { return __eventSolver.getIndependentVariableValue(); };

    __odeSelf.getInternalStepSize = function() { return __eventSolver.getInternalStepSize(); };

    __odeSelf.isAccelerationIndependentOfVelocity = function() { return false; };

    __odeSelf.initializeSolver = function() {
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); return; }
      __pushState();
      __eventSolver.initialize(dt);
      __eventSolver.setBestInterpolation(false);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.removeAllEvents();
      __eventSolver.setEstimateFirstStep(false);
      __eventSolver.setEnableExceptions(false);
      __eventSolver.setTolerances(0.00001,0.00001);
      __mustReinitialize = true;
      __mustInitialize = false;
    };

    function __pushState() {
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        if (__state[__cIn]!=y) __mustReinitialize = true;
        __state[__cIn++] = y;
        if (__state[__cIn]!=t) __mustReinitialize = true;
        __state[__cIn++] = t;
    }

    function __arraysChanged () {
      return false;
    }

    __odeSelf.getEventSolver = function() {
      return __eventSolver;
    };

    __odeSelf.resetSolver = function() {
      __mustUserReinitialize = true;
    };

    __odeSelf.automaticResetSolver = function() {
      __mustReinitialize = true;
    };

    function __errorAction () {
      if (__ignoreErrors) return;
      console.log (__eventSolver.getErrorMessage());
      _pause();
      // Make sure the solver is reinitialized;
      __mustReinitialize = true;
    }

    __odeSelf.step = function() { return __privateStep(false); };

    __odeSelf.solverStep = function() { return __privateStep(true); };

    function __privateStep(__takeMaximumStep) {
      if (!__isEnabled) return 0;
      if (dt===0) return 0;
      if (__mustInitialize) __odeSelf.initializeSolver();
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); }
      __eventSolver.setStepSize(dt);
      __eventSolver.setInternalStepSize(dt);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.setTolerances(0.00001,0.00001);
      __pushState();
      if (__mustUserReinitialize) { 
        __eventSolver.userReinitialize();
        __mustUserReinitialize = false;
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      else if (__mustReinitialize) { 
        __eventSolver.reinitialize();
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      var __stepTaken = __takeMaximumStep ? __eventSolver.maxStep() : __eventSolver.step();
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        y = __state[__cOut++];
        t = __state[__cOut++];
      // Check for error
      if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      return __stepTaken;
    }

    __odeSelf.getState = function() { return __state; };

    __odeSelf.getRate = function(_aState,_aRate) {
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var y = _aState[__cOut++];
        var t = _aState[__cOut++];
      // Compute the rate
        var __cRate=0;
        _aRate[__cRate++] = vy/m; // Rate for ODE: Evol Page:y
        _aRate[__cRate++] = 1; // independent variable
        return _aRate;
    }; //end of getRate

    __instantiateSolver();

    return __odeSelf;
  }

  function _historic_y(__time) {
    var __index = 0;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

    _model._resized = function(_width,_height) {
      _view._resized(_width,_height);
  }; // end of _resized
    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : 800, height : 600 };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new ch19_i01_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.radioPanel.linkProperty("Width",  function() { return width; }, function(_v) { width = _v; } ); // HtmlView Page linking property 'Width' for element 'radioPanel'
          _view.heat1.setAction("OnCheckOn", function() {
  heat1();

}); // HtmlView Page setting action 'OnCheckOn' for element 'heat1'
          _view.heat2.setAction("OnCheckOn", function() {
  heat2();

}); // HtmlView Page setting action 'OnCheckOn' for element 'heat2'
          _view.panel.linkProperty("Width",  function() { return width; }, function(_v) { width = _v; } ); // HtmlView Page linking property 'Width' for element 'panel'
          _view.drawingPanel.linkProperty("Height",  function() { return height; }, function(_v) { height = _v; } ); // HtmlView Page linking property 'Height' for element 'drawingPanel'
          _view.drawingPanel.linkProperty("Width",  function() { return width; }, function(_v) { width = _v; } ); // HtmlView Page linking property 'Width' for element 'drawingPanel'
          _view.drawingPanel.linkProperty("MaximumY",  function() { return ySpace; }, function(_v) { ySpace = _v; } ); // HtmlView Page linking property 'MaximumY' for element 'drawingPanel'
          _view.drawingPanel.linkProperty("MaximumX",  function() { return xSpace; }, function(_v) { xSpace = _v; } ); // HtmlView Page linking property 'MaximumX' for element 'drawingPanel'
          _view.drawingPanel.linkProperty("BRMessage",  function() { return msgStr; }, function(_v) { msgStr = _v; } ); // HtmlView Page linking property 'BRMessage' for element 'drawingPanel'
          _view.time.linkProperty("X",  function() { return xSpace*.8; } ); // HtmlView Page linking property 'X' for element 'time'
          _view.time.linkProperty("Y",  function() { return ySpace*.9; } ); // HtmlView Page linking property 'Y' for element 'time'
          _view.time.linkProperty("Text",  function() { return "Tiempo:    " +  t.toFixed(1); } ); // HtmlView Page linking property 'Text' for element 'time'
          _view.title.linkProperty("X",  function() { return xSpace*.5; } ); // HtmlView Page linking property 'X' for element 'title'
          _view.title.linkProperty("Y",  function() { return ySpace*.9; } ); // HtmlView Page linking property 'Y' for element 'title'
          _view.title.linkProperty("Text",  function() { return plotTitle; }, function(_v) { plotTitle = _v; } ); // HtmlView Page linking property 'Text' for element 'title'
          _view.ThermoGroup.linkProperty("X",  function() { return xSpace*.3; } ); // HtmlView Page linking property 'X' for element 'ThermoGroup'
          _view.ThermoGroup.linkProperty("Y",  function() { return ySpace*.5; } ); // HtmlView Page linking property 'Y' for element 'ThermoGroup'
          _view.back.linkProperty("SizeX",  function() { return 0.5*meterSize; } ); // HtmlView Page linking property 'SizeX' for element 'back'
          _view.back.linkProperty("Y",  function() { return 1.25*meterSize; } ); // HtmlView Page linking property 'Y' for element 'back'
          _view.back.linkProperty("SizeY",  function() { return 2.5*meterSize; } ); // HtmlView Page linking property 'SizeY' for element 'back'
          _view.bulb.linkProperty("SizeX",  function() { return 0.8*meterSize; } ); // HtmlView Page linking property 'SizeX' for element 'bulb'
          _view.bulb.linkProperty("SizeY",  function() { return 0.8*meterSize; } ); // HtmlView Page linking property 'SizeY' for element 'bulb'
          _view.bulbRed.linkProperty("SizeX",  function() { return 0.5*meterSize; } ); // HtmlView Page linking property 'SizeX' for element 'bulbRed'
          _view.bulbRed.linkProperty("SizeY",  function() { return 0.5*meterSize; } ); // HtmlView Page linking property 'SizeY' for element 'bulbRed'
          _view.marker.linkProperty("SizeX",  function() { return 0.3*meterSize; } ); // HtmlView Page linking property 'SizeX' for element 'marker'
          _view.marker.linkProperty("Y",  function() { return y*meterSize/2; } ); // HtmlView Page linking property 'Y' for element 'marker'
          _view.marker.linkProperty("SizeY",  function() { return y*meterSize; } ); // HtmlView Page linking property 'SizeY' for element 'marker'
          _view.scale.linkProperty("SizeX",  function() { return 0.5*meterSize; } ); // HtmlView Page linking property 'SizeX' for element 'scale'
          _view.scale.linkProperty("X",  function() { return -0.5*meterSize/2; } ); // HtmlView Page linking property 'X' for element 'scale'
          _view.scale.linkProperty("Y",  function() { return scale; }, function(_v) { scale = _v; } ); // HtmlView Page linking property 'Y' for element 'scale'
          _view.textSet.linkProperty("Y",  function() { return scale; }, function(_v) { scale = _v; } ); // HtmlView Page linking property 'Y' for element 'textSet'
          _view.massGroup.linkProperty("X",  function() { return xSpace*.6; } ); // HtmlView Page linking property 'X' for element 'massGroup'
          _view.massGroup.linkProperty("Y",  function() { return ySpace*.2; } ); // HtmlView Page linking property 'Y' for element 'massGroup'
          _view.text.linkProperty("Text",  function() { return heatLabel; }, function(_v) { heatLabel = _v; } ); // HtmlView Page linking property 'Text' for element 'text'
          _view.mass.linkProperty("Y",  function() { return m/4; } ); // HtmlView Page linking property 'Y' for element 'mass'
          _view.mass.linkProperty("SizeY",  function() { return m/2; } ); // HtmlView Page linking property 'SizeY' for element 'mass'
          _view.playPauseButton.setAction("OffClick", function() {
  _pause();

}); // HtmlView Page setting action 'OffClick' for element 'playPauseButton'
          _view.playPauseButton.linkProperty("State",  function() { return _isPaused; } ); // HtmlView Page linking property 'State' for element 'playPauseButton'
          _view.playPauseButton.setAction("OnClick", function() {
  dt=Math.abs(dt);
  _play();

}); // HtmlView Page setting action 'OnClick' for element 'playPauseButton'
          _view.stepForwardButton.setAction("OnPress", function() {
  _pause();
  _step();

}); // HtmlView Page setting action 'OnPress' for element 'stepForwardButton'
          _view.stepBackButton.setAction("OnPress", function() {
  _pause();
  dt=-Math.abs(dt);
  _step();

}); // HtmlView Page setting action 'OnPress' for element 'stepBackButton'
          _view.restartButton.setAction("OnPress", function() {
  _initialize();

}); // HtmlView Page setting action 'OnPress' for element 'restartButton'
          _view.massField.linkProperty("Value",  function() { return m; }, function(_v) { m = _v; } ); // HtmlView Page linking property 'Value' for element 'massField'
          _view.massField.setAction("OnChange", _initialize); // HtmlView Page setting action 'OnChange' for element 'massField'
          _view.bottomPanel.linkProperty("Width",  function() { return width; }, function(_v) { width = _v; } ); // HtmlView Page linking property 'Width' for element 'bottomPanel'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(false);
  _model.setFPS(20);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function ch19_i01_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = ch19_i01_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);


  return _view;
} // end of main function

function ch19_i01_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.panel,"topPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'topPanel'
      .setProperty("Html","<h1></h1>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'topPanel'
      ;

    _view._addElement(EJSS_INTERFACE.wrappedPanel,"wrappedPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'wrappedPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"radioPanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'radioPanel'
      .setProperty("CSS",{"display":"inline-block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'radioPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"hLabel", _view.radioPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'hLabel'
      .setProperty("Text","Calor: ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'hLabel'
      .setProperty("Font","normal normal 14px ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'hLabel'
      ;

    _view._addElement(EJSS_INTERFACE.radioButton,"heat1", _view.radioPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'heat1'
      .setProperty("Checked",true) // EJsS HtmlView.HtmlView Page: setting property 'Checked' for element 'heat1'
      .setProperty("Text","Alto") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'heat1'
      ;

    _view._addElement(EJSS_INTERFACE.radioButton,"heat2", _view.radioPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'heat2'
      .setProperty("Text","Bajo") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'heat2'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"panel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'panel'
      ;

    _view._addElement(EJSS_DRAWING2D.drawingPanel,"drawingPanel", _view.panel,"GRAPHICS2D_CANVAS") // EJsS HtmlView.HtmlView Page: declaration of element 'drawingPanel'
      .setProperty("ShowCoordinates",true) // EJsS HtmlView.HtmlView Page: setting property 'ShowCoordinates' for element 'drawingPanel'
      .setProperty("Background","White") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'drawingPanel'
      .setProperty("Enabled",true) // EJsS HtmlView.HtmlView Page: setting property 'Enabled' for element 'drawingPanel'
      .setProperty("SquareAspect",false) // EJsS HtmlView.HtmlView Page: setting property 'SquareAspect' for element 'drawingPanel'
      .setProperty("MinimumX",0) // EJsS HtmlView.HtmlView Page: setting property 'MinimumX' for element 'drawingPanel'
      .setProperty("MinimumY",0) // EJsS HtmlView.HtmlView Page: setting property 'MinimumY' for element 'drawingPanel'
      .setProperty("AutoScaleY",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleY' for element 'drawingPanel'
      .setProperty("AutoScaleX",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleX' for element 'drawingPanel'
      .setProperty("GraphicsMode","Canvas") // EJsS HtmlView.HtmlView Page: setting property 'GraphicsMode' for element 'drawingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"time", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'time'
      .setProperty("Font","normal normal 15px ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'time'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"title", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'title'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"ThermoGroup", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'ThermoGroup'
      .setProperty("Visibility",true) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'ThermoGroup'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"back", _view.ThermoGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'back'
      .setProperty("FillColor","Gray") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'back'
      .setProperty("ShapeType","ROUND_RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'back'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'back'
      .setProperty("LineColor","Gray") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'back'
      .setProperty("DrawFill",true) // EJsS HtmlView.HtmlView Page: setting property 'DrawFill' for element 'back'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"bulb", _view.ThermoGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'bulb'
      .setProperty("FillColor","Gray") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'bulb'
      .setProperty("ShapeType","ELLIPSE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'bulb'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'bulb'
      .setProperty("LineColor","Gray") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'bulb'
      .setProperty("Y",0) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'bulb'
      .setProperty("DrawFill",true) // EJsS HtmlView.HtmlView Page: setting property 'DrawFill' for element 'bulb'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"bulbRed", _view.ThermoGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'bulbRed'
      .setProperty("FillColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'bulbRed'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'bulbRed'
      .setProperty("LineColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'bulbRed'
      .setProperty("Y",0) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'bulbRed'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"marker", _view.ThermoGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'marker'
      .setProperty("FillColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'marker'
      .setProperty("ShapeType","RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'marker'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'marker'
      .setProperty("LineColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'marker'
      ;

    _view._addElement(EJSS_DRAWING2D.segmentSet,"scale", _view.ThermoGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'scale'
      .setProperty("NumberOfElements",5) // EJsS HtmlView.HtmlView Page: setting property 'NumberOfElements' for element 'scale'
      .setProperty("SizeY",0) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'scale'
      ;

    _view._addElement(EJSS_DRAWING2D.textSet,"textSet", _view.ThermoGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'textSet'
      .setProperty("NumberOfElements",5) // EJsS HtmlView.HtmlView Page: setting property 'NumberOfElements' for element 'textSet'
      .setProperty("X",-0.5) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'textSet'
      .setProperty("Text",[20,21,22,23,24]) // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'textSet'
      .setProperty("Font","normal normal 10px ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'textSet'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"massGroup", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'massGroup'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"heater", _view.massGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'heater'
      .setProperty("FillColor","Orange") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'heater'
      .setProperty("SizeX",2) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'heater'
      .setProperty("ShapeType","RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'heater'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'heater'
      .setProperty("Y",-0.5) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'heater'
      .setProperty("SizeY",1) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'heater'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"text", _view.massGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'text'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'text'
      .setProperty("Y",-0.5) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'text'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"box", _view.massGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'box'
      .setProperty("SizeX",3) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'box'
      .setProperty("ShapeType","ROUND_RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'box'
      .setProperty("LineColor","Black") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'box'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'box'
      .setProperty("Y",1.5) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'box'
      .setProperty("SizeY",3) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'box'
      .setProperty("LineWidth",4) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'box'
      .setProperty("DrawFill",false) // EJsS HtmlView.HtmlView Page: setting property 'DrawFill' for element 'box'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"mass", _view.massGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'mass'
      .setProperty("SizeX",1) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'mass'
      .setProperty("ShapeType","RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'mass'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'mass'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"controlPanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'controlPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"buttonPanel", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'buttonPanel'
      .setProperty("CSS",{ "display":"inline-block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'buttonPanel'
      .setProperty("BorderStyle","double") // EJsS HtmlView.HtmlView Page: setting property 'BorderStyle' for element 'buttonPanel'
      .setProperty("BorderColor","BLACK") // EJsS HtmlView.HtmlView Page: setting property 'BorderColor' for element 'buttonPanel'
      .setProperty("BorderWidth",1) // EJsS HtmlView.HtmlView Page: setting property 'BorderWidth' for element 'buttonPanel'
      ;

    _view._addElement(EJSS_INTERFACE.twoStateButton,"playPauseButton", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'playPauseButton'
      .setProperty("ImageOnUrl","/org/opensourcephysics/resources/controls/images/play.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageOnUrl' for element 'playPauseButton'
      .setProperty("ImageOffUrl","/org/opensourcephysics/resources/controls/images/pause.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageOffUrl' for element 'playPauseButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"stepForwardButton", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'stepForwardButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/stepforward.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'stepForwardButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"stepBackButton", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'stepBackButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/stepback.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'stepBackButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"restartButton", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'restartButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/reset.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'restartButton'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"inputPanel", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'inputPanel'
      .setProperty("CSS",{ "display":"inline-block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'inputPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"massLabel", _view.inputPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'massLabel'
      .setProperty("Text","    Masa:") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'massLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"massField", _view.inputPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'massField'
      .setProperty("Width",30) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'massField'
      .setProperty("Format","1.0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'massField'
      .setProperty("Editable",true) // EJsS HtmlView.HtmlView Page: setting property 'Editable' for element 'massField'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"bottomPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'bottomPanel'
      .setProperty("Html","<h1></h1> <p></p>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'bottomPanel'
      ;

  };

  return _view;
}



      var _model;
      window.addEventListener('load',
        function () { 
          _model =  new ch19_i01("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined" && _isApp) _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
      var interval = setInterval(function() {
         if(document.readyState === 'complete') {
           window.addEventListener('resize', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           window.addEventListener('scroll', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           var startCaptureBut = document.getElementById('startCaptureBut'); 
           var stopCaptureBut = document.getElementById('stopCaptureBut'); 
           var resetCaptureBut = document.getElementById('resetCaptureBut'); 
           var playCaptureBut = document.getElementById('playCaptureBut'); 
           var stepCaptureBut = document.getElementById('stepCaptureBut'); 
           if (startCaptureBut) {
             startCaptureBut.onclick = function() {
               _model.startCapture();
             };
             stopCaptureBut.onclick = function() {
               _model.saveText('recording','rec',JSON.stringify(_model.stopCapture()));
             };
             resetCaptureBut.onclick = function() {
               _model.resetCapture();
             };
             playCaptureBut.onclick = function() {
               _model.readText(null,'.rec',function(content){
               _model.playCapture(JSON.parse(content),function(){startCaptureBut.disabled=false; playCaptureBut.disabled=false; stepCaptureBut.disabled=false; window.alert(end_reproduction_message);});               });
             };
             stepCaptureBut.onchange= function() {
               var stepCapt;
               if (stepCaptureBut.value >= 0) stepCapt =  stepCaptureBut.value + 1;
               else stepCapt = 1 + 1.8*stepCaptureBut.value/8;
               _model.changeCaptureStep(stepCapt);
             };
           }
           clearInterval(interval);
         };
      }, 200)
