function CoulombField_movingTestCharge(_topFrame,_libraryPath,_codebasePath) {
  var _model = EJSS_CORE.createAnimation();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = {
    showInputDialog : EJSS_INTERFACE.BoxPanel.showInputDialog,
    showOkDialog : EJSS_INTERFACE.BoxPanel.showOkDialog,
    showOkCancelDialog : EJSS_INTERFACE.BoxPanel.showOkCancelDialog
  };

  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var width; // EjsS Model.Variables.Drawing Vars.width
  var height; // EjsS Model.Variables.Drawing Vars.height
  var xmin; // EjsS Model.Variables.Drawing Vars.xmin
  var xmax; // EjsS Model.Variables.Drawing Vars.xmax
  var ymin; // EjsS Model.Variables.Drawing Vars.ymin
  var ymax; // EjsS Model.Variables.Drawing Vars.ymax
  var headSize; // EjsS Model.Variables.Drawing Vars.headSize
  var lower; // EjsS Model.Variables.Drawing Vars.lower
  var upper; // EjsS Model.Variables.Drawing Vars.upper

  var n; // EjsS Model.Variables.Charge Vars.n
  var nMax; // EjsS Model.Variables.Charge Vars.nMax
  var nPos; // EjsS Model.Variables.Charge Vars.nPos
  var nNeg; // EjsS Model.Variables.Charge Vars.nNeg
  var x; // EjsS Model.Variables.Charge Vars.x
  var y; // EjsS Model.Variables.Charge Vars.y
  var vis; // EjsS Model.Variables.Charge Vars.vis
  var q; // EjsS Model.Variables.Charge Vars.q
  var qColor; // EjsS Model.Variables.Charge Vars.qColor
  var scale; // EjsS Model.Variables.Charge Vars.scale
  var msgStr; // EjsS Model.Variables.Charge Vars.msgStr

  var nx; // EjsS Model.Variables.Field Vars.nx
  var ny; // EjsS Model.Variables.Field Vars.ny
  var xPos; // EjsS Model.Variables.Field Vars.xPos
  var yPos; // EjsS Model.Variables.Field Vars.yPos
  var data; // EjsS Model.Variables.Field Vars.data
  var vectorField; // EjsS Model.Variables.Field Vars.vectorField

  var nq; // EjsS Model.Variables.Test Charge Vars.nq
  var nTestMax; // EjsS Model.Variables.Test Charge Vars.nTestMax
  var visTest; // EjsS Model.Variables.Test Charge Vars.visTest
  var clearTrail; // EjsS Model.Variables.Test Charge Vars.clearTrail
  var msgCollision; // EjsS Model.Variables.Test Charge Vars.msgCollision

  var t; // EjsS Model.Variables.Dynamic Vars.t
  var dt; // EjsS Model.Variables.Dynamic Vars.dt
  var xTest; // EjsS Model.Variables.Dynamic Vars.xTest
  var yTest; // EjsS Model.Variables.Dynamic Vars.yTest
  var ExTest; // EjsS Model.Variables.Dynamic Vars.ExTest
  var EyTest; // EjsS Model.Variables.Dynamic Vars.EyTest
  var vxTest; // EjsS Model.Variables.Dynamic Vars.vxTest
  var vyTest; // EjsS Model.Variables.Dynamic Vars.vyTest

  var _privateOdesList;
  var _ODEi_evolution1;

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      width : width,
      height : height,
      xmin : xmin,
      xmax : xmax,
      ymin : ymin,
      ymax : ymax,
      headSize : headSize,
      lower : lower,
      upper : upper,
      n : n,
      nMax : nMax,
      nPos : nPos,
      nNeg : nNeg,
      x : x,
      y : y,
      vis : vis,
      q : q,
      qColor : qColor,
      scale : scale,
      msgStr : msgStr,
      nx : nx,
      ny : ny,
      xPos : xPos,
      yPos : yPos,
      data : data,
      vectorField : vectorField,
      nq : nq,
      nTestMax : nTestMax,
      visTest : visTest,
      clearTrail : clearTrail,
      msgCollision : msgCollision,
      t : t,
      dt : dt,
      xTest : xTest,
      yTest : yTest,
      ExTest : ExTest,
      EyTest : EyTest,
      vxTest : vxTest,
      vyTest : vyTest
    };
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model._userUnserialize = function(json) {
    if(typeof json.width != "undefined") width = json.width;
    if(typeof json.height != "undefined") height = json.height;
    if(typeof json.xmin != "undefined") xmin = json.xmin;
    if(typeof json.xmax != "undefined") xmax = json.xmax;
    if(typeof json.ymin != "undefined") ymin = json.ymin;
    if(typeof json.ymax != "undefined") ymax = json.ymax;
    if(typeof json.headSize != "undefined") headSize = json.headSize;
    if(typeof json.lower != "undefined") lower = json.lower;
    if(typeof json.upper != "undefined") upper = json.upper;
    if(typeof json.n != "undefined") n = json.n;
    if(typeof json.nMax != "undefined") nMax = json.nMax;
    if(typeof json.nPos != "undefined") nPos = json.nPos;
    if(typeof json.nNeg != "undefined") nNeg = json.nNeg;
    if(typeof json.x != "undefined") x = json.x;
    if(typeof json.y != "undefined") y = json.y;
    if(typeof json.vis != "undefined") vis = json.vis;
    if(typeof json.q != "undefined") q = json.q;
    if(typeof json.qColor != "undefined") qColor = json.qColor;
    if(typeof json.scale != "undefined") scale = json.scale;
    if(typeof json.msgStr != "undefined") msgStr = json.msgStr;
    if(typeof json.nx != "undefined") nx = json.nx;
    if(typeof json.ny != "undefined") ny = json.ny;
    if(typeof json.xPos != "undefined") xPos = json.xPos;
    if(typeof json.yPos != "undefined") yPos = json.yPos;
    if(typeof json.data != "undefined") data = json.data;
    if(typeof json.vectorField != "undefined") vectorField = json.vectorField;
    if(typeof json.nq != "undefined") nq = json.nq;
    if(typeof json.nTestMax != "undefined") nTestMax = json.nTestMax;
    if(typeof json.visTest != "undefined") visTest = json.visTest;
    if(typeof json.clearTrail != "undefined") clearTrail = json.clearTrail;
    if(typeof json.msgCollision != "undefined") msgCollision = json.msgCollision;
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.dt != "undefined") dt = json.dt;
    if(typeof json.xTest != "undefined") xTest = json.xTest;
    if(typeof json.yTest != "undefined") yTest = json.yTest;
    if(typeof json.ExTest != "undefined") ExTest = json.ExTest;
    if(typeof json.EyTest != "undefined") EyTest = json.EyTest;
    if(typeof json.vxTest != "undefined") vxTest = json.vxTest;
    if(typeof json.vyTest != "undefined") vyTest = json.vyTest;
   _resetSolvers();
   _model.update();
  };

  _model.addToReset(function() {
    __pagesEnabled["Init Vector Field"] = true;
    __pagesEnabled["Evol Page"] = true;
    __pagesEnabled["Compute Electric Field"] = false;
    __pagesEnabled["Compute Field"] = true;
  });

  _model.addToReset(function() {
    width = (_isMobile||_isEPub)?400:600; // EjsS Model.Variables.Drawing Vars.width
    height = (_isMobile||_isEPub)?400:600; // EjsS Model.Variables.Drawing Vars.height
    xmin = -10; // EjsS Model.Variables.Drawing Vars.xmin
    xmax = 10; // EjsS Model.Variables.Drawing Vars.xmax
    ymin = -10; // EjsS Model.Variables.Drawing Vars.ymin
    ymax = 10; // EjsS Model.Variables.Drawing Vars.ymax
    headSize = 3; // EjsS Model.Variables.Drawing Vars.headSize
    lower = 0.2; // EjsS Model.Variables.Drawing Vars.lower
    upper = 1.0; // EjsS Model.Variables.Drawing Vars.upper
  });

  _model.addToReset(function() {
    n = 1; // EjsS Model.Variables.Charge Vars.n
    nMax = 20; // EjsS Model.Variables.Charge Vars.nMax
    nPos = 1; // EjsS Model.Variables.Charge Vars.nPos
    nNeg = 1; // EjsS Model.Variables.Charge Vars.nNeg
    x = new Array(nMax); // EjsS Model.Variables.Charge Vars.x
    y = new Array(nMax); // EjsS Model.Variables.Charge Vars.y
    vis = new Array(nMax); // EjsS Model.Variables.Charge Vars.vis
    (function () {
      var _i0;
      for (_i0=0; _i0<nMax; _i0+=1) {  // EjsS Model.Variables.Charge Vars.vis
        vis[_i0] = false;  // EjsS Model.Variables.Charge Vars.vis
      }
    }());
    q = new Array(nMax); // EjsS Model.Variables.Charge Vars.q
    (function () {
      var _i0;
      for (_i0=0; _i0<nMax; _i0+=1) {  // EjsS Model.Variables.Charge Vars.q
        q[_i0] = 1;  // EjsS Model.Variables.Charge Vars.q
      }
    }());
    qColor = new Array(nMax); // EjsS Model.Variables.Charge Vars.qColor
    scale = 3; // EjsS Model.Variables.Charge Vars.scale
    msgStr = ""; // EjsS Model.Variables.Charge Vars.msgStr
  });

  _model.addToReset(function() {
    nx = 18; // EjsS Model.Variables.Field Vars.nx
    ny = 18; // EjsS Model.Variables.Field Vars.ny
    xPos = new Array(0); // EjsS Model.Variables.Field Vars.xPos
    (function () {
      var _i0;
      for (_i0=0; _i0<0; _i0+=1) {  // EjsS Model.Variables.Field Vars.xPos
        xPos[_i0] = 0;  // EjsS Model.Variables.Field Vars.xPos
      }
    }());
    yPos = new Array(0); // EjsS Model.Variables.Field Vars.yPos
    (function () {
      var _i0;
      for (_i0=0; _i0<0; _i0+=1) {  // EjsS Model.Variables.Field Vars.yPos
        yPos[_i0] = 0;  // EjsS Model.Variables.Field Vars.yPos
      }
    }());
    data = new Array(1); // EjsS Model.Variables.Field Vars.data
  });

  _model.addToReset(function() {
    nq = 1; // EjsS Model.Variables.Test Charge Vars.nq
    nTestMax = 20; // EjsS Model.Variables.Test Charge Vars.nTestMax
    visTest = new Array(nTestMax); // EjsS Model.Variables.Test Charge Vars.visTest
    (function () {
      var _i0;
      for (_i0=0; _i0<nTestMax; _i0+=1) {  // EjsS Model.Variables.Test Charge Vars.visTest
        visTest[_i0] = false;  // EjsS Model.Variables.Test Charge Vars.visTest
      }
    }());
    clearTrail = false; // EjsS Model.Variables.Test Charge Vars.clearTrail
    msgCollision = ""; // EjsS Model.Variables.Test Charge Vars.msgCollision
  });

  _model.addToReset(function() {
    t = 0; // EjsS Model.Variables.Dynamic Vars.t
    dt = 0.01; // EjsS Model.Variables.Dynamic Vars.dt
    xTest = new Array(nTestMax); // EjsS Model.Variables.Dynamic Vars.xTest
    (function () {
      var _i0;
      for (_i0=0; _i0<nTestMax; _i0+=1) {  // EjsS Model.Variables.Dynamic Vars.xTest
        xTest[_i0] = 0;  // EjsS Model.Variables.Dynamic Vars.xTest
      }
    }());
    yTest = new Array(nTestMax); // EjsS Model.Variables.Dynamic Vars.yTest
    (function () {
      var _i0;
      for (_i0=0; _i0<nTestMax; _i0+=1) {  // EjsS Model.Variables.Dynamic Vars.yTest
        yTest[_i0] = 0;  // EjsS Model.Variables.Dynamic Vars.yTest
      }
    }());
    ExTest = new Array(nTestMax); // EjsS Model.Variables.Dynamic Vars.ExTest
    (function () {
      var _i0;
      for (_i0=0; _i0<nTestMax; _i0+=1) {  // EjsS Model.Variables.Dynamic Vars.ExTest
        ExTest[_i0] = 0;  // EjsS Model.Variables.Dynamic Vars.ExTest
      }
    }());
    EyTest = new Array(nTestMax); // EjsS Model.Variables.Dynamic Vars.EyTest
    (function () {
      var _i0;
      for (_i0=0; _i0<nTestMax; _i0+=1) {  // EjsS Model.Variables.Dynamic Vars.EyTest
        EyTest[_i0] = 0;  // EjsS Model.Variables.Dynamic Vars.EyTest
      }
    }());
    vxTest = new Array(nTestMax); // EjsS Model.Variables.Dynamic Vars.vxTest
    (function () {
      var _i0;
      for (_i0=0; _i0<nTestMax; _i0+=1) {  // EjsS Model.Variables.Dynamic Vars.vxTest
        vxTest[_i0] = 0;  // EjsS Model.Variables.Dynamic Vars.vxTest
      }
    }());
    vyTest = new Array(nTestMax); // EjsS Model.Variables.Dynamic Vars.vyTest
    (function () {
      var _i0;
      for (_i0=0; _i0<nTestMax; _i0+=1) {  // EjsS Model.Variables.Dynamic Vars.vyTest
        vyTest[_i0] = 0;  // EjsS Model.Variables.Dynamic Vars.vyTest
      }
    }());
  });

  _model.addToReset(function() {
    _privateOdesList=[];
    _ODEi_evolution1 = _ODE_evolution1();
    _privateOdesList.push(_ODEi_evolution1);
  });

  _model.addToReset(function() {
    _model.setAutoplay(false);
    _model.setPauseOnPageExit(true);
    _model.setFPS(10);
    _model.setStepsPerDisplay(1);
  });

  function drawVectorField(context,element) {  // > CustomCode.Draw Vectors:1
    //if(!showField) return;  // > CustomCode.Draw Vectors:2
    var ospCanvas = new OSPCanvas(context,element, xmin,xmax,ymin,ymax);  // > CustomCode.Draw Vectors:3
    vectorField.updateData(data);  // > CustomCode.Draw Vectors:4
    ospCanvas.addDrawable(vectorField);  // > CustomCode.Draw Vectors:5
    ospCanvas.drawObjects();  // > CustomCode.Draw Vectors:6
  }  // > CustomCode.Draw Vectors:7

  function createData() {  // > CustomCode.Create Data Array:1
    var newXData= [];  // > CustomCode.Create Data Array:2
    var newYData= [];  // > CustomCode.Create Data Array:3
    for(var i=0; i<nx; i++) {  // > CustomCode.Create Data Array:4
      newXData.push([]);  // > CustomCode.Create Data Array:5
      newYData.push([]);  // > CustomCode.Create Data Array:6
      for (var j=0; j<ny; j++) {  // > CustomCode.Create Data Array:7
        newXData[i].push(0); //adds the value to the data  // > CustomCode.Create Data Array:8
        newYData[i].push(0); //adds the value to the data  // > CustomCode.Create Data Array:9
      }  // > CustomCode.Create Data Array:10
    }  // > CustomCode.Create Data Array:11
    return [newXData,newYData]; //returns new component arrays  // > CustomCode.Create Data Array:12
  }  // > CustomCode.Create Data Array:13

  function addTestCharge () {  // > CustomCode.addTestCharge:1
    clearTrail=true; //hide trail when adding a new test charge  // > CustomCode.addTestCharge:2
    xTest[nq]=xmin+(xmax-xmin)*Math.random();  // > CustomCode.addTestCharge:3
    yTest[nq]=ymin+(ymax-ymin)*Math.random();  // > CustomCode.addTestCharge:4
    visTest[nq]=true;  // > CustomCode.addTestCharge:5
    getETest(); //calculate value of E Field for test charge  // > CustomCode.addTestCharge:6
    nq=1+nq;  // > CustomCode.addTestCharge:7
    _pause();  // > CustomCode.addTestCharge:8
  }  // > CustomCode.addTestCharge:9

  function getETest () {  // > CustomCode.EField_Test:1
    for (var i=0;i<nq; i++) {  // > CustomCode.EField_Test:2
      ExTest[i]=0;  // > CustomCode.EField_Test:3
      EyTest[i]=0;  // > CustomCode.EField_Test:4
      for(var p=0; p<n; p++) {  // > CustomCode.EField_Test:5
        // loop over charges  // > CustomCode.EField_Test:6
        var dx=xTest[i]-x[p];                      // grid point x-separation  // > CustomCode.EField_Test:7
        var dy=yTest[i]-y[p];                      // grid point y-separation  // > CustomCode.EField_Test:8
        var r2=dx*dx+dy*dy;                  // distance squared  // > CustomCode.EField_Test:9
        var r3=r2*Math.sqrt(r2);             // distance cubed  // > CustomCode.EField_Test:10
        if (r2>0.2){  // > CustomCode.EField_Test:11
        // check for collision  // > CustomCode.EField_Test:12
          ExTest[i]+= 1000*q[p]*dx/r3;               // add E field x-component  // > CustomCode.EField_Test:13
          EyTest[i]+= 1000*q[p]*dy/r3;               // add E field y-component  // > CustomCode.EField_Test:14
        }  // > CustomCode.EField_Test:15
        else{  // > CustomCode.EField_Test:16
          msgCollision="Collision";  // > CustomCode.EField_Test:17
          _pause();  // > CustomCode.EField_Test:18
          }  // > CustomCode.EField_Test:19
      }  // > CustomCode.EField_Test:20
    }  // > CustomCode.EField_Test:21
  }  // > CustomCode.EField_Test:22

  _model.addToInitialization(function() {
    if (!__pagesEnabled["Init Vector Field"]) return;
    _view.custom.setFunction(drawVectorField);  // > Initialization.Init Vector Field:1
    _view._update();  // updates the function Field and draws the wave function   // > Initialization.Init Vector Field:2
    xPos= arrayCoordinates(xmin, xmax, nx); // returns array(nx);  // > Initialization.Init Vector Field:3
    yPos= arrayCoordinates(ymin, ymax, ny); // returns array(nx);  // > Initialization.Init Vector Field:4
    data=createData();  // creates component arrays  // > Initialization.Init Vector Field:5
    vectorField = new VectorField(data, xmin,xmax,nx,ymin,ymax,ny);  // > Initialization.Init Vector Field:6
    vectorField.setThreshold(lower,upper);  // > Initialization.Init Vector Field:7
    t=0;  // > Initialization.Init Vector Field:8
    n=nPos+nNeg;  // > Initialization.Init Vector Field:9
    //check number of charges  // > Initialization.Init Vector Field:10
    if (n<1 || n>20){  // > Initialization.Init Vector Field:11
      msgStr = "Number of charges must be between 1 and 20";  // > Initialization.Init Vector Field:12
      n=2;  // > Initialization.Init Vector Field:13
      nPos=1;  // > Initialization.Init Vector Field:14
      nNeg=1;  // > Initialization.Init Vector Field:15
      }  // > Initialization.Init Vector Field:16
     else {  // > Initialization.Init Vector Field:17
       msgStr ="";  // > Initialization.Init Vector Field:18
       }  // > Initialization.Init Vector Field:19
    //initialize position of charges  // > Initialization.Init Vector Field:20
    for (var i=0;i<nPos;i++){  // > Initialization.Init Vector Field:21
      x[i]=xmax*(i/n);  // > Initialization.Init Vector Field:22
      y[i]=0;  // > Initialization.Init Vector Field:23
      q[i]=1;  // > Initialization.Init Vector Field:24
      vis[i]=true;  // > Initialization.Init Vector Field:25
      qColor[i]="rgb(255,0,0)";  // > Initialization.Init Vector Field:26
      }  // > Initialization.Init Vector Field:27
    for (var i=nPos;i<n;i++){  // > Initialization.Init Vector Field:28
      x[i]=xmax*(i/n);  // > Initialization.Init Vector Field:29
      y[i]=ymin/2;  // > Initialization.Init Vector Field:30
      q[i]=-1;  // > Initialization.Init Vector Field:31
      vis[i]=true;  // > Initialization.Init Vector Field:32
      qColor[i]="rgb(0,0,255)";  // > Initialization.Init Vector Field:33
      }  // > Initialization.Init Vector Field:34
        // > Initialization.Init Vector Field:35
      //make old charges invisible  // > Initialization.Init Vector Field:36
      for (var i=n; i<nMax; i++){  // > Initialization.Init Vector Field:37
      vis[i]=false;  // > Initialization.Init Vector Field:38
      }  // > Initialization.Init Vector Field:39
    //make test charges invisible & set initial velocity=0 & add one test charge  // > Initialization.Init Vector Field:40
      for(var i=0;i<nTestMax;i++){  // > Initialization.Init Vector Field:41
        visTest[i]=false;  // > Initialization.Init Vector Field:42
        vxTest[i]=0;  // > Initialization.Init Vector Field:43
        vyTest[i]=0;  // > Initialization.Init Vector Field:44
        }  // > Initialization.Init Vector Field:45
      nq=0;  // > Initialization.Init Vector Field:46
      addTestCharge();  // > Initialization.Init Vector Field:47
  });

  _model.addToInitialization(function() {
    _initializeSolvers();
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Evol Page"]) return;
    _ODEi_evolution1.step();
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["Compute Electric Field"]) return;
    for (var i=0; i<nx; i++) {  // > FixedRelations.Compute Electric Field:1
      for (var j=0; j<ny; j++) {  // > FixedRelations.Compute Electric Field:2
        xField[i][j]=0;  // > FixedRelations.Compute Electric Field:3
        yField[i][j]=0;  // > FixedRelations.Compute Electric Field:4
        var xi=xPos[i][j];  // > FixedRelations.Compute Electric Field:5
        var yj=yPos[i][j];  // > FixedRelations.Compute Electric Field:6
        for(var p=0; p<n; p++) {  // > FixedRelations.Compute Electric Field:7
          var dx=xi-x[p];                      // grid point x-separation  // > FixedRelations.Compute Electric Field:8
          var dy=yj-y[p];                      // grid point y-separation  // > FixedRelations.Compute Electric Field:9
          var r2=dx*dx+dy*dy;                  // distance squared  // > FixedRelations.Compute Electric Field:10
          var r3=r2*Math.sqrt(r2);             // distance cubed  // > FixedRelations.Compute Electric Field:11
          if(r2!=0) {  // > FixedRelations.Compute Electric Field:12
            // check for singularity  // > FixedRelations.Compute Electric Field:13
            xField[i][j] += scale*q[p]*dx/r3;               // add E field x-component  // > FixedRelations.Compute Electric Field:14
            yField[i][j] += scale*q[p]*dy/r3;               // add E field y-component  // > FixedRelations.Compute Electric Field:15
          } // end of if statement  // > FixedRelations.Compute Electric Field:16
        }  // > FixedRelations.Compute Electric Field:17
      }  // > FixedRelations.Compute Electric Field:18
    }  // > FixedRelations.Compute Electric Field:19
    getETest();//calculate E-Field at location of test charges  // > FixedRelations.Compute Electric Field:20
  });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["Compute Field"]) return;
    var xField=data[0];  // > FixedRelations.Compute Field:1
    var yField=data[1];  // > FixedRelations.Compute Field:2
    for (var i=0; i<nx; i++) {  // > FixedRelations.Compute Field:3
      for (var j=0; j<ny; j++) {  // > FixedRelations.Compute Field:4
        xField[i][j]=0;  // > FixedRelations.Compute Field:5
        yField[i][j]=0;  // > FixedRelations.Compute Field:6
        var xi=xPos[i];  // > FixedRelations.Compute Field:7
        var yj=yPos[j];  // > FixedRelations.Compute Field:8
        for(var p=0; p<n; p++) {  // > FixedRelations.Compute Field:9
          // loop over charges  // > FixedRelations.Compute Field:10
          var dx=xi-x[p];                      // grid point x-separation  // > FixedRelations.Compute Field:11
          var dy=yj-y[p];                      // grid point y-separation  // > FixedRelations.Compute Field:12
          var r2=dx*dx+dy*dy;                  // distance squared  // > FixedRelations.Compute Field:13
          var r3=r2*Math.sqrt(r2);             // distance cubed  // > FixedRelations.Compute Field:14
          if(r2!=0) {  // > FixedRelations.Compute Field:15
            // check for singularity  // > FixedRelations.Compute Field:16
            xField[i][j] += scale*q[p]*dx/r3;               // add E field x-component  // > FixedRelations.Compute Field:17
            yField[i][j] += scale*q[p]*dy/r3;               // add E field y-component  // > FixedRelations.Compute Field:18
          } // end of if statement  // > FixedRelations.Compute Field:19
        }  // > FixedRelations.Compute Field:20
      }  // > FixedRelations.Compute Field:21
    }  // > FixedRelations.Compute Field:22
    getETest();//calculate E-Field at location of test charges  // > FixedRelations.Compute Field:23
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  function _initializeSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].initializeSolver();
  }

  function _automaticResetSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].automaticResetSolver();
  }

  _model.resetSolvers = function() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].resetSolver();
  };

  function _getODE(_odeName) {
    if (_odeName=="Evol Page") return _ODEi_evolution1;
    return null;
  }

  function _getEventSolver(_odeName) {
    var ode = _getODE(_odeName);
    if (ode===null) return null;
    return ode.getEventSolver();
  }

  function _setSolverClass(_odeName, _engine) {
    var ode = _getODE(_odeName);
    if (ode===null) return;
    if (!_engine.setODE) {
      var classname = _engine.toLowerCase();
      if      (classname.indexOf("boga")>=0)   _engine = EJSS_ODE_SOLVERS.bogackiShampine23;
      else if (classname.indexOf("cash")>=0)   _engine = EJSS_ODE_SOLVERS.cashKarp45;
      else if (classname.indexOf("dopri5")>=0) _engine = EJSS_ODE_SOLVERS.dopri5;
      else if (classname.indexOf("dopri8")>=0) _engine = EJSS_ODE_SOLVERS.dopri853;
      else if (classname.indexOf("richa")>=0)  _engine = EJSS_ODE_SOLVERS.eulerRichardson;
      else if (classname.indexOf("euler")>=0)  _engine = EJSS_ODE_SOLVERS.euler;
      else if (classname.indexOf("fehlberg87")>=0) _engine = EJSS_ODE_SOLVERS.fehlberg87;
      else if (classname.indexOf("fehlberg8")>=0)  _engine = EJSS_ODE_SOLVERS.fehlberg8;
      else if (classname.indexOf("radau")>=0)   _engine = EJSS_ODE_SOLVERS.radau5;
      else if (classname.indexOf("runge")>=0)  _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("rk4")>=0)    _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("verlet")>=0) _engine = EJSS_ODE_SOLVERS.velocityVerlet;
    }
    if (_engine) ode.setSolverClass(_engine);
  }

  function _ODE_evolution1() {
    var __odeSelf = {};
    var __eventSolver;
    var __solverClass = EJSS_ODE_SOLVERS.rungeKutta4;
    var __state=[];
    var __ignoreErrors=false;
    var __mustInitialize=true;
    var __isEnabled=true;
    var __mustUserReinitialize=false;
    var __mustReinitialize=true;

    var _xTestLength;
    var _yTestLength;
    var _vxTestLength;
    var _vyTestLength;

    __odeSelf.setSolverClass = function(__aSolverClass) {
      __solverClass = __aSolverClass;
      __instantiateSolver();
    };

    function __instantiateSolver() {
      __state=[];
      _xTestLength = xTest.length;
      _yTestLength = yTest.length;
      _vxTestLength = vxTest.length;
      _vyTestLength = vyTest.length;
      __pushState();
      __eventSolver = EJSS_ODE_SOLVERS.interpolatorEventSolver(__solverClass(),__odeSelf);
      __mustInitialize = true;
    }

    __odeSelf.setEnabled = function(_enabled) { __isEnabled = _enabled; };

    __odeSelf.getIndependentVariableValue = function() { return __eventSolver.getIndependentVariableValue(); };

    __odeSelf.getInternalStepSize = function() { return __eventSolver.getInternalStepSize(); };

    __odeSelf.isAccelerationIndependentOfVelocity = function() { return false; };

    __odeSelf.initializeSolver = function() {
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); return; }
      __pushState();
      __eventSolver.initialize(dt);
      __eventSolver.setBestInterpolation(false);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.removeAllEvents();
      __eventSolver.setEstimateFirstStep(false);
      __eventSolver.setEnableExceptions(false);
      __eventSolver.setTolerances(0.00001,0.00001);
      __mustReinitialize = true;
      __mustInitialize = false;
    };

    function __pushState() {
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
      if (!__mustReinitialize)
        for (__j=0,__n=__cIn; __j<_xTestLength; __j++)
           if (__state[__n++]!=xTest[__j]) { __mustReinitialize = true; break; }
        for (__j=0;__j<_xTestLength; __j++) {
          __state[__cIn++] = xTest[__j];
        }
      if (!__mustReinitialize)
        for (__j=0,__n=__cIn; __j<_yTestLength; __j++)
           if (__state[__n++]!=yTest[__j]) { __mustReinitialize = true; break; }
        for (__j=0;__j<_yTestLength; __j++) {
          __state[__cIn++] = yTest[__j];
        }
      if (!__mustReinitialize)
        for (__j=0,__n=__cIn; __j<_vxTestLength; __j++)
           if (__state[__n++]!=vxTest[__j]) { __mustReinitialize = true; break; }
        for (__j=0;__j<_vxTestLength; __j++) {
          __state[__cIn++] = vxTest[__j];
        }
      if (!__mustReinitialize)
        for (__j=0,__n=__cIn; __j<_vyTestLength; __j++)
           if (__state[__n++]!=vyTest[__j]) { __mustReinitialize = true; break; }
        for (__j=0;__j<_vyTestLength; __j++) {
          __state[__cIn++] = vyTest[__j];
        }
        if (__state[__cIn]!=t) __mustReinitialize = true;
        __state[__cIn++] = t;
    }

    function __arraysChanged () {
      if (_xTestLength != xTest.length) return true;
      if (_yTestLength != yTest.length) return true;
      if (_vxTestLength != vxTest.length) return true;
      if (_vyTestLength != vyTest.length) return true;
      return false;
    }

    __odeSelf.getEventSolver = function() {
      return __eventSolver;
    };

    __odeSelf.resetSolver = function() {
      __mustUserReinitialize = true;
    };

    __odeSelf.automaticResetSolver = function() {
      __mustReinitialize = true;
    };

    function __errorAction () {
      if (__ignoreErrors) return;
      console.log (__eventSolver.getErrorMessage());
      _pause();
      // Make sure the solver is reinitialized;
      __mustReinitialize = true;
    }

    __odeSelf.step = function() { return __privateStep(false); };

    __odeSelf.solverStep = function() { return __privateStep(true); };

    function __privateStep(__takeMaximumStep) {
      if (!__isEnabled) return 0;
      if (dt===0) return 0;
      if (__mustInitialize) __odeSelf.initializeSolver();
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); }
      __eventSolver.setStepSize(dt);
      __eventSolver.setInternalStepSize(dt);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.setTolerances(0.00001,0.00001);
      __pushState();
      if (__mustUserReinitialize) { 
        __eventSolver.userReinitialize();
        __mustUserReinitialize = false;
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      else if (__mustReinitialize) { 
        __eventSolver.reinitialize();
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      var __stepTaken = __takeMaximumStep ? __eventSolver.maxStep() : __eventSolver.step();
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        for (__i=0;__i<_xTestLength; __i++) {
          xTest[__i] = __state[__cOut++];
        }
        for (__i=0;__i<_yTestLength; __i++) {
          yTest[__i] = __state[__cOut++];
        }
        for (__i=0;__i<_vxTestLength; __i++) {
          vxTest[__i] = __state[__cOut++];
        }
        for (__i=0;__i<_vyTestLength; __i++) {
          vyTest[__i] = __state[__cOut++];
        }
        t = __state[__cOut++];
      // Check for error
      if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      return __stepTaken;
    }

    __odeSelf.getState = function() { return __state; };

    __odeSelf.getRate = function(_aState,_aRate) {
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var xTest = [];
        for (__i=0;__i<_xTestLength; __i++) {
          xTest[__i] = _aState[__cOut++];
        }
        var yTest = [];
        for (__i=0;__i<_yTestLength; __i++) {
          yTest[__i] = _aState[__cOut++];
        }
        var vxTest = [];
        for (__i=0;__i<_vxTestLength; __i++) {
          vxTest[__i] = _aState[__cOut++];
        }
        var vyTest = [];
        for (__i=0;__i<_vyTestLength; __i++) {
          vyTest[__i] = _aState[__cOut++];
        }
        var t = _aState[__cOut++];
      // Compute the rate
        var __cRate=0;
        var i;
        for (i=0;i<_xTestLength;i++) {
          _aRate[__cRate++] = Array.isArray(vxTest[i]) ? vxTest[i][i] : vxTest[i]; // Rate for ODE: Evol Page:xTest
        }
        for (i=0;i<_yTestLength;i++) {
          _aRate[__cRate++] = Array.isArray(vyTest[i]) ? vyTest[i][i] : vyTest[i]; // Rate for ODE: Evol Page:yTest
        }
        for (i=0;i<_vxTestLength;i++) {
          _aRate[__cRate++] = Array.isArray(ExTest[i]) ? ExTest[i][i] : ExTest[i]; // Rate for ODE: Evol Page:vxTest
        }
        for (i=0;i<_vyTestLength;i++) {
          _aRate[__cRate++] = Array.isArray(EyTest[i]) ? EyTest[i][i] : EyTest[i]; // Rate for ODE: Evol Page:vyTest
        }
        _aRate[__cRate++] = 1; // independent variable
        return _aRate;
    }; //end of getRate

    __instantiateSolver();

    return __odeSelf;
  }

  function _historic_xTest(__time) {
    var __beginIndex = 0;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,new Array(xTest.length),__beginIndex,xTest.ength);
  }

  function _historic_yTest(__time) {
    var __beginIndex = 0 + xTest.length;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,new Array(yTest.length),__beginIndex,yTest.ength);
  }

  function _historic_vxTest(__time) {
    var __beginIndex = 0 + xTest.length + yTest.length;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,new Array(vxTest.length),__beginIndex,vxTest.ength);
  }

  function _historic_vyTest(__time) {
    var __beginIndex = 0 + xTest.length + yTest.length + vxTest.length;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,new Array(vyTest.length),__beginIndex,vyTest.ength);
  }

    _model._resized = function(_width,_height) {
      _view._resized(_width,_height);
  }; // end of _resized
    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : 800, height : 600 };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new CoulombField_movingTestCharge_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.plottingPanel.linkProperty("Height",  function() { return height; }, function(_v) { height = _v; } ); // HtmlView Page linking property 'Height' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("Width",  function() { return width; }, function(_v) { width = _v; } ); // HtmlView Page linking property 'Width' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MaximumY",  function() { return ymax; }, function(_v) { ymax = _v; } ); // HtmlView Page linking property 'MaximumY' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MaximumX",  function() { return xmax; }, function(_v) { xmax = _v; } ); // HtmlView Page linking property 'MaximumX' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MinimumX",  function() { return xmin; }, function(_v) { xmin = _v; } ); // HtmlView Page linking property 'MinimumX' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MinimumY",  function() { return ymin; }, function(_v) { ymin = _v; } ); // HtmlView Page linking property 'MinimumY' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("BLMessage",  function() { return msgCollision; }, function(_v) { msgCollision = _v; } ); // HtmlView Page linking property 'BLMessage' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("BRMessage",  function() { return msgStr; }, function(_v) { msgStr = _v; } ); // HtmlView Page linking property 'BRMessage' for element 'plottingPanel'
          _view.custom.linkProperty("SizeX",  function() { return xmax-xmin; } ); // HtmlView Page linking property 'SizeX' for element 'custom'
          _view.custom.linkProperty("X",  function() { return xmin; }, function(_v) { xmin = _v; } ); // HtmlView Page linking property 'X' for element 'custom'
          _view.custom.linkProperty("Y",  function() { return ymin; }, function(_v) { ymin = _v; } ); // HtmlView Page linking property 'Y' for element 'custom'
          _view.custom.linkProperty("SizeY",  function() { return ymax-ymin; } ); // HtmlView Page linking property 'SizeY' for element 'custom'
          _view.chargeSet.linkProperty("NumberOfElements",  function() { return n; }, function(_v) { n = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'chargeSet'
          _view.chargeSet.linkProperty("FillColor",  function() { return qColor; }, function(_v) { qColor = _v; } ); // HtmlView Page linking property 'FillColor' for element 'chargeSet'
          _view.chargeSet.linkProperty("X",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView Page linking property 'X' for element 'chargeSet'
          _view.chargeSet.linkProperty("Y",  function() { return y; }, function(_v) { y = _v; } ); // HtmlView Page linking property 'Y' for element 'chargeSet'
          _view.chargeSet.linkProperty("Visibility",  function() { return vis; }, function(_v) { vis = _v; } ); // HtmlView Page linking property 'Visibility' for element 'chargeSet'
          _view.testChargeSet.linkProperty("NumberOfElements",  function() { return nTestMax; }, function(_v) { nTestMax = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'testChargeSet'
          _view.testChargeSet.setAction("OnDrag", function() {
  clearTrail=true;
  for (var i=0;i<n;i++){
    vxTest[i]=0;
    vyTest[i]=0;
    }
    msgCollision="";
    getETest();

}); // HtmlView Page setting action 'OnDrag' for element 'testChargeSet'
          _view.testChargeSet.setAction("OnRelease", function() {
  clearTrail=false;

}); // HtmlView Page setting action 'OnRelease' for element 'testChargeSet'
          _view.testChargeSet.linkProperty("X",  function() { return xTest; }, function(_v) { xTest = _v; } ); // HtmlView Page linking property 'X' for element 'testChargeSet'
          _view.testChargeSet.linkProperty("Y",  function() { return yTest; }, function(_v) { yTest = _v; } ); // HtmlView Page linking property 'Y' for element 'testChargeSet'
          _view.testChargeSet.linkProperty("Visibility",  function() { return visTest; }, function(_v) { visTest = _v; } ); // HtmlView Page linking property 'Visibility' for element 'testChargeSet'
          _view.arrowSet.linkProperty("NumberOfElements",  function() { return nTestMax; }, function(_v) { nTestMax = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'arrowSet'
          _view.arrowSet.linkProperty("SizeX",  function() { return vxTest; }, function(_v) { vxTest = _v; } ); // HtmlView Page linking property 'SizeX' for element 'arrowSet'
          _view.arrowSet.linkProperty("X",  function() { return xTest; }, function(_v) { xTest = _v; } ); // HtmlView Page linking property 'X' for element 'arrowSet'
          _view.arrowSet.linkProperty("Y",  function() { return yTest; }, function(_v) { yTest = _v; } ); // HtmlView Page linking property 'Y' for element 'arrowSet'
          _view.arrowSet.linkProperty("Visibility",  function() { return visTest; }, function(_v) { visTest = _v; } ); // HtmlView Page linking property 'Visibility' for element 'arrowSet'
          _view.arrowSet.linkProperty("SizeY",  function() { return vyTest; }, function(_v) { vyTest = _v; } ); // HtmlView Page linking property 'SizeY' for element 'arrowSet'
          _view.trailSet.linkProperty("NumberOfElements",  function() { return nTestMax; }, function(_v) { nTestMax = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'trailSet'
          _view.trailSet.linkProperty("InputX",  function() { return xTest; }, function(_v) { xTest = _v; } ); // HtmlView Page linking property 'InputX' for element 'trailSet'
          _view.trailSet.linkProperty("Visibility",  function() { return visTest; }, function(_v) { visTest = _v; } ); // HtmlView Page linking property 'Visibility' for element 'trailSet'
          _view.trailSet.linkProperty("InputY",  function() { return yTest; }, function(_v) { yTest = _v; } ); // HtmlView Page linking property 'InputY' for element 'trailSet'
          _view.trailSet.linkProperty("ClearAtInput",  function() { return clearTrail; }, function(_v) { clearTrail = _v; } ); // HtmlView Page linking property 'ClearAtInput' for element 'trailSet'
          _view.controlPanel.linkProperty("Width",  function() { return width; }, function(_v) { width = _v; } ); // HtmlView Page linking property 'Width' for element 'controlPanel'
          _view.playPauseButton.setAction("OffClick", _pause); // HtmlView Page setting action 'OffClick' for element 'playPauseButton'
          _view.playPauseButton.linkProperty("State",  function() { return _isPaused; } ); // HtmlView Page linking property 'State' for element 'playPauseButton'
          _view.playPauseButton.setAction("OnClick", function() {
  clearTrail=false;
  _play();

}); // HtmlView Page setting action 'OnClick' for element 'playPauseButton'
          _view.addTestChargeButton.setAction("OnClick", addTestCharge); // HtmlView Page setting action 'OnClick' for element 'addTestChargeButton'
          _view.resetButton.setAction("OnClick", function() {
  _reset();

}); // HtmlView Page setting action 'OnClick' for element 'resetButton'
          _view.nPosField.linkProperty("Value",  function() { return nPos; }, function(_v) { nPos = _v; } ); // HtmlView Page linking property 'Value' for element 'nPosField'
          _view.nPosField.setAction("OnChange", _initialize); // HtmlView Page setting action 'OnChange' for element 'nPosField'
          _view.nNegField.linkProperty("Value",  function() { return nNeg; }, function(_v) { nNeg = _v; } ); // HtmlView Page linking property 'Value' for element 'nNegField'
          _view.nNegField.setAction("OnChange", _initialize); // HtmlView Page setting action 'OnChange' for element 'nNegField'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(false);
  _model.setFPS(10);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function CoulombField_movingTestCharge_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = CoulombField_movingTestCharge_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);

  _view._addDescriptionPage('Intro Page','./resources/movingTestCharges.xhtml');

  return _view;
} // end of main function

function CoulombField_movingTestCharge_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.wrappedPanel,"wrappedPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'wrappedPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"titlePanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'titlePanel'
      .setProperty("Html","") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'titlePanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"mainPanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'mainPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.plottingPanel,"plottingPanel", _view.mainPanel,"GRAPHICS2D_CANVAS") // EJsS HtmlView.HtmlView Page: declaration of element 'plottingPanel'
      .setProperty("Background","White") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'plottingPanel'
      .setProperty("XFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'XFixedTick' for element 'plottingPanel'
      .setProperty("Enabled",true) // EJsS HtmlView.HtmlView Page: setting property 'Enabled' for element 'plottingPanel'
      .setProperty("Title","Campo eléctrico") // EJsS HtmlView.HtmlView Page: setting property 'Title' for element 'plottingPanel'
      .setProperty("SquareAspect",false) // EJsS HtmlView.HtmlView Page: setting property 'SquareAspect' for element 'plottingPanel'
      .setProperty("YFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'YFixedTick' for element 'plottingPanel'
      .setProperty("GridYShow",false) // EJsS HtmlView.HtmlView Page: setting property 'GridYShow' for element 'plottingPanel'
      .setProperty("YAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'YAutoTicks' for element 'plottingPanel'
      .setProperty("XTickStep",2.0) // EJsS HtmlView.HtmlView Page: setting property 'XTickStep' for element 'plottingPanel'
      .setProperty("YTickStep",2.0) // EJsS HtmlView.HtmlView Page: setting property 'YTickStep' for element 'plottingPanel'
      .setProperty("AutoScaleY",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleY' for element 'plottingPanel'
      .setProperty("AutoScaleX",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleX' for element 'plottingPanel'
      .setProperty("XAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'XAutoTicks' for element 'plottingPanel'
      .setProperty("GraphicsMode","Canvas") // EJsS HtmlView.HtmlView Page: setting property 'GraphicsMode' for element 'plottingPanel'
      .setProperty("GridXShow",false) // EJsS HtmlView.HtmlView Page: setting property 'GridXShow' for element 'plottingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.custom,"custom", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'custom'
      .setProperty("FillColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'custom'
      .setProperty("RelativePosition","SOUTH_WEST") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'custom'
      .setProperty("LineColor","Blue") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'custom'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'custom'
      ;

    _view._addElement(EJSS_DRAWING2D.shapeSet,"chargeSet", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'chargeSet'
      .setProperty("Sensitivity",15) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'chargeSet'
      .setProperty("SizeX",15) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'chargeSet'
      .setProperty("ShapeType","ELLIPSE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'chargeSet'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'chargeSet'
      .setProperty("SizeY",15) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'chargeSet'
      .setProperty("EnabledPosition","ENABLED_ANY") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'chargeSet'
      ;

    _view._addElement(EJSS_DRAWING2D.shapeSet,"testChargeSet", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'testChargeSet'
      .setProperty("FillColor","Black") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'testChargeSet'
      .setProperty("MovesGroup",false) // EJsS HtmlView.HtmlView Page: setting property 'MovesGroup' for element 'testChargeSet'
      .setProperty("Sensitivity",15) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'testChargeSet'
      .setProperty("SizeX",10) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'testChargeSet'
      .setProperty("SizeY",10) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'testChargeSet'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'testChargeSet'
      .setProperty("EnabledPosition","ENABLED_ANY") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'testChargeSet'
      ;

    _view._addElement(EJSS_DRAWING2D.arrowSet,"arrowSet", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'arrowSet'
      .setProperty("LineColor","green") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'arrowSet'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'arrowSet'
      .setProperty("LineWidth",3) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'arrowSet'
      ;

    _view._addElement(EJSS_DRAWING2D.trailSet,"trailSet", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'trailSet'
      .setProperty("NoRepeat",true) // EJsS HtmlView.HtmlView Page: setting property 'NoRepeat' for element 'trailSet'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"controlPanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'controlPanel'
      .setProperty("CSS",{ "display":"block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'controlPanel'
      .setProperty("Background","rgba(240,240,240,255)") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'controlPanel'
      .setProperty("BorderStyle","double") // EJsS HtmlView.HtmlView Page: setting property 'BorderStyle' for element 'controlPanel'
      .setProperty("BorderColor","Black") // EJsS HtmlView.HtmlView Page: setting property 'BorderColor' for element 'controlPanel'
      .setProperty("BorderWidth",1) // EJsS HtmlView.HtmlView Page: setting property 'BorderWidth' for element 'controlPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"buttonPanel", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'buttonPanel'
      .setProperty("CSS",{"display":"block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'buttonPanel'
      ;

    _view._addElement(EJSS_INTERFACE.twoStateButton,"playPauseButton", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'playPauseButton'
      .setProperty("ImageOnUrl","/org/opensourcephysics/resources/controls/images/play.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageOnUrl' for element 'playPauseButton'
      .setProperty("ImageOffUrl","/org/opensourcephysics/resources/controls/images/pause.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageOffUrl' for element 'playPauseButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"addTestChargeButton", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'addTestChargeButton'
      .setProperty("Text","Adiciona cargas de prueba") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'addTestChargeButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"resetButton", _view.buttonPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'resetButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/reset.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'resetButton'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"inputPanel", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'inputPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"nPosLabel", _view.inputPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'nPosLabel'
      .setProperty("Text","Número de cargas positivas: ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'nPosLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"nPosField", _view.inputPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'nPosField'
      .setProperty("Width",35) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'nPosField'
      .setProperty("Format","0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'nPosField'
      .setProperty("Editable",true) // EJsS HtmlView.HtmlView Page: setting property 'Editable' for element 'nPosField'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"nNegLabel", _view.inputPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'nNegLabel'
      .setProperty("Text","y cargas negativas: ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'nNegLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"nNegField", _view.inputPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'nNegField'
      .setProperty("Width",35) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'nNegField'
      .setProperty("Format","0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'nNegField'
      .setProperty("Editable",true) // EJsS HtmlView.HtmlView Page: setting property 'Editable' for element 'nNegField'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"narrativePanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'narrativePanel'
      .setProperty("Html","") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'narrativePanel'
      ;

  };

  return _view;
}



      var _model;
      window.addEventListener('load',
        function () { 
          _model =  new CoulombField_movingTestCharge("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined") _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
      var interval = setInterval(function() {
         if(document.readyState === 'complete') {
           window.addEventListener('resize', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           window.addEventListener('scroll', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           var startCaptureBut = document.getElementById('startCaptureBut'); 
           var stopCaptureBut = document.getElementById('stopCaptureBut'); 
           var resetCaptureBut = document.getElementById('resetCaptureBut'); 
           var playCaptureBut = document.getElementById('playCaptureBut'); 
           var stepCaptureBut = document.getElementById('stepCaptureBut'); 
           if (startCaptureBut) {
             startCaptureBut.onclick = function() {
               _model.startCapture();
             };
             stopCaptureBut.onclick = function() {
               _model.saveText('recording','rec',JSON.stringify(_model.stopCapture()));
             };
             resetCaptureBut.onclick = function() {
               _model.resetCapture();
             };
             playCaptureBut.onclick = function() {
               _model.readText(null,'.rec',function(content){
               _model.playCapture(JSON.parse(content),function(){startCaptureBut.disabled=false; playCaptureBut.disabled=false; stepCaptureBut.disabled=false; window.alert(end_reproduction_message);});               });
             };
             stepCaptureBut.onchange= function() {
               var stepCapt;
               if (stepCaptureBut.value >= 0) stepCapt =  stepCaptureBut.value + 1;
               else stepCapt = 1 + 1.8*stepCaptureBut.value/8;
               _model.changeCaptureStep(stepCapt);
             };
           }
           clearInterval(interval);
         };
      }, 200)
