ProgramFont = "Georgia";

function initialize(){
	
/* Initial Conditions */	
	TopGrid = 25;
	RightGrid = 700;
	LeftGrid = 200;
	BottomGrid = 450;
	
	GridHeight = BottomGrid - TopGrid;
	GridWidth = RightGrid - LeftGrid;
	
	radius1 = 40;
	radius2 = 30;
	TopTube = TopGrid;
	LeftTube = LeftGrid+radius1;
	RightTube = RightGrid-radius2;
	BottomTube = BottomGrid;
	TubeCurve = 15;
	MidTube = (RightGrid + LeftGrid)/2;
	depthcurvefactor = 0.2;
	
	FluidColor = "#66FFFF";
	
	FluidLevel1 = 300;
	FluidLevel2 = 300;
	densityoffluid = 0.001;
	YPin = 435;
	PinSpeed = 50/50;
	PullPin = "no";
	FactorsChangeable = "yes";
	
	Mass1g = 250;
	Mass2g = 200;
	
	heighttoradiusratio = 3;
	densityofmasses = 5;
	masscurve = 0.2;
	
	ScaleFactor = (BottomGrid - TopGrid)/500;
	
	document.getElementById("MessageToUser").innerHTML = "Tira del pasador y observa en qué dirección se mueve tu sistema para alcanzar el equilibrio.";

	
//  Sets up the canvas for live action.
	
	theCanvas = document.getElementById("CanvasOne");
	ctx = theCanvas.getContext("2d");
	
	CalculateParameters();
}



/* Called by the Begin Button */

function LoadIt(){
	document.getElementById("LabSection").style.visibility = "visible";
	document.getElementById("OverviewSection").style.visibility = "hidden";
	StartItMoving = setInterval(drawingpart, 50);
}

function CalculateParameters(){
	heightmass1 = Math.pow(((Mass1g*Math.pow(heighttoradiusratio,2.0))/(densityofmasses*Math.PI)),0.33333)*10;
	radiusmass1 = heightmass1/heighttoradiusratio;
	heightmass2 = Math.pow(((Mass2g*Math.pow(heighttoradiusratio,2.0))/(densityofmasses*Math.PI)),0.33333)*10;
	radiusmass2 = heightmass2/heighttoradiusratio;
	
	radiustube1cm = radius1/10;
	radiustube2cm = radius2/10;
	h1ocm = FluidLevel1/10;
	h2ocm = FluidLevel2/10;
	
	deltaPfromMasses = Mass1g/(Math.PI*Math.pow(radiustube1cm, 2.0)) - Mass2g/(Math.PI*Math.pow(radiustube2cm, 2.0));
	
	h2cm = (Math.pow(radiustube1cm, 2.0)*(deltaPfromMasses + h1ocm) + Math.pow(radiustube2cm, 2.0)*(h2ocm))/(Math.pow(radiustube1cm, 2.0) + Math.pow(radiustube2cm, 2.0));
	
	h1cm = (Math.pow(radiustube2cm, 2.0)*h2ocm + Math.pow(radiustube1cm, 2.0)*h1ocm - Math.pow(radiustube2cm, 2.0)*h2cm)/Math.pow(radiustube1cm, 2.0);
	
	FluidLevelFinal2 = h2cm*10;
	FluidLevelFinal1 = h1cm*10;
	
	radiusratio = radius2/radius1;
	radiusrationsq = Math.pow(radiusratio, 2.0);
	densitypiproductrecip = 1/(densityoffluid*Math.PI);
	
	SpeedForFluid1 = (FluidLevelFinal1 - FluidLevel1)/50;
	SpeedForFluid2 = (FluidLevelFinal2 - FluidLevel2)/50;
	ratiototube = radius1/TubeCurve;
	tuberadiusrationsq = Math.pow(ratiototube, 2.0);
	PistonSpeed = tuberadiusrationsq*SpeedForFluid1;
	PistonMotion = PistonSpeed*50;
	LeftTube = LeftGrid+radius1;
	RightTube = RightGrid-radius2;
}

function drawingpart(){
	
	ctx.fillStyle = "#ffffff";
	ctx.fillRect(0,0,900,600);
	
	DrawAxes();
	
	DrawTubeBack();
	DrawFluid1();
	DrawFluid2();
	if (PullPin == "yes"){
		YPin = YPin - PinSpeed;
		if (YPin < 385){
			PullPin = "no";
			document.getElementById("ResetPinButton").style.visibility = "visible";
			document.getElementById("MessageToUser").innerHTML = "El sistema está en equilibrio.<br /><br/>Haz clic en el pin para volver a la posición anterior.";
		}
		if (MidTube >= (RightTube-radius2-TubeCurve) || MidTube <= (LeftTube+radius1+TubeCurve)){
			PullPin = "no";
			document.getElementById("ResetPinButton").style.visibility = "visible";
			document.getElementById("MessageToUser").innerHTML = "El sistema no pudo alcanzar el equilibrio.<br /><br/>Haz clic en el pin para volver a la posición anterior.";
		}
		FluidLevel1 = FluidLevel1 + SpeedForFluid1;
		FluidLevel2 = FluidLevel2 + SpeedForFluid2;
		MidTube = MidTube - PistonSpeed;
	}
	DrawPin(450,YPin,40, 40);
	DrawPiston();
	
	DrawMass(LeftTube,BottomTube-(FluidLevel1+10)*ScaleFactor,radiusmass1,heightmass1);
	DrawMass(RightTube,BottomTube-(FluidLevel2+10)*ScaleFactor,radiusmass2,heightmass2);
	DrawTubeFront();
	
	MassOneControlArea(4,304,150,292);
	MassTwoControlArea(746,304,150,292);
	
	TubeOneControlArea(4,4,150,292);
	TubeTwoControlArea(746,4,150,292);
	
	//WriteText(450,550,heightmass1,12,"#000000",0.5,ProgramFont);
}

function DrawMass(x,y,r,h){
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#ffc314";
	ctx.lineWidth = 1;
	ctx.beginPath();
	ctx.moveTo(x-r, y);
	ctx.lineTo(x-r, y-h);
	ctx.bezierCurveTo(x-r,y-h-masscurve*r, x+r,y-h-masscurve*r, x+r,y-h);
	ctx.lineTo(x+r, y);
	ctx.bezierCurveTo(x+r, y+masscurve*r, x-r, y+masscurve*r, x-r, y);
	ctx.stroke();
	ctx.fill();
	ctx.fillStyle = "#dba710";
	ctx.beginPath();
	ctx.moveTo(x-r, y-h);
	ctx.bezierCurveTo(x-r,y-h-masscurve*r, x+r,y-h-masscurve*r, x+r,y-h);
	ctx.bezierCurveTo(x+r,y-h+masscurve*r, x-r,y-h+masscurve*r, x-r,y-h);
	ctx.stroke();
	ctx.fill();
	ctx.strokeStyle = "#dba710";
	ctx.lineWidth = 5;
	ctx.beginPath();
	ctx.moveTo(x, y-h);
	ctx.lineTo(x, y-h-20);
	ctx.arc(x, y-h-30, 10, 0.5*Math.PI, 1.1*Math.PI, true);
	ctx.stroke();
}

function DrawPin(x,y,w,h){
	ctx.lineWidth = 2;
	ctx.strokeStyle = "#000000";
	ctx.beginPath();
	ctx.moveTo(x,y);
	ctx.lineTo(x,y-h);
	ctx.moveTo(x-0.5*w, y-h);
	ctx.lineTo(x+0.5*w, y-h);
	ctx.stroke();
	
}

function TubeOneControlArea(x,y,w,h){
	DrawRectangle(x, y, w, h, 3, "#990000", "#CCCCCC", 2);
	WriteText(x+0.5*w,y+0.1*h,"Radio Tubo 1",22,"#990000",0.5);
	WriteText(x+0.5*w,y+0.3*h,radius1 + " mm",26,"#990000",0.5);
	if (FactorsChangeable == "yes"){
		DrawArrow(x+0.5*w, y+0.45*h, 0.2*h, 0.1*h, "#990000", 1.0*Math.PI);
		DrawArrow(x+0.5*w, y+0.70*h, 0.2*h, 0.1*h, "#990000", 0.0*Math.PI);
	}
	
}

function TubeTwoControlArea(x,y,w,h){
	DrawRectangle(x, y, w, h, 3, "#990000", "#CCCCCC", 2);
	WriteText(x+0.5*w,y+0.1*h,"Radio Tubo 2",22,"#990000",0.5);
	WriteText(x+0.5*w,y+0.3*h,radius2 + " mm",26,"#990000",0.5);
	if (FactorsChangeable == "yes"){
		DrawArrow(x+0.5*w, y+0.45*h, 0.2*h, 0.1*h, "#990000", 1.0*Math.PI);
		DrawArrow(x+0.5*w, y+0.70*h, 0.2*h, 0.1*h, "#990000", 0.0*Math.PI);
	}
}


function MassOneControlArea(x,y,w,h){
	DrawRectangle(x, y, w, h, 3, "#990000", "#CCCCCC", 2);
	WriteText(x+0.5*w,y+0.1*h,"Masa 1",32,"#990000",0.5);
	WriteText(x+0.5*w,y+0.3*h,Mass1g.toFixed(0) + " g",26,"#990000",0.5);
	if (FactorsChangeable == "yes"){
		DrawArrow(x+0.3*w, y+0.45*h, 0.2*h, 0.1*h, "#990000", 1.0*Math.PI);
		DrawArrow(x+0.3*w, y+0.70*h, 0.2*h, 0.1*h, "#990000", 0.0*Math.PI);
		DrawArrow(x+0.8*w, y+0.50*h, 0.1*h, 0.05*h, "#990000", 1.0*Math.PI);
		DrawArrow(x+0.8*w, y+0.75*h, 0.1*h, 0.05*h, "#990000", 0.0*Math.PI);
	}
}

function MassTwoControlArea(x,y,w,h){
	DrawRectangle(x, y, w, h, 3, "#990000", "#CCCCCC", 2);
	WriteText(x+0.5*w,y+0.1*h,"Masa 2",32,"#990000",0.5);
	WriteText(x+0.5*w,y+0.3*h,Mass2g.toFixed(0) + " g",26,"#990000",0.5);
	if (FactorsChangeable == "yes"){
		DrawArrow(x+0.3*w, y+0.45*h, 0.2*h, 0.1*h, "#990000", 1.0*Math.PI);
		DrawArrow(x+0.3*w, y+0.70*h, 0.2*h, 0.1*h, "#990000", 0.0*Math.PI);
		DrawArrow(x+0.8*w, y+0.50*h, 0.1*h, 0.05*h, "#990000", 1.0*Math.PI);
		DrawArrow(x+0.8*w, y+0.75*h, 0.1*h, 0.05*h, "#990000", 0.0*Math.PI);
	}
}

function DrawPiston(){
	DrawRectangle(MidTube-5, BottomTube-TubeCurve, 10, 2*TubeCurve, 3, "#000000", "#CCCCCC", 2);
}

function DrawFluid1(){
	ctx.lineWidth = 2;
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = FluidColor;
	ctx.beginPath();
	ctx.moveTo(LeftTube+radius1, BottomTube-FluidLevel1*ScaleFactor);
	ctx.bezierCurveTo(LeftTube+radius1, BottomTube-FluidLevel1*ScaleFactor+depthcurvefactor*radius1, LeftTube-radius1, BottomTube-FluidLevel1*ScaleFactor+depthcurvefactor*radius1, LeftTube-radius1, BottomTube-FluidLevel1*ScaleFactor);
	ctx.lineTo(LeftTube-radius1, BottomTube);
	ctx.quadraticCurveTo(LeftTube-radius1, BottomTube+TubeCurve, LeftTube-radius1+TubeCurve, BottomTube+TubeCurve);
	ctx.lineTo(MidTube, BottomTube+TubeCurve);
	ctx.lineTo(MidTube, BottomTube-TubeCurve);
	ctx.lineTo(LeftTube+radius1+0.5*TubeCurve, BottomTube-TubeCurve);
	ctx.quadraticCurveTo(LeftTube+radius1, BottomTube-TubeCurve, LeftTube+radius1, BottomTube-1.5*TubeCurve);
	ctx.lineTo(LeftTube+radius1, BottomTube-FluidLevel1*ScaleFactor);
	ctx.stroke();
	ctx.globalAlpha = 0.3;
	ctx.fill();
	ctx.globalAlpha = 1.0;
	
	ctx.beginPath();
	ctx.moveTo(LeftTube+radius1, BottomTube-FluidLevel1*ScaleFactor);
	ctx.bezierCurveTo(LeftTube+radius1, BottomTube-FluidLevel1*ScaleFactor-depthcurvefactor*radius1, LeftTube-radius1, BottomTube-FluidLevel1*ScaleFactor-depthcurvefactor*radius1, LeftTube-radius1, BottomTube-FluidLevel1*ScaleFactor);
	ctx.bezierCurveTo(LeftTube-radius1, BottomTube-FluidLevel1*ScaleFactor+depthcurvefactor*radius1, LeftTube+radius1, BottomTube-FluidLevel1*ScaleFactor+depthcurvefactor*radius1, LeftTube+radius1, BottomTube-FluidLevel1*ScaleFactor);
	ctx.stroke();
	ctx.globalAlpha = 0.7;
	ctx.fill();
	ctx.globalAlpha = 1.0;
	
	ctx.lineWidth = 2;
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#BBBBBB";
	ctx.beginPath();
	ctx.moveTo(LeftTube+radius1, BottomTube-(FluidLevel1+10)*ScaleFactor);
	ctx.bezierCurveTo(LeftTube+radius1, BottomTube-(FluidLevel1+10)*ScaleFactor-depthcurvefactor*radius1, LeftTube-radius1, BottomTube-(FluidLevel1+10)*ScaleFactor-depthcurvefactor*radius1, LeftTube-radius1, BottomTube-(FluidLevel1+10)*ScaleFactor);
	ctx.bezierCurveTo(LeftTube-radius1, BottomTube-(FluidLevel1+10)*ScaleFactor+depthcurvefactor*radius1, LeftTube+radius1, BottomTube-(FluidLevel1+10)*ScaleFactor+depthcurvefactor*radius1, LeftTube+radius1, BottomTube-(FluidLevel1+10)*ScaleFactor);
	ctx.stroke();
	ctx.fill();
	
	ctx.lineWidth = 2;
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#DDDDDD";
	ctx.beginPath();
	ctx.moveTo(LeftTube+radius1, BottomTube-(FluidLevel1+10)*ScaleFactor);
	ctx.lineTo(LeftTube+radius1, BottomTube-(FluidLevel1)*ScaleFactor);
	ctx.bezierCurveTo(LeftTube+radius1, BottomTube-(FluidLevel1)*ScaleFactor+depthcurvefactor*radius1, LeftTube-radius1, BottomTube-(FluidLevel1)*ScaleFactor+depthcurvefactor*radius1, LeftTube-radius1, BottomTube-(FluidLevel1)*ScaleFactor);
	ctx.lineTo(LeftTube-radius1, BottomTube-(FluidLevel1+10)*ScaleFactor);
	ctx.bezierCurveTo(LeftTube-radius1, BottomTube-(FluidLevel1+10)*ScaleFactor+depthcurvefactor*radius1, LeftTube+radius1, BottomTube-(FluidLevel1+10)*ScaleFactor+depthcurvefactor*radius1, LeftTube+radius1, BottomTube-(FluidLevel1+10)*ScaleFactor);
	ctx.stroke();
	ctx.fill();
	
	ctx.lineWidth = 1;
	ctx.strokeStyle = "#990000";
	ctx.beginPath();
	ctx.moveTo(LeftTube+radius1, BottomTube-FluidLevel1*ScaleFactor);
	ctx.lineTo(LeftTube+radius1+10, BottomTube-FluidLevel1*ScaleFactor);
	ctx.stroke();

}

function DrawFluid2(){
	ctx.lineWidth = 2;
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = FluidColor;
	ctx.beginPath();
	ctx.moveTo(MidTube, BottomTube-TubeCurve);
	ctx.lineTo(MidTube, BottomTube+TubeCurve);
	ctx.lineTo(RightTube+radius2-TubeCurve, BottomTube+TubeCurve);
	ctx.quadraticCurveTo(RightTube+radius2, BottomTube+TubeCurve, RightTube+radius2, BottomTube);
	ctx.lineTo(RightTube+radius2, BottomTube-FluidLevel2*ScaleFactor);
	ctx.bezierCurveTo(RightTube+radius2, BottomTube-FluidLevel2*ScaleFactor+depthcurvefactor*radius2, RightTube-radius2, BottomTube-FluidLevel2*ScaleFactor+depthcurvefactor*radius2, RightTube-radius2, BottomTube-FluidLevel2*ScaleFactor);
	ctx.lineTo(RightTube-radius2, BottomTube-1.5*TubeCurve);
	ctx.quadraticCurveTo(RightTube-radius2, BottomTube-TubeCurve, RightTube-radius2-0.5*TubeCurve, BottomTube-TubeCurve);
	ctx.lineTo(MidTube, BottomTube-TubeCurve);
	ctx.stroke();
	ctx.globalAlpha = 0.3;
	ctx.fill();
	ctx.globalAlpha = 1.0;
	
	ctx.beginPath();
	ctx.moveTo(RightTube+radius2, BottomTube-FluidLevel2*ScaleFactor);
	ctx.bezierCurveTo(RightTube+radius2, BottomTube-FluidLevel2*ScaleFactor-depthcurvefactor*radius2, RightTube-radius2, BottomTube-FluidLevel2*ScaleFactor-depthcurvefactor*radius2, RightTube-radius2, BottomTube-FluidLevel2*ScaleFactor);
	ctx.bezierCurveTo(RightTube-radius2, BottomTube-FluidLevel2*ScaleFactor+depthcurvefactor*radius2, RightTube+radius2, BottomTube-FluidLevel2*ScaleFactor+depthcurvefactor*radius2, RightTube+radius2, BottomTube-FluidLevel2*ScaleFactor);
	
	ctx.stroke();
	ctx.globalAlpha = 0.7;
	ctx.fill();
	ctx.globalAlpha = 1.0;
	
	ctx.lineWidth = 2;
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#BBBBBB";
	ctx.beginPath();
	ctx.moveTo(RightTube+radius2, BottomTube-(FluidLevel2+10)*ScaleFactor);
	ctx.bezierCurveTo(RightTube+radius2, BottomTube-(FluidLevel2+10)*ScaleFactor-depthcurvefactor*radius2, RightTube-radius2, BottomTube-(FluidLevel2+10)*ScaleFactor-depthcurvefactor*radius2, RightTube-radius2, BottomTube-(FluidLevel2+10)*ScaleFactor);
	ctx.bezierCurveTo(RightTube-radius2, BottomTube-(FluidLevel2+10)*ScaleFactor+depthcurvefactor*radius2, RightTube+radius2, BottomTube-(FluidLevel2+10)*ScaleFactor+depthcurvefactor*radius2, RightTube+radius2, BottomTube-(FluidLevel2+10)*ScaleFactor);
	ctx.stroke();
	ctx.fill();
	
	ctx.lineWidth = 2;
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#DDDDDD";
	ctx.beginPath();
	ctx.moveTo(RightTube+radius2, BottomTube-(FluidLevel2+10)*ScaleFactor);
	ctx.lineTo(RightTube+radius2, BottomTube-(FluidLevel2)*ScaleFactor);
	ctx.bezierCurveTo(RightTube+radius2, BottomTube-(FluidLevel2)*ScaleFactor+depthcurvefactor*radius2, RightTube-radius2, BottomTube-(FluidLevel2)*ScaleFactor+depthcurvefactor*radius2, RightTube-radius2, BottomTube-(FluidLevel2)*ScaleFactor);
	ctx.lineTo(RightTube-radius2, BottomTube-(FluidLevel2+10)*ScaleFactor);
	ctx.bezierCurveTo(RightTube-radius2, BottomTube-(FluidLevel2+10)*ScaleFactor+depthcurvefactor*radius2, RightTube+radius2, BottomTube-(FluidLevel2+10)*ScaleFactor+depthcurvefactor*radius2, RightTube+radius2, BottomTube-(FluidLevel2+10)*ScaleFactor);
	ctx.stroke();
	ctx.fill();
	
	ctx.lineWidth = 1;
	ctx.strokeStyle = "#990000";
	ctx.beginPath();
	ctx.moveTo(RightTube-radius2, BottomTube-FluidLevel2*ScaleFactor);
	ctx.lineTo(RightTube-radius2-10, BottomTube-FluidLevel2*ScaleFactor);
	ctx.stroke();
}


function DrawTubeFront(){
	ctx.lineWidth = 2;
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#FFFFFF";
	ctx.beginPath();
	ctx.moveTo(LeftTube+radius1, TopTube);
	ctx.bezierCurveTo(LeftTube+radius1, TopTube+depthcurvefactor*radius1, LeftTube-radius1, TopTube+depthcurvefactor*radius1, LeftTube-radius1, TopTube);
	ctx.lineTo(LeftTube-radius1, BottomTube);
	ctx.quadraticCurveTo(LeftTube-radius1, BottomTube+TubeCurve, LeftTube-radius1+TubeCurve, BottomTube+TubeCurve);
	ctx.lineTo(RightTube+radius2-TubeCurve, BottomTube+TubeCurve);
	ctx.quadraticCurveTo(RightTube+radius2, BottomTube+TubeCurve, RightTube+radius2, BottomTube);
	ctx.lineTo(RightTube+radius2, TopTube);
	ctx.bezierCurveTo(RightTube+radius2, TopTube+depthcurvefactor*radius2, RightTube-radius2, TopTube+depthcurvefactor*radius2, RightTube-radius2, TopTube);
	ctx.lineTo(RightTube-radius2, BottomTube-1.5*TubeCurve);
	ctx.quadraticCurveTo(RightTube-radius2, BottomTube-TubeCurve, RightTube-radius2-0.5*TubeCurve, BottomTube-TubeCurve);
	ctx.lineTo(LeftTube+radius1+0.5*TubeCurve, BottomTube-TubeCurve);
	ctx.quadraticCurveTo(LeftTube+radius1, BottomTube-TubeCurve, LeftTube+radius1, BottomTube-1.5*TubeCurve);
	ctx.lineTo(LeftTube+radius1, TopTube);
	ctx.stroke();
	ctx.globalAlpha = 0.5;
	ctx.fill();
	ctx.globalAlpha = 1.0;
}


function DrawTubeBack(){
	ctx.lineWidth = 2;
	ctx.strokeStyle = "#000000";
	ctx.fillStyle = "#FFFFFF";
	ctx.beginPath();
	ctx.moveTo(LeftTube+radius1, TopTube);
	ctx.bezierCurveTo(LeftTube+radius1, TopTube-depthcurvefactor*radius1, LeftTube-radius1, TopTube-depthcurvefactor*radius1, LeftTube-radius1, TopTube);
	ctx.lineTo(LeftTube-radius1, BottomTube);
	ctx.quadraticCurveTo(LeftTube-radius1, BottomTube+TubeCurve, LeftTube-radius1+TubeCurve, BottomTube+TubeCurve);
	ctx.lineTo(RightTube+radius2-TubeCurve, BottomTube+TubeCurve);
	ctx.quadraticCurveTo(RightTube+radius2, BottomTube+TubeCurve, RightTube+radius2, BottomTube);
	ctx.lineTo(RightTube+radius2, TopTube);
	ctx.bezierCurveTo(RightTube+radius2, TopTube-depthcurvefactor*radius2, RightTube-radius2, TopTube-depthcurvefactor*radius2, RightTube-radius2, TopTube);
	ctx.lineTo(RightTube-radius2, BottomTube-1.5*TubeCurve);
	ctx.quadraticCurveTo(RightTube-radius2, BottomTube-TubeCurve, RightTube-radius2-0.5*TubeCurve, BottomTube-TubeCurve);
	ctx.lineTo(LeftTube+radius1+0.5*TubeCurve, BottomTube-TubeCurve);
	ctx.quadraticCurveTo(LeftTube+radius1, BottomTube-TubeCurve, LeftTube+radius1, BottomTube-1.5*TubeCurve);
	ctx.lineTo(LeftTube+radius1, TopTube);
	ctx.stroke();
	ctx.globalAlpha = 0.5;
	ctx.fill();
	ctx.globalAlpha = 1.0;
}

function ChangeRadius1(x){
	radius1 = radius1 + x;
	if (radius1 < (radiusmass1 + 6)){
		radius1temp = radiusmass1 + 6;
		radius1 = Math.floor(radius1temp/2.0)*2;
	}
	if (radius1 > 50){
		radius1 = 50;
	}
	CalculateParameters();
}

function ChangeRadius2(x){
	radius2 = radius2 + x;
	if (radius2 < (radiusmass2 + 6)){
		radius2temp = radiusmass2 + 6;
		radius2 = Math.floor(radius2temp/2.0)*2;
	}
	if (radius2 > 50){
		radius2 = 50;
	}
	CalculateParameters();
}

function ChangeMass1(x){
	OldMass = Mass1g;
	Mass1g = Mass1g + x;
	
	heightmass1 = Math.pow(((Mass1g*Math.pow(heighttoradiusratio,2.0))/(densityofmasses*Math.PI)),0.33333)*10;
	radiusmass1temp = heightmass1/heighttoradiusratio;
	
	if (Mass1g < 50){
		Mass1g = 50;
	}
	if ((radiusmass1temp + 4) > radius1 && x > 0){
		Mass1g = OldMass;
	}
	CalculateParameters();
}

function ChangeMass2(x){
	OldMass = Mass2g;
	Mass2g = Mass2g + x;
	
	heightmass2 = Math.pow(((Mass2g*Math.pow(heighttoradiusratio,2.0))/(densityofmasses*Math.PI)),0.33333)*10;
	radiusmass2temp = heightmass2/heighttoradiusratio;
	
	if (Mass2g < 50){
		Mass2g = 50;
	}
	if ((radiusmass2temp + 4) > radius2 && x > 0){
		Mass2g = OldMass;
	}
	CalculateParameters();
}

function DrawAxes(){
	ctx.globalAlpha = 0.4;
	ctx.strokeStyle = "#000000";
	
	//Y lines
	
	NumberOfYLines = 50;
	MoveYFactor = 1/NumberOfYLines;
	
	for (i=0;i<=NumberOfYLines;i++){
		if (i%5 == 0){
			ctx.lineWidth = 2;
			ctx.strokeStyle = "#000000";
		}
		else{
			ctx.lineWidth = 1;
			ctx.strokeStyle = "#AAAAAA";
		}
		if (i == 0){
			ctx.lineWidth = 4;
			ctx.strokeStyle = "#000000";
		}
		ctx.beginPath();
		ctx.moveTo(LeftGrid, BottomGrid - MoveYFactor*i*GridHeight);
		ctx.lineTo(RightGrid, BottomGrid - MoveYFactor*i*GridHeight);
		ctx.stroke();
		temptext = 10*i;
		if (i%5 == 0){
			WriteText(LeftGrid - 5, BottomGrid - MoveYFactor*i*GridHeight+5,temptext.toFixed(0),18,"#000000",1, ProgramFont);
			WriteText(RightGrid + 5, BottomGrid - MoveYFactor*i*GridHeight+5,temptext,18,"#000000",0, ProgramFont);
		}
	}
	
	//X lines
	
	NumberOfXLines = 50;
	MoveXFactor = 1/NumberOfXLines;
	
	for (i=0;i<=NumberOfXLines;i++){
		if (i%5 == 0){
			ctx.lineWidth = 2;
			ctx.strokeStyle = "#000000";
		}
		else{
			ctx.lineWidth = 1;
			ctx.strokeStyle = "#AAAAAA";
		}
		if (i == 25){
			ctx.lineWidth = 4;
			ctx.strokeStyle = "#000000";
		}
		ctx.beginPath();
		ctx.moveTo(LeftGrid + MoveXFactor*i*GridWidth, BottomGrid);
		ctx.lineTo(LeftGrid + MoveXFactor*i*GridWidth, TopGrid);
		ctx.stroke();
		temptext = 0.1*i - 2.5;
	}
	ctx.globalAlpha = 1.0;
	
	WriteText(450,15,"Distancias en mm",14,"#990000",0.5,ProgramFont);
}

function Pin(){
	
	if(FluidLevelFinal1 > 500){
		document.getElementById("MessageToUser").innerHTML = "Si tiras del pasador, el fluido 1 se derramará por la parte superior del tubo.<br /><br />Intenta ajustar los parámetros y vuelve a tirar del pin.";
	}
	else if(FluidLevelFinal2 > 500){
		document.getElementById("MessageToUser").innerHTML = "Si tiras del pasador, el fluido 2 se derramará por la parte superior del tubo.<br /><br /Intenta ajustar los parámetros y vuelve a tirar del pin.";
	}
	else if(FluidLevelFinal2 < 30){
		document.getElementById("MessageToUser").innerHTML = "Si tiras del pasador, el fluido 2 se acercará a la parte inferior del tubo.<br /><br />Intenta ajustar los parámetros y vuelve a tirar del pin.";
	}
	else if(FluidLevelFinal1 < 30){
		document.getElementById("MessageToUser").innerHTML = "Si tiras del pasador, el fluido 1 se acercará al fondo del tubo.<br /><br />Intenta ajustar los parámetros y vuelve a tirar del pin.";
	}
	else{
		PullPin = "yes";
		StartFluidLevel1 = FluidLevel1;
		StartFluidLevel2 = FluidLevel2;
		document.getElementById("PinButton").style.visibility = "hidden";
		document.getElementById("ResetPinButton").style.visibility = "hidden";
		document.getElementById("Radius1UpButton").style.visibility = "hidden";
		document.getElementById("Radius2UpButton").style.visibility = "hidden";
		document.getElementById("Radius1DownButton").style.visibility = "hidden";
		document.getElementById("Radius2DownButton").style.visibility = "hidden";
		document.getElementById("Mass1UpButton").style.visibility = "hidden";
		document.getElementById("Mass2UpButton").style.visibility = "hidden";
		document.getElementById("Mass1DownButton").style.visibility = "hidden";
		document.getElementById("Mass2DownButton").style.visibility = "hidden";
		document.getElementById("Mass1UpSmallButton").style.visibility = "hidden";
		document.getElementById("Mass2UpSmallButton").style.visibility = "hidden";
		document.getElementById("Mass1DownSmallButton").style.visibility = "hidden";
		document.getElementById("Mass2DownSmallButton").style.visibility = "hidden";
		document.getElementById("ResetM1To100").style.visibility = "hidden";
		FactorsChangeable = "no";
		document.getElementById("MessageToUser").innerHTML = "El sistema se está acercando al equilibrio.";

	}
	
}

function ResetPin(){
	FluidLevel1 = StartFluidLevel1;
	FluidLevel2 = StartFluidLevel2;
	MidTube = 450;
	YPin = 435;
	document.getElementById("PinButton").style.visibility = "visible";
	document.getElementById("ResetPinButton").style.visibility = "hidden";
	document.getElementById("Radius1UpButton").style.visibility = "visible";
	document.getElementById("Radius2UpButton").style.visibility = "visible";
	document.getElementById("Radius1DownButton").style.visibility = "visible";
	document.getElementById("Radius2DownButton").style.visibility = "visible";
	document.getElementById("Mass1UpButton").style.visibility = "visible";
	document.getElementById("Mass2UpButton").style.visibility = "visible";
	document.getElementById("Mass1DownButton").style.visibility = "visible";
	document.getElementById("Mass2DownButton").style.visibility = "visible";
	document.getElementById("Mass1UpSmallButton").style.visibility = "visible";
	document.getElementById("Mass2UpSmallButton").style.visibility = "visible";
	document.getElementById("Mass1DownSmallButton").style.visibility = "visible";
	document.getElementById("Mass2DownSmallButton").style.visibility = "visible";
	document.getElementById("ResetM1To100").style.visibility = "visible";
	FactorsChangeable = "yes";
	document.getElementById("MessageToUser").innerHTML = "Tire del pasador después de reajustar tus parámetros.";
}

function ResetM100(){
	x = 1;
	OldMass = Mass1g;
	Mass1g = 100;
	
	heightmass1 = Math.pow(((Mass1g*Math.pow(heighttoradiusratio,2.0))/(densityofmasses*Math.PI)),0.33333)*10;
	radiusmass1temp = heightmass1/heighttoradiusratio;
	
	if ((radiusmass1temp + 4) > radius1 && x > 0){
		Mass1g = OldMass;
		document.getElementById("MessageToUser").innerHTML = "El tubo 1 es demasiado estrecho para reajustarlo a 100 g. Tira del pasador después de reajustar sus parámetros.";
	}
	else{
		document.getElementById("MessageToUser").innerHTML = "Masa 1 reajustada a 100 g. Tira del pasador después de reajustar sus parámetros.";
	}
	CalculateParameters();
}

function WriteText(x,y,t,s,c,m,ff){
	ctx.fillStyle = c;
	ctx.font= s + "px " + ff;
	temptext = t;
	metrics = ctx.measureText(temptext);
	textWidth = metrics.width;
	xposition = x - m*textWidth;
	ctx.fillText(temptext,xposition, y);
}


function DrawArrow(x, y, h, w, c, r){
	ctx.save();
	ctx.translate(x, y+0.5*h);
	ctx.rotate(r);
	ctx.fillStyle = c;
	ctx.strokeStyle = "#000000";
	ctx.lineWidth = 1;
	ctx.beginPath();
	ctx.moveTo(0,-0.5*h);
	ctx.lineTo(0+w, -0.5*h+w);
	ctx.lineTo(0+0.5*w, -0.5*h+w);
	ctx.lineTo(0+0.5*w, -0.5*h+h);
	ctx.lineTo(0-0.5*w, -0.5*h+h);
	ctx.lineTo(0-0.5*w, -0.5*h+w);
	ctx.lineTo(0-w, -0.5*h+w);
	ctx.lineTo(0,-0.5*h);
	ctx.stroke();
	ctx.closePath();
	ctx.fill();
	ctx.restore();
}

function DrawRectangle(xrect, yrect, wrect, hrect, curverectangle, lcolor, fcolor, lwid){
	ctx.fillStyle = fcolor;
	ctx.strokeStyle = lcolor;
	ctx.lineWidth = lwid;
	ctx.beginPath();
	ctx.moveTo(xrect+curverectangle, yrect);
	ctx.lineTo(xrect+wrect-curverectangle, yrect);
	ctx.arc(xrect+wrect-curverectangle, yrect+curverectangle, curverectangle, 1.5*Math.PI, 0*Math.PI, false);
	ctx.lineTo(xrect+wrect, yrect+hrect-curverectangle);
	ctx.arc(xrect+wrect-curverectangle, yrect+hrect-curverectangle, curverectangle, 0.0*Math.PI, 0.5*Math.PI, false);
	ctx.lineTo(xrect+curverectangle, yrect+hrect);
	ctx.arc(xrect+curverectangle, yrect+hrect-curverectangle, curverectangle, 0.5*Math.PI, 1.0*Math.PI, false);
	ctx.lineTo(xrect, yrect+curverectangle);
	ctx.arc(xrect+curverectangle, yrect+curverectangle, curverectangle, 1.0*Math.PI, 1.5*Math.PI, false);
	ctx.stroke();
	ctx.fill();
}

