      // Asegurar que este script se ejecute después de que todo esté cargado
      document.addEventListener("DOMContentLoaded", function () {
        // 1. Primero, restaurar la funcionalidad del índice
        setTimeout(function () {
          restaurarNavegacionIndice();
        }, 300);

        // 2. Luego, inicializar el sistema NRS con un retraso mayor
        setTimeout(function () {
          inicializarSistemaNRS();
        }, 500);
      });

      // Función para restaurar la navegación desde el índice
      function restaurarNavegacionIndice() {
        const tocLinks = document.querySelectorAll(".toc_link");
        console.log(
          `Restaurando navegación para ${tocLinks.length} elementos del índice`
        );

        tocLinks.forEach((link) => {
          // Crear un nuevo manejador de evento que no interfiera con otros
          link.onclick = function (event) {
            // Obtener el destino desde el atributo href
            const targetId = this.getAttribute("href");
            if (targetId) {
              console.log(`Navegando a: ${targetId}`);

              // Cerrar el índice general si está abierto
              const tableOfContent =
                document.getElementById("table_of_content");
              if (tableOfContent && tableOfContent.style.display === "block") {
                tableOfContent.style.display = "none";
              }

              // Encontrar el elemento de destino
              const targetElement = document.querySelector(targetId);
              if (targetElement) {
                // Navegar a la página que contiene el elemento
                const pageElement = encontrarPaginaContenedora(targetElement);
                if (pageElement) {
                  scrollToPage(pageElement);
                }
              }
            }
          };
        });
      }

      // Función para encontrar la página que contiene un elemento
      function encontrarPaginaContenedora(element) {
        // Buscar el ancestro más cercano que sea una página
        let current = element;
        while (current && !current.classList.contains("page")) {
          current = current.parentElement;
        }
        return current;
      }

      // Función para desplazarse a una página específica
      function scrollToPage(pageElement) {
        if (!pageElement) return;

        // Obtener todas las páginas
        const pages = document.querySelectorAll(".page");
        let pageIndex = -1;

        // Encontrar el índice de la página
        pages.forEach((page, index) => {
          if (page === pageElement) {
            pageIndex = index;
          }
        });

        if (pageIndex >= 0) {
          // Ajustar el índice restando 3 para compensar el desplazamiento
          const adjustedIndex = Math.max(0, pageIndex - 3);
          console.log(
            `Índice original: ${pageIndex}, Índice ajustado: ${adjustedIndex}`
          );

          // Usar la función de navegación del libro si existe
          if (typeof goToPage === "function") {
            goToPage(adjustedIndex);
          } else {
            // Alternativa básica de desplazamiento
            const pagesContainer = document.getElementById("pages_container");
            if (pagesContainer) {
              const pageWidth = pageElement.offsetWidth;
              pagesContainer.style.transition = "all 0.3s ease";
              pagesContainer.style.left = `-${adjustedIndex * pageWidth}px`;
            }
          }
        }
      }

      // Función para inicializar el sistema NRS
      function inicializarSistemaNRS() {
        // Obtener elementos del DOM
        const nrsRefs = document.querySelectorAll(".nrs-ref");
        const citaNRS = document.getElementById("citaNRS");
        const citaNRSContent = document.getElementById("citaNRS-content");
        const citaNRSClose = document.querySelector(".citaNRS-close");

        // Verificar que los elementos existan
        if (!citaNRS || !citaNRSContent || !citaNRSClose) {
          console.error("Elementos del sistema NRS no encontrados");
          return;
        }

        // Función para buscar una referencia NRS en el anexo
        function buscarNRSEnAnexo(nrsId) {
          const listaItems = document.querySelectorAll(".nrs-item");
          for (let item of listaItems) {
            const numero = item.querySelector(".nrs-numero").textContent.trim();
            if (numero === `[${nrsId}]`) {
              return item.querySelector(".nrs-descripcion").textContent.trim();
            }
          }
          return null;
        }

        // Función para mostrar la cita NRS
        function mostrarCitaNRS(nrsId) {
          const contenidoNRS = buscarNRSEnAnexo(nrsId);
          if (contenidoNRS) {
            citaNRSContent.textContent = contenidoNRS;
            citaNRS.style.display = "block";
          } else {
            citaNRSContent.textContent = "Referencia NRS no encontrada.";
            citaNRS.style.display = "block";
          }
        }

        // Agregar eventos a las referencias NRS
        nrsRefs.forEach((ref) => {
          ref.onclick = function (event) {
            const nrsId = this.getAttribute("data-nrs-id");
            if (nrsId) {
              event.preventDefault();
              event.stopPropagation();
              mostrarCitaNRS(nrsId);
              return false;
            }
          };
        });

        // Cerrar popup al hacer clic en la X
        citaNRSClose.onclick = function (event) {
          event.preventDefault();
          citaNRS.style.display = "none";
          return false;
        };

        // Cerrar el popup si se hace clic en él
        citaNRS.onclick = function (event) {
          if (event.target === this) {
            citaNRS.style.display = "none";
          }
        };
      }

