const draggableElements = document.querySelectorAll(".draggable");
const droppableElements = document.querySelectorAll(".droppable");

let correct = 0;
let btnshow = document.querySelector("next");

// btnshow.addEventListener("done"), () =>{
//   output.innerHTML = "5/5";
// };

// input.addEventListener("hide"), () =>{
//   if(correct=5) btnshow.disabled=true
//   else btnshow.disabled=false;
// }

draggableElements.forEach(elem => {
  elem.addEventListener("dragstart", dragStart); // Fires as soon as the user starts dragging an item - This is where we can define the drag data
  // elem.addEventListener("drag", drag); // Fires when a dragged item (element or text selection) is dragged
  // elem.addEventListener("dragend", dragEnd); // Fires when a drag operation ends (such as releasing a mouse button or hitting the Esc key) - After the dragend event, the drag and drop operation is complete
    console.log(dragStart)
});

droppableElements.forEach(elem => {
  elem.addEventListener("dragenter", dragEnter); // Fires when a dragged item enters a valid drop target
  elem.addEventListener("dragover", dragOver); // Fires when a dragged item is being dragged over a valid drop target, repeatedly while the draggable item is within the drop zone
  elem.addEventListener("dragleave", dragLeave); // Fires when a dragged item leaves a valid drop target
  elem.addEventListener("drop", drop); // Fires when an item is dropped on a valid drop target
  });

// Drag and Drop Functions

//Events fired on the drag target

function dragStart(event) {
  event.dataTransfer.setData("text", event.target.id); // or "text/plain" but just "text" would also be fine since we are not setting any other type/format for data value
}

//Events fired on the drop target

function dragEnter(event) {
  if(!event.target.classList.contains("dropped")) {
    event.target.classList.add("droppable-hover");
  }
}

function dragOver(event) {
  if(!event.target.classList.contains("dropped")) {
    event.preventDefault(); // Prevent default to allow drop
  }
}

function dragLeave(event) {
  if(!event.target.classList.contains("dropped")) {
    event.target.classList.remove("droppable-hover");
  }
}

function drop(event) {
  event.preventDefault(); // This is in order to prevent the browser default handling of the data
  event.target.classList.remove("droppable-hover");
  const draggableElementData = event.dataTransfer.getData("text"); // Get the dragged data. This method will return any data that was set to the same type in the setData() method
  const droppableElementData = event.target.getAttribute("data-draggable-id");
  const isCorrectMatching = draggableElementData === droppableElementData;
  if(isCorrectMatching) {
    const draggableElement = document.getElementById(draggableElementData);
    event.target.classList.add("dropped");
    draggableElement.classList.add("dragged");
    draggableElement.setAttribute("draggable", "false")
    correct +=1
    fishNum.innerHTML++;
    document.getElementById("score").innerHTML = correct+"/5";
    if (fishNum.innerHTML >4) {
      traps.classList.add("fadeIn");
      traps.disabled = false;
    }
    }
  }
  let fishNum = document.getElementById("fishNum");
let traps = document.getElementById("cm2Btn2");

function addFish() {
  fishNum.innerHTML++;
  correct +=1;
  document.getElementById("score").innerHTML = correct+"/5";
  
  if (fishNum.innerHTML >4) {
    traps.classList.add("fadeIn");
    traps.disabled = false;
  }
  
}
document.getElementById("cm2Btn")
  .addEventListener("click", addFish);
