/**
* @author Joel Espinosa Longi
* @licencia LGPL - http://www.gnu.org/licenses/lgpl.html
*/

var tooltip = (function(tooltip) {

 /**
  * 
  */
 tooltip.gal = 
 {
	Panels: {
		Buttons: 'Selecciona o panel de edición de configuración da escena e filas de controis numéricos.',
		Spaces: 'Selecciona o panel de edición de Espazos.',
		Controls: 'Selecciona o panel de edición de Controis.',
		Definitions: 'Selecciona o panel de edición das Definicións.\n\nAs definicións son todos os vectores, matrices, funcións, variables e bibliotecas dunha escena.',
		Programs: 'Selecciona o panel de edición de programa.\n\nOs programas son todos os algoritmos e eventos dunha escena.',
		Graphics: 'Selecciona o panel de edición de Gráficos 2D.',
		Graphics3D: 'Selecciona o panel de edicón de Gráficos 3D.',
		Animation: 'Selecciona o panel de edición da Animación.',
	},

	Buttons: {
		width: 'O ancho da escena en píxeles.',
		height: 'O alto da escena en píxeles.',
		about: 'Determina se o botón "Créditos" aparece na escena.\n\nO botón "Créditos" abre unha xanela coa información dos autores de Descartes.',
		config: 'Determina se o botón "Config" aparece na escena.\n\nO botón "Config" abre unha xanela coa configuración da escena.',
		init: 'Determina se o botón "Inicio" aparece na escena.\n\nO botón "Inicio" reinicia os valores de controis, definicións e programas, regresando a escena ao seu estado inicial.\n\nSe hai unha animación automática, esta comeza de novo.',
		clear: 'Determina se o botón "Limpar" aparece na escena.\n\nO botón "Limpar" borra os rastros deixados polos obxectos gráficos que teñen a opción "rastro" activada.',
		rowsNorth: 'Número de filas que ocuparán os controis numéricos colocados na rexión norte.\n\nSe o valor é cero entón haberá unha fila se é necesaria, pero se non o é, non haberá ningunha.\n\nO valor por defecto é cero.',
		rowsSouth: 'Número de filas que ocuparán os controis numéricos colocados na rexión sur.\n\nSe o valor é cero entón haberá unha fila se é necesaria, pero se non o é, non haberá ningunha.\n\nO valor por defecto é cero.',
		widthWest: 'Ancho en píxeles da rexión oeste para controis numéricos. O valor por defecto é 150.\n\nSe o valor é 0, pero existe polo menos un control numérico na rexión oeste, entón adóptase por defecto un valor de 125.',
		widthEast: 'Ancho en píxeles da rexión leste para controis numéricos. O valor por defecto é 150.\n\nSe o valor é 0, pero existe polo menos un control numérico na rexión leste, entón adóptase por defecto un valor de 125.',
		heightRows: 'Altura en píxeles dos controis numéricos das rexións norte e sur. O valor por defecto é 40.',
		decimal_symbol: 'Símbolo que separa os enteiros dos decimais nunha expresión decimal.\n\nNalgúns paises úsase a coma e noutros o punto.',
		language: 'Linguaxe na que se garda a configuración da escena.',
		editable: 'Determina si se mostra o espazo exterior ao realizar un clic co botón dereito do rato sobre a escena.',
		expand: 'Opcións para modificar as dimensións da escena.\n\n"Cubrir": cambia só o ancho e o alto das escenas que teñan un valor do 100%, para que teñan as dimensións do seu contenedor.\n\n"Escalar": modifica a escala dos píxeles da escena para cubrir as dimensións do seu contenedor, dando un efecto zoom xeral en toda a escena.\n\nO valor por defecto é baleiro, o que indica non facer cambios nas dimensións.',
		image_loader: 'Imaxe que se vai utilizar como imaxe de carga da escena.\n\nO valor por defecto é baleiro, o que indica que se mostrará o logotipo de Descartes.',
	},

	ListEditButtons: {
		add: 'Engade un novo elemento á lista.',
		clone: 'Engade á lista un novo elemento idéntico ao que se atopa seleccionado.',
		delete: 'Elimina da lista o elemento seleccionado.',
		list: 'Abre a xanela de texto para editar manualmente todos os obxectos da lista.',
		up_down: 'Cambia a orde da lista permutando o elemento seleccionado polo seu veciño.\n\nSe mantense presionado repite rapidamente a operación.',
	},

	Spaces: {
		type: 'Determina o tipo de espazo, o cal pode ser de dúas ou tres dimensións ou de tipo HTMLIFrame.',
		id: 'Identificador do espazo.',
		cID: '*********',
		x: 'Abscisa do extremo superior esquerdo da xanela do espazo. É dicir, a súa distancia á marxe esquerda da escena.\n\nPode especificarse co número de píxeles (por exemplo 20) ou coa porcentaxe (por exemplo 10%) do ancho total da escena.',
		y: 'Ordenada do extremo superior esquerdo da xanela do espazo. É dicir, a súa distancia á marxe superior da escena.\n\n\nPode especificarse co número de píxeles (por exemplo 20) ou coa porcentaxe (por exemplo 10%) do alto total da escena.',
		width: 'Ancho do espazo.\n\nPode especificarse co número de píxeles (por exemplo 240) ou coa porcentaxe (por exemplo 50%) do ancho total da escena.',
		height: 'Alto do espazo.\n\nPode especificarse co número de píxeles (por exemplo 180) ou coa porcentaxe (por exemplo 50%) do alto total da escena.',
		drawif: 'Expresión booleana que determina se o espazo é visible ou non.\n\nO espazo é invisible si é só si o valor da expresión é cero.\n\nSi se deixa en branco este espazo será sempre visible.',
		fixed: '*********',
		fixed_R2: 'Ao estar activado impide que o usuario modifique a escala e a localización da orixe arrastrando o espazo co rato.',
		fixed_R3: 'Ao estar activado impide que o usuario modifique o punto de vista arrastrando o espazo co rato.',
		scale: 'Tamaño en píxiles dun segmento unitario (ou de lonxitude 1).\n\nPara modificar esta variable hay que referirse a ela como <id>.escala, onde <id> é o identificador do espazo.\n\nNota: É importante que os identificadores non teñan espazos nin símbolos de operadores.',
		"O.x": 'Distancia en píxeles cara a dereita, do centro do espazo ao punto onde vaise debuxar a orixe de coordenadas.\n\nPara modificar esta variable hai que referirse a ela como <id>.Ox, onde <id> é o identificador do espazo.\n\nNota: É importante que os identificadores non conteñan espazos nin símbolos de operadores.',
		"O.y": 'Distancia en píxeles cara abaixo, do centro do espazo ao punto onde vaise debuxar a orixe de coordenadas.\n\nPara modificar esta variable hai que referirse a ela como <id>.Oy, onde <id> é o identificador do espazo.\n\nNota: É importante que os identificadores non conteñan espazos nin símbolos de operadores.',
		image: 'Imaxe utilizada como fondo do espazo.\n\nOs arquivos de imaxes deben colocarse no mesmo directorio onde se coloca o arquivo html da escena ou en subdirectorios a partir de ahí, ademáis do nome do arquivo hai que incluír os subdirectorios.\n\nPoden utilizarse arquivos png, jpg, gif e svg.',
		bg_display: 'Opcións para modificar a maneira na que se vai desplegar a imaxe de fondo do espazo.\n\n"arr-esq": a esquina superior esquerda da imaxe alinéase coa esquina superior esquerda do espazo.\n\n"expandir": a imáxe estírase para cubrir o expazo.\n\n"mosaico": a imaxe repítese tantas veces como sexa necesaro para cubrir o espazo.\n\n"centrada": a imaxe debúxase centrada no espazo.',
		background: 'Cor de fondo do espazo.\n\nO botón activa o editor das cores.\n\nO valor por defecto é branco(#ffffff).',
		axes: 'Cor dos eixes de coordenadas.\n\nO selector sirve para decidir se os eixes debúxanse ou non.\n\nO botón activa o editor das cores.\n\nOs valores por defecto son o selector activado e a cor gris escura (#404040).',
		net: 'Cor da rede de rectas paralelas aos eixes de coordenadas que serven como referencia.\n\nO selector serve para decidir se a rede se debuxa ou non.\n\nO botón activa o editor das cores.\n\nOs valores por defecto son o selector activado e a cor gris clara (#c0c0c0).',
		net10: 'Cor dunha rede que se debuxa cada 10 unidades da rede anterior.\n\nO selector serve para decidir se a red10 debúxase ou non.\n\nO botón activa o editor das cores.\n\nOs valores por defecto son o selector activado e a cor gris (#808080).',
		text: 'Cor das coordenadas mostradas ao facer clic co botón esquerdo do rato no espazo.\n\nO selector serve para decidir se as coordenadas escríbense ou non.\n\nO botón activa o editor das cores.\n\nO valor por defecto é o selector desactivado.',
		numbers: 'Determina si se escriben algúns valores das coordenadas sobre os eixes. No caso de escribirse estas coordenadas aparecen da mesma cor ca os eixes.\n\nSó poden escribirse as coordenadas se os eixes se debuxan.\n\nO valor por defecto é desactivado.',
		x_axis: 'Etiqueta que se debuxará á dereita da escena, xusto debaixo do eixe x.\n\nA cor da etiqueta é a mesma ca dos eixes.\n\nSe o contido é "non" entón o eixe non se debuxa.',
		y_axis: 'Etiqueta que se debuxará na parte de arriba da escena, xusto á esquerda do eixe y.\n\nA cor da etiqueta é a mesma ca dos eixes.\n\nSe o contido é "non" entón o eixe non se debuxa.',
		render: 'Método que se utiliza para despregar os obxectos en tres dimensións.\n\n"orde": debuxa os obxectos tridimensionais de atrás cara adiante. É o más rápido, pero falla cando os obxectos están compostos por caras grandes.\n\n"pintor": é algo máis lento pero moito máis fiable ca opción "orde".\n\n"trazado de raios": enche o esspazo pixel a pixel, beduxando a cor do obxecto que se atopa máis cerca do observador. É o método máis fiable pero tamén o máis lento.',
		split: 'Se está activado determina se todos os obxectos se cortan entre si.\n\nO valor por defecto é desactivado.\n\nSe dúas superficies se intersectan pero non se lles permite cortarse o seu despregamento é "imposible" e o debuxo resulta incomprensible.\n\nCando os obxectos do espazo non se intersectan entre si, non é necesario seleccionar esta opción.',
		sensitive_to_mouse_movements: 'Se está activado determina se a escena detectará os movementos do rato sobre este espazo.\n\nO valor por defecto é desactivado.',
		file: 'Nome do arquivo a o que fai referencia o espazo HTMLIFrame.',
		info: 'Comentarios.',
		resizable: 'Permite que o ancho e o alto do espazo cambio, ao permitir a avaliación de variables en estes parámetros.\n\nNota: modifica o comportamento orixinal, onde os espazos non poden ter un tamaño maior á área da escena.',
	},

	Controls: {
		id: 'Identificador do control.\n\nSe o control é numérico, entón <id>, é o nome da variable numérica que representa.\n\nSe é gráfico, entón <id>.x e <id>.y son as coordenadas do control.',
		type: '*********',
		gui: 'Tipo de interfaz gráfica do control numérico. As opcións son: "pulsador", "campo de texto", "menú" (despregable), "barra" (de desprazamento) e "botón".',
		onlyText: 'Ao estar activado fai que o campo de texto non interprete os números ou variables que nel se escriben, só os toma como cadeas de texto.',
		region: 'Rexión da escena onde se asigna o control numérico.\n\n"norte": é unha ou varias filas horizontais na parte superior da escena entre os botóns de créditos e config.\n\n"sur": é unha ou varias filas na parte inferior da escena entre os botóns de inicio e limpar.\n\n"oeste" e "leste": son columnas á esquerda e á dereita da escena.\n\n"exterior": é unha xanela que aparece cando faise clic co botón dereito do rato sobre a escena.\n\n"interior": cando un control numérico se asocia á rexión interior, entón pode colocarse en calqueira dos espazos da escena e a súa posición ahí está determinada polo parámetro "expresión".\n\nO valor por defecto é "sur".',
		space: 'Lista cos identificadores de todos os espazos definidos na escena.\n\nEste parámetro só ten sentido en controis asignados á rexión interior e en controis gráficos.',
		color_CTRGRAPHIC: 'Control da circunferencia do disco que representa un control gráfico.\n\nA cor por defecto da marxe é #222222.',
		colorInt_CTRGRAPHIC: 'Control do círculo ou interior da circunferencia do disco que representa un control gráfico.\n\nA cor por defecto do interior é #f0f8ff.',
		image_CTRGRAPHIC: 'Nome de arquivo de unha imaxe que se utilizará en lugar do círculo que Descartes utiliza para mostrar este control gráfico.',
		size: 'Raio do control gráfico en píxeles.\n\nPode ser calquer número un expresión positiva.\n\nO valor por defecto é 4.',
		name: 'Nome externo do control que aparece como etiqueta á esquerda do control numérico e non ten ningunha outra función dentro do programa.\n\nO valor por defecto é igual ao identificador do control.',
		expression: 'Extremo superior esquerdo dun control numérico interior.\n\nExprésase con dous números entre parénteses separados por unha coma. Os números poden ser constantes ou expresións nas que interveñen onstantes ou parámetros definidos en controis anteriores.\n\nNo caso dun control numérico interior pode usarse unha expresión de catro valores (x,y,w,h) onde os primeiros son as coordenadas do vértice superior esquerdo do control e os dous últimos son o ancho e o alto.\n\nO valor por defecto é (0,0,150,40).',
		expression_CTRGRAPHIC: 'Punto inicial dun control gráfico.\n\nExprésase con dous números entre parénteses separados por unha coma. Os números poden ser constantes ou expresións nas que interveñen constantes ou parámetros definidos en controis anteriores.\n\nO valor por defecto é (0,0).',
		value: 'Valor inicial da variable <id>.\n\nPode ser unha expresión decimal ou unha fórmula na que poden intervir constantes e outros parámetros definidos en controis anteriores.\n\nO seu valor por defecto é 0.\n\nNo caso dos botóns é o valor que se asigna á variable cando se pulsa o botón.',
		constraint: 'Ecuación en x ou y que as coordenadas do control gráfico deben satisfacer. É dicir, o control queda restrinxido a moverse sobre a gráfica da súa constricción.\n\nPode ser expresión ou ser baleira. Se é baleira o control non está limitado no seu movemento.\n\nO valor por defecto é baleiro.',
		text: 'Etiqueta que acompaña ao control.\n\nPode ser calquer texto que ademais pode incluír valores numéricos variables.\n\nO valor por defecto é baleiro.',
		text_CTRTEXT: 'Contido inicial da área de texto.\n\nO valor por defecto é baleiro.',
		incr: 'Cantidade que aumenta ou diminúe o valor da variable <id> cando se pulsan as frechas do control numérico.\n\nPode ser unha constante ou unha expresión.\n\nO valor por defecto é 0.1.',
		min: 'Valor mínimo que pode ter o control.\n\nPode ser unha constante, unha expresión ou estar baleiro, e neste caso non hai valor mínimo e o control non está limitado inferiormente.\n\nO valor por defecto é baleiro.',
		max: 'Valor máximo que pode ter o control.\n\nPode ser unha constante, unha expresión ou estar baleiro, e neste caso non hai valor máximo e o control non está limitado superiormente.\n\nO valor por defecto é baleiro.',
		discrete: 'Obriga que os valores do control numérico difiran do valor inicial so en múltiplos exactos do incremento.\n\nEsto funciona correctamente só se o incremento é constante e ademais pode expresarse co número de deciamis elexido.\n\nO valor por defecto é desactivado.',
		decimals: 'Número de decimais cos que se escribirán os valores de <id>.\n\nPode ser calquer número ou expresión\n\nA expresión evalúase e redondéase ao enteiro máis próximo para especificar o número de decimais, por ex. 3.5 redondéase a 4.\n\nO valor por defecto é 2.',
		fixed: 'Ao estar activado, escribe números co número especificado de decimais.\n\nSe non está activado, utilízase a notación axustada. Neste caso, o ceros innecesarios elimínanse e tamén o punto decimal se non fai falta. Por exemplo, en lugar de 25.3400, escríbese 25.34 e en lugar de 13.0, escríbese 13 (sen o punto decimal).\n\nSi se utiliza a notación expoencial, os números sempre escríbense en notación axustada, é dicir, ignórase o atributo fixo.\n\nO valor por defecto é activado.',
		exponentialif: 'Expresión booleana que cando se cumpre fai que o valor do parámetro poida escribirse en notación exponencial. Se a expresión é baleira, nunca se utiliza a notación exponencial. É importante observar que esto non forza a que apareza a notación exponencial, só a permite. Se a expresión non se cumpre non haberá notación exponencial.\n\nO valor por defecto é baleiro.',
		visible: 'Indica se o valor do parámetro debe mostrarse ou non (o nome e os pulsadores sempre se mostran).\n\nO valor por defecto é activado, e dicir, que o valor do parámetro si se mostra.',
		trace: 'Indica se o control gráfico debe deixar rastro do seu percorrido. O rastro do control corresponde unicamente ao do seu borde.\n\nO valor por defecto é desactivado.',
		color: 'Control do texto na etiqueta do botón.',
		colorInt: 'Control do fondo na etiqueta do botón.',
		bold: 'Ao estar activado o texto na etiqueta escríbese en negriña.',
		italics: 'Ao estar activado o texto na etiqueta escríbese en cursiva.',
		underlined: 'Ao estar activado o texto na etiqueta escríbese subliñado.',
		font_size: 'Tamaño en puntos da fonte coa que se escribe o texto da etiqueta do botón.\n\nO tipo de letra sempre é SansSerif.',
		image: 'Nome do arquivo dunha imaxe que se vai utilizar como fondo do botón.\n\nSe na mesma carpeta na que está a imaxe hai outra co mesmo nome seguido de "_over" e coa mesma extensión, entón esta imaxe aparecerá no botón cando o cursor do rato pase por riba do botón.\n\nSe na mesma carpeta donde está a imaxe hai outra co mesmo nome seguido de "_down" e coa mesma extensión, entón esta imaxe aparecerá no botón cando se pulse o botón co rato.',
		options: 'Lista de opcións que mostra o "menú".\n\nAs opcións deben ser textos separadas por comas. Despois de cada texto pode vir entre corchetes [] o valor que se asigna ao control cando se selecciona esta opción. Se o valor non se define entón asígnase automaticamente un valor enteiro correspondente ao índice da opción.',
		action: 'A acción que se realiza cando o usuario manipula o control (pulsar o botón, seleccionar un elemento dun menú, mover a barra de desprazamento, ou dar <intro> no campo de texto).\n\nHai as seguints accións posibles: "calcular", "inicio", "limpar", "animar", "abrir URL", "abrir escena" e "reproducir".',
		parameter: 'O parámetro da acción.\n\nSe a acción é "calcular", entón debe conter cero ou varias asignacións separadas por punto e coma (;) ou salto de liña (\\n), que o programa realizará cando se execute a acción.\n\nSe a acción é "abrir URL", o parámetro ten que ser unha URL.\n\nSe a acción é "abrir escena" o parámetro debe ser unha dirección relativa e o que fai é abrir a escena de Descartes que se atopa nun arquivo de texto con esa dirección.\n\nAs outras accións non usan o parámetro.',
		drawif: 'Expresión booleana que determina cando o control é visible.\n\nO valor por defecto é baleiro e nese caso o control é sempre visible.',
		activeif: 'Expresión booleana que determina cando o control está activo.\n\nO valor por defecto é baleiro e nese caso é posible interactuar co control.',
		evaluate: 'Determina se o control leva avaliación automática.\n\nSó se aplica nos controis das escenas que son items (ou reactivos) para avaliaciones.\n\nAparece desactivado por defecto. Cando se activa nun control dun ítem, o programa sabe que ao avaliarse o ítem deberá considerar o que o usuario escribira ou seleccionara no control, como unha resposta e comparalo co patrón de respostas asociado.',
		answer: 'Este campo está inactivo mentres que o selector "avaliar" está desactivado.\n\nA resposta esperada, programada polo autor da lección. Esta é a resposta fronte a cal se compara a resposta do usuario para determinar se é correcta.\n\nAplícase só con controis que propoñen preguntas e onde unha resposta necesita ser avaliada comparando a resposta do usuario coa resposta da lección.\n\nPode consistir en un ou máis textos separados por |, cada un deles compárase coa resposta do usuario.\n\nSe hai coincidencia, a resposta márcase como correcta, en caso contrario márcase como incorrecta.\n\nCando a resposta esperada é numérico, o autor da lección necesita establecer un intervalo válido, por exemplo, [a,b]. (a,b), (a,b] ou [a,a].\n\nCando o control é do tipo "só texto", a avaliación da resposta faise comparando letra por letra.\n\nSe unha opción de resposta remata con *, a resposta do usuario se compara só co comenzo da resposta.\n\nSe unha opción de resposta comeza con *, a resposta do usuario debe rematar co mesmo valor da resposta.\n\nSe unha opción de resposta comeza e remata con *, por exemplo *resposta*, a resposta do usuario debe conter o termo "resposta" indicado entre os *.\n\nSe a resposta esperada e válida tanto en maiúsculas como en minúsculas, debe escribirse entre comiñas simples, por exemplo: \'resposta\'.\n\nSe as tiles e as letras n e ñ non se distinguen, a resposta debe escribirse entre acentos, por exemplo `resposta´.\n\nDe maneira similar, pode escribirse `\'resposta\'´ para que non se teñan en conta nin as tiles nin as maiúsculas ou minúsculas.\n\nPara facer que non se teña en conta unha letra ponse ? en lugar da letra.',
		weight: 'Peso (no contexto dunha media ponderada) que se da á resposta dada na avaliación ao calcular a nota.\n\nSó se admiten valores enteiros positivos e recoméndase utilizar só 0, 1 ou 2.',
		tooltip: 'Texto que aparece cando o rato detense máis de un segundo e medio sobre a etiqueta dun control numérico ou dentro do círculo dun control gráfico.\n\nO valor por defecto é baleiro.',
		explication: 'Texto que aparece cando un usuario fai clic co botón dereito do rato sobre a etiqueta dun control numérico ou dentro do círculo dun control gráfico.\n\nO valor por defecto é "tooltip".',
		cID: 'Identificador para os controis que se atopan no escenario.\n\nÉ úti só en escenas de Arquímedes ou Discurso.\n\nO valor do identificador o calcula o programa de acordo co momento preciso no que esto foi creado, polo que todos os identificadores creados nun mesmo ordenador son diferentes.\n\nNon se recomenda manipular manualmente este identificador.',
		file: 'Nome do arquivo multimedia (audio ou vídeo).',
		info: 'Comentarios.',
		borderColor: 'Cor do bordo do texto do botón.\n\nCando está activado o texto do botón debúxase cun bordo da cor seleccionada.\n\nO valor por defecto é desactivado.',
		flat: 'Ao estar activo o botón debúxase sen degradado (estilo plano).\n\nO valor por defecto é desactivado, é dicir, que o botón debúxase con degradado (estilo tradicional de Descartes).',
		text_align: 'Opcións para elexir o aliñamento da etiqueta do botón, respecto da rexión rectangular que ocupa o control.',
		image_align: 'Opcións para elexir o aliñamento da imaxe do botón, respecto á rexión rectangular que ocupa o control.',
		cssClass: 'Clases de estilo CSS ás que pertence o botón.\n\nEsto permite modificar o estilo do botón por medio de follas de estilo externas.',
		radio_group: 'Se o valor é baleiro, o control compórtase coma unha casa de verificación.\n\nSe por contra contén un nome, o control compórtase como un botón de opción pertencente ao grupo co nome especificado. Cando é un botón de opción, só un dos controis do mesmo grupo pode estar seleccionado.',
	},

	Definitions: {
		id: 'Identificador da definición.\n\nNo caso dunha función debe incluír os parámetros dos que dependa, escritos entre parénteses e separados por comas. Por exemplo: f(x,y).',
		expression: 'Valor da constante, variable ou función.',
		evaluate: 'Opcións que permiten definir se a constante, a expresióndo vector ou o algoritmo deben avaliarse cada vez que o usuario modifica un control ou só unha vez ao iniciarse a escena.\n\nÉ importante seleccionar "unha sola vez" cando sexa factible para que o funcionamento da escena sexa máis rápido.',
		size: 'Número de elementos do vector.',
		rows: 'Número de filas da matriz.',
		columns: 'Número de columnas da matriz.',
		range: 'Expresión booleana que determina o dominio da función.\n\nCalquer intento de avaliar a función fora do seu dominio lanzará unha excepción, co cal, por exemplo, a súa gráfica non se debuxa nos puntos que non estean no dominio.\n\nO valor por defecto é baleiro, o cal se interpreta como que o dominio non está restrinxido.',
		algorithm: 'Ao estar activado indica que a función, para avaliarse, debe usar un algoritmo; é dicir, utiliza os cálculos indicados en "inicio, "facer" e "mentres".\n\nO valor por defecto é non activado.',
		expression2: 'Asignacións aos valores do vector separadas por punto e coma (;) ou salto de liña (\\n).\n\nPor exemplo, se o identificador do vector é v e ten tamaño 3, entón pode escribirse:\n\nv[0]=1\nv[1]=2.5\nv[2]=-3.1',
		local: 'Declaración das variables que se deben protexer durante a execución da función.\n\nPara protexer as variables, hai que escribir os identificadores separados por comas (,) ou punto e coma (;).\n\nPor exemplo: i,j;k.',
		init: 'Asignacións e chamadas a funcións separadas por punto e coma (;), tal que, todo o contido nese campo execútase ao inicio do cálculo.',
		doExpr: 'Asignacións e chamadas a funcións separadas por saltos de liña (\\n), tal que, todo o contido nese campo execútase repetidamente mentres a condición do parámetro "mentres" sexa válida.',
		whileExpr: 'Expresión booleana que determina a condición para repetir as instruccións do parámetro "facer".',
		file: 'Arquivo de texto (recoméndase que leve a extensión .txt) no que aparecen os valores dos elementos do vector, separados por un salto de liña.\n\nOs valores poden ser numéricos ou de cadea, e neste último caso deben aparecen entre comiñas sinxelas, por exemplo \'valor\'.',
		info: 'Comentarios.',
	},

	Programs: {
		id: 'Identificador do programa.',
		evaluate: 'Opcións que permiten definir se a constante, a expresión do vector ou o algoritmo deben avaliarse cada vez que o usuario modifica un control ou só unha vez ao iniciarse a escena.\n\nÉ importante seleccionar "unha soa vez" cando sexa factible para que o funcionamento da escena sexa máis rápido.',
		init: 'Asignacións e chamadas a funcións separadas por punto e coma (;) de maneira que todo o comprendido neste campo sexa executado ao inicio do cálculo.',
		doExpr: 'Asignacións e chamadas a funcións separadas por saltos de liña (\\n) de maneira que todo o comprendido neste campo sexa executado repetidamente mentres a condición do parámetro "mentres" sexa válida.',
		whileExpr: 'Expresión booleana que determina a condición para repetir as instruccións do parámetro "facer".',
		condition: 'Expresión booleana que cando se cumpre executa a acción.\n\nA repetición da acción está condicionada polo parámetro "execución".',
		action: 'Acción que se executa ao interactuar coa escena e cumprir a condición booleana do parámetro "condición".\n\nExisten as seguintes accións: "calcular", "abrir URL", "abrir escena", "inicio", "limpar", "animar", "reiniciar animación" e "reprodicir".',
		parameter: 'Parámetro utilizado para a acción.\n\nSe a acción é "calcular", entón debe donter cero ou varias asignacións que o programa realizará cando se execute a acción.\n\nSe a acción é "abrir URL", entón debe ser calqueira URL.\n\nSe a acción é "abrir escena", entón debe ser unha dirección absoluta ou relativa á escena de Descartes que se desexa abrir.\n\nAs outras accións non usan o parámetro.',
		execution: 'Determina o modo de execución da acción do evento.\n\n"unha soa vez": a acción só se executa a primeira vez que se cumpre a condición.\n\n"alternar": a acción execútase a primeira vez que a condición se cumpre, pero se a condición deixa de ser válida e logo volve a selo, entón volve a executarse a acción.\n\n"sempre": a acción execútase sempre que se cumpra a condición.\n\nO valor por defecto é "unha soa vez".',
		info: 'Comentarios.',
	},

	Graphics: {
		space: 'Lista dos espazos de dúas dimensións que se teñan definido.\n\nUtilízase para asignar o espazo ao que pertence o gráfico.',
		type: 'O tipo de gráfico.',
		background: 'Ao estar activado indica que o gráfico debúxase só no fondo da escena e, polo tanto, actualízase unicamente cando se pulsa "inicio" e cando se modifica a escala ou a posición da orixe (O.x e O.y).\n\nCando un gráfico está sempre fixo na escena, é dicir, non depende dos controis, definicións ou programas, convén activar esta opción pois así afórrase o traballo de debuxar o gráfico cada vez que hai un cambio na escena.',
		color: 'Cor do gráfico.\n\nO botón abre o editor de cores.\n\nO valor por defecto é #20303a.',
		color_ARROW: 'Cor do bordo da frecha, o seu interior debúxase na cor do parámetro "frecha".\n\nO valor por defecto é #20303a.',
		drawif: 'Expresión booleana que determina se o gráfico debúxase ou non.\n\nO gráfico debúxase se a expresión é baleira ou se ten valor verdadeiro (ou maior que cero).\n\nO valor por defecto é baleiro, o que indica que sempre se debuxa.',
		drawif_EQUATION: 'Expresión booleana que determina se o gráfico debúxase ou non.\n\nO gráfico debúxase se a expresión é baleira ou se ten valor verdadeiro (ou maior que cero).\n\nSe a expresión depende de x ou y, e o gráfico é unha ecuación, entón só debúxanse os puntos da gráfica que satisfacen a expresión.\n\nSe o valor de x ou y non permiten que a expresión se cumpra no momento no que se vai debuxar (é responsabilidade do autor controlar o valor de x e y fóra das ecuacións).\n\nO valor por defecto é baleiro, o que indica que sempre se debuxa.',
		abs_coord: 'Ao estar activado fai que o gráfico sexa interpretado en píxeles e en coordenadas absolutas, coa orixe no vértice superior esquerdo da área do espazo ao que pertence no gráfico e a escala igual a 1 píxel por unidade.\n\nOs gráficos definidos en coordenadas absolutas non se moven ao cambiar a orixe do sistema ou a escala.',
		expression_EQUATION: 'Debe ser unha ecuación en x, y. O obxecto gráfico asociado a unha ecuación é o lugar xeométrico dos puntos que a satisfacen.\n\nO valor por defecto é y=x.',
		expression_CURVE: 'Expresión da forma (f(t),g(t)), onde f e g son funcións calesquera do parámetro t (ou o que se defina no campo "parámetro").\n\nO valor por defecto é (t,t).',
		expression_SEQUENCE: 'Expresión do tipo (X,Y), onde X e Y son expresións reais dependentes de n, que representan as abscisa e ordenada dos puntos da sucesión.\n\nO valor por defecto é (n,1/n).',
		expression_POINT: 'Expresión do tipo (X,Y), onde X e Y son expresións reais calesquera que representan as abscisa e ordenada do punto.\n\nO valor por defecto é (0,0).',
		expression_SEGMENT: 'Expresión do tipo (X1,Y1)(X2,Y2), onde (X1,Y1) son as coordenadas do inicio do segmento e (X2,Y2) as do final do segmento.\n\nO valor por defecto é (0,0)(1,1), é dicir, o segmento entre a orixe e o punto (1,1).',
		expression_ARROW: 'Expresión do tipo (X1,Y1)(X2,Y2), onde (X1,Y1) son as coordenadas do inicio da frecha e (X2,Y2) as da punta.\n\nO valor por defecto é (0,0)(1,1), é dicir, a frecha vai da orixe ao punto (1,1).',
		expression_POLYGON: 'Expresión do tipo\n\n(x1,y1)(x2,y2)...(xN,yN),\n\nonde xn e yn son expresións reais arbitrarias.\n\nO gráfico é o polígono con vértices nos puntos (xn,yn).\n\nO valor por defecto é (0,0)(1,1)(2,-1).',
		expression_FILL: 'Expresión do tipo (X,Y), onde X e Y son expresións reais calesquera que representan as abscisa e ordenada do punto onde se vai iniciar o proceso de recheo ou coloreo da rexión pechada que ten ao punto (X,Y) no seu interior.\n\nO valor por defecto é (0,0).',
		expression_TEXT: 'Expresión do tipo [X,Y], onde X e Y son expresións reais calesquera que representan as abscisa e ordenada do comezo do texto, pero medidos en píxeles a partir do vértice superior esquerdo da escena.\n\nO valor por defecto é [20,20].',
		expression_IMAGE: 'Expresión do tipo (X,Y), onde X e Y son expresións reais calesquera que representan as abscisa e ordenada do extremo superior esquerdo da imaxe con respecto á orixe de coordenadas do espazo.\n\nO valor por defecto é (0,0).',
		expression_MACRO: 'Nome do arquivo que contén os datos da macro. O arquivo debe encontrarse na carpeta onde está a páxina que contén a escena ou en subcarpetas dela.',
		expression: '*********',
		center: 'Expresión do tipo (X,Y) que representa o centro do arco, onde X e Y poden ser expresións reais arbitrarias.\n\nO valor por defecto é (0,0).',
		radius: 'Expresión real arbitraria, que representa o raio do arco.',
		init: 'Inicio do arco.\n\nHai dúas opcións: unha expresión real arbitraria que vaise interpretar como o ángulo inicial en graos, ou pode ser unha expresión da forma (x1,y1) que se interpretará como un punto. Neste segundo caso o arco comeza no segmento que une o centro (X,Y) co punto (x1,y1).',
		end: 'Fin do arco.\n\nHai dúas opcións: unha expresión real arbitraria que vaise interpretar como o ángulo final en graos, ou pode ser unha expresión da forma (x2,y2) que se interpretará como un punto. Neste segundo caso o arco remata no segmento que une o centro (X,Y) co punto (x2,y2).',
		vectors: 'Ao estar activado, determina que o lado inicial e final do arco se obteñan de dous vectores que parten do centro do arco e non de dous puntos do plano.',
		trace: 'Ao estar activado o obxecto gráfico deixa un rastro na escena da cor seleccionada.\n\nO botón abre o editor de cores.\n\nCando un gráfico deixa rastro pode apreciarse a súa traxectoria na escena. Pulsando o botón de "limpar" bórranse os rastros dos gráficos.\n\nO valor por defecto é non activado.',
		useFamily: 'Ao estar activado permite convertir un gráfico en toda unha familia de gráficos dependentes dun parámetro.\n\nAo seleccionar familia actívanse os campos "parámetro", "intervalo" e "pasos".\n\nO valor por defecto é non activado.',
		family: 'Nome do parámetro que se utiliza na efinición do obxecto gráfico para definir a familia.\n\nO valor por defecto é "s".\n\nO programa debuxará os gráficos, cos valores de "s", percorrendo o intervalo especificado no número de pasos elexido.',
		family_interval: 'Intervalo sobre o cal o parámetro da familia obterá os valores ao percorrelo no número de pasos especificado.\n\nSon expresións reais entre corchetes e separadas por unha coma.\n\nO valor por defecto é [0,1].',
		family_steps: 'Número de subintervalos iguais nos que se divide o intervalo da familia e o parámetro da familia pasa polos extremos dos subintervalos.\n\nO valor por defecto é 8.',
		parameter: 'Identificador do parámetro utilizada na curva. Recoméndase utilizar unha parabra curta. O valor por defecto é "t".\n\nO programa debuxará o polígono con vértices:\n\n(f(t),g(t)) para "t" entre o primeiro e o último dos valores do intervalo, con incrementos iguais á lonxitude do intervalo entre o número de pasos.',
		parameter_interval: 'Intervalo sobre o cal o parámetro da curva obterá os valores ao percorrelo no número de pasos especificado.\n\nSon dúas expresións ti e tf reais entre corchetes e separadas por unha coma, é dicir, [ti,tf].\n\nO valor por defecto é [0,1].',
		parameter_steps: 'Número de subintervalos iguais no que se divide o intervalo da curva e o parámetro da curva pasa polos extremos dos subintervalos.\n\nO valor por defecto é 8.',
		text: 'Etiqueta que acompaña ao obxecto gráfico e escríbese cerca da súa posición ou algo que se poida considerar como a súa posición.\n\nOs textos debúxanse na mesma cor ca o obxecto gráfico.\n\nOs textos poden ter varias liñas e ademais poden incluír valores numéricos variables.\n\nO valor por defecto é baleiro.',
		decimals: 'Número de decimais cos que se escriben os números incluídos no texto.\n\nPode ser un número fixo ou unha expresión. Ao avaliarse os números redondéanse para decidir o número de decimais.\n\nO valor por defcto é 2.',
		fixed: 'Ao estar activado determina se o número de decimais é fixo ou se, pola contra, utilízase a notación axustada, na que se eliminan os ceros innecesarios e o punto decimal se tamén é innecesario.\n\nPor exemplo: en lugar de 25.3400 escríbese 25.34 e en lugar de 13.0 escríbese 13 (sen o punto decimal).\n\nSi se utiliza a notación exponencial sempre se escriben os números en forma axustada, é dicir, o atributo fixo non interven neste caso.\n\nO valor por defecto é desactivado.',
		border: 'Cor do bordo no texto.',
		font: '*********',
		fill: 'Ao estar activado, o programa enche o interior da curva (considerada coma un polígono) coa cor seleccionada. Se a curva non ten un interior ben definido, o resultado pode ser algo estraño.',
		fillP: 'Cando está activado:\n\nSe a ecuación é da forma y=f(x) o espazo entre o eixe x e a gráfica (enriba do eixe x) énchese coa cor seleccionada.\n\nSe a ecuación é da forma x=g(y) o espazo entre o eixe y e a gráfica (á dereita do eixe y) énchese coa cor seleccionada.\n\nO valor por defecto é desactivado.',
		fillM: 'Cando está activado:\n\nSe a ecuación é da forma y=f(x) o espazo entre o eixe x e a gráfica (debaixo do eixe x) énchese coa cor seleccionada.\n\nSe a ecuación é da forma x=g(y) o espazo entre o eixe y e a gráfica (á esquerda do eixe y) énchese coa cor seleccionada.\n\nO valor por defecto é desactivado.',
		size: '*********',
		size_POINT: 'Raio do disco utilizado para representar o punto.\n\nSe o valor é 0 o punto non se debuxa. Esto último pode aproveitarse para debuxar textos asociados a puntos invisibles, usando as coordenadas do espazo.\n\nO valor por defecto é 2.',
		size_SEQUENCE: 'Raio do disco utilizado para representar os puntos da sucesión.\n\nSe o valor é 0 os puntos non se debuxan.\n\nO valor por defecto é 2.',
		size_SEGMENT: 'Raio do disco utilizado para representar os extremos do segmento.\n\nSe o valor é 0 os extremos non se debuxan.\n\nO valor por defecto é 2.',
		width: '*********',
		width_EQUATION: 'Ancho ou groso do trazo en píxeles.\n\nO valor por defecto é 1. Recoméndase utilizar pouco os anchos diferentes de 1, pois ralentizan o debuxo.',
		width_CURVE: 'Ancho ou groso en píxeles dos segmentos da curva.\n\nO valor por defecto é 1.',
		width_SEGMENT: 'Ancho ou groso en píxeles do segmento.\n\nO valor por defecto é 1.',
		width_POLYGON: 'Ancho ou groso en píxeles dos segmentos do polígono.\n\nO valor por defecto é 1.',
		width_ARC: 'Ancho ou groso en píxeles do arco.\n\nO valor por defecto é 1.',
		width_ARROW: 'Ancho ou groso en píxeles da frecha.\n\nO valor por defecto é 5.',
		width_TEXT: 'En textos non enriquecidos, especifica o ancho máximo de unha liña de texto antes de agregar saltos de liña-\n\nSi se usa en textos enriquecidos ou se é menor que 20, entón é ignorado.\n\nO valor por defecto é 1.',
		spear: 'Ancho da punta da frecha. O valor por defecto é 8.',
		arrow: 'Cor do interior da frecha.\n\nO valor por defecto é #ee0022.',
		visible: 'Cando está activado, na parte inferior da escena aparecerá un campo de texto onde se ve a expresión da ecuación na mesma cor da gráfica e coa cor de fondo da escena.\n\nO valor por defecto é non activado.\n\nSe hai varias ecuacións ou curvas nunha escena, debaixo dela aparecen os campos de texto de todas e cada unha delas que son visibles. Se son moitas os campos poden resultar demasiado pequenos, polo que se recomenda non deixar visibles os campos de texto de máis de tres ou catro ecuacións ou curvas.',
		editable: 'Cando está activado o contido do campo de texto que aparece baixo a escena coa ecuación (ou curva) pode ser modificado polo usuario.\n\nEsta opción é útil cando se desexa que o alumno practique a escritura de fórmulas.',
		range: 'Expresión da forma [n1,n2] onde n1 e n2 son dous enteiros que se interpretan como o inicio e o final do intervalo de enteiros que "n" percorrerá. O programa debuxa os puntos (X,Y) para cada valor de "n" entre n1 e n2.',
		file: 'Nome do arquivo da imaxe que se desexa utiliza como obxecto gráfico. Só poden utilizarse arquivos png, jpg, gif e svg. Os arquivos de imaxe deben colocarse no mesmo sitio onde se sitúa o arquivo html da escena ou en subdirectoris a partir de ahí. No nome do arquivo hai que incluír os subdirectorios.',
		inirot: 'Ángulo de xiro do obxecto gráfico, no sentido contrario ás agullas do reloxo.\n\nPode ser unha expresión ou un número fixo.',
		inipos: 'Expresión do tipo (X,Y) , onde X e Y son expresións reais calesqueira que representan as abscisa e ordenada do punto inicial da macro con respecto á orixe de coordenadas no espazo.',
		name: 'Nome da macro, que se utiliza para acceder aos seus parámetros ao facer cálculos.\n\nA sintaxe para acceder aos parámetros é <nome_macro>.nome_do_parámetro.',
		opacity: 'Nivel de opacidade da imaxe, é dicir, como de opaca ou translúcida é.\n\nO valor aceptade é un número entre 0 e 1, onde 0 é completamente transparente e 1 é completamente opaco.\n\nO valor por defecto é 1.',
		align: 'Aliñamento do texto respecto a unha caixa, onde o ancho está determinado polo tamaño da liña de texto máis longa das que conforman o texto e o alto está determinado pola altura que ocupa o texto.\n\nO texto pode aliñarse pegado ao bordo esquerdo, centrado ou pegado ao bordo dereito da caixa.\n\nSe o texto consta de unha soa liña, os tres aliñamentos debuxan o texto da mesma maneira.',
		anchor: 'Punto de ancoraxe da caixa de texto, onde o ancho está determinado polo tamaño da liña de texto máis longa das que conforman o texto e o alto está determinado pola altura que ocupa o texto.\n\nA posición do texto (dada polo parámetro expresión) e o punto de ancoraxe, determinan como se constrúe a caixa de texto e polo tanto a posición do texto dentro do espazo.',
		lineDash: 'Opcións que determinan o estilo do debuxo do trazo do gráfico, o cal pode ser un "sólido", "raiado" ou "punteado".',
		info: 'Comentarios.',
	},

	Graphics3D: {
		name: 'Nome da macro, que se utiliza paraacceder aos seus parámetros ao facer cálculos.\n\nA sintaxe para acceder aos parámetros é <nome_macro>.nome_do_parámetro.',
		space: 'Lista dos espazos de tres dimensións que se teñan definido.\n\nUtilízase para asignar o espazo ao que pertence o gráfico.',
		type: 'O tipo de gráfico.',
		background: 'Cando está activado o gráfico 3D calcúlase só unha vez e actualízase unicamente cando se pulsa inicio.\n\nCando un gráfico 3D non depende dos controis nin dos auxiliares, convén definilo como de fondo, pois así afórrase traballo ao procesador que non terá que calculalo cada vez que haxa un cambio na escena',
		color: 'Cor do gráfico.\n\nO botón abre o editor das cores.\n\nO valor por defecto é #eeffaa.',
		backcolor: 'Cor do reverso do gráfico.\n\nO botón abre o editor das cores.\n\nO valor por defecto é #6090a0.',
		drawif: 'Expresión booleana que determina se o gráfico debúxase ou non.\n\nO gráfico debúxase se a expresión é baleira ou ten valor verdadeiro (ou maior ca cero).\n\nO valor por defecto é baleiro, o que indica que sempre se debuxa.',
		expression: '*********',
		expression_POINT: 'Expresión da forma:\n\n(X,Y,Z)\n\nonde X, Y e Z son expresións numéricas calesquera, que representan a posición espacial dun punto en tres dimensións.\n\nO valor por defecto é (0,0,0).',
		expression_SEGMENT: 'Expresión da forma:\n\n(X1,Y1,Z1)(X2,Y2,Z2)\n\nonde X1, X2, Y1, Y2, Z1 e Z2 son expresións numéricas que representan a posición espacial dos extremos dun segmento en tres dimensións.\n\nO valor por defecto é (0,0,0)(1,1,1).',
		expression_POLYGON: 'Expresión da forma:\n\n(X1,Y1,Z1)(X2,Y2,Z2)...(Xn,Yn,Zn)\n\nonde X1, X2, Y1, Y2, Z1, Z2, ..., Xn, Yn, Zn son expresións numéricas que representan varios segmentos que forman un poligono (sen caras) en tres dimensións.\n\nO valor por defecto é (0,0,0)(1,0,0)(1,1,0)(1,1,1).',
		expression_CURVE: 'Expresión da forma:\n\nx=X(u)\ny=Y(u)\nz=Z(u)\n\nonde X, Y e Z son expresións numéricas dependentes do parámetro u.\n\nA curva debúxase como unha poligonal con Nu lados que forman os Nu+1 vértices dados polos puntos:\n\n(X(i/Nu),Y(i/Nu),Z(i/Nu)) para i=0,...,Nu+1.\n\nAntes de x, y, z poden definirse variables intermedias que só se utilizan para os cálculos que se realizan ao debuxar a curva.\n\n',
		expression_TRIANGLE: 'Coordenadas de tres puntos do espazo, é dicir, unha expresión da forma:\n\n(X1,Y1,Z1)(X2,Y2,Z2)(X3,Y3,Z3)\n\nonde Xi, Yi, para i=1,2,3 poden ser expresións numéricas.',
		expression_FACE: 'Coordenadas dun polígono no plano, é dicir, unha expresión da forma:\n\n(X1,Y1)(X2,Y2)...(Xn,Yn)\n\nonde Xi, Yi, para i=1,...,n son expresións numéricas.',
		expression_SURFACE: 'Expresión da forma:\n\nx=X(u,v)\ny=Y(u,v)\nz=Z(u,v)\n\nonde X, Y e Z son expresións numéricas dependentes dos parámetros u e v.\n\nA superficie consta da rede de cuadriláteros formada polos puntos:\n\n(X(i/Nu,j/Nv),Y(i/Nu,j/Nv),Z(i/Nu,j/Nv)) para i=0,...,Nu+1 e j=0,...,Nv+1.\n\nAntes de x, y, z poden definirse variables intermedias que só se utilizan para os cálculos que se realizan ao debuxar a superficie.\n\n',
		expression_TEXT: 'Expresión da forma:\n\n[X,Y]\n\nonde X e Y son expresións numéricas que determinan a posición do texto en píxeles medidos de esquerda a dereita e de arriba a abaixo con respecto ao vértice superior esquerdo do espazo.',
		expression_MACRO: 'Nome do arquivo que contén os datos da macro. O arquivo debe atoparse na carpeta onde está a páxina que contén a escena ou en subcarpetas dela.',
		useFamily: 'Cando está activado permite convertir un gráfico en toda unha familia de gráficos dependentes dun parámetro.\n\nAo seleccionar familia actívanse os campos "parámetro", "intervalo" e "pasos".\n\nO valor por defecto é non activado.',
		family: 'Nome do parámetro que se utiliza na definición do obxecto gráfico para definir a familia.\n\nO valor por defecto é "s".\n\nO programa debuxará os gráficos, cos valores de "s", percorrendo o intervalo especificado o número de pasos elexido.',
		family_interval: 'Intervalo sobre o cal o parámetro da familia obterá os valores ao percorrelo no número de pasos especificado.\n\nSon dúas expresións reais entre corchetes e separadas por unha coma.\n\nO valor por defecto é [0,1].',
		family_steps: 'Número de subintervalos iguais nos que se divide o intervalo da familia e o parámetro da familia pasa polos extremos dos subintervalos.\n\nO valor por defecto é 8.',
		inirot: 'Vector de tres componentes (A,B,C) que representa unha rotación inicial. Os seus elementos son rotacións (en graos) ao redor dos eixes x, y e z respectivamente, que se aplicarán sobre o obxecto gráfico antes de debuxarse.\n\nSi se agrega a palabra "Euler" antes da terna ordenada, é dicir, escríbese Euler(A,B,C), entón os ángulos A, B e C interprétanse como rotacións de Euler, é dicir, A é unha rotación ao redor do eixe z, B unha rotación ao redor do novo eixe x (o que se obtén tras a primeira rotación) e C ao redor do novo eixe z (o que se obtén tras as dúas primeiras rotacións).\n\nNota: Aplícase antes que a traslación inicial.',
		inipos: 'Vector de tres componentes (A,B,C) que representa unha traslación inicial, que se aplicará ao obxecto gráfico antes de debuxarse.\n\n\nNota: Aplícase despois da rotación inicial e antes que a rotación inicial.',
		endrot: 'Vector de tres componentes (A,B,C) que representa unha rotación final. Os seus elementos son rotacións (en graos) ao redor dos eixes x, y e z respectivamente, que se aplicarán sobre o obxecto gráfico antes de debuxarse.\n\nSi se agrega a palabra "Euler" antes da terna ordenada, é dicir, escríbese Euler(A,B,C), entón os ángulos A, B e C interprétanse como rotacións de Euler, é dicir, A é unha rotación ao redor do eixe z, B unha rotación ao redor do novo eixe x (o que se obtén tras a primeira rotación) e C ao redor do novo eixe z (o que se obtén tras as dúas primeiras rotacións).\n\nNota: Aplícase despois da traslación inicial e antes da traslación final.',
		endpos: 'Vector de tres componentes (A,B,C) que representa unha traslación final, que se aplicará ao obxecto gráfico antes de debuxarse.\n\nNota: Aplícase despois da rotación final.',
		split: 'Cando está activado, indica se a superficie debe ser cortada polos gráficos do mesmo espazo que a preceden na lista, no caso de intersección.\n\nÉ recomendable manter esta opción sempre activada, excepto no caso de utilizar moitos gráficos que non se intersectan e conveña facer un pouco máis rápida a execución.',
		edges: 'Cando está activado determina se os bordos das caras que forman o obxecto deben debuxarse ou non. Os bordos debúxanse en cor gris.',
		text: 'Etiqueta que acompaña ao obxecto gráfico e escríbese cerca da súa posición ou algo que poida considerarse a súa posición.\n\nOs textos debúxanse na mesma cor ca o obxecto gráfico.\n\nOs textos poden ter varias liñas e ademais poden incluír valores numéricos variables.\n\nO valor por defecto é baleiro.',
		font: '*********',
		decimals: 'Número de decimais cos que se escriben os números incluídos no texto.\n\nPode ser un número fixo ou unha expresión. Ao avaliarse os números redondéanse para decidir o número de decimais.\n\nO valor por defecto é 2.',
		fixed: 'Cando está activado indica se o número de decimais é fixo ou se, pola contra, utilízase a notación axustada, na que se eliminan os ceros innecesarios e o punto decimal se tamén é innecesario.\n\nPor exemplo: en lugar de 25.3400 escríbese 25.34 e en lugar de 13.0 escríbese 13 (sen o punto decimal).\n\nSi se usa notación exponencial sempre se escriben os números en forma axustada, é dicir, o atributo fixo non intervén neste caso.\n\nO valor por defecto é desactivado.',
		model: 'Opcións para debuxar as caras do obxecto gráfico.\n\n"cor": fai que se debuxe con cores sólidas.\n\n"luz": fai que a cor sexa máis ou menos brillante segundo a orientación, para dar unha sensación de iluminación.\n\n"metal": é como luz, pero con brillos máis contrastados para dar a impresión de que a superficie é metálica.\n\n"alambre": debuxa só os bordos na cor seleccionada.\n\nNota: Co modelo alambre as arestas debúxanse na cor seleccionada en lugar de gris como ocorre nos outros modelos.',
		width: '*********',
		width_POINT: 'Tamaño do punto en píxeles.\n\nO valor por defecto é 1.',
		width_SEGMENT: 'Ancho ou groso en píxeles do segmento.\n\nO valor por defecto é 1.',
		width_POLYGON: 'Ancho ou groso en píxeles dos segmentos do polígono.\n\nO valor por defecto é 1.',
		width_CURVE: 'Ancho ou groso en píxeles dos segmentos da curva.\n\nO valor por defecto é 1.',
		width_POLIREG: 'Metade do raio do polígono regular se ancho=longo. Se ancho!=longo entón o polígono non é regular, é unha deformación dun regular.',
		width_CUBE: 'Tamaño do lado do cubo en píxeles.\n\nO valor por defecto é 2.',
		width_BOX: 'Dimensión ao longo do eixe x.\n\nO valor por defecto é 2.',
		width_TETRAHEDRON: 'Tamaño do lado do tetraedro en píxeles.\n\nO valor por defecto é 2.',
		width_OCTAHEDRON: 'Tamaño do lado do octaedro en píxeles.\n\nO valor por defecto é 2.',
		width_DODECAHEDRON: 'Tamaño do lado do dodecaedro en píxeles.\n\nO valor por defecto é 2.',
		width_ICOSAHEDRON: 'Tamaño do lado do icosaedro en píxeles.\n\nO valor por defecto é 2.',
		width_SPHERE: 'Tamaño do diámetro da esfera en píxeles.\n\nO valor por defecto é 2.',
		width_ELLIPSOID: 'Dimensión ao longo do eixe x.\n\nO valor por defecto é 2.',
		width_CONE: 'Dimensión ao longo do eixe x.\n\nO valor por defecto é 2.',
		width_CYLINDER: 'Dimensión ao longo do eixe x.\n\nO valor por defecto é 2.',
		length: '*********',
		length_POLIREG: 'Metade do raio do polígono regular se ancho=longo. Se ancho!=longo entón o polígono non é regular, é unha deformación dun regular.',
		length_ELLIPSOID: 'Dimensión ao longo do eixe y.\n\nO valor por defecto é 2.',
		length_CONE: 'Dimensión ao longo do eixe y.\n\nO valor por defecto é 2.',
		length_CYLINDER: 'Dimensión ao longo do eixe y.\n\nO valor por defecto é 2.',
		height: 'Dimensión ao longo do eixe z.\n\nO valor por defecto é 2.',
		Nu: 'Número de intervalos nos que se parte o intervalo unitario [0,1] para o parámetro "u".',
		Nv: 'Número de intervalos nos que se parte o intervalo unitario [0,1] para o parámetro "v".',
		offset_dist: 'Desprazamento do texto á posición do punto.',
		offset_angle: 'Ángulo no que se realiza o desprazamento do texto respecto á posición do punto.',
		info: 'Comentarios.',
	},

	Animation: {
		useAnimation: 'Cando está activado todos os campos do panel de animación actívanse e o autor pode escribir neles ou elexir opcións para programar a animación.',
		delay: 'O tempo en milisegundos que o programa espera en cada paso da animación.\n\nO valor por defecto é 40.\n\nOs valores pequenos fan que a animación sexa máis rápida e viceversa. En procesadores lentos os valores pequenos non necesariamente producen animacións rápidas.',
		auto: 'Cando está activado determina se a animación comeza automaticamente cando a escena aparece na pantalla e cada vez que se pulsa o botón de "inicio".\n\nCando está desactivado a animación comeza só cando o usuario executa unha acción que inicie a animación.',
		loop: 'Cando está activado determina se a animación se repite indefinidamente ou ben detense cando a condición "mentres" deixa de ser verdadeira.',
		init: 'Asignacións e chamadas a funcións separadas por punto e coma (;), de maneira que todo o que conteña esta campo execútase ao inicio do cálculo.',
		doExpr: 'Asignacións e chamadas a funcións separadas por altos de liña(\\n), de maneira que todo o que conteña esta campo execútase repetidamente mentres a condición do parámetro "mentres" sexa válida.',
		whileExpr: 'Expresión booleana que determina a condición para repetir as instruccións do parámetro "facer".',
		info: 'Comentarios.',
	},

	Extra: {
		expand: 'Expande o contido do campo de texto.',
		simple_text_editor: 'Editor de texto simple.',
		rich_text_editor: 'Editor de texto enriquecido.',
	},

  }

  return tooltip;
})(tooltip || {});