// Generated by CoffeeScript 1.10.0
(function() {
  var Data, PostTable, Table,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  Table = require('../table');

  Data = require('../../data');

  PostTable = (function(superClass) {
    var POSTSCRIPT_GLYPHS;

    extend(PostTable, superClass);

    function PostTable() {
      return PostTable.__super__.constructor.apply(this, arguments);
    }

    PostTable.prototype.tag = 'post';

    PostTable.prototype.parse = function(data) {
      var i, j, length, numberOfGlyphs, ref, results;
      data.pos = this.offset;
      this.format = data.readInt();
      this.italicAngle = data.readInt();
      this.underlinePosition = data.readShort();
      this.underlineThickness = data.readShort();
      this.isFixedPitch = data.readInt();
      this.minMemType42 = data.readInt();
      this.maxMemType42 = data.readInt();
      this.minMemType1 = data.readInt();
      this.maxMemType1 = data.readInt();
      switch (this.format) {
        case 0x00010000:
          break;
        case 0x00020000:
          numberOfGlyphs = data.readUInt16();
          this.glyphNameIndex = [];
          for (i = j = 0, ref = numberOfGlyphs; 0 <= ref ? j < ref : j > ref; i = 0 <= ref ? ++j : --j) {
            this.glyphNameIndex.push(data.readUInt16());
          }
          this.names = [];
          results = [];
          while (data.pos < this.offset + this.length) {
            length = data.readByte();
            results.push(this.names.push(data.readString(length)));
          }
          return results;
          break;
        case 0x00025000:
          numberOfGlyphs = data.readUInt16();
          return this.offsets = data.read(numberOfGlyphs);
        case 0x00030000:
          break;
        case 0x00040000:
          return this.map = (function() {
            var k, ref1, results1;
            results1 = [];
            for (i = k = 0, ref1 = this.file.maxp.numGlyphs; 0 <= ref1 ? k < ref1 : k > ref1; i = 0 <= ref1 ? ++k : --k) {
              results1.push(data.readUInt32());
            }
            return results1;
          }).call(this);
      }
    };

    PostTable.prototype.glyphFor = function(code) {
      var index;
      switch (this.format) {
        case 0x00010000:
          return POSTSCRIPT_GLYPHS[code] || '.notdef';
        case 0x00020000:
          index = this.glyphNameIndex[code];
          if (index <= 257) {
            return POSTSCRIPT_GLYPHS[index];
          } else {
            return this.names[index - 258] || '.notdef';
          }
          break;
        case 0x00025000:
          return POSTSCRIPT_GLYPHS[code + this.offsets[code]] || '.notdef';
        case 0x00030000:
          return '.notdef';
        case 0x00040000:
          return this.map[code] || 0xFFFF;
      }
    };

    PostTable.prototype.encode = function(mapping) {
      var id, index, indexes, j, k, l, len, len1, len2, position, post, raw, string, strings, table;
      if (!this.exists) {
        return null;
      }
      raw = this.raw();
      if (this.format === 0x00030000) {
        return raw;
      }
      table = new Data(raw.slice(0, 32));
      table.writeUInt32(0x00020000);
      table.pos = 32;
      indexes = [];
      strings = [];
      for (j = 0, len = mapping.length; j < len; j++) {
        id = mapping[j];
        post = this.glyphFor(id);
        position = POSTSCRIPT_GLYPHS.indexOf(post);
        if (position !== -1) {
          indexes.push(position);
        } else {
          indexes.push(257 + strings.length);
          strings.push(post);
        }
      }
      table.writeUInt16(Object.keys(mapping).length);
      for (k = 0, len1 = indexes.length; k < len1; k++) {
        index = indexes[k];
        table.writeUInt16(index);
      }
      for (l = 0, len2 = strings.length; l < len2; l++) {
        string = strings[l];
        table.writeByte(string.length);
        table.writeString(string);
      }
      return table.data;
    };

    POSTSCRIPT_GLYPHS = '.notdef .null nonmarkingreturn space exclam quotedbl numbersign dollar percent\nampersand quotesingle parenleft parenright asterisk plus comma hyphen period slash\nzero one two three four five six seven eight nine colon semicolon less equal greater\nquestion at A B C D E F G H I J K L M N O P Q R S T U V W X Y Z\nbracketleft backslash bracketright asciicircum underscore grave\na b c d e f g h i j k l m n o p q r s t u v w x y z\nbraceleft bar braceright asciitilde Adieresis Aring Ccedilla Eacute Ntilde Odieresis\nUdieresis aacute agrave acircumflex adieresis atilde aring ccedilla eacute egrave\necircumflex edieresis iacute igrave icircumflex idieresis ntilde oacute ograve\nocircumflex odieresis otilde uacute ugrave ucircumflex udieresis dagger degree cent\nsterling section bullet paragraph germandbls registered copyright trademark acute\ndieresis notequal AE Oslash infinity plusminus lessequal greaterequal yen mu\npartialdiff summation product pi integral ordfeminine ordmasculine Omega ae oslash\nquestiondown exclamdown logicalnot radical florin approxequal Delta guillemotleft\nguillemotright ellipsis nonbreakingspace Agrave Atilde Otilde OE oe endash emdash\nquotedblleft quotedblright quoteleft quoteright divide lozenge ydieresis Ydieresis\nfraction currency guilsinglleft guilsinglright fi fl daggerdbl periodcentered\nquotesinglbase quotedblbase perthousand Acircumflex Ecircumflex Aacute Edieresis\nEgrave Iacute Icircumflex Idieresis Igrave Oacute Ocircumflex apple Ograve Uacute\nUcircumflex Ugrave dotlessi circumflex tilde macron breve dotaccent ring cedilla\nhungarumlaut ogonek caron Lslash lslash Scaron scaron Zcaron zcaron brokenbar Eth\neth Yacute yacute Thorn thorn minus multiply onesuperior twosuperior threesuperior\nonehalf onequarter threequarters franc Gbreve gbreve Idotaccent Scedilla scedilla\nCacute cacute Ccaron ccaron dcroat'.split(/\s+/g);

    return PostTable;

  })(Table);

  module.exports = PostTable;

}).call(this);
