/*
 * Decompiled with CFR 0.152.
 */
package com.jla.sound;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;

public class SoundPlayer {
    static final Hashtable hashAudios = new Hashtable();

    private static AudioContainerPack[] getAudioPackArray(String string) {
        AudioContainerPack[] audioContainerPackArray;
        if (string != null) {
            audioContainerPackArray = new AudioContainerPack[]{(AudioContainerPack)hashAudios.get(string)};
        } else {
            Enumeration enumeration = hashAudios.elements();
            audioContainerPackArray = new AudioContainerPack[hashAudios.size()];
            for (int i = 0; i < audioContainerPackArray.length; ++i) {
                if (!enumeration.hasMoreElements()) continue;
                audioContainerPackArray[i] = (AudioContainerPack)enumeration.nextElement();
            }
        }
        return audioContainerPackArray;
    }

    public static boolean isPaused(String string) {
        AudioContainerPack[] audioContainerPackArray = SoundPlayer.getAudioPackArray(string);
        for (int i = 0; i < audioContainerPackArray.length; ++i) {
            if (!audioContainerPackArray[i].isAlive() || !audioContainerPackArray[i].isPaused()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlaying(String string) {
        AudioContainerPack[] audioContainerPackArray = SoundPlayer.getAudioPackArray(string);
        for (int i = 0; i < audioContainerPackArray.length; ++i) {
            if (!audioContainerPackArray[i].isAlive()) continue;
            return true;
        }
        return false;
    }

    public static void stop(String string) {
        if (string == null) {
            SoundPlayer.stopAll();
        } else {
            AudioContainerPack audioContainerPack = (AudioContainerPack)hashAudios.get(string);
            try {
                AudioInputStream audioInputStream = audioContainerPack.getAudioInputStream();
                Thread thread = audioContainerPack.getThread();
                SourceDataLine sourceDataLine = audioContainerPack.getLine();
                if (thread != null && thread.isAlive()) {
                    thread.stop();
                }
                if (sourceDataLine != null) {
                    sourceDataLine.drain();
                    sourceDataLine.stop();
                    sourceDataLine.close();
                }
                if (audioInputStream == null) {
                    audioInputStream.close();
                }
                hashAudios.remove(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static boolean isFinished(String string) {
        AudioContainerPack audioContainerPack = (AudioContainerPack)hashAudios.get(string);
        if (audioContainerPack == null) {
            return true;
        }
        AudioInputStream audioInputStream = audioContainerPack.getAudioInputStream();
        Thread thread = audioContainerPack.getThread();
        int n = 0;
        boolean bl = true;
        try {
            if (audioInputStream != null) {
                n = audioInputStream.available();
                boolean bl2 = bl = !thread.isAlive() && n <= 0;
                if (bl) {
                    SoundPlayer.stop(string);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    public static void stopAll() {
        Hashtable hashtable = hashAudios;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            SoundPlayer.stop((String)enumeration.nextElement());
        }
    }

    public static void my_gc() {
        Hashtable hashtable = hashAudios;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            SoundPlayer.isFinished(string);
        }
    }

    public static void setVolumeLevel(String string, float f) {
        AudioContainerPack[] audioContainerPackArray = SoundPlayer.getAudioPackArray(string);
        for (int i = 0; i < audioContainerPackArray.length; ++i) {
            if (audioContainerPackArray[i] == null) continue;
            try {
                SourceDataLine sourceDataLine = audioContainerPackArray[i].getLine();
                FloatControl floatControl = (FloatControl)sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
                float f2 = floatControl.getMinimum();
                float f3 = floatControl.getMaximum();
                double d = f2;
                double d2 = 0.5f * f3 - f2;
                double d3 = Math.log(10.0) / 20.0;
                double d4 = d + 1.0 / d3 * Math.log(1.0 + (Math.exp(d3 * d2) - 1.0) * (double)f);
                audioContainerPackArray[i].setVolumen(f);
                floatControl.setValue((float)d4);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void pause(String string) {
        AudioContainerPack[] audioContainerPackArray = SoundPlayer.getAudioPackArray(string);
        for (int i = 0; i < audioContainerPackArray.length; ++i) {
            Thread thread;
            if (audioContainerPackArray[i] == null || (thread = audioContainerPackArray[i].getThread()) == null || !thread.isAlive()) continue;
            if (audioContainerPackArray[i].isPaused()) {
                audioContainerPackArray[i].setPaused(false);
                thread.resume();
                continue;
            }
            audioContainerPackArray[i].setPaused(true);
            thread.suspend();
        }
    }

    public static void setInLoop(String string, boolean bl) {
        AudioContainerPack audioContainerPack = (AudioContainerPack)hashAudios.get(string);
        if (audioContainerPack == null) {
            return;
        }
        audioContainerPack.setLoop(bl);
    }

    public static void play(String string, URL uRL) {
        SoundPlayer.play(string, uRL, false);
    }

    public static void play(final String string, URL uRL, boolean bl) {
        try {
            MpegAudioFileReader mpegAudioFileReader = new MpegAudioFileReader();
            if (uRL == null) {
                throw new IOException("El URL es null");
            }
            AudioInputStream audioInputStream = mpegAudioFileReader.getAudioInputStream(uRL);
            AudioFormat audioFormat = audioInputStream.getFormat();
            final AudioFormat audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
            AudioInputStream audioInputStream2 = AudioSystem.getAudioInputStream(audioFormat2, audioInputStream);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat2);
            SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            final AudioContainerPack audioContainerPack = new AudioContainerPack(uRL, audioInputStream2, null, sourceDataLine);
            audioContainerPack.setLoop(bl);
            if (sourceDataLine != null) {
                Runnable runnable = new Runnable(){
                    AudioContainerPack pack2;
                    {
                        this.pack2 = audioContainerPack;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            this.pack2.getLine().open(audioFormat2);
                            byte[] byArray = new byte[4096];
                            this.pack2.getLine().start();
                            int n = this.pack2.getAudioInputStream().read(byArray, 0, byArray.length);
                            this.pack2.getAudioInputStream().mark(1024);
                            Object object = this.pack2.getLock();
                            synchronized (object) {
                                while (n != -1) {
                                    while (this.pack2.isPaused()) {
                                        if (this.pack2.getLine().isRunning()) {
                                            this.pack2.getLine().stop();
                                        }
                                        try {
                                            this.pack2.getLock().wait();
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    if (!this.pack2.getLine().isRunning()) {
                                        this.pack2.getLine().start();
                                    }
                                    this.pack2.getLine().write(byArray, 0, n);
                                    n = this.pack2.getAudioInputStream().read(byArray, 0, byArray.length);
                                }
                            }
                            this.pack2.getLine().drain();
                            this.pack2.getLine().stop();
                            this.pack2.getLine().close();
                            this.pack2.getAudioInputStream().close();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        finally {
                            if (this.pack2.getAudioInputStream() != null) {
                                try {
                                    this.pack2.getAudioInputStream().close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        if (this.pack2.isLoop()) {
                            SoundPlayer.play(string, this.pack2.getFile(), true);
                            SoundPlayer.setVolumeLevel(string, this.pack2.getVolumen());
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                audioContainerPack.setThread(thread);
                hashAudios.put(string, audioContainerPack);
                thread.start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static final class AudioContainerPack {
        URL file;
        AudioInputStream audioInputStream;
        Thread thread;
        SourceDataLine line;
        Object lock = new Object();
        boolean paused;
        boolean loop;
        float volumen = 1.0f;

        public AudioContainerPack(URL uRL, AudioInputStream audioInputStream, Thread thread, SourceDataLine sourceDataLine) {
            this.file = uRL;
            this.audioInputStream = audioInputStream;
            this.thread = thread;
            this.line = sourceDataLine;
        }

        public AudioInputStream getAudioInputStream() {
            return this.audioInputStream;
        }

        public SourceDataLine getLine() {
            return this.line;
        }

        public Object getLock() {
            return this.lock;
        }

        public boolean isAlive() {
            return this.thread != null && this.thread.isAlive();
        }

        public Thread getThread() {
            return this.thread;
        }

        public void setAudioInputStream(AudioInputStream audioInputStream) {
            this.audioInputStream = audioInputStream;
        }

        public void setLine(SourceDataLine sourceDataLine) {
            this.line = sourceDataLine;
        }

        public void setThread(Thread thread) {
            this.thread = thread;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public void setPaused(boolean bl) {
            this.paused = bl;
        }

        public boolean isLoop() {
            return this.loop;
        }

        public void setLoop(boolean bl) {
            this.loop = bl;
        }

        public URL getFile() {
            return this.file;
        }

        public void setFile(URL uRL) {
            this.file = uRL;
        }

        public float getVolumen() {
            return this.volumen;
        }

        public void setVolumen(float f) {
            this.volumen = f;
        }
    }
}

