/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descartes;

import com.mja.descartes.Arquimedes;
import com.mja.descartes.Descartes;
import com.mja.descartes.Scene;
import com.mja.descartes.controlConfig;
import com.mja.descartes.spaceConfig;
import com.mja.descgui.ButtonControl;
import com.mja.descgui.MediaControl;
import com.mja.descgui.TextAreaControl;
import com.mja.descgui.mjaGui;
import com.mja.file.mjaFile;
import com.mja.file.mjaFont;
import com.mja.gui.mjaColor;
import com.mja.gui.mjaText;
import com.mja.math.R2;
import com.mja.parser.Node;
import com.mja.util.BasicStr;
import com.mja.util.LiveOrDie;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public abstract class Space
extends Panel
implements KeyListener,
MouseListener,
MouseMotionListener,
LiveOrDie {
    public boolean TextBound = false;
    protected Descartes D;
    public spaceConfig spcfg;
    TextAreaControl[] TAC;
    MediaControl[] MC;
    mjaColor backColor;
    Image main;
    protected Image back;
    private Image bgimage;
    protected Graphics2D gmain;
    Graphics2D gback;
    Graphics2D G;
    protected boolean pleaseStop;
    protected Thread thr;
    static final int bck = 0;
    static final int net = 1;
    static final int net10 = 2;
    static final int axe = 3;
    static final int tex = 4;
    int w = -1;
    int h = -1;
    int Ox;
    int Oy;
    private int Oxa;
    private int Oya;
    private double esca;
    Node NOx;
    Node NOy;
    Node Nesc;
    private int xa;
    private int ya;
    private controlConfig aC;
    private int acix;
    private controlConfig[] grctrl;
    private controlConfig[] txtctrl;
    private controlConfig[] mediactrl;
    private String SpaceID = "";
    protected Node visibilityN;
    private boolean isPainted = false;
    private Node pos_x;
    private Node pos_y;
    Scene scene;
    private boolean isUsed = false;
    private Dimension d;
    protected boolean started = false;
    private boolean variable_back_drawn = false;
    private boolean space_variable = false;
    protected Image buffer;
    private Graphics2D gb;
    private boolean updating;
    private boolean dragging;
    private volatile boolean stopping = false;
    private boolean dragged;
    private R2 ds = new R2(0.0, 0.0);
    private long mouse_pressed_at;
    private long mouse_released_at;
    long mouse_dragged_at;
    private controlConfig ttc;
    private int Mouse_X;
    private int Mouse_Y;

    protected abstract void stopMoving();

    protected abstract void flushImages();

    protected abstract boolean isMoving();

    protected abstract void doCalc();

    protected abstract boolean onDrag(boolean var1, int var2, int var3);

    protected abstract void writeCoordinates(Graphics var1, int var2, int var3);

    protected abstract R2 injection(double var1, double var3);

    protected abstract R2 projection(R2 var1);

    public Space(Descartes descartes, int n) {
        this(descartes, descartes.cfg.sc[n]);
    }

    public Space(Descartes descartes, spaceConfig spaceConfig2) {
        int n;
        int n2;
        int n3;
        int n4;
        this.setLayout(null);
        this.D = descartes;
        this.spcfg = spaceConfig2;
        this.visibilityN = descartes.p.Analyse(this.spcfg.s_visicond, "1");
        this.setVisible(this.visibilityN.Evaluate(1.0) > 0.0);
        this.backColor = this.spcfg.DC[0];
        int n5 = 0;
        for (n4 = 0; n4 < descartes.cfg.cc.length; ++n4) {
            if (descartes.cfg.cc[n4].type != 97 || !descartes.cfg.cc[n4].s_value[controlConfig.ixspace].equals(this.spcfg.getName())) continue;
            ++n5;
        }
        this.grctrl = new controlConfig[n5];
        n4 = 0;
        for (n3 = 0; n3 < descartes.cfg.cc.length; ++n3) {
            if (descartes.cfg.cc[n3].type != 97 || !descartes.cfg.cc[n3].s_value[controlConfig.ixspace].equals(this.spcfg.getName())) continue;
            this.grctrl[n4] = descartes.cfg.cc[n3];
            this.grctrl[n4].setSpace(this);
            ++n4;
        }
        n3 = 0;
        for (n2 = 0; n2 < descartes.cfg.cc.length; ++n2) {
            if (descartes.cfg.cc[n2].type != 98 || !descartes.cfg.cc[n2].s_value[controlConfig.ixspace].equals(this.spcfg.getName())) continue;
            ++n3;
        }
        this.txtctrl = new controlConfig[n3];
        n4 = 0;
        for (n2 = 0; n2 < descartes.cfg.cc.length; ++n2) {
            if (descartes.cfg.cc[n2].type != 98 || !descartes.cfg.cc[n2].s_value[controlConfig.ixspace].equals(this.spcfg.getName())) continue;
            this.txtctrl[n4] = descartes.cfg.cc[n2];
            this.txtctrl[n4].setSpace(this);
            ++n4;
        }
        this.TAC = new TextAreaControl[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.TAC[n2] = new TextAreaControl(descartes, this.txtctrl[n2]);
            this.add(this.TAC[n2]);
        }
        n2 = 0;
        for (n = 0; n < descartes.cfg.cc.length; ++n) {
            if (descartes.cfg.cc[n].type != 325 && descartes.cfg.cc[n].type != 326 || !descartes.cfg.cc[n].s_value[controlConfig.ixspace].equals(this.spcfg.getName())) continue;
            ++n2;
        }
        this.mediactrl = new controlConfig[n2];
        n4 = 0;
        for (n = 0; n < descartes.cfg.cc.length; ++n) {
            if (descartes.cfg.cc[n].type != 325 && descartes.cfg.cc[n].type != 326 || !descartes.cfg.cc[n].s_value[controlConfig.ixspace].equals(this.spcfg.getName())) continue;
            this.mediactrl[n4] = descartes.cfg.cc[n];
            this.mediactrl[n4].setSpace(this);
            ++n4;
        }
        this.MC = new MediaControl[n2];
        for (n = 0; n < n2; ++n) {
            this.MC[n] = new MediaControl(descartes, this.mediactrl[n]);
            this.add(this.MC[n]);
        }
        this.setSpaceID(this.spcfg.getSpaceID());
    }

    public Image getBackImage() {
        return this.back;
    }

    public void registerTextsInParser() {
        for (int i = 0; i < this.TAC.length; ++i) {
            this.TAC[i].registerTextInParser();
        }
    }

    public void updateTextsFromNodes() {
        for (int i = 0; i < this.TAC.length; ++i) {
            this.TAC[i].updateVisualComponent();
        }
    }

    public void showSolutions() {
        for (int i = 0; i < this.TAC.length; ++i) {
            this.TAC[i].showSolution();
        }
    }

    public void showUserTexts() {
        for (int i = 0; i < this.TAC.length; ++i) {
            this.TAC[i].showUserText();
        }
    }

    public String getSpaceID() {
        return this.SpaceID;
    }

    public void setSpaceID(String string) {
        this.SpaceID = string;
    }

    @Override
    public void setIsUsed(boolean bl) {
        this.isUsed = bl;
        if (this.isUsed) {
            this.D.cfg.addSpace(this.spcfg);
        } else {
            if (this.getParent() != null) {
                this.getParent().remove(this);
            }
            this.D.cfg.removeSpace(this.spcfg);
        }
    }

    @Override
    public boolean isUsed() {
        return this.isUsed;
    }

    @Override
    public Component cloneComponent(String string) {
        spaceConfig spaceConfig2 = this.spcfg.cloneSpaceConfig();
        Space space = spaceConfig2.makeSpace(this.D);
        space.preSize();
        this.D.scene.addEditObjectToText(spaceConfig2, string);
        return space;
    }

    public String getSpaceName() {
        return this.spcfg.getName();
    }

    public void preSize() {
        int n;
        this.d = this.D.getSceneSize();
        this.d.height -= this.D.scene.getTitleHeight();
        if (this.d.width <= 0 || this.d.height <= 0) {
            System.out.println("premature sizing");
            new Exception("premature preSize 2").printStackTrace();
        }
        if (!BasicStr.hasContent(this.spcfg.left)) {
            this.spcfg.left = "0";
        }
        if (!BasicStr.hasContent(this.spcfg.top)) {
            this.spcfg.top = "0";
        }
        try {
            this.pos_x = this.D.p.Analyse("Space " + this.getName() + ".x", this.spcfg.left, true, false);
        }
        catch (Exception exception) {
            n = (int)Math.round(BasicStr.parsePercentageOf(this.spcfg.left, this.d.width, 0.0, 0.0));
            this.pos_x = this.D.p.Analyse(Integer.toString(n), n);
        }
        try {
            this.pos_y = this.D.p.Analyse("Space " + this.getName() + ".y", this.spcfg.top, true, false);
        }
        catch (Exception exception) {
            n = (int)Math.round(BasicStr.parsePercentageOf(this.spcfg.top, this.d.height, 0.0, 0.0));
            this.pos_y = this.D.p.Analyse(Integer.toString(n), n);
        }
        this.w = (int)Math.round(BasicStr.parsePercentageOf(this.spcfg.width, this.d.width, this.d.width, this.d.width));
        this.h = (int)Math.round(BasicStr.parsePercentageOf(this.spcfg.height, this.d.height, this.d.height, this.d.height));
        if (this.w <= 0 || this.h <= 0) {
            System.out.println("spcfg.width=" + this.spcfg.width + " d.width=" + this.d.width);
            System.out.println("spcfg.height=" + this.spcfg.height + " d.height=" + this.d.height);
            System.out.println("Space.presize w=" + this.w);
            System.out.println("Space.presize h=" + this.h);
            new Exception("espacio sin dimensiones").printStackTrace();
        }
        int n2 = (int)Math.round(this.pos_x.Evaluate(0.0));
        n = (int)Math.round(this.pos_y.Evaluate(0.0));
        if (!(this.D instanceof Arquimedes)) {
            if (n2 < 0) {
                this.w += n2;
                n2 = 0;
            }
            if (n < 0) {
                this.h += n;
                n = 0;
            }
            int n3 = Math.min(n2 + this.w, this.d.width);
            int n4 = Math.min(n + this.h, this.d.height);
            this.w = n3 - n2;
            this.h = n4 - n;
        }
        this.getSpaceParameters(new Dimension(this.w, this.h));
        this.locate();
        if (BasicStr.hasContent(this.spcfg.bgimage) && this.w > 0 && this.h > 0) {
            this.bgimage = mjaFile.loadImage(this.D.imagesHT, this.D, this.spcfg.bgimage);
        }
        this.D.p.Var(this.spcfg.prefix() + "_w").setDouble(this.w);
        this.D.p.Var(this.spcfg.prefix() + "_h").setDouble(this.h);
    }

    void getSpaceParameters(Dimension dimension) {
        String string = this.spcfg.prefix() + "escala";
        double d = this.D.p.isVar(string) || this.D.p.isAux(string) ? this.D.p.rvalue(string) : BasicStr.parsePercentageOf(this.spcfg.getScale(), dimension.width, this.D.cfg.escala0, this.D.cfg.escala0);
        this.Nesc = this.D.p.Var(string);
        this.Nesc.setDouble(d);
        string = this.spcfg.prefix() + "Ox";
        if (this.D.p.isVar(string) || this.D.p.isAux(string)) {
            this.Ox = (int)Math.round(this.D.p.rvalue(string) + (double)this.w / 2.0);
        } else {
            this.Ox = (int)Math.round(BasicStr.parsePercentageOf(this.spcfg.s_Ox, dimension.width, 0.0, 0.0) + (double)this.w / 2.0);
            this.D.p.Var(string).setDouble((double)this.Ox - (double)this.w / 2.0);
        }
        this.NOx = this.D.p.Var(string);
        string = this.spcfg.prefix() + "Oy";
        if (this.D.p.isVar(string) || this.D.p.isAux(string)) {
            this.Oy = (int)Math.round(this.D.p.rvalue(string) + (double)this.h / 2.0);
        } else {
            this.Oy = (int)Math.round(BasicStr.parsePercentageOf(this.spcfg.s_Oy, dimension.height, 0.0, 0.0) + (double)this.h / 2.0);
            this.D.p.Var(string).setDouble((double)this.Oy - (double)this.h / 2.0);
        }
        this.NOy = this.D.p.Var(string);
        String[] stringArray = new String[]{"x"};
        String string2 = "(x-" + this.spcfg.prefix() + "Ox-" + Integer.toString(this.w / 2) + ")/" + this.spcfg.prefix() + "escala";
        this.D.p.defineFunc(this.spcfg.prefix() + "_x", stringArray, string2, false);
        String[] stringArray2 = new String[]{"y"};
        string2 = "(" + Integer.toString(this.h / 2) + "-y+" + this.spcfg.prefix() + "Oy)/" + this.spcfg.prefix() + "escala";
        this.D.p.defineFunc(this.spcfg.prefix() + "_y", stringArray2, string2, false);
    }

    void locate() {
        int n;
        if (this.TextBound) {
            this.setSize(this.w, this.h);
        } else {
            double d = this.pos_x.Evaluate(0.0);
            double d2 = this.pos_y.Evaluate(0.0);
            int n2 = (int)Math.round(d);
            int n3 = (int)Math.round(d2);
            int n4 = this.w;
            int n5 = this.h;
            this.setBounds(n2, n3, n4, n5);
        }
        for (n = 0; n < this.TAC.length; ++n) {
            this.TAC[n].locate();
        }
        for (n = 0; n < this.MC.length; ++n) {
            this.MC[n].locate();
        }
    }

    private Image TransformGrayToTransparency(BufferedImage bufferedImage) {
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){

            @Override
            public final int filterRGB(int n, int n2, int n3) {
                return n3 << 8 & 0xFF000000;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), rGBImageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    Image createTranspImage(int n, int n2) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.setFont(mjaFont.AWTMono);
        return bufferedImage;
    }

    void prepareMainImage() {
        this.main = this.createTranspImage(this.w, this.h);
        this.gmain = (Graphics2D)this.main.getGraphics();
        this.gmain.setFont(mjaFont.AWTMono);
        this.buffer = this.createImage(this.w, this.h);
        this.gb = (Graphics2D)this.buffer.getGraphics();
        this.gb.setFont(mjaFont.AWTMono);
    }

    @Override
    public void start() {
        int n;
        this.setBackground(this.backColor.getAdaptedColor());
        if (this.isVisible()) {
            for (n = 0; n < this.spcfg.DC.length; ++n) {
                this.spcfg.DC[n].analyse(this.D.p);
            }
            this.G = (Graphics2D)this.getGraphics();
            n = 0;
            while (n < 10) {
                try {
                    this.prepareMainImage();
                    break;
                }
                catch (Exception exception) {
                    System.out.println("Space.start waiting " + ++n);
                }
            }
            if (this.gmain == null) {
                System.out.println("Graphics not initialized in " + this);
            }
            n = 0;
            while (n < 10) {
                try {
                    this.back = this.createImage(this.w, this.h);
                    this.gback = (Graphics2D)this.back.getGraphics();
                    break;
                }
                catch (Exception exception) {
                    System.out.println("Space.start waiting " + ++n);
                }
            }
            this.pleaseStop = false;
            this.started = true;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addKeyListener(this);
        }
        for (n = 0; n < this.TAC.length; ++n) {
            this.TAC[n].start();
        }
    }

    protected void updateForTransparency() {
        int n = -this.getLocation().x;
        int n2 = -this.getLocation().y;
        if (this.D.scene.EC != null) {
            this.gback.drawImage((Image)this.D.scene.EC.getBufferedImage(), n, n2, this);
        }
        for (int i = 0; i < this.D.scene.spa.length && this.D.scene.spa[i] != this; ++i) {
            if (!this.D.scene.spa[i].isVisible() || this.buffer == null) continue;
            n = this.D.scene.spa[i].getLocation().x - this.getLocation().x;
            n2 = this.D.scene.spa[i].getLocation().y - this.getLocation().y;
            this.gback.drawImage(this.D.scene.spa[i].buffer, n, n2, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doBack(boolean bl) {
        this.setVisible(this.visibilityN.Evaluate(1.0) > 0.0);
        if (this.isVisible()) {
            if (!this.started) {
                this.start();
            }
            BasicStroke basicStroke = new BasicStroke(1.0f, 0, 1);
            this.gback.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.gback.setStroke(basicStroke);
            if (this.backColor.variable() && !this.variable_back_drawn || this.backColor.getAdaptedColor().getAlpha() < 255) {
                this.gback.setColor(Color.lightGray);
                this.gback.fillRect(0, 0, this.w, this.h);
                this.updateForTransparency();
                bl = true;
            }
            if (bl) {
                if (this.backColor.variable()) {
                    if (!this.variable_back_drawn) {
                        Color color = this.backColor.getAdaptedColor();
                        this.gback.setColor(color);
                        Node node = this.D.p.Var("x");
                        Node node2 = this.D.p.Var("y");
                        Node node3 = node;
                        synchronized (node3) {
                            Node node4 = node2;
                            synchronized (node4) {
                                double d = node.getDouble();
                                double d2 = node2.getDouble();
                                for (int i = 0; i < this.h; ++i) {
                                    node2.setDouble(this.y(i));
                                    for (int j = 0; j < this.w; ++j) {
                                        node.setDouble(this.x(j));
                                        Color color2 = this.backColor.getAdaptedColor();
                                        if (!color.equals(color2)) {
                                            this.gback.setColor(color2);
                                            this.space_variable = true;
                                        }
                                        this.gback.fillRect(j, i, 1, 1);
                                    }
                                }
                                node.setDouble(d);
                                node2.setDouble(d2);
                            }
                        }
                        this.variable_back_drawn = true;
                    } else if (!this.space_variable) {
                        this.gback.setColor(this.backColor.getAdaptedColor());
                        this.gback.fillRect(0, 0, this.w, this.h);
                    }
                } else {
                    this.gback.setColor(this.backColor.getAdaptedColor());
                    this.gback.fillRect(0, 0, this.w, this.h);
                }
                if (this.bgimage != null) {
                    int n = this.bgimage.getWidth(this);
                    int n2 = this.bgimage.getHeight(this);
                    switch (this.spcfg.bgdisplay) {
                        case 1: {
                            this.gback.drawImage(this.bgimage, 0, 0, this.w, this.h, this);
                            break;
                        }
                        case 3: {
                            this.gback.drawImage(this.bgimage, (this.w - n) / 2, (this.h - n2) / 2, this);
                            break;
                        }
                        case 2: {
                            for (int i = 0; i < this.h; i += n2) {
                                for (int j = 0; j < this.w; j += n) {
                                    this.gback.drawImage(this.bgimage, j, i, this);
                                }
                            }
                            break;
                        }
                        default: {
                            this.gback.drawImage(this.bgimage, 0, 0, this);
                        }
                    }
                }
            }
        }
    }

    protected void doFront(boolean bl) {
        if (this.isVisible()) {
            int n;
            Component[] componentArray = this.getComponents();
            if (this.buffer != null) {
                for (n = 0; n < componentArray.length; ++n) {
                    if (!(componentArray[n] instanceof ButtonControl)) continue;
                    ((ButtonControl)componentArray[n]).getMjaButton().setBackImage(this.buffer);
                }
            }
            if (this.D instanceof Arquimedes && !this.backColor.isEqualTo(Scene.sceneBackColor)) {
                n = 4;
                for (int i = 0; i < n; ++i) {
                    this.gmain.setColor(new Color(0, 0, 0, 3 * (n - i) * (n - i) / 2));
                    this.gmain.drawRect(i, i, this.getSize().width - 1 - 2 * i, this.getSize().height - 1 - 2 * i);
                }
            }
        }
    }

    protected void drawBackControls() {
        Graphics[] graphicsArray = new Graphics2D[]{(Graphics2D)this.back.getGraphics()};
        for (int i = 0; i < this.grctrl.length; ++i) {
            if (!this.grctrl[i].hasTrace) continue;
            this.grctrl[i].drawControl(true, graphicsArray);
        }
    }

    private void drawFrontControls() {
        Graphics[] graphicsArray = new Graphics2D[]{(Graphics2D)this.buffer.getGraphics()};
        for (int i = 0; i < this.grctrl.length; ++i) {
            this.grctrl[i].drawControl(false, graphicsArray);
        }
    }

    @Override
    public synchronized void paint(Graphics graphics) {
        if (graphics != null && this.back != null && this.main != null && this.buffer != null) {
            this.gb.drawImage(this.back, 0, 0, this);
            this.gb.drawImage(this.main, 0, 0, this);
            this.drawFrontControls();
            graphics.drawImage(this.buffer, 0, 0, this);
        }
    }

    public Image getBuffer() {
        return this.buffer;
    }

    public synchronized void updateSpace(boolean bl, boolean bl2) {
        if (!this.updating) {
            this.updating = true;
            this.doBack(bl);
            this.doFront(bl2);
            this.updating = false;
        }
    }

    synchronized void paintSpace() {
        this.paint(this.G);
    }

    boolean isDragging() {
        return this.dragging;
    }

    protected boolean isStopping() {
        return this.stopping;
    }

    public void stop() {
        for (int i = 0; i < this.TAC.length; ++i) {
            this.TAC[i].stop();
        }
        this.stopping = true;
        this.pleaseStop = true;
        try {
            while (this.isRunning()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.flushImages();
        if (this.main != null) {
            this.main.flush();
            this.main = null;
        }
        if (this.back != null) {
            this.back.flush();
            this.back = null;
        }
        if (this.bgimage != null) {
            this.bgimage.flush();
            this.bgimage = null;
        }
        if (this.buffer != null) {
            this.buffer.flush();
            this.buffer = null;
        }
        this.stopping = false;
    }

    protected boolean pleaseStop() {
        return this.pleaseStop;
    }

    private boolean isRunning() {
        return this.thr != null;
    }

    double x(int n) {
        return this.Nesc != null ? (double)(n - this.Ox) / this.Nesc.getDouble() : 0.0;
    }

    double y(int n) {
        return this.Nesc != null ? (double)(this.Oy - n) / this.Nesc.getDouble() : 0.0;
    }

    boolean inside(R2 r2) {
        return -this.w <= r2.ix() && r2.ix() <= 2 * this.w && -this.h <= r2.iy() && r2.iy() <= 2 * this.h;
    }

    boolean closeEnough(R2 r2, R2 r22, int n, int n2, boolean bl) {
        R2 r23 = this.projection(r22);
        if (bl) {
            return Math.abs(r23.x - r2.x) < (double)n && Math.abs(r23.y - r2.y) < (double)n2;
        }
        return (r23.x - r2.x) * (r23.x - r2.x) / (double)(n * n) + (r23.y - r2.y) * (r23.y - r2.y) / (double)(n2 * n2) < 1.0;
    }

    void adjustControls() {
        for (int i = 0; i < this.grctrl.length; ++i) {
            this.grctrl[i].adjust();
        }
    }

    void setActiveControl(int n) {
        if (n < 0) {
            n = this.grctrl.length - 1;
        }
        if (n >= this.grctrl.length) {
            n = 0;
        }
        for (int i = 0; i < this.grctrl.length; ++i) {
            this.grctrl[i].isSelected = false;
        }
        this.grctrl[n].isSelected = true;
        this.aC = this.grctrl[n];
        this.aC.isPressed = true;
        this.acix = n;
    }

    boolean spaceChanged() {
        this.Ox = (int)Math.round(this.D.p.rvalue(this.spcfg.prefix() + "Ox") + (double)this.w / 2.0);
        this.Oy = (int)Math.round(this.D.p.rvalue(this.spcfg.prefix() + "Oy") + (double)this.h / 2.0);
        this.correctScale();
        boolean bl = this.Nesc.getDouble() != this.esca || this.Ox != this.Oxa || this.Oy != this.Oya;
        this.esca = this.Nesc.getDouble();
        this.Oxa = this.Ox;
        this.Oya = this.Oy;
        return bl;
    }

    protected void correctScale() {
        if (this.Nesc.getDouble() < 1.0E-6) {
            this.Nesc.setDouble(1.0E-6);
        }
        if (this.Nesc.getDouble() > 1000000.0) {
            this.Nesc.setDouble(1000000.0);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.dragging = true;
        this.xa = mouseEvent.getX();
        this.ya = mouseEvent.getY();
        if (mouseEvent.getModifiers() == 16) {
            int n;
            this.D.updateNodesFromControls();
            this.stopMoving();
            this.mouse_pressed_at = System.currentTimeMillis();
            this.updateMouseVariables(mouseEvent);
            this.dragged = false;
            if (this.aC != null) {
                this.aC.isSelected = false;
            }
            this.aC = null;
            R2 r2 = new R2(this.xa, this.ya);
            boolean bl = false;
            for (n = this.grctrl.length - 1; n >= 0; --n) {
                this.D.p.Var(this.grctrl[n].label + ".active").setDouble(0.0);
                this.D.p.Var(this.grctrl[n].label + ".activo").setDouble(0.0);
            }
            for (n = this.grctrl.length - 1; n >= 0; --n) {
                if (!this.grctrl[n].isActive() || !this.closeEnough(r2, this.grctrl[n].cpos, this.grctrl[n].size_x + 1, this.grctrl[n].size_y + 1, this.grctrl[n].hasImage())) continue;
                R2 r22 = this.projection(this.grctrl[n].cpos);
                this.ds.x = r22.x - r2.x;
                this.ds.y = r22.y - r2.y;
                this.setActiveControl(n);
                this.D.p.Var(this.grctrl[n].label + ".active").setDouble(1.0);
                this.D.p.Var(this.grctrl[n].label + ".activo").setDouble(1.0);
                bl = true;
                this.D.refresh(false);
                return;
            }
            if (!bl) {
                this.D.p.Var(this.spcfg.prefix() + "mouse_pressed").setDouble(1.0);
                this.D.p.Var(this.spcfg.prefix() + "rat\u00f3n_apretado").setDouble(1.0);
            }
            this.D.refresh(false);
            if (!bl) {
                this.writeCoordinates(this.G, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16) {
            if (this.aC != null) {
                this.aC.isPressed = false;
            }
            this.mouse_released_at = System.currentTimeMillis();
            if (this.mouse_dragged_at + 250L < this.mouse_released_at) {
                this.stopMoving();
            }
            this.updateMouseVariables(mouseEvent);
            boolean bl = this.dragged;
            if (this.dragged) {
                this.dragged = false;
                this.D.setCursor(null);
                this.dragged = false;
            }
            if (this.aC != null) {
                this.requestFocus();
            }
            if (this.D.p.Var(this.spcfg.prefix() + "mouse_pressed").getDouble() == 1.0) {
                this.D.p.Var(this.spcfg.prefix() + "mouse_pressed").setDouble(0.0);
                this.D.p.Var(this.spcfg.prefix() + "rat\u00f3n_apretado").setDouble(0.0);
                this.D.refresh(true);
            } else {
                this.D.refresh(false);
            }
        }
        this.dragging = false;
        this.requestFocus();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 || mouseEvent.getClickCount() == 1 && BasicStr.CtrlOn && !BasicStr.ShiftOn) {
            Space space = this;
            if (space.D.inNippeEditor()) {
                this.D.edit(this);
                return;
            }
        }
        if (mouseEvent.getClickCount() != 1) return;
        if ((mouseEvent.getModifiers() == 4 || BasicStr.CtrlOn && BasicStr.ShiftOn) && System.currentTimeMillis() - this.mouse_released_at > 1000L) {
            R2 r2 = new R2(this.xa, this.ya);
            boolean bl = false;
            int n = 0;
            while (true) {
                if (n >= this.grctrl.length) {
                    if (bl) return;
                    this.D.showExternalSpinners();
                    return;
                }
                if (this.grctrl[n].isActive() && this.closeEnough(r2, this.grctrl[n].cpos, this.grctrl[n].size_x + 1, this.grctrl[n].size_y + 1, this.grctrl[n].hasImage()) && BasicStr.hasContent(this.grctrl[n].explanation)) {
                    bl = true;
                    this.paint(this.G);
                    mjaText.msg((Component)mouseEvent.getSource(), this.grctrl[n].label, this.grctrl[n].explanation, this.grctrl[n].expl_font);
                }
                ++n;
            }
        }
        this.stopMoving();
        this.D.p.Var(this.spcfg.prefix() + "mouse_clicked").setDouble(1.0);
        this.D.p.Var(this.spcfg.prefix() + "clic_izquierdo").setDouble(1.0);
        this.D.p.Var(this.spcfg.prefix() + "mouse_clicked").setDouble(0.0);
        this.D.p.Var(this.spcfg.prefix() + "clic_izquierdo").setDouble(0.0);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 16) {
            this.updateMouseVariables(mouseEvent);
        }
        if (this.aC != null) {
            if (mouseEvent.getModifiers() == 16) {
                this.aC.setControlPos((double)mouseEvent.getX() + this.ds.x, (double)mouseEvent.getY() + this.ds.y);
            }
        } else if (!this.spcfg.fixed) {
            this.mouse_dragged_at = System.currentTimeMillis();
            this.dragged |= this.onDrag(mouseEvent.getModifiers() == 4, mouseEvent.getX() - this.xa, mouseEvent.getY() - this.ya);
            this.D.updateTextFieldsFromNodes();
            if (this.dragged) {
                this.D.setCursor(new Cursor(13));
            }
        }
        this.xa = mouseEvent.getX();
        this.ya = mouseEvent.getY();
        this.D.refresh(false);
        if (this.aC == null) {
            if (mouseEvent.getModifiers() == 16) {
                this.writeCoordinates(this.G, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        this.Mouse_X = mouseEvent.getX();
        this.Mouse_Y = mouseEvent.getY();
        if (this.spcfg.mouseMotionActive) {
            this.updateMouseVariables(mouseEvent);
        }
        if (this.ttc != null) {
            this.ttc.isOver = false;
        }
        boolean bl = false;
        R2 r2 = new R2(mouseEvent.getX(), mouseEvent.getY());
        for (n = 0; n < this.grctrl.length; ++n) {
            this.grctrl[n].isOver = false;
            if (!this.grctrl[n].isActive() || !this.closeEnough(r2, this.grctrl[n].cpos, this.grctrl[n].size_x, this.grctrl[n].size_y, this.grctrl[n].hasImage())) continue;
            bl = true;
            if (this.grctrl[n] == this.ttc) break;
            this.ttc = this.grctrl[n];
            if (!BasicStr.hasContent(this.grctrl[n].tooltip)) break;
            Component component = (Component)mouseEvent.getSource();
            mjaGui.showTooltip(this.D, component, new Point(component.getLocationOnScreen().x + mouseEvent.getX(), component.getLocationOnScreen().y + mouseEvent.getY() + 16), this.grctrl[n].tooltip, this.D.Tr.getTr(201), this.grctrl[n].tooltip_font);
            break;
        }
        n = 0;
        if (bl) {
            this.setCursor(new Cursor(12));
            if (!this.ttc.isOver) {
                this.ttc.isOver = true;
            }
        } else {
            this.setCursor(null);
            mjaGui.hideTooltip();
            if (this.ttc != null) {
                this.ttc.isOver = false;
            }
            this.ttc = null;
        }
        if (n == 0 && this.spcfg.mouseMotionActive) {
            this.D.refresh(true);
        }
    }

    private void updateMouseVariables(MouseEvent mouseEvent) {
        this.D.p.Var(this.spcfg.prefix() + "mouse_x").setDouble(this.x(mouseEvent.getX()));
        this.D.p.Var(this.spcfg.prefix() + "mouse_y").setDouble(this.y(mouseEvent.getY()));
        this.D.p.Var(this.spcfg.prefix() + "rat\u00f3n_x").setDouble(this.x(mouseEvent.getX()));
        this.D.p.Var(this.spcfg.prefix() + "rat\u00f3n_y").setDouble(this.y(mouseEvent.getY()));
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        BasicStr.CtrlOn = keyEvent.isControlDown();
        BasicStr.ShiftOn = keyEvent.isShiftDown();
        if (keyEvent.getSource() == this && this.grctrl.length > 0) {
            if (this.aC == null) {
                this.setActiveControl(0);
            }
            if (this.aC != null && this.aC.isActive()) {
                controlConfig controlConfig2 = this.aC;
                R2 r2 = this.aC.getControlPos();
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        r2.x -= 1.0;
                        break;
                    }
                    case 39: {
                        r2.x += 1.0;
                        break;
                    }
                    case 38: {
                        r2.y -= 1.0;
                        break;
                    }
                    case 40: {
                        r2.y += 1.0;
                        break;
                    }
                    case 9: {
                        if (keyEvent.getModifiers() == 1) {
                            --this.acix;
                            if (this.acix < 0) {
                                this.acix = this.grctrl.length - 1;
                            }
                        } else {
                            ++this.acix;
                            if (this.acix >= this.grctrl.length) {
                                this.acix = 0;
                            }
                        }
                        this.setActiveControl(this.acix);
                        keyEvent.consume();
                        this.updateSpace(false, false);
                        return;
                    }
                    default: {
                        return;
                    }
                }
                controlConfig2.setControlPos(r2.x, r2.y);
                this.D.scene.refreshScene(true);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        BasicStr.CtrlOn = false;
        BasicStr.ShiftOn = false;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

