/*
 * Decompiled with CFR 0.152.
 */
package com.mja.gui;

import com.mja.file.mjaFont;
import com.mja.gui.Explainer;
import com.mja.gui.mjaText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.net.URL;

public class MouseCursorHandler
implements MouseListener {
    Component parent;
    Explainer E;
    private Cursor qCursor;
    public boolean handEnabled = true;

    public MouseCursorHandler(Component component, Explainer explainer) {
        this.parent = component;
        this.E = explainer;
        URL uRL = this.getClass().getResource("/resources/images/questionMark.png");
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        BufferedImage bufferedImage = new BufferedImage(32, 32, 6);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(new Color(0, 0, 0, 0));
        graphics.fillRect(0, 0, 20, 20);
        graphics.drawImage(image, 8, 5, component);
        this.qCursor = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(16, 16), "question");
    }

    public void setHand() {
        this.parent.setCursor(this.qCursor);
    }

    public void setWait() {
        this.parent.setCursor(new Cursor(3));
    }

    public void setNull() {
        this.parent.setCursor(null);
    }

    public boolean isHand() {
        if (this.parent.getCursor() == null) {
            return false;
        }
        return this.parent.getCursor() == this.qCursor;
    }

    public String getExplLabel(MouseEvent mouseEvent) {
        return "";
    }

    public String getExplanation(MouseEvent mouseEvent) {
        return "";
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isHand()) {
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getModifiers() == 4 || mouseEvent.getSource() instanceof Label) {
            mouseEvent.consume();
            if (this.E != null) {
                mjaText.msg((Component)mouseEvent.getSource(), this.E.getExplLabel(mouseEvent), this.E.getExplanation(mouseEvent), mjaFont.AWTMonoB);
            }
            this.setNull();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isHand()) {
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

