/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKResources;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.VoltmeterModel;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public class VoltmeterNode
extends PhetPNode {
    private VoltmeterModel voltmeterModel;
    private UnitNode unitImageNode;
    private LeadNode blackProbe;
    private LeadNode redProbe;
    private CableNode redCable;
    private CableNode blackCable;

    public VoltmeterNode(VoltmeterModel voltmeterModel) {
        this.voltmeterModel = voltmeterModel;
        this.unitImageNode = new UnitNode(voltmeterModel);
        this.redProbe = new LeadNode("circuit-construction-kit/images/probeRed.gif", voltmeterModel.getRedLeadModel());
        this.blackProbe = new LeadNode("circuit-construction-kit/images/probeBlack.gif", voltmeterModel.getBlackLeadModel());
        this.addChild(this.unitImageNode);
        Point2D.Double double_ = new Point2D.Double(0.1305, 2.3707499999999997);
        Point2D.Double double_2 = new Point2D.Double(0.957, 2.3707499999999997);
        this.redCable = new CableNode(Color.red, this.redProbe, voltmeterModel.getUnitModel(), voltmeterModel.getRedLeadModel(), double_);
        this.blackCable = new CableNode(Color.black, this.blackProbe, voltmeterModel.getUnitModel(), voltmeterModel.getBlackLeadModel(), double_2);
        this.addChild(this.redCable);
        this.addChild(this.redProbe);
        this.addChild(this.blackCable);
        this.addChild(this.blackProbe);
        voltmeterModel.addListener(new VoltmeterModel.Listener(){

            public void voltmeterChanged() {
                VoltmeterNode.this.update();
            }
        });
        this.update();
    }

    private void update() {
        this.setVisible(this.voltmeterModel.isVisible());
    }

    private class CableNode
    extends PhetPNode {
        private PPath path;
        private final BasicStroke cableStroke = new BasicStroke(0.032625f);
        private LeadNode leadNode;
        private VoltmeterModel.UnitModel unitModel;
        private VoltmeterModel.LeadModel leadModel;
        private Point2D unitConnectionOffset;

        public CableNode(Color color, LeadNode leadNode, VoltmeterModel.UnitModel unitModel, VoltmeterModel.LeadModel leadModel, Point2D point2D) {
            this.leadNode = leadNode;
            this.unitModel = unitModel;
            this.leadModel = leadModel;
            this.unitConnectionOffset = point2D;
            this.path = new PPath();
            this.path.setStroke(this.cableStroke);
            this.path.setStrokePaint(color);
            this.addChild(this.path);
            unitModel.addListener(new VoltmeterModel.UnitModel.Listener(){

                public void unitModelChanged() {
                    CableNode.this.update();
                }
            });
            leadModel.addListener(new VoltmeterModel.LeadModel.Listener(){

                public void leadModelChanged() {
                    CableNode.this.update();
                }
            });
            this.update();
        }

        public void update() {
            Point2D point2D = this.leadNode.getTailLocation();
            Point2D.Double double_ = new Point2D.Double(this.unitModel.getLocation().getX() + this.unitConnectionOffset.getX(), this.unitModel.getLocation().getY() + this.unitConnectionOffset.getY());
            this.path.setPathTo(new Line2D.Double(point2D, double_));
            double d = ((Point2D)double_).getX();
            double d2 = ((Point2D)double_).getY();
            double d3 = point2D.getX();
            double d4 = point2D.getY();
            float f = 1.0875f;
            CubicCurve2D.Double double_2 = new CubicCurve2D.Double(d3, d4, d3, d4 + (double)f, (2.0 * d + d3) / 3.0, d2, d, d2);
            this.path.setPathTo(double_2);
        }
    }

    private class LeadNode
    extends PhetPNode {
        private VoltmeterModel.LeadModel leadModel;
        private PImage imageNode;
        private PhetPPath tipPath;

        public LeadNode(String string, final VoltmeterModel.LeadModel leadModel) {
            this.leadModel = leadModel;
            this.imageNode = PImageFactory.create(string);
            this.imageNode.rotateAboutPoint(leadModel.getAngle(), 0.1, 0.1);
            this.imageNode.scale(0.010875);
            this.addChild(this.imageNode);
            leadModel.addListener(new VoltmeterModel.LeadModel.Listener(){

                public void leadModelChanged() {
                    LeadNode.this.updateLead();
                }
            });
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseDragged(PInputEvent pInputEvent) {
                    PDimension pDimension = pInputEvent.getDeltaRelativeTo(LeadNode.this.getParent());
                    leadModel.translate(pDimension.width, pDimension.height);
                }
            });
            this.addInputEventListener(new CursorHandler());
            this.tipPath = new PhetPPath(Color.lightGray);
            this.addChild(this.tipPath);
            this.updateLead();
        }

        private void updateLead() {
            double d = (double)this.imageNode.getImage().getWidth(null) * 0.010875 * Math.cos(this.leadModel.getAngle()) / 2.0;
            double d2 = (double)this.imageNode.getImage().getWidth(null) * 0.010875 * Math.sin(this.leadModel.getAngle()) / 2.0;
            this.imageNode.setOffset(this.leadModel.getTipLocation().getX() - d, this.leadModel.getTipLocation().getY() - d2);
            this.tipPath.setPathTo(this.leadModel.getTipShape());
        }

        public Point2D getTailLocation() {
            Point2D.Double double_ = new Point2D.Double(this.imageNode.getWidth() / 2.0, this.imageNode.getHeight());
            this.imageNode.localToParent(double_);
            this.localToParent(double_);
            return new Point2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY());
        }
    }

    static class UnitNode
    extends PhetPNode {
        private VoltmeterModel voltmeterModel;
        private PText textNode;
        private DecimalFormat decimalFormat = new DefaultDecimalFormat("0.00");
        private final String UNKNOWN_VOLTS = CCKResources.getString("VoltmeterGraphic.UnknownVolts");

        public UnitNode(final VoltmeterModel voltmeterModel) {
            this.voltmeterModel = voltmeterModel;
            this.scale(0.010875);
            voltmeterModel.addListener(new VoltmeterModel.Listener(){

                public void voltmeterChanged() {
                    UnitNode.this.update();
                }
            });
            voltmeterModel.getUnitModel().addListener(new VoltmeterModel.UnitModel.Listener(){

                public void unitModelChanged() {
                    UnitNode.this.update();
                }
            });
            this.addChild(PImageFactory.create("circuit-construction-kit/images/vm3.gif"));
            this.textNode = new PText();
            this.textNode.setFont(new PhetFont(0, 20));
            this.textNode.setOffset(15.0, 20.0);
            this.addChild(this.textNode);
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseDragged(PInputEvent pInputEvent) {
                    PDimension pDimension = pInputEvent.getDeltaRelativeTo(UnitNode.this.getParent());
                    voltmeterModel.bodyDragged(pDimension.width, pDimension.height);
                }
            });
            this.addInputEventListener(new CursorHandler());
            this.update();
        }

        private void update() {
            this.setOffset(this.voltmeterModel.getUnitModel().getLocation());
            if (Double.isNaN(this.voltmeterModel.getVoltage())) {
                this.textNode.setText(this.UNKNOWN_VOLTS);
            } else {
                this.textNode.setText(this.decimalFormat.format(this.voltmeterModel.getVoltage()) + " V");
            }
        }
    }
}

