/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.CCKStrings;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListenerAdapter;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Wire;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.BranchNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKSimulationPanel;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.JunctionNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.TrackingHelpNode;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class RightClickHelpNode
extends PhetPNode {
    private boolean userRightClicked = false;
    private CCKModule module;
    private TrackingHelpNode branchHelpNode;
    private CCKSimulationPanel cckSimulationPanel;
    private TrackingHelpNode junctionHelpNode;
    private boolean dragging = false;

    public RightClickHelpNode(CCKSimulationPanel cCKSimulationPanel, CCKModule cCKModule) {
        this.module = cCKModule;
        this.cckSimulationPanel = cCKSimulationPanel;
        String string = PhetUtilities.isMacintosh() ? CCKStrings.getString("CCKHelp.right-click-help-mac") : CCKStrings.getString("CCKHelp.right-click-help");
        this.branchHelpNode = new TrackingHelpNode(cCKSimulationPanel, cCKModule, string, TrackingHelpNode.BOTTOM_CENTER);
        this.addChild(this.branchHelpNode);
        this.junctionHelpNode = new TrackingHelpNode(cCKSimulationPanel, cCKModule, string, TrackingHelpNode.RIGHT_BOTTOM);
        this.addChild(this.junctionHelpNode);
        cCKSimulationPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isMetaDown()) {
                    RightClickHelpNode.this.userRightClicked = true;
                    RightClickHelpNode.this.dragging = true;
                    RightClickHelpNode.this.update();
                }
            }
        });
        cCKModule.getCircuit().addCircuitListener(new CircuitListenerAdapter(){

            public void selectionChanged() {
                RightClickHelpNode.this.update();
            }
        });
        this.update();
    }

    private void update() {
        BranchNode branchNode = this.getFirstSelectedBranch();
        this.branchHelpNode.setVisible(false);
        if (branchNode != null) {
            boolean bl = !this.userRightClicked && this.isConnectedToSomething(branchNode) && this.isNonWireSelected() && !this.dragging;
            this.branchHelpNode.setVisible(bl);
            this.branchHelpNode.setFollowedNode(branchNode);
        } else {
            this.branchHelpNode.setVisible(false);
        }
        JunctionNode junctionNode = this.getFirstSelectedJunction();
        this.junctionHelpNode.setVisible(false);
        if (junctionNode != null) {
            boolean bl = !this.userRightClicked && this.isConnectedToTwoThings(junctionNode) & this.isJunctionSelected() && !this.dragging;
            this.junctionHelpNode.setVisible(bl);
            this.junctionHelpNode.setFollowedNode(junctionNode);
        } else {
            this.junctionHelpNode.setVisible(false);
        }
    }

    private boolean isConnectedToTwoThings(JunctionNode junctionNode) {
        return this.module.getCircuit().getAdjacentBranches(junctionNode.getJunction()).length >= 2;
    }

    private boolean isConnectedToSomething(BranchNode branchNode) {
        return this.module.getCircuit().getNeighbors(branchNode.getBranch()).length > 0;
    }

    private JunctionNode getFirstSelectedJunction() {
        for (int i = 0; i < this.cckSimulationPanel.getCircuitNode().getNumJunctionNodes(); ++i) {
            JunctionNode junctionNode = this.cckSimulationPanel.getCircuitNode().getJunctionNode(i);
            if (!junctionNode.getJunction().isSelected()) continue;
            return junctionNode;
        }
        return null;
    }

    private BranchNode getFirstSelectedBranch() {
        for (int i = 0; i < this.cckSimulationPanel.getCircuitNode().getNumBranchNodes(); ++i) {
            BranchNode branchNode = this.cckSimulationPanel.getCircuitNode().getBranchNode(i);
            if (!branchNode.getBranch().isSelected()) continue;
            return branchNode;
        }
        return null;
    }

    private boolean isJunctionSelected() {
        return this.module.getCircuit().getSelectedJunctions().length > 0;
    }

    private boolean isNonWireSelected() {
        int n = 0;
        Branch[] branchArray = this.module.getCircuit().getSelectedBranches();
        if (n < branchArray.length) {
            Branch branch = branchArray[n];
            if (branch instanceof Wire) {
                // empty if block
            }
            return true;
        }
        return false;
    }
}

