/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.controls.GrabBagButton;
import edu.colorado.phet.circuitconstructionkit.controls.SimpleKeyEvent;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.Wire;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.BranchNodeFactory;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKBackground;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKHelpSuite;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ChartSetNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CircuitNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.MeasurementToolSetNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.MessageNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.RightClickHelpNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.TimeScaleNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ToolboxNodeSuite;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.WarningMessageNode;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class CCKSimulationPanel
extends PhetPCanvas {
    private CCKModel model;
    private CCKModule module;
    private CircuitNode circuitNode;
    private MessageNode messageNode;
    private MeasurementToolSetNode measurementToolSetNode;
    private CCKHelpSuite cckHelpSuite;
    private BranchNodeFactory branchNodeFactory;
    private ToolboxNodeSuite toolboxSuite;
    private ChartSetNode chartSetNode;
    private TimeScaleNode timeScaleNode;
    private PSwing grabBagPSwing;
    private RightClickHelpNode rightClickHelpNode;
    private final CCKBackground backgroundNode;
    public WarningMessageNode warningMessageNode;

    public CCKSimulationPanel(CCKModel cCKModel, final CCKModule cCKModule, IClock iClock) {
        super(new Dimension(10, 10));
        this.model = cCKModel;
        this.module = cCKModule;
        this.backgroundNode = new CCKBackground(cCKModel, this);
        this.addScreenChild(this.backgroundNode);
        this.setBackground(CCKModule.BACKGROUND_COLOR);
        this.branchNodeFactory = new BranchNodeFactory(cCKModel, this, cCKModule, cCKModule.getCCKViewState().getLifelikeProperty());
        this.toolboxSuite = new ToolboxNodeSuite(cCKModel, cCKModule, this, this.branchNodeFactory, cCKModule.getCCKViewState().getLifelikeProperty());
        this.addScreenChild(this.toolboxSuite);
        this.circuitNode = new CircuitNode(cCKModel, cCKModel.getCircuit(), this, cCKModule, this.branchNodeFactory, cCKModule.getCCKViewState().getReadoutsVisibleProperty(), cCKModule.getCCKViewState().getLifelikeProperty());
        this.addWorldChild(this.circuitNode);
        this.measurementToolSetNode = new MeasurementToolSetNode(cCKModel, this, cCKModule, cCKModule.getVoltmeterModel(), iClock);
        this.addWorldChild(this.measurementToolSetNode);
        this.messageNode = new MessageNode();
        this.addScreenChild(this.messageNode);
        this.chartSetNode = new ChartSetNode(this, cCKModel.getCircuit(), iClock);
        this.addScreenChild(this.chartSetNode);
        this.cckHelpSuite = new CCKHelpSuite(this, cCKModule);
        this.addScreenChild(this.cckHelpSuite);
        this.rightClickHelpNode = new RightClickHelpNode(this, cCKModule);
        this.addScreenChild(this.rightClickHelpNode);
        this.addKeyListener(new SimpleKeyEvent(32){

            public void invoke() {
                super.invoke();
                CCKSimulationPanel.this.addTestElement();
            }
        });
        this.setWorldScale(30.0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                CCKSimulationPanel.this.relayout();
            }
        });
        this.requestFocus();
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 65 && keyEvent.isControlDown()) {
                    cCKModule.selectAll();
                }
                if (keyEvent.getKeyCode() == 8 || keyEvent.getKeyCode() == 127) {
                    cCKModule.desolderSelection();
                    cCKModule.deleteSelectedBranches();
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.timeScaleNode = new TimeScaleNode(this, cCKModel);
        this.addScreenChild(this.timeScaleNode);
        this.timeScaleNode.addPropertyChangeListener("visible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CCKSimulationPanel.this.relayout();
            }
        });
        this.warningMessageNode = new WarningMessageNode(cCKModel.getCircuit());
        this.relayout();
    }

    private void relayout() {
        if (this.getWidth() > 0) {
            if (this.grabBagPSwing != null) {
                this.updateButtonLayout();
            }
            this.updateToolboxLayout();
            this.updateTimeScaleNodeLayout();
            this.warningMessageNode.setOffset(this.getTimeScaleNodeX(), this.getTimeScaleNodeY() - this.warningMessageNode.getFullBounds().getHeight() - 5.0);
        }
    }

    private double getToolboxTopY() {
        return this.grabBagPSwing == null ? 0.0 : this.grabBagPSwing.getFullBounds().getMaxY();
    }

    private void updateToolboxLayout() {
        this.toolboxSuite.setTransform(new AffineTransform());
        PBounds pBounds = this.toolboxSuite.getGlobalFullBounds();
        this.getPhetRootNode().globalToScreen(pBounds);
        int n = 5;
        double d = this.getHeight() > 600 ? 50.0 : 10.0;
        double d2 = (double)(this.getHeight() - n) - d - this.getToolboxTopY();
        double d3 = d2 / ((RectangularShape)pBounds).getHeight();
        this.toolboxSuite.scale(d3);
        double d4 = 8.0;
        this.toolboxSuite.setOffset((double)this.getWidth() - this.toolboxSuite.getFullBounds().getWidth() - d4, this.getToolboxTopY() + d);
    }

    private void updateTimeScaleNodeLayout() {
        this.timeScaleNode.setOffset(this.getTimeScaleNodeX(), this.getTimeScaleNodeY());
    }

    private int getTimeScaleNodeX() {
        return 10;
    }

    private double getTimeScaleNodeY() {
        this.timeScaleNode.setScale(1.0);
        double d = this.timeScaleNode.getFullBounds().getWidth() / (double)this.getWidth();
        if (d > 0.8) {
            this.timeScaleNode.setScale(0.8 / d);
        } else {
            this.timeScaleNode.setScale(1.0);
        }
        double d2 = (double)(this.getHeight() - 10) - this.timeScaleNode.getFullBounds().getHeight();
        return d2;
    }

    private void addTestElement() {
        this.model.getCircuit().addBranch(new Wire(this.model.getCircuitChangeListener(), new Junction(5.0, 5.0), new Junction(8.0, 5.0)));
    }

    public void setToolboxBackgroundColor(Color color) {
        this.toolboxSuite.setBackground(color);
    }

    public Color getToolboxBackgroundColor() {
        return this.toolboxSuite.getBackgroundColor();
    }

    public CircuitNode getCircuitNode() {
        return this.circuitNode;
    }

    public void setVirtualAmmeterVisible(boolean bl) {
        this.measurementToolSetNode.setVirtualAmmeterVisible(bl);
    }

    public void setStopwatchVisible(boolean bl) {
        this.measurementToolSetNode.setStopwatchVisible(bl);
    }

    public void setSeriesAmmeterVisible(boolean bl) {
        this.toolboxSuite.setSeriesAmmeterVisible(bl);
    }

    public void addGrabBag() {
        GrabBagButton grabBagButton = new GrabBagButton(this.module);
        this.grabBagPSwing = new PSwing(grabBagButton);
        this.addScreenChild(this.grabBagPSwing);
    }

    public void updateButtonLayout() {
        int n = 4;
        this.grabBagPSwing.setOffset((double)this.getWidth() - this.grabBagPSwing.getFullBounds().getWidth() - (double)n, n);
    }

    public ToolboxNodeSuite getToolboxNodeSuite() {
        return this.toolboxSuite;
    }

    public void applicationStarted() {
        this.cckHelpSuite.applicationStarted();
    }

    public void setHelpEnabled(boolean bl) {
        this.cckHelpSuite.setHelpEnabled(bl);
    }

    public PNode getWireMaker() {
        return this.toolboxSuite.getWireMaker();
    }

    public void setZoom(double d) {
        AffineTransform affineTransform = this.circuitNode.getTransformForZoom(d, this);
        int n = 2000;
        this.circuitNode.animateToTransform(affineTransform, n);
        this.measurementToolSetNode.animateToTransform(affineTransform, n);
    }

    public void addCurrentChart() {
        this.chartSetNode.addCurrentChart();
    }

    public void addVoltageChart() {
        this.chartSetNode.addVoltageChart();
    }

    public boolean getElectronsVisible() {
        return this.circuitNode.isElectronsVisible();
    }

    public Color getCCKBackground() {
        return this.backgroundNode.getColor();
    }

    public void setCCKBackground(Color color) {
        this.backgroundNode.setColor(color);
    }
}

