/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model;

import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;

public abstract class Connection {
    public abstract Junction getJunction();

    public abstract double getVoltageAddon();

    public static class BranchConnection
    extends Connection {
        Branch branch;
        double dist;

        public BranchConnection(Branch branch, double d) {
            this.branch = branch;
            this.dist = d;
        }

        public Junction getJunction() {
            return this.branch.getStartJunction();
        }

        public double getVoltageAddon() {
            double d = this.branch.getResistance();
            double d2 = this.branch.getLength();
            double d3 = d / d2;
            double d4 = this.dist * d3;
            double d5 = this.branch.getCurrent();
            double d6 = d5 * d4;
            return d6;
        }
    }

    public static class JunctionConnection
    extends Connection {
        Junction junction;

        public JunctionConnection(Junction junction) {
            this.junction = junction;
        }

        public boolean equals(Object object) {
            if (object instanceof JunctionConnection) {
                JunctionConnection junctionConnection = (JunctionConnection)object;
                if (junctionConnection.junction == this.junction) {
                    return true;
                }
            }
            return false;
        }

        public Junction getJunction() {
            return this.junction;
        }

        public double getVoltageAddon() {
            return 0.0;
        }
    }
}

