/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model;

import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.SimpleObservableDebug;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import java.util.ArrayList;

public class BranchSet {
    private ArrayList<Branch> branches = new ArrayList();
    private ArrayList<Junction> junctions = new ArrayList();
    private Circuit circuit;

    public BranchSet(Circuit circuit, Branch[] branchArray) {
        this.circuit = circuit;
        this.addBranches(branchArray);
    }

    public void addJunction(Junction junction) {
        if (!this.junctions.contains(junction)) {
            this.junctions.add(junction);
        }
    }

    public void addBranches(Branch[] branchArray) {
        for (int i = 0; i < branchArray.length; ++i) {
            if (this.branches.contains(branchArray[i])) continue;
            this.branches.add(branchArray[i]);
        }
    }

    public void translate(ImmutableVector2D immutableVector2D) {
        SimpleObservableDebug simpleObservableDebug;
        int n;
        ArrayList<Junction> arrayList = new ArrayList<Junction>();
        arrayList.addAll(this.junctions);
        for (int i = 0; i < this.branches.size(); ++i) {
            Branch branch = this.branches.get(i);
            if (!arrayList.contains(branch.getStartJunction())) {
                arrayList.add(branch.getStartJunction());
            }
            if (arrayList.contains(branch.getEndJunction())) continue;
            arrayList.add(branch.getEndJunction());
        }
        ArrayList<Branch> arrayList2 = new ArrayList<Branch>();
        arrayList2.addAll(this.branches);
        for (n = 0; n < arrayList.size(); ++n) {
            simpleObservableDebug = (Junction)arrayList.get(n);
            ((Junction)simpleObservableDebug).translateNoNotify(immutableVector2D.getX(), immutableVector2D.getY());
            Branch[] branchArray = this.circuit.getAdjacentBranches((Junction)simpleObservableDebug);
            for (int i = 0; i < branchArray.length; ++i) {
                Branch branch = branchArray[i];
                if (arrayList2.contains(branch)) continue;
                arrayList2.add(branch);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            simpleObservableDebug = (Junction)arrayList.get(n);
            ((Junction)simpleObservableDebug).notifyChanged();
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            simpleObservableDebug = (Branch)arrayList2.get(n);
            ((Branch)simpleObservableDebug).notifyObservers();
        }
        Branch[] branchArray = arrayList2.toArray(new Branch[0]);
        this.circuit.fireJunctionsMoved();
        this.circuit.fireBranchesMoved(branchArray);
    }

    public Branch[] getBranches() {
        return this.branches.toArray(new Branch[0]);
    }
}

