/**
 * Programa de sombreado para figuras sencillas en 2D.
 * @author Melissa Méndez Servín.
 */
export default class Slimple2D {
    constructor(gl, WebGL, attributes){
        var vsh = `#version 300 es
            uniform mat3 u_matrix;
        
            in vec2 a_position;
        
            void main(){
                
                vec3 position =  u_matrix * vec3(a_position,1);
                gl_Position = vec4(position.xy, 0, 1);
            }
            `;
        var fsh = `#version 300 es
            precision highp float;
            
            uniform vec4 color;
            
            out vec4 glColor;
            
            void main(){
                glColor = normalize(color);
            }
            `; 
        if (WebGL.programs["Simple2D"])
            this.program = WebGL.programs["Simple2D"];
        else
            this.program = WebGL.createProgram(gl, vsh, fsh, "Simple2D");
        this.vao = WebGL.setVAOAndAttributes(gl, this.program, attributes);  
        this.setUniforms = WebGL.setUniforms(gl, this.program);
    }
}
