import Particle from "./Particle.js";

export default class Emitter {
  constructor(x=0, y=0, num_particles=100, life_span=100) {
    this.x = x;
    this.y = y;
    this.num_particles = num_particles;
    this.life_span = life_span;
    this.particles = [];
    for (let i=0; i<this.num_particles; i++) {
      this.particles.push( new Particle(x, y) );
    }
  }

  update() {
    this.particles.forEach((p) => {
      p.update();
    });
  }

  draw(ctx) {
    var oneLife = false;
    this.particles.forEach((p) => {
      if (p.life < this.life_span) {
        oneLife = true;
        p.draw(ctx);
      }
    });
    if(!oneLife)
      this.reset();
  }
  //
  reset(){
    this.particles = [];
    for (let i=0; i<this.num_particles; i++) {
      this.particles.push( new Particle(this.x, this.y) );
    }
  }
}
