/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descedit;

import com.mja.file.mjaFont;
import com.mja.gui.editDialog;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

public class editTextDialog
extends editDialog
implements ItemListener {
    private static final String[] fNames = new String[]{"SansSerif", "Serif", "Monospaced"};
    private CheckboxGroup cbgName;
    private Checkbox[] cbName;
    private Checkbox cbItalic;
    private Checkbox cbBold;
    private Choice chSize;
    private Font font;
    private TextArea TA = new TextArea(8, 48);
    private Panel NP;

    public editTextDialog(Frame frame, String string, boolean bl, String string2, String string3) {
        super(frame, string, bl, string2, string3);
        this.add("Center", this.TA);
        this.font = mjaFont.AWTMono;
        this.TA.setFont(this.font);
        this.NP = new Panel();
        this.NP.setLayout(new GridLayout(1, 3));
        this.add("North", this.NP);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(fNames.length, 1));
        this.cbgName = new CheckboxGroup();
        this.cbName = new Checkbox[fNames.length];
        for (int i = 0; i < this.cbName.length; ++i) {
            this.cbName[i] = new Checkbox(fNames[i], this.cbgName, false);
            panel.add(this.cbName[i]);
        }
        this.NP.add(panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(2, 1));
        this.cbItalic = new Checkbox("K");
        panel2.add(this.cbItalic);
        this.cbBold = new Checkbox("N");
        panel2.add(this.cbBold);
        this.NP.add(panel2);
        this.chSize = new Choice();
        this.NP.add(this.chSize);
        this.makeChSz();
        for (int i = 0; i < this.cbName.length; ++i) {
            this.cbName[i].addItemListener(this);
            this.cbName[i].setFont(mjaFont.AWTMono);
        }
        this.cbItalic.addItemListener(this);
        this.cbItalic.setFont(mjaFont.AWTMono.deriveFont(2, 24.0f));
        this.cbBold.addItemListener(this);
        this.cbBold.setFont(mjaFont.AWTMono.deriveFont(1, 24.0f));
        this.updateAll();
    }

    private void makeChSz() {
        int n;
        this.NP.remove(this.chSize);
        this.chSize = new Choice();
        this.NP.add(this.chSize);
        this.chSize.addItemListener(this);
        this.chSize.setFont(mjaFont.AWTMono);
        for (n = 6; n < 24; ++n) {
            this.chSize.addItem(String.valueOf(n));
        }
        for (n = 24; n < 48; n += 2) {
            this.chSize.addItem(String.valueOf(n));
        }
        for (n = 48; n <= 80; n += 4) {
            this.chSize.addItem(String.valueOf(n));
        }
        this.NP.invalidate();
        this.NP.repaint();
    }

    public Font getSelectedFont() {
        return this.font;
    }

    public void setSelectedFont(Font font) {
        this.font = font;
        this.updateAll();
    }

    public void setText(String string) {
        this.TA.setText(string);
    }

    public String getText() {
        return this.TA.getText();
    }

    private void updateAll() {
        this.cbgName.setSelectedCheckbox(this.cbName[0]);
        for (int i = 0; i < this.cbName.length; ++i) {
            if (!this.cbName[i].getLabel().equals(this.font.getName())) continue;
            this.cbgName.setSelectedCheckbox(this.cbName[i]);
            break;
        }
        this.cbItalic.setState(this.font.isItalic());
        this.cbBold.setState(this.font.isBold());
        this.chSize.select(String.valueOf(this.font.getSize()));
        this.TA.setFont(this.font);
    }

    private String selectedName() {
        Checkbox checkbox = this.cbgName.getSelectedCheckbox();
        for (int i = 0; i < this.cbName.length; ++i) {
            if (this.cbName[i] != checkbox) continue;
            return this.cbName[i].getLabel();
        }
        return this.cbName[0].getLabel();
    }

    private int selectedStyle() {
        int n = 0;
        if (this.cbItalic.getState()) {
            n += 2;
        }
        if (this.cbBold.getState()) {
            ++n;
        }
        return n;
    }

    private int selectedSize() {
        return Integer.parseInt(this.chSize.getSelectedItem());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.selectedSize();
        this.font = new Font(this.selectedName(), this.selectedStyle(), n);
        this.TA.setFont(this.font);
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.setSelectedFont(this.getSelectedFont());
        super.windowActivated(windowEvent);
    }
}

