/*
 * Decompiled with CFR 0.152.
 */
package com.mja.poly;

import com.mja.math.R2;
import com.mja.math3D.R3;
import com.mja.parser.Node;
import com.mja.poly.viewModel;
import com.mja.poly.viewR3;
import com.mja.text.MathText;
import com.mja.util.BasicStr;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.util.Enumeration;
import java.util.Vector;

public class Face {
    static final R3 Ux = new R3(1.0, 0.0, 0.0);
    static final double epsilon = 1.0E-8;
    R3[] P;
    boolean drawn;
    boolean pointsOut;
    R3 unitToEye = new R3(0.0, 0.0, 0.0);
    R3 unitNormal = new R3(0.0, 0.0, 0.0);
    private Color FC = Color.white;
    private Color BC = Color.pink;
    private Color EC = Color.gray;
    private boolean drawEdges = false;
    private viewModel vM = new viewModel();
    private viewR3 view;
    private int widthness = 1;
    private Polygon poly;
    private R2[] pr;
    private int minx;
    private int miny;
    private int maxx;
    private int maxy;
    private double normalToEye;
    private double minDistanceToEye;
    private double maxDistanceToEye;
    double aveDistanceToEye;
    R3 average;
    private MathText mt;
    private double svalue = 0.0;
    private Node sNode = null;

    public Face cloneFace() {
        R3[] r3Array = new R3[this.P.length];
        for (int i = 0; i < this.P.length; ++i) {
            r3Array[i] = this.P[i].cloneR3();
        }
        Face face = new Face(r3Array);
        face.init();
        face.FC = this.FC;
        face.BC = this.BC;
        face.EC = this.EC;
        face.drawEdges = this.drawEdges;
        face.vM = this.vM;
        face.mt = this.mt;
        return face;
    }

    public Face(R3[] r3Array) {
        boolean bl = true;
        for (int i = 0; i < r3Array.length; ++i) {
            if (r3Array[i] != null) continue;
            bl = false;
            break;
        }
        this.P = bl ? r3Array : new R3[0];
        this.init();
    }

    public Face(R3 r3) {
        if (r3 != null) {
            this.P = new R3[1];
            this.P[0] = r3;
        } else {
            this.P = new R3[0];
        }
        this.init();
    }

    public Face(R3 r3, R3 r32) {
        if (r3 != null && r32 != null) {
            this.P = new R3[2];
            this.P[0] = r3;
            this.P[1] = r32;
        } else {
            this.P = new R3[0];
        }
        this.init();
    }

    public Face(R3 r3, R3 r32, R3 r33) {
        if (r3 != null && r32 != null && r33 != null) {
            this.P = new R3[3];
            this.P[0] = r3;
            this.P[1] = r32;
            this.P[2] = r33;
        } else {
            this.P = new R3[0];
        }
        this.init();
    }

    public Face(R3 r3, R3 r32, R3 r33, R3 r34) {
        if (r3 != null && r32 != null && r33 != null && r34 != null) {
            this.P = new R3[4];
            this.P[0] = r3;
            this.P[1] = r32;
            this.P[2] = r33;
            this.P[3] = r34;
        } else if (r32 != null && r33 != null && r34 != null) {
            this.P = new R3[3];
            this.P[0] = r32;
            this.P[1] = r33;
            this.P[2] = r34;
        } else if (r3 != null && r33 != null && r34 != null) {
            this.P = new R3[3];
            this.P[0] = r3;
            this.P[1] = r33;
            this.P[2] = r34;
        } else if (r3 != null && r32 != null && r34 != null) {
            this.P = new R3[3];
            this.P[0] = r3;
            this.P[1] = r32;
            this.P[2] = r34;
        } else if (r3 != null && r32 != null && r33 != null) {
            this.P = new R3[3];
            this.P[0] = r3;
            this.P[1] = r32;
            this.P[2] = r33;
        } else {
            this.P = new R3[0];
        }
        this.init();
    }

    public Face(R3 r3, R3 r32, R3 r33, R3 r34, R3 r35) {
        if (r3 != null && r32 != null && r33 != null && r34 != null && r35 != null) {
            this.P = new R3[5];
            this.P[0] = r3;
            this.P[1] = r32;
            this.P[2] = r33;
            this.P[3] = r34;
            this.P[4] = r35;
        } else {
            this.P = new R3[0];
        }
        this.init();
    }

    public Face(R2[] r2Array) {
        int n;
        boolean bl = true;
        for (n = 0; n < r2Array.length; ++n) {
            if (r2Array[n] != null) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.P = new R3[r2Array.length];
            for (n = 0; n < this.P.length; ++n) {
                this.P[n] = new R3(r2Array[n].x, r2Array[n].y, 0.0);
            }
        } else {
            this.P = new R3[0];
        }
        this.init();
    }

    public void setWidthness(int n) {
        this.widthness = n;
    }

    public void setViewModel(viewModel viewModel2) {
        this.vM = viewModel2;
    }

    viewModel getViewModel() {
        return this.vM;
    }

    public void setFrontColor(Color color) {
        this.FC = color;
    }

    public void setEdgeColor(Color color) {
        this.EC = color;
    }

    public void setBackColor(Color color) {
        this.BC = color;
    }

    public Color getEdgeColor() {
        return this.EC;
    }

    public Color getFrontColor() {
        return this.FC;
    }

    public Color getBackColor() {
        return this.BC;
    }

    public void setDrawEdges(boolean bl) {
        this.drawEdges = bl;
    }

    public boolean getDrawEdges() {
        return this.drawEdges;
    }

    public double getArea() {
        double d = 0.0;
        for (int i = 1; i < this.P.length - 1; ++i) {
            d += this.P[0].Subtract(this.P[i]).CrossProduct(this.P[0].Subtract(this.P[i + 1])).Norm() / 2.0;
        }
        return d;
    }

    private void init() {
        int n;
        Vector<R3> vector = new Vector<R3>();
        for (int i = 0; i < this.P.length; ++i) {
            if (vector.contains(this.P[i])) continue;
            n = 1;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                R3 r3 = (R3)enumeration.nextElement();
                if (!(r3.Subtract(this.P[i]).Norm() < 1.0E-8)) continue;
                n = 0;
                break;
            }
            if (n == 0) continue;
            vector.addElement(this.P[i]);
        }
        this.P = new R3[vector.size()];
        Enumeration enumeration = vector.elements();
        for (n = 0; n < this.P.length; ++n) {
            this.P[n] = (R3)enumeration.nextElement();
        }
        this.calculateUnitNormal();
    }

    void calculateUnitNormal() {
        if (this.P.length == 0) {
            this.unitNormal = null;
        } else if (this.P.length == 1) {
            this.unitNormal = Ux;
        } else if (this.P.length == 2) {
            R3 r3 = this.P[1].Subtract(this.P[0]);
            R3 r32 = Ux.CrossProduct(r3);
            this.unitNormal = r3.CrossProduct(r32);
        } else {
            this.unitNormal = new R3(0.0, 0.0, 0.0);
            for (int i = 0; i < this.P.length - 2; ++i) {
                R3 r3 = this.P[i + 1].Subtract(this.P[0]);
                R3 r33 = this.P[i + 2].Subtract(this.P[0]);
                this.unitNormal = this.unitNormal.Add(r3.CrossProduct(r33));
            }
        }
        if (this.unitNormal != null) {
            double d = this.unitNormal.Norm();
            this.unitNormal = d != 0.0 ? this.unitNormal.ScalarProduct(1.0 / d) : Ux;
        }
    }

    void updateView(viewR3 viewR32) {
        if (this.P.length > 0) {
            int n;
            this.view = viewR32;
            this.minx = Integer.MAX_VALUE;
            this.miny = Integer.MAX_VALUE;
            this.maxx = -2147483647;
            this.maxy = -2147483647;
            this.pr = new R2[this.P.length + 1];
            this.poly = new Polygon();
            for (n = 0; n < this.P.length; ++n) {
                this.pr[n] = this.view.pr(this.P[n]);
                this.poly.addPoint((int)Math.round(this.pr[n].x), (int)Math.round(this.pr[n].y));
                if (this.minx > this.poly.xpoints[n]) {
                    this.minx = this.poly.xpoints[n];
                }
                if (this.maxx < this.poly.xpoints[n]) {
                    this.maxx = this.poly.xpoints[n];
                }
                if (this.miny > this.poly.ypoints[n]) {
                    this.miny = this.poly.ypoints[n];
                }
                if (this.maxy >= this.poly.ypoints[n]) continue;
                this.maxy = this.poly.ypoints[n];
            }
            this.pr[this.P.length] = this.pr[0];
            this.poly.addPoint(this.poly.xpoints[0], this.poly.ypoints[0]);
            if (this.P.length > 1) {
                this.minDistanceToEye = Double.MAX_VALUE;
                this.maxDistanceToEye = -1.7976931348623157E308;
                for (n = 0; n < this.P.length; ++n) {
                    double d = this.P[n].Subtract(this.view.Eye).Norm();
                    this.minDistanceToEye = Math.min(this.minDistanceToEye, d);
                    this.maxDistanceToEye = Math.max(this.maxDistanceToEye, d);
                }
                this.average = new R3(this.P[0].x, this.P[0].y, this.P[0].z);
                for (n = 1; n < this.P.length; ++n) {
                    this.average.x += this.P[n].x;
                    this.average.y += this.P[n].y;
                    this.average.z += this.P[n].z;
                }
                this.average.x /= (double)this.P.length;
                this.average.y /= (double)this.P.length;
                this.average.z /= (double)this.P.length;
                R3 r3 = this.view.Eye.Subtract(this.average);
                this.aveDistanceToEye = r3.Norm();
                this.unitToEye = r3.ScalarProduct(1.0 / this.aveDistanceToEye);
                this.pointsOut = this.unitToEye.DotProduct(this.unitNormal) > 0.0;
                this.normalToEye = this.average.Subtract(this.view.Eye).DotProduct(this.unitNormal);
            } else {
                double d;
                this.minDistanceToEye = d = this.P[0].Subtract(this.view.Eye).Norm();
                this.maxDistanceToEye = d;
                this.average = this.P[0];
                R3 r3 = this.view.Eye.Subtract(this.average);
                this.aveDistanceToEye = d;
                this.unitToEye = r3.ScalarProduct(1.0 / this.aveDistanceToEye);
                this.pointsOut = true;
                this.normalToEye = this.average.Subtract(this.view.Eye).DotProduct(this.unitNormal);
            }
        }
    }

    public void setSValue(double d) {
        this.svalue = d;
    }

    public void setSNode(Node node) {
        this.sNode = node;
    }

    void setMathText(MathText mathText) {
        this.mt = mathText;
    }

    public void draw(Container container, Graphics2D graphics2D) {
        BasicStroke basicStroke = new BasicStroke(this.widthness, 1, 1);
        graphics2D.setStroke(basicStroke);
        if (this.P.length != 0) {
            if (this.P.length == 1) {
                if (this.widthness > 0) {
                    basicStroke = new BasicStroke(1.0f, 1, 1);
                    graphics2D.setStroke(basicStroke);
                    graphics2D.setColor(this.BC);
                    int n = 1 + this.widthness + this.widthness;
                    graphics2D.fillOval(this.poly.xpoints[0] - this.widthness, this.poly.ypoints[0] - this.widthness, n, n);
                    graphics2D.setColor(this.FC);
                    graphics2D.drawOval(this.poly.xpoints[0] - this.widthness, this.poly.ypoints[0] - this.widthness, n, n);
                }
            } else if (this.P.length == 2) {
                graphics2D.setColor(this.FC);
                graphics2D.drawLine(this.poly.xpoints[0], this.poly.ypoints[0], this.poly.xpoints[1], this.poly.ypoints[1]);
            } else if (this.vM.getModel() == 3) {
                if (this.widthness > 0) {
                    graphics2D.setColor(this.FC);
                    graphics2D.drawPolygon(this.poly);
                }
            } else {
                graphics2D.setColor(this.vM.getFaceColor(this));
                if (BasicStr.antialias) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                graphics2D.fillPolygon(this.poly);
                if (BasicStr.antialias) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                if (this.drawEdges) {
                    graphics2D.setColor(this.EC);
                    graphics2D.drawPolygon(this.poly);
                }
            }
        }
        this.drawText(container, graphics2D);
        basicStroke = new BasicStroke(1.0f);
        graphics2D.setStroke(basicStroke);
    }

    void drawText(Container container, Graphics2D graphics2D) {
        if (this.mt != null) {
            Graphics[] graphicsArray = new Graphics2D[]{graphics2D};
            R2 r2 = new R2(this.poly.xpoints[0], this.poly.ypoints[0]);
            double d = this.sNode.getDouble();
            this.sNode.setDouble(this.svalue);
            this.mt.draw((Component)container, r2.ix(), r2.iy(), graphicsArray);
            this.sNode.setDouble(d);
        }
    }

    Face[] split(Face face) {
        Object object;
        if (this.P.length >= 3 && face.P.length >= 2 && this.intersects(face)) {
            Object object2;
            int n;
            object = null;
            Object object3 = null;
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < face.P.length; ++n) {
                object2 = this.intersection(face.P[n], face.P[(n + 1) % face.P.length]);
                if (object2 == null) continue;
                if (object == null) {
                    object = object2;
                    n2 = n;
                    if (face.P.length != 2) continue;
                    object3 = object;
                    break;
                }
                if (((R3)object2).equals((R3)object, 1.0E-8)) continue;
                object3 = object2;
                n3 = n;
                break;
            }
            if (object != null && object3 != null) {
                Object object4;
                int n4;
                n = this.isInterior((R3)object) || this.isInterior((R3)object3) ? 1 : 0;
                object2 = null;
                Object object5 = null;
                if (n == 0 && face.P.length >= 3) {
                    for (n4 = 0; n4 < this.P.length; ++n4) {
                        object4 = face.intersection(this.P[n4], this.P[(n4 + 1) % this.P.length]);
                        if (object4 == null) continue;
                        if (object2 == null) {
                            object2 = object4;
                            continue;
                        }
                        if (((R3)object4).equals((R3)object2, 1.0E-8)) continue;
                        object5 = object4;
                        break;
                    }
                }
                if (n != 0 || object2 != null && object5 != null && face.isInterior((R3)object2) && face.isInterior((R3)object5)) {
                    int n5;
                    n4 = 1;
                    object4 = face.P;
                    R3[] r3Array = null;
                    R3[] r3Array2 = null;
                    if (((R3[])object4).length == 2) {
                        if (((R3)object).equals(object4[0], 1.0E-8) || ((R3)object).equals(object4[1], 1.0E-8)) {
                            n4 = 0;
                        } else {
                            r3Array = new R3[]{object4[0], object};
                            r3Array2 = new R3[]{object, object4[1]};
                        }
                    } else {
                        r3Array = new R3[2 + n2 + ((R3[])object4).length - n3];
                        r3Array2 = new R3[n3 - n2 + 2];
                        int n6 = 0;
                        n5 = 0;
                        boolean bl = false;
                        for (int i = 0; i < ((Object)object4).length; ++i) {
                            if (i < n2) {
                                r3Array[n6++] = object4[i];
                                continue;
                            }
                            if (i == n2) {
                                r3Array[n6++] = object4[i];
                                r3Array[n6++] = object;
                                r3Array2[n5++] = object;
                                continue;
                            }
                            if (i < n3) {
                                r3Array2[n5++] = object4[i];
                                continue;
                            }
                            if (i == n3) {
                                r3Array2[n5++] = object4[i];
                                r3Array2[n5++] = object3;
                                r3Array[n6++] = object3;
                                continue;
                            }
                            r3Array[n6++] = object4[i];
                        }
                    }
                    if (n4 != 0) {
                        Face[] faceArray = new Face[]{new Face(r3Array), new Face(r3Array2)};
                        for (n5 = 0; n5 < faceArray.length; ++n5) {
                            faceArray[n5].vM = face.vM;
                            faceArray[n5].FC = face.FC;
                            faceArray[n5].BC = face.BC;
                            faceArray[n5].EC = face.EC;
                            faceArray[n5].drawEdges = face.drawEdges;
                        }
                        return faceArray;
                    }
                }
            }
        }
        object = new Face[]{face};
        return object;
    }

    private boolean intersects(Face face) {
        return this.intersectsPlane(face) && face.intersectsPlane(this);
    }

    private boolean intersectsPlane(Face face) {
        if (this.P.length > 0) {
            double d;
            double d2 = face.P[0].DotProduct(face.unitNormal);
            if (Math.abs(d2 - (d = this.P[0].DotProduct(face.unitNormal))) < 1.0E-8) {
                return true;
            }
            for (int i = 1; i < this.P.length; ++i) {
                double d3 = this.P[i].DotProduct(face.unitNormal);
                if (!(Math.abs(d2 - d3) < 1.0E-8 || d3 > d2 && d < d2) && (!(d3 < d2) || !(d > d2))) continue;
                return true;
            }
        }
        return false;
    }

    private R3 intersection(R3 r3, R3 r32) {
        double d;
        R3 r33;
        double d2;
        if (this.P.length > 0 && (d2 = (r33 = r32.Subtract(r3)).DotProduct(this.unitNormal)) != 0.0 && -1.0E-8 < (d = this.P[0].Subtract(r3).DotProduct(this.unitNormal) / d2) && d < 1.00000001) {
            return r3.Add(r33.ScalarProduct(d));
        }
        return null;
    }

    private boolean isInterior(R3 r3) {
        if (this.P.length > 0) {
            double d = 0.0;
            R3 r32 = this.P[0].Subtract(r3);
            for (int i = 0; i < this.P.length; ++i) {
                R3 r33 = this.P[(i + 1) % this.P.length].Subtract(r3);
                double d2 = r32.CrossProduct(r33).DotProduct(this.unitNormal);
                if (Math.abs(d2) < 1.0E-8) {
                    if (!(r32.DotProduct(r33) < 0.0)) continue;
                    return true;
                }
                if (d < 0.0 && d2 > 0.0 || d > 0.0 && d2 < 0.0) {
                    return false;
                }
                r32 = r33;
                d = d2;
            }
        }
        return true;
    }

    boolean inFrontOf(Face face, double d) {
        if (this.maxx <= face.minx || this.minx >= face.maxx || this.maxy <= face.miny || this.miny >= face.maxy) {
            return false;
        }
        if (this.minDistanceToEye >= face.maxDistanceToEye) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            Vector vector = null;
            switch (i) {
                case 0: {
                    vector = this.verticesContainedIn(face);
                    break;
                }
                case 1: {
                    vector = face.verticesContainedIn(this);
                    break;
                }
                case 2: {
                    vector = this.intersections(face);
                }
            }
            if (vector == null || vector.isEmpty()) continue;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                R2 r2 = (R2)enumeration.nextElement();
                R3 r3 = this.view.rayFromEye(r2.x, r2.y);
                try {
                    double d2 = this.distanceToEyeAlong(r3) - face.distanceToEyeAlong(r3);
                    if (d2 <= -d) {
                        return true;
                    }
                    if (!(d2 >= d)) continue;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return false;
    }

    private double distanceToEyeAlong(R3 r3) throws Exception {
        double d = this.unitNormal.DotProduct(r3);
        if (Math.abs(d) > 1.0E-6) {
            return this.normalToEye / d;
        }
        throw new Exception("Face is invisible");
    }

    private Vector verticesContainedIn(Face face) {
        Vector<R2> vector = new Vector<R2>();
        for (int i = 0; i < this.P.length; ++i) {
            if (face.isVertex(this.P[i]) || !face.appearsToContain(this.pr[i])) continue;
            vector.addElement(this.pr[i]);
        }
        return vector;
    }

    private boolean appearsToContain(R2 r2) {
        double d = 0.0;
        for (int i = 0; i < this.P.length; ++i) {
            double d2 = (this.pr[i].x - r2.x) * (this.pr[i + 1].y - r2.y) - (this.pr[i + 1].x - r2.x) * (this.pr[i].y - r2.y);
            if (d != 0.0) {
                if (Math.abs(d2) < 1.0E-8) {
                    if (Math.abs(this.pr[i].x - this.pr[i + 1].x) > 1.0E-8) {
                        return Math.min(this.pr[i].x, this.pr[i + 1].x) <= r2.x + 1.0E-8 && r2.x <= Math.max(this.pr[i].x, this.pr[i + 1].x) + 1.0E-8;
                    }
                    if (Math.abs(this.pr[i].y - this.pr[i + 1].y) > 1.0E-8) {
                        return Math.min(this.pr[i].y, this.pr[i + 1].y) <= r2.y + 1.0E-8 && r2.y <= Math.max(this.pr[i].y, this.pr[i + 1].y) + 1.0E-8;
                    }
                } else if (d > 0.0 && d2 < 0.0 || d < 0.0 && d2 > 0.0) {
                    return false;
                }
            }
            d = d2;
        }
        return true;
    }

    private boolean isVertex(R3 r3) {
        for (int i = 0; i < this.P.length; ++i) {
            if (!r3.equals(this.P[i])) continue;
            return true;
        }
        return false;
    }

    private Vector intersections(Face face) {
        Vector<R2> vector = new Vector<R2>();
        for (int i = 0; i < this.P.length; ++i) {
            R3 r3 = this.P[i];
            R3 r32 = this.P[(i + 1) % this.P.length];
            for (int j = 0; j < face.P.length; ++j) {
                R2 r2;
                R3 r33 = face.P[j];
                R3 r34 = face.P[(j + 1) % face.P.length];
                if (r3 == r33 || r3 == r34 || r32 == r33 || r32 == r34 || (r2 = R2.intersection(this.pr[i], this.pr[i + 1], face.pr[j], face.pr[j + 1])) == null) continue;
                vector.addElement(r2);
            }
        }
        return vector;
    }

    Color getColorAt(int n, int n2, boolean bl) {
        if (bl && this.drawEdges && this.isOnEdge(n, n2)) {
            return this.EC;
        }
        return this.vM.getFaceColor(this);
    }

    double intersectionToEye(double d, double d2) {
        try {
            return this.distanceToEyeAlong(this.view.rayFromEye(d, d2));
        }
        catch (Exception exception) {
            return this.minDistanceToEye;
        }
    }

    boolean contains(int n, int n2, int n3) {
        if (n3 <= 1) {
            return this.contains(n, n2);
        }
        if (this.vM.getModel() == 3) {
            return false;
        }
        return this.contains(n, n2) && this.contains(n + n3 - 1, n2) && this.contains(n + n3 - 1, n2 + n3 - 1) && this.contains(n, n2 + n3 - 1);
    }

    private boolean contains(int n, int n2) {
        if (n < this.minx || n > this.maxx || n2 < this.miny || n2 > this.maxy) {
            return false;
        }
        for (int i = 0; i < this.P.length; ++i) {
            if (n != this.poly.xpoints[i] || n2 != this.poly.ypoints[i]) continue;
            return true;
        }
        if (this.P.length == 1) {
            return false;
        }
        if (this.P.length == 2) {
            return Face.pointInSegment(n, n2, this.poly.xpoints[0], this.poly.ypoints[0], this.poly.xpoints[1], this.poly.ypoints[1]);
        }
        if ((this.drawEdges || this.vM.getModel() == 3) && this.isOnEdge(n, n2)) {
            return true;
        }
        if (this.vM.getModel() == 3) {
            return false;
        }
        return this.poly.contains(n, n2);
    }

    boolean touches(int n, int n2, int n3) {
        if (n3 == 1) {
            return this.poly.contains(n, n2);
        }
        return this.poly.intersects(n, n2, n3, n3);
    }

    boolean isOnEdge(int n, int n2) {
        for (int i = 0; i < this.P.length; ++i) {
            if (!Face.pointInSegment(n, n2, this.poly.xpoints[i], this.poly.ypoints[i], this.poly.xpoints[i + 1], this.poly.ypoints[i + 1])) continue;
            return true;
        }
        return false;
    }

    static boolean pointInSegment(int n, int n2, int n3, int n4, int n5, int n6) {
        return Face.rectangleIntersectsSegment(n, n2, 1, 1, n3, n4, n5, n6);
    }

    static boolean rectangleIntersectsSegment(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 2;
        int[] nArray = new int[]{n5, n7};
        int[] nArray2 = new int[]{n6, n8};
        Polygon polygon = new Polygon(nArray, nArray2, n9);
        return polygon.intersects(n, n2, n3, n4);
    }
}

