/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.descgui.NumericControl;
import com.mja.parser.Parser;
import com.mja.text.BasicText;
import com.mja.text.Formula;
import com.mja.text.FormulaItem;
import com.mja.text.TColors;
import com.mja.text.TNode;
import com.mja.text.TextCanvas;
import com.mja.util.LiveOrDie;
import com.mja.util.TFont;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;

public class Text
extends BasicText {
    private int leftMargin = 16;
    private int topMargin = 8;
    private int bottomMargin = 8;
    private boolean mustClean;

    public Text(Parser parser) {
        super(parser);
    }

    public Text(Parser parser, TFont tFont) {
        super(parser, tFont);
    }

    public Text(Parser parser, TFont tFont, Color color, Color color2) {
        super(parser, tFont, color, color2);
    }

    public void setLeftMargin(int n) {
        this.leftMargin = n;
    }

    public void setTopAndBottomMargin(int n) {
        this.topMargin = n;
        this.bottomMargin = n;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public Text cloneText() {
        Text text = new Text(this.getParser());
        text.info = this.cloneInfo();
        return text;
    }

    public boolean updateNodes(Component component, String string) {
        for (int i = this.begin(); i < this.end(); ++i) {
            if (!this.TNode(i).updateComponent(component, string)) continue;
            return true;
        }
        return false;
    }

    public void unmarkSegment() {
        super.unmarkSegment();
        for (int i = this.begin(); i < this.end(); ++i) {
            if (this.TNode(i).getFI() == null) continue;
            FormulaItem formulaItem = this.TNode(i).getFI();
            for (int j = 0; j < formulaItem.size(); ++j) {
                formulaItem.getFormula(j).unmarkSegment();
            }
        }
    }

    public void markSegment(int n, int n2) {
        this.unmarkSegment();
        super.markSegment(n, n2);
    }

    public void insertText(String string) {
        super.insertText(string);
        if (this.mustClean) {
            this.clean();
        }
    }

    public void clearColors() {
        this.clearColors(this.begin(), this.end());
    }

    public void clearColors(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n3 < n4) {
            TNode tNode = this.TNode(n3);
            if (tNode.isColors()) {
                if (this.removeNode(n3)) {
                    --n4;
                }
            } else {
                tNode.clearColors();
            }
            if (tNode != this.TNode(n3)) continue;
            ++n3;
        }
    }

    public void clearFonts() {
        this.clearFonts(this.begin(), this.end());
    }

    public void clearFonts(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n3 < n4) {
            TNode tNode = this.TNode(n3);
            if (tNode.isTFont()) {
                if (this.removeNode(n3)) {
                    --n4;
                }
            } else {
                tNode.clearFonts();
            }
            if (tNode != this.TNode(n3)) continue;
            ++n3;
        }
    }

    public void insertColors(TColors tColors, boolean bl) {
        if (this.segMarked()) {
            this.insert(new TNode((BasicText)this, this.getColorsAtTNode(this.segMax())), this.segMax());
            this.clearColors(this.segMin(), this.segMax() - 1);
            this.insert(new TNode((BasicText)this, tColors), this.segMin());
            this.setColorsInFormulas(this.segMin(), this.segMax());
        } else {
            int n = this.getCursorPos();
            TColors tColors2 = this.getColorsAtTNode(n);
            this.insert(new TNode((BasicText)this, tColors), n);
            this.setCursorPos(n + 1);
            this.setColorsInFormulas(n + 1);
        }
        this.mustClean = bl;
    }

    public void insertTFont(TFont tFont, boolean bl) {
        if (this.segMarked()) {
            this.insert(new TNode((BasicText)this, this.getTFontAtTNode(this.segMax())), this.segMax());
            this.clearFonts(this.segMin() + 1, this.segMax() - 1);
            this.insert(new TNode((BasicText)this, tFont), this.segMin());
            this.setFontsInFormulas(this.segMin(), this.segMax());
        } else {
            int n = this.getCursorPos();
            TFont tFont2 = this.getTFontAtTNode(n);
            this.insert(new TNode((BasicText)this, tFont), n);
            this.setCursorPos(n + 1);
            this.setFontsInFormulas(n + 1);
        }
        this.mustClean = bl;
    }

    private void setFontsInFormulas(int n) {
        TFont tFont = this.getTFontAtTNode(n);
        for (int i = n; i < this.end() && !this.TNode(i).isTFont(); ++i) {
            if (!this.TNode(i).isFormula()) continue;
            Formula formula = this.TNode(i).getFI().getFormula(0);
            formula.setFonts(tFont);
        }
    }

    private void setFontsInFormulas(int n, int n2) {
        TFont tFont = this.getTFontAtTNode(n);
        for (int i = n; i < n2; ++i) {
            if (this.TNode(i).isTFont()) {
                tFont = this.TNode(i).getTFont();
                continue;
            }
            if (!this.TNode(i).isFormula()) continue;
            Formula formula = this.TNode(i).getFI().getFormula(0);
            formula.setFonts(tFont);
        }
    }

    private void setColorsInFormulas(int n) {
        TColors tColors = this.getColorsAtTNode(n);
        for (int i = n; i < this.end() && !this.TNode(i).isColors(); ++i) {
            if (!this.TNode(i).isMath()) continue;
            this.TNode(i).setColors(tColors);
        }
    }

    private void setColorsInFormulas(int n, int n2) {
        TColors tColors = this.getColorsAtTNode(n);
        for (int i = n; i < n2; ++i) {
            if (this.TNode(i).isColors()) {
                tColors = this.TNode(i).getColors();
                continue;
            }
            if (!this.TNode(i).isMath()) continue;
            this.TNode(i).setColors(tColors);
        }
    }

    public void setColors(Color color, Color color2) {
        super.setColors(color, color2);
        this.setColorsInFormulas(this.begin(), this.end());
    }

    public void insertComponent(Component component, String string, String string2) {
        TNode tNode = new TNode((BasicText)this, component, string, string2);
        this.insert(tNode, this.getCursorPos());
    }

    public void insertHyperlink(String string, String string2) {
        this.insert(new TNode((BasicText)this, string + "|" + string2, 15), this.getCursorPos());
    }

    public void insertFormula(String string) {
        this.insert(new TNode((BasicText)this, string, 13), this.getCursorPos());
    }

    public void insertFormula(Formula formula) {
        this.insert(new TNode((BasicText)this, formula), this.getCursorPos());
    }

    public boolean delete() {
        if (super.delete()) {
            this.clean();
            return true;
        }
        return false;
    }

    public boolean backSpace() {
        if (super.backSpace()) {
            this.clean();
            return true;
        }
        return false;
    }

    public void removeMarkedSegment() {
        if (this.segMarked()) {
            TColors tColors = this.getColorsAtTNode(this.segMax());
            TFont tFont = this.getTFontAtTNode(this.segMax());
            this.remove(this.segMin(), this.segMax());
            this.insertColors(tColors, false);
            this.insertTFont(tFont, false);
        }
        this.unmarkSegment();
    }

    public TNode getTNodeAtPixel(Component component, int n, int n2) {
        int n3 = this.getIndexOfLineAtPixel(component, n2);
        int n4 = this.getOffsetOfTNodeAtPixel(component, n3, n, true);
        int n5 = n3 + n4;
        TNode tNode = this.TNode(n5);
        int n6 = this.getY(component, n5) - this.getLineAscentAtTNode(component, n5);
        if (n6 <= n2 && n2 < n6 + this.getLineHeightAtTNode(component, n5)) {
            return tNode;
        }
        return null;
    }

    public int getIndexOfTNodeAtPixel(Component component, int n, int n2) {
        int n3 = this.getIndexOfLineAtPixel(component, n2);
        int n4 = this.getOffsetOfTNodeAtPixel(component, n3, n, false);
        return this.firstChar(n3 + n4);
    }

    public int getIndexOfLineAtPixel(Component component, int n) {
        int n2;
        int n3 = this.firstLine();
        for (int i = this.topMargin + this.getLineHeightAtTNode(component, n3); n3 < this.end() && i < n && (n3 = this.nextLine(n2 = n3)) != n2; i += this.getLineHeightAtTNode(component, n3)) {
        }
        return n3;
    }

    public int getOffsetOfTNodeAtPixel(Component component, int n, int n2, boolean bl) {
        int n3;
        int n4 = n3 = this.startOfLine(n);
        int n5 = this.leftMargin;
        while (n4 < this.end() && !this.TNode(n4).isEndOfLine() && n5 + this.getCharVisualLimitAtTNode(component, n4, false, bl) < n2 + 3) {
            n5 += this.getCharWidthAtTNode(component, n4++, false);
        }
        return n4 - n3;
    }

    public int getX(Component component, int n) {
        int n2 = this.startOfLine(n);
        TFont tFont = this.getTFontAtTNode(n2);
        int n3 = 0;
        for (int i = n2; i < n; ++i) {
            TNode tNode = this.TNode(i);
            if (tNode.isTFont()) {
                tFont = tNode.getTFont();
                continue;
            }
            if (!tNode.isChar()) continue;
            if ("\n".equals(tNode.getChar())) {
                n3 = 0;
                continue;
            }
            int n4 = tNode.getCharWidth(tFont, component, false);
            n3 += n4;
        }
        return this.leftMargin + n3;
    }

    public int getY(Component component, int n) {
        int n2 = this.topMargin + this.getLineHeightAtTNode(component, n);
        int n3 = this.startOfLine(n);
        int n4 = this.previousLine(n3);
        while (n4 < n3) {
            n2 += this.getLineHeightAtTNode(component, n4);
            n3 = n4;
            n4 = this.previousLine(n3);
        }
        int n5 = n2 - this.getLineDescentAtTNode(component, n);
        return n5;
    }

    public int getHeight(Component component) {
        return this.getY(component, this.end()) + this.getLineDescentAtTNode(component, this.end()) + this.bottomMargin + this.getExtraDescent(component);
    }

    private int getExtraDescent(Component component) {
        int n;
        TFont tFont = this.getTFontAtTNode(n);
        int n2 = this.TNode(n).getExtraDescent(tFont);
        for (n = this.startOfLine(0); n <= this.end(); ++n) {
            TNode tNode = this.TNode(n);
            if (tNode.isChar() && tNode.isComponent()) {
                n2 = Math.max(n2, tNode.getExtraDescent(tFont));
            } else if (tNode.isTFont()) {
                tFont = tNode.getTFont();
            }
            if (!tNode.isEndOfLine()) continue;
            n2 = Math.max(0, n2 - this.getLineHeightAtTNode(component, n));
        }
        return n2;
    }

    public int getWidth(Component component) {
        TFont tFont = this.getTFontAtTNode(this.firstLine());
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.end(); ++i) {
            TNode tNode = this.TNode(i);
            if (tNode.isTFont()) {
                tFont = tNode.getTFont();
                continue;
            }
            if (!tNode.isChar()) continue;
            if ("\n".equals(tNode.getChar())) {
                n = Math.max(n, n2);
                n2 = 0;
                continue;
            }
            int n3 = tNode.getCharWidth(tFont, component, false);
            n2 += n3;
        }
        n = Math.max(n, n2);
        return n += 2 * this.leftMargin;
    }

    public String toExpression(boolean bl) {
        String string = "";
        for (int i = 0; i < this.info.size(); ++i) {
            TNode tNode = (TNode)this.info.elementAt(i);
            string = string + tNode.toExpresion(bl);
        }
        return string;
    }

    protected void updateComponentLocation(Container container, Graphics graphics, int n) {
        TNode tNode = this.TNode(n);
        if (tNode.isComponent()) {
            TFont tFont = this.getTFontAtTNode(n);
            int n2 = tFont.getAscent();
            int n3 = tFont.getDescent();
            int n4 = this.getX(container, n);
            int n5 = this.getY(container, n);
            int n6 = tNode.getCharWidth(tFont, container, false);
            Component component = tNode.getComponent();
            int n7 = (n6 - component.getSize().width) / 2;
            int n8 = n4 + n7;
            int n9 = n5 - n2 - 3;
            int n10 = component.getSize().width;
            int n11 = component.getSize().height;
            if (component instanceof NumericControl) {
                n11 = n2 + n3 + 6;
            }
            if (n8 != component.getLocation().x || n9 != component.getLocation().y || component.getSize().width != n10 || component.getSize().height != n11) {
                component.setBounds(n8, n9, n10, n11);
            }
            if (component instanceof NumericControl && (!component.getFont().getName().equals(tFont.getName()) || component.getFont().getStyle() != tFont.getStyle() % 4 || component.getFont().getSize() != tFont.getSize())) {
                component.setFont(new Font(tFont.getName(), tFont.getStyle() % 4, tFont.getSize()));
            }
            if (component.getParent() != container) {
                container.add(component);
                component.setVisible(true);
                if (component instanceof LiveOrDie) {
                    ((LiveOrDie)((Object)component)).start();
                }
            }
            component.repaint();
        }
    }

    void updateComponentLocations(Container container, Graphics graphics) {
        for (int i = 0; i < this.info.size(); ++i) {
            TNode tNode = this.TNode(i);
            if (tNode.isComponent()) {
                this.updateComponentLocation(container, graphics, i);
                continue;
            }
            if (tNode.getFI() == null) continue;
            FormulaItem formulaItem = tNode.getFI();
            for (int j = 0; j < formulaItem.size(); ++j) {
                Formula formula = formulaItem.getFormula(j);
                formula.locate(container, this.getX(container, i), this.getY(container, i));
                formula.updateComponentLocations(container);
            }
        }
    }

    public void drawSegment(Graphics graphics, Container container, boolean bl, int n, int n2, boolean bl2) {
        this.drawSegment(graphics, container, bl, n, n2, true, bl2);
    }

    public void drawSegment(Graphics graphics, Container container, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        graphics.setColor(this.getColors().getTextColor());
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            int n5 = this.drawLineAtTNode(graphics, container, bl, n4, bl2, bl3, false);
            n3 = Math.max(n3, n5);
            int n6 = n4;
            if ((n4 = this.nextLine(n4)) != n6) continue;
            break;
        }
    }

    private void drawLineAtTNode(Graphics graphics, Container container, boolean bl, int n, boolean bl2) {
        this.drawLineAtTNode(graphics, container, bl, n, true, bl2, false);
    }

    private void calcAndSetLineFonts(int n) {
        int n2 = this.startOfLine(n);
        int n3 = Math.min(this.endOfLine(n), this.end());
        TFont tFont = this.getTFontAtTNode(n2);
        for (int i = n2; i < n3; ++i) {
            TNode tNode = this.TNode(i);
            if (tNode.isTFont()) {
                tFont = tNode.getTFont();
                continue;
            }
            if (!tNode.isFormula()) continue;
            Formula formula = tNode.getFI().getFormula(0);
            formula.calcAndSetFonts(tFont);
        }
    }

    private int drawLineAtTNode(Graphics graphics, Container container, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4) {
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        int n6 = this.startOfLine(n);
        this.calcAndSetLineFonts(n6);
        int n7 = this.getLineHeightAtTNode(container, n6);
        int n8 = this.getLineAscentAtTNode(container, n6);
        int n9 = n5 = this.getY(container, n6);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Image image = null;
        if (container instanceof TextCanvas) {
            image = container.createImage(container.getSize().width, n7);
            graphics2D = (Graphics2D)image.getGraphics();
            n9 = n8;
        }
        TColors tColors = this.getColorsAtTNode(n6, bl2);
        if (bl) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, container.getSize().width, n7);
        }
        int n10 = Math.min(this.endOfLine(n), this.end());
        graphics2D.setColor(Color.black);
        Color color = null;
        if (tColors != null) {
            color = tColors.getBackColor();
            if (tColors.getTextColor() != null) {
                graphics2D.setColor(tColors.getTextColor());
            }
        } else {
            tColors = this.getColors();
        }
        if (this.segMarked() && this.segMax() >= n6 && this.segMin() < n10) {
            object = graphics2D.getColor();
            n4 = this.getX(container, Math.max(n6, this.segMin()));
            n3 = this.getX(container, Math.min(this.segMax(), n10));
            if (n4 == this.leftMargin) {
                n4 -= 2;
            }
            graphics2D.setColor(Text.bestBG(Color.white));
            graphics2D.fillRect(n4, 0, n3 - n4, n7);
            n2 = this.getX(container, n10);
            graphics2D.setColor((Color)object);
        }
        object = this.getTFontAtTNode(n6);
        n4 = ((TFont)object).getAscent();
        n3 = ((TFont)object).getDescent();
        n2 = (n4 - n3) / 2;
        int n11 = ((TFont)object).getDescent() / 2;
        int n12 = this.leftMargin;
        graphics2D.setColor(tColors.getTextColor());
        boolean bl5 = ((TFont)object).isUnderline() || ((TFont)object).isOverline();
        for (int i = n6; i < n10; ++i) {
            TNode tNode;
            String string;
            TFont.setAntialias(graphics2D, (TFont)object);
            TNode tNode2 = this.TNode(i);
            if (tNode2.isColors()) {
                tColors = tNode2.getColors();
                if (tColors != null) {
                    color = tColors.getBackColor();
                    if (tColors.getTextColor() == null) continue;
                    graphics2D.setColor(tColors.getTextColor());
                    continue;
                }
                tColors = this.getColors();
                continue;
            }
            if (tNode2.isTFont()) {
                object = tNode2.getTFont();
                bl5 = ((TFont)object).isUnderline() || ((TFont)object).isOverline();
                TFont.setAntialias(graphics2D, (TFont)object);
                n4 = ((TFont)object).getAscent();
                n3 = ((TFont)object).getDescent();
                n2 = (n4 - n3) / 2;
                n11 = 2;
                continue;
            }
            if (tNode2.isComponent()) {
                int n13 = tNode2.getCharWidth((TFont)object, container, false);
                Component component = tNode2.getComponent();
                int n14 = (n13 - component.getSize().width) / 2;
                if (this.segMarked() && this.segMin() <= i && i < this.segMax()) {
                    component.setForeground(Text.bestFG(Color.white));
                    component.setBackground(Color.black);
                } else {
                    component.setForeground(tColors.getTextColor());
                    component.setBackground(null);
                }
                this.updateComponentLocation(container, graphics2D, i);
                n12 += n13;
                continue;
            }
            if (tNode2.isFormula()) {
                int n15 = tNode2.getCharWidth((TFont)object, container, false);
                Formula formula = tNode2.getFI().getFormula(0);
                boolean bl6 = this.segMarked() && this.segMin() <= i && i < this.segMax();
                formula.locate(container, n12 + tNode2.getdX1(), n5);
                formula.draw(graphics2D, container, (TFont)object, n12 + tNode2.getdX1(), n9, bl, bl6, true, bl3);
                n12 += n15;
                continue;
            }
            if (!tNode2.isChar() || (string = tNode2.getChar()) == null) continue;
            if (this.segMarked()) {
                if (this.segMin() <= i && i < this.segMax()) {
                    graphics2D.setColor(Text.bestFG(Color.white));
                } else {
                    graphics2D.setColor(tColors.getTextColor());
                }
            }
            int n16 = tNode2.getCharWidth((TFont)object, container, true);
            Color color2 = graphics2D.getColor();
            if (color != null) {
                graphics2D.setColor(color);
                int n17 = this.getLineAscentAtTNode(container, i);
                int n18 = this.getLineDescentAtTNode(container, i);
                graphics2D.fillRect(n12, n9 - n17, n16, n17 + n18);
                graphics2D.setColor(color2);
            }
            while (i + 1 < n10 && (tNode = this.TNode(i + 1)).isPureChar()) {
                string = string + tNode.getChar();
                ++i;
            }
            if (tNode2.isHyperlink()) {
                graphics2D.setColor(new Color(0x662288));
            }
            n16 = ((TFont)object).getMjaFont().drawString(container, graphics2D, string, n12, n9);
            if (bl5 || tNode2.isHyperlink()) {
                TFont.setAntialias(graphics2D, false);
                if (((TFont)object).isUnderline() || tNode2.isHyperlink()) {
                    graphics2D.drawLine(n12, n9 + n11, n12 + n16 - 1, n9 + n11);
                    if (((TFont)object).isBold()) {
                        graphics2D.drawLine(n12, n9 + n11 + 1, n12 + n16 - 1, n9 + n11 + 1);
                    }
                }
                if (tNode2.isHyperlink()) {
                    graphics2D.setColor(color2);
                }
                if (((TFont)object).isOverline()) {
                    graphics2D.drawLine(n12, n9 - n4, n12 + n16 - 1, n9 - n4);
                    if (((TFont)object).isBold()) {
                        graphics2D.drawLine(n12, n9 - n4 + 1, n12 + n16 - 1, n9 - n4 + 1);
                    }
                }
                TFont.setAntialias(graphics2D, (TFont)object);
            }
            n12 += n16;
        }
        if (container instanceof TextCanvas) {
            graphics.drawImage(image, 0, n5 - n8, container);
            container.getGraphics().drawImage(image, 0, n5 - n8, container);
        }
        return n7;
    }
}

