/*
 * Decompiled with CFR 0.152.
 */
package com.mja.poly;

import com.mja.gui.mjaColor;
import com.mja.math.R2;
import com.mja.math3D.LinearTransformation;
import com.mja.math3D.R3;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.poly.Face;
import com.mja.poly.Surface;
import com.mja.poly.viewModel;
import com.mja.text.MathText;
import com.mja.util.BasicStr;
import java.awt.Color;
import org.unam.matem.Attribute;

public class mjaSurface {
    public static final double oneDegree = Math.PI / 180;
    public boolean split = false;
    public Node cond;
    private Node[] var;
    private Node[] node;
    private Node NNu;
    private Node NNv;
    private Node Ngr;
    private Node Nw;
    private Node Nl;
    private Node Nh;
    private Node X;
    private Node Y;
    private Node Z;
    private Node U;
    private Node V;
    private mjaColor fc;
    private mjaColor bc;
    private boolean edges;
    private Node[] irN = new Node[3];
    private Node[] ipN = new Node[3];
    private Node[] frN = new Node[3];
    private Node[] fpN = new Node[3];
    private Node[] rN = new Node[3];
    private Node[] pN = new Node[3];
    private viewModel vM;
    private Parser p;
    private int special = 0;
    private R3[] v;
    private Color[] Fc;
    private Color[] Bc;
    private boolean fixed;
    private boolean EulerInitialAngles = false;
    private boolean EulerFinalAngles = false;
    private boolean EulerAngles = false;
    private MathText mt;
    Node[] Vx;
    Node[] Vy;
    Node[] Vz;
    R3[] vertices3D;
    R2[] vertices;
    Node[] VX;
    Node[] VY;

    public mjaSurface(Parser parser, int n, String string, String string2, String string3, String string4, String string5, String string6, mjaColor mjaColor3, mjaColor mjaColor4, boolean bl, String string7, String string8, String string9, String string10, String string11, String string12, viewModel viewModel2, boolean bl2) {
        int n2;
        String[] stringArray;
        this.p = parser;
        this.special = n;
        this.X = parser.Var("x");
        this.Y = parser.Var("y");
        this.Z = parser.Var("z");
        this.U = parser.Var("u");
        this.V = parser.Var("v");
        this.setNu(string);
        this.setNv(string2);
        this.Ngr = parser.Analyse(string3, "1");
        this.Nw = parser.Analyse(string4, "2");
        this.Nl = parser.Analyse(string5, "2");
        this.Nh = parser.Analyse(string6, "2");
        this.fc = mjaColor3;
        this.bc = mjaColor4;
        this.fc.analyse(parser);
        this.bc.analyse(parser);
        this.edges = bl;
        int n3 = 0;
        try {
            stringArray = BasicStr.getTokens(string7);
            n3 = 0;
            if (string7.startsWith("Euler")) {
                this.EulerInitialAngles = true;
                n3 = 1;
            }
            if (stringArray.length >= 3 + n3) {
                for (n2 = n3; n2 < stringArray.length; ++n2) {
                    this.irN[n2 - n3] = parser.Analyse(stringArray[n2], 0.0);
                }
            } else {
                this.irN[0] = parser.Analyse("0");
                this.irN[1] = this.irN[0];
                this.irN[2] = this.irN[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringArray = BasicStr.getTokens(string8);
            if (stringArray.length >= 3) {
                for (n2 = 0; n2 < this.ipN.length; ++n2) {
                    this.ipN[n2] = parser.Analyse(stringArray[n2], 0.0);
                }
            } else {
                this.ipN[0] = parser.Analyse("0");
                this.ipN[1] = this.ipN[0];
                this.ipN[2] = this.ipN[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringArray = BasicStr.getTokens(string9);
            n3 = 0;
            if (string9.startsWith("Euler")) {
                this.EulerFinalAngles = true;
                n3 = 1;
            }
            if (stringArray.length >= 3 + n3) {
                for (n2 = n3; n2 < stringArray.length; ++n2) {
                    this.frN[n2 - n3] = parser.Analyse(stringArray[n2], 0.0);
                }
            } else {
                this.frN[0] = parser.Analyse("0");
                this.frN[1] = this.frN[0];
                this.frN[2] = this.frN[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringArray = BasicStr.getTokens(string10);
            if (stringArray.length >= 3) {
                for (n2 = 0; n2 < this.fpN.length; ++n2) {
                    this.fpN[n2] = parser.Analyse(stringArray[n2], 0.0);
                }
            } else {
                this.fpN[0] = parser.Analyse("0");
                this.fpN[1] = this.fpN[0];
                this.fpN[2] = this.fpN[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringArray = BasicStr.getTokens(string11);
            n3 = 0;
            if (string11.startsWith("Euler")) {
                this.EulerAngles = true;
                n3 = 1;
            }
            if (stringArray.length >= 3 + n3) {
                for (n2 = n3; n2 < stringArray.length; ++n2) {
                    this.rN[n2 - n3] = parser.Analyse(stringArray[n2], 0.0);
                }
            } else {
                this.rN[0] = parser.Analyse("0");
                this.rN[1] = this.rN[0];
                this.rN[2] = this.rN[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringArray = BasicStr.getTokens(string12);
            if (stringArray.length >= 3) {
                for (n2 = 0; n2 < this.pN.length; ++n2) {
                    this.pN[n2] = parser.Analyse(stringArray[n2], 0.0);
                }
            } else {
                this.pN[0] = parser.Analyse("0");
                this.pN[1] = this.pN[0];
                this.pN[2] = this.pN[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.vM = viewModel2;
        this.fixed = bl2;
    }

    public void setMathText(MathText mathText) {
        this.mt = mathText;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    void setEquation(String string) {
        this.special = 0;
        String string2 = BasicStr.replace(string, "\\n", " ");
        Attribute[] attributeArray = Attribute.parse(string2);
        this.var = new Node[attributeArray.length];
        this.node = new Node[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            this.var[i] = this.p.Var(attributeArray[i].name);
            this.node[i] = this.p.Analyse(attributeArray[i].value);
        }
    }

    public void set3DVertices(String string) {
        this.Vx = new Node[3];
        this.Vy = new Node[3];
        this.Vz = new Node[3];
        for (int i = 0; i < 3; ++i) {
            this.Vx[i] = this.p.Analyse("0", 0.0);
            this.Vy[i] = this.p.Analyse("0", 0.0);
            this.Vz[i] = this.p.Analyse("0", 0.0);
        }
        try {
            String[] stringArray = BasicStr.getTokens(string);
            int n = stringArray.length;
            for (int i = 0; i < n / 3 && i < 3; ++i) {
                int n2 = 3 * i;
                if (n2 < stringArray.length) {
                    this.Vx[i] = this.p.Analyse(stringArray[n2++], 0.0);
                }
                if (n2 < stringArray.length) {
                    this.Vy[i] = this.p.Analyse(stringArray[n2++], 0.0);
                }
                if (n2 >= stringArray.length) continue;
                this.Vz[i] = this.p.Analyse(stringArray[n2++], 0.0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.calculate3DVertices();
    }

    private void calculate3DVertices() {
        this.vertices3D = new R3[this.Vx.length];
        for (int i = 0; i < this.Vx.length; ++i) {
            try {
                this.vertices3D[i] = new R3(this.Vx[i].Evaluate(), this.Vy[i].Evaluate(), this.Vz[i].Evaluate());
                continue;
            }
            catch (Exception exception) {
                this.vertices3D[i] = null;
            }
        }
    }

    public void setVertices(String string) {
        this.VX = new Node[0];
        this.VY = new Node[0];
        try {
            String[] stringArray = BasicStr.getTokens(string);
            int n = stringArray.length;
            if (n % 2 != 0) {
                --n;
            }
            if (n > 0) {
                this.VX = new Node[n /= 2];
                this.VY = new Node[n];
                for (int i = 0; i < n; ++i) {
                    String string2 = stringArray[2 * i];
                    String string3 = stringArray[2 * i + 1];
                    this.VX[i] = this.p.Analyse(string2, 0.0);
                    this.VY[i] = this.p.Analyse(string3, 0.0);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.calculateVertices();
    }

    private void calculateVertices() {
        this.vertices = new R2[this.VX.length];
        for (int i = 0; i < this.VX.length; ++i) {
            double d = this.VX[i].Evaluate(0.0);
            double d2 = this.VY[i].Evaluate(0.0);
            this.vertices[i] = new R2(d, d2);
        }
    }

    public void setNu(String string) {
        this.NNu = this.p.Analyse(string, "7");
    }

    public void setNv(String string) {
        this.NNv = this.p.Analyse(string, "7");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface create() {
        Object object;
        Object object2;
        Surface surface = null;
        Node node = this.p.Var("_AnChO_");
        Node node2 = this.p.Var("_LaRgO_");
        Node node3 = this.p.Var("_AlTo_");
        Object object3 = node;
        synchronized (object3) {
            object2 = node2;
            synchronized (object2) {
                object = node3;
                synchronized (object) {
                    double d = node.getDouble();
                    double d2 = node2.getDouble();
                    double d3 = node3.getDouble();
                    node.setDouble(this.Nw.Evaluate(2.0));
                    node2.setDouble(this.Nl.Evaluate(2.0));
                    node3.setDouble(this.Nh.Evaluate(2.0));
                    if (this.special > 0) {
                        double d4 = node.getDouble() / 2.0;
                        double d5 = node2.getDouble() / 2.0;
                        double d6 = node3.getDouble() / 2.0;
                        switch (this.special) {
                            case 5: {
                                this.calculate3DVertices();
                                surface = mjaSurface.getFace(this.vertices3D);
                                break;
                            }
                            case 6: {
                                this.calculateVertices();
                                surface = mjaSurface.getFace(this.vertices);
                                break;
                            }
                            case 8: {
                                surface = mjaSurface.getBox(d4, d5, d6);
                                break;
                            }
                            case 11: {
                                surface = mjaSurface.getRegularTetrahedron(d4);
                                break;
                            }
                            case 12: {
                                double d7 = d4 / Math.sqrt(3.0);
                                surface = mjaSurface.getBox(d7, d7, d7);
                                break;
                            }
                            case 13: {
                                surface = mjaSurface.getRegularOctahedron(d4);
                                break;
                            }
                            case 14: {
                                surface = mjaSurface.getRegularDodecahedron(d4);
                                break;
                            }
                            case 15: {
                                surface = mjaSurface.getRegularIcosahedron(d4);
                            }
                        }
                        surface.setFrontColor(this.fc.getAdaptedColor());
                        surface.setBackColor(this.bc.getAdaptedColor());
                    } else {
                        int n = (int)Math.round(this.NNu.Evaluate(7.0));
                        int n2 = (int)Math.round(this.NNv.Evaluate(7.0));
                        this.calculateVerticesAndColors(n, n2);
                        surface = this.makeSurface(n, n2, (int)Math.round(this.Ngr.Evaluate(1.0)));
                    }
                    node.setDouble(d);
                    node2.setDouble(d2);
                    node3.setDouble(d3);
                }
            }
        }
        if (surface != null) {
            surface.setDrawEdges(this.edges);
            object3 = new R3(Math.PI / 180 * this.irN[0].Evaluate(0.0), Math.PI / 180 * this.irN[1].Evaluate(0.0), Math.PI / 180 * this.irN[2].Evaluate(0.0));
            object2 = new R3(this.ipN[0].Evaluate(0.0), this.ipN[1].Evaluate(0.0), this.ipN[2].Evaluate(0.0));
            surface.apply(LinearTransformation.RigidMotion(this.EulerInitialAngles, (R3)object3, (R3)object2));
            object = new R3(Math.PI / 180 * this.frN[0].Evaluate(0.0), Math.PI / 180 * this.frN[1].Evaluate(0.0), Math.PI / 180 * this.frN[2].Evaluate(0.0));
            R3 r3 = new R3(this.fpN[0].Evaluate(0.0), this.fpN[1].Evaluate(0.0), this.fpN[2].Evaluate(0.0));
            surface.apply(LinearTransformation.RigidMotion(this.EulerFinalAngles, (R3)object, r3));
            R3 r32 = new R3(Math.PI / 180 * this.rN[0].Evaluate(0.0), Math.PI / 180 * this.rN[1].Evaluate(0.0), Math.PI / 180 * this.rN[2].Evaluate(0.0));
            R3 r33 = new R3(this.pN[0].Evaluate(0.0), this.pN[1].Evaluate(0.0), this.pN[2].Evaluate(0.0));
            surface.apply(LinearTransformation.RigidMotion(this.EulerAngles, r32, r33));
            surface.fixAsInitialPosition();
            surface.setViewModel(this.vM);
            surface.setMathText(this.mt);
        }
        return surface;
    }

    private Surface makeSurface(int n, int n2, int n3) {
        Face[] faceArray = null;
        if (n2 == 0) {
            if (n == 0) {
                faceArray = new Face[]{new Face(this.v[0])};
                faceArray[0].setFrontColor(this.Fc[0]);
                faceArray[0].setBackColor(this.Bc[0]);
                faceArray[0].setWidthness(n3);
            } else {
                faceArray = new Face[n];
                for (int i = 0; i < n; ++i) {
                    faceArray[i] = new Face(this.v[i], this.v[i + 1]);
                    faceArray[i].setFrontColor(this.Fc[i]);
                    faceArray[i].setBackColor(this.Bc[i]);
                    faceArray[i].setWidthness(n3);
                }
            }
        } else {
            faceArray = new Face[n * n2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    faceArray[j + n * i] = new Face(this.v[j + i * (n + 1)], this.v[j + 1 + i * (n + 1)], this.v[j + 1 + (i + 1) * (n + 1)], this.v[j + (i + 1) * (n + 1)]);
                    faceArray[j + n * i].setFrontColor(this.Fc[j + i * (n + 1)]);
                    faceArray[j + n * i].setBackColor(this.Bc[j + i * (n + 1)]);
                }
            }
        }
        return new Surface(faceArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateVerticesAndColors(int n, int n2) {
        this.v = new R3[(n + 1) * (n2 + 1)];
        this.Fc = new Color[(n + 1) * (n2 + 1)];
        this.Bc = new Color[(n + 1) * (n2 + 1)];
        Node node = this.X;
        synchronized (node) {
            Node node2 = this.Y;
            synchronized (node2) {
                Node node3 = this.Z;
                synchronized (node3) {
                    Node node4 = this.U;
                    synchronized (node4) {
                        Node node5 = this.V;
                        synchronized (node5) {
                            int n3;
                            double d = this.X.getDouble();
                            double d2 = this.Y.getDouble();
                            double d3 = this.Z.getDouble();
                            double d4 = this.U.getDouble();
                            double d5 = this.V.getDouble();
                            double[] dArray = new double[this.node.length];
                            for (int i = 0; i < this.node.length; ++i) {
                                dArray[i] = this.var[i].getDouble();
                            }
                            double d6 = 1.0 / (double)n;
                            double d7 = 1.0 / (double)n2;
                            int n4 = 0;
                            this.V.setDouble(0.0);
                            for (n3 = 0; n3 <= n2; ++n3) {
                                this.U.setDouble(0.0);
                                for (int i = 0; i <= n; ++i) {
                                    boolean bl = true;
                                    for (int j = 0; j < this.node.length; ++j) {
                                        try {
                                            this.var[j].setDouble(this.node[j].Evaluate());
                                            continue;
                                        }
                                        catch (Exception exception) {
                                            this.var[j].setDouble(Double.NaN);
                                            bl = false;
                                        }
                                    }
                                    this.Fc[n4] = this.fc.getAdaptedColor();
                                    this.Bc[n4] = this.bc.getAdaptedColor();
                                    this.v[n4++] = bl && this.X.getDouble() != Double.NaN && this.Y.getDouble() != Double.NaN && this.Z.getDouble() != Double.NaN ? new R3(this.X.getDouble(), this.Y.getDouble(), this.Z.getDouble()) : null;
                                    if (i + 1 == n) {
                                        this.U.setDouble(1.0);
                                        continue;
                                    }
                                    this.U.setDouble(this.U.getDouble() + d6);
                                }
                                if (n3 + 1 == n2) {
                                    this.V.setDouble(1.0);
                                    continue;
                                }
                                this.V.setDouble(this.V.getDouble() + d7);
                            }
                            for (n3 = 0; n3 < this.node.length; ++n3) {
                                this.var[n3].setDouble(dArray[n3]);
                            }
                            this.X.setDouble(d);
                            this.Y.setDouble(d2);
                            this.Z.setDouble(d3);
                            this.U.setDouble(d4);
                            this.V.setDouble(d5);
                        }
                    }
                }
            }
        }
    }

    private static final Surface getFace(R2[] r2Array) {
        Face[] faceArray = new Face[]{r2Array != null && r2Array.length >= 3 ? new Face(r2Array) : new Face(new R3(-1.0, -1.0, 0.0), new R3(-1.0, 1.0, 0.0), new R3(1.0, 1.0, 0.0), new R3(1.0, -1.0, 0.0))};
        return new Surface(faceArray);
    }

    private static final Surface getFace(R3[] r3Array) {
        Face[] faceArray = new Face[]{r3Array != null && r3Array.length == 3 ? new Face(r3Array) : new Face(new R3(1.0, 0.0, 0.0), new R3(0.0, 1.0, 0.0), new R3(0.0, 0.0, 1.0))};
        return new Surface(faceArray);
    }

    private static final Surface getBox(double d, double d2, double d3) {
        R3[] r3Array = new R3[]{new R3(d, d2, d3), new R3(d, -d2, d3), new R3(-d, -d2, d3), new R3(-d, d2, d3), new R3(d, d2, -d3), new R3(d, -d2, -d3), new R3(-d, -d2, -d3), new R3(-d, d2, -d3)};
        Face[] faceArray = new Face[]{new Face(r3Array[0], r3Array[3], r3Array[2], r3Array[1]), new Face(r3Array[0], r3Array[1], r3Array[5], r3Array[4]), new Face(r3Array[1], r3Array[2], r3Array[6], r3Array[5]), new Face(r3Array[2], r3Array[3], r3Array[7], r3Array[6]), new Face(r3Array[3], r3Array[0], r3Array[4], r3Array[7]), new Face(r3Array[7], r3Array[4], r3Array[5], r3Array[6])};
        return new Surface(faceArray);
    }

    private static final Surface getRegularTetrahedron(double d) {
        R3[] r3Array;
        r3Array = new R3[]{new R3(0.0, 0.0, d), new R3(d * 2.0 * Math.sqrt(2.0) / 3.0, 0.0, -d * 1.0 / 3.0), r3Array[1].RotZ(2.0943951023931953), r3Array[2].RotZ(2.0943951023931953)};
        Face[] faceArray = new Face[]{new Face(r3Array[0], r3Array[1], r3Array[2]), new Face(r3Array[1], r3Array[3], r3Array[2]), new Face(r3Array[0], r3Array[2], r3Array[3]), new Face(r3Array[0], r3Array[3], r3Array[1])};
        return new Surface(faceArray);
    }

    private static final Surface getRegularOctahedron(double d) {
        R3[] r3Array = new R3[]{new R3(0.0, 0.0, d), new R3(d, 0.0, 0.0), new R3(0.0, d, 0.0), new R3(-d, 0.0, 0.0), new R3(0.0, -d, 0.0), new R3(0.0, 0.0, -d)};
        Face[] faceArray = new Face[]{new Face(r3Array[0], r3Array[1], r3Array[2]), new Face(r3Array[0], r3Array[2], r3Array[3]), new Face(r3Array[0], r3Array[3], r3Array[4]), new Face(r3Array[0], r3Array[4], r3Array[1]), new Face(r3Array[5], r3Array[2], r3Array[1]), new Face(r3Array[5], r3Array[3], r3Array[2]), new Face(r3Array[5], r3Array[4], r3Array[3]), new Face(r3Array[5], r3Array[1], r3Array[4])};
        return new Surface(faceArray);
    }

    private static final Surface getRegularDodecahedron(double d) {
        R3[] r3Array = new R3[20];
        R3 r3 = new R3(0.0, 0.0, d);
        double d2 = 4.0 / (Math.sqrt(3.0) * (Math.sqrt(5.0) + 1.0));
        double d3 = 1.2566370614359172;
        double d4 = 1.0 - Math.cos(d3);
        d4 = d4 * d4 + Math.sin(d3) * Math.sin(d3);
        double d5 = Math.asin(d2 / Math.sqrt(d4));
        double d6 = 2.0 * Math.asin(Math.sin(0.6283185307179586) * Math.sin(d5));
        r3Array[0] = r3.RotY(d5);
        r3Array[1] = r3Array[0].RotZ(d3);
        r3Array[2] = r3Array[1].RotZ(d3);
        r3Array[3] = r3Array[2].RotZ(d3);
        r3Array[4] = r3Array[3].RotZ(d3);
        r3Array[5] = r3Array[0].RotY(d6);
        r3Array[6] = r3Array[5].RotZ(d3);
        r3Array[7] = r3Array[6].RotZ(d3);
        r3Array[8] = r3Array[7].RotZ(d3);
        r3Array[9] = r3Array[8].RotZ(d3);
        r3Array[10] = r3Array[0].Negative();
        r3Array[11] = r3Array[1].Negative();
        r3Array[12] = r3Array[2].Negative();
        r3Array[13] = r3Array[3].Negative();
        r3Array[14] = r3Array[4].Negative();
        r3Array[15] = r3Array[5].Negative();
        r3Array[16] = r3Array[6].Negative();
        r3Array[17] = r3Array[7].Negative();
        r3Array[18] = r3Array[8].Negative();
        r3Array[19] = r3Array[9].Negative();
        Face[] faceArray = new Face[]{new Face(r3Array[0], r3Array[1], r3Array[2], r3Array[3], r3Array[4]), new Face(r3Array[0], r3Array[5], r3Array[18], r3Array[6], r3Array[1]), new Face(r3Array[1], r3Array[6], r3Array[19], r3Array[7], r3Array[2]), new Face(r3Array[2], r3Array[7], r3Array[15], r3Array[8], r3Array[3]), new Face(r3Array[3], r3Array[8], r3Array[16], r3Array[9], r3Array[4]), new Face(r3Array[4], r3Array[9], r3Array[17], r3Array[5], r3Array[0]), new Face(r3Array[14], r3Array[13], r3Array[12], r3Array[11], r3Array[10]), new Face(r3Array[11], r3Array[16], r3Array[8], r3Array[15], r3Array[10]), new Face(r3Array[12], r3Array[17], r3Array[9], r3Array[16], r3Array[11]), new Face(r3Array[13], r3Array[18], r3Array[5], r3Array[17], r3Array[12]), new Face(r3Array[14], r3Array[19], r3Array[6], r3Array[18], r3Array[13]), new Face(r3Array[10], r3Array[15], r3Array[7], r3Array[19], r3Array[14])};
        return new Surface(faceArray);
    }

    private static final Surface getRegularIcosahedron(double d) {
        R3[] r3Array = new R3[12];
        r3Array[0] = new R3(0.0, 0.0, d);
        double d2 = 2.0 * Math.sqrt(2.0) / Math.sqrt(5.0 + Math.sqrt(5.0));
        double d3 = 2.0 * Math.asin(d2 / 2.0);
        double d4 = 1.2566370614359172;
        r3Array[1] = r3Array[0].RotY(d3);
        r3Array[2] = r3Array[1].RotZ(d4);
        r3Array[3] = r3Array[2].RotZ(d4);
        r3Array[4] = r3Array[3].RotZ(d4);
        r3Array[5] = r3Array[4].RotZ(d4);
        r3Array[6] = r3Array[1].Negative();
        r3Array[7] = r3Array[2].Negative();
        r3Array[8] = r3Array[3].Negative();
        r3Array[9] = r3Array[4].Negative();
        r3Array[10] = r3Array[5].Negative();
        r3Array[11] = r3Array[0].Negative();
        Face[] faceArray = new Face[]{new Face(r3Array[0], r3Array[1], r3Array[2]), new Face(r3Array[0], r3Array[2], r3Array[3]), new Face(r3Array[0], r3Array[3], r3Array[4]), new Face(r3Array[0], r3Array[4], r3Array[5]), new Face(r3Array[0], r3Array[5], r3Array[1]), new Face(r3Array[1], r3Array[9], r3Array[2]), new Face(r3Array[2], r3Array[10], r3Array[3]), new Face(r3Array[3], r3Array[6], r3Array[4]), new Face(r3Array[4], r3Array[7], r3Array[5]), new Face(r3Array[5], r3Array[8], r3Array[1]), new Face(r3Array[6], r3Array[7], r3Array[4]), new Face(r3Array[7], r3Array[8], r3Array[5]), new Face(r3Array[8], r3Array[9], r3Array[1]), new Face(r3Array[9], r3Array[10], r3Array[2]), new Face(r3Array[10], r3Array[6], r3Array[3]), new Face(r3Array[11], r3Array[10], r3Array[9]), new Face(r3Array[11], r3Array[9], r3Array[8]), new Face(r3Array[11], r3Array[8], r3Array[7]), new Face(r3Array[11], r3Array[7], r3Array[6]), new Face(r3Array[11], r3Array[6], r3Array[10])};
        return new Surface(faceArray);
    }
}

