/*
 * Decompiled with CFR 0.152.
 */
package org.jfxtras.stage;

import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.swing.WindowStage;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.lang.FX;
import javafx.scene.Scene;
import javafx.stage.StageStyle;
import javax.swing.JDialog;
import org.jfxtras.stage.WindowHelper;

public class DialogStage
extends WindowStage {
    protected JDialog dialog;

    protected DialogStage(JDialog dialog, StageStyle stageStyle, Scene scene) {
        super((Window)dialog, stageStyle);
        this.dialog = dialog;
        dialog.addPropertyChangeListener("resizable", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                if (DialogStage.this.listener != null) {
                    DialogStage.this.listener.changedResizable(DialogStage.this.dialog.isResizable());
                }
            }
        });
        this.setJavaFXScene(scene);
    }

    protected void initializeStyle(Window win, StageStyle style) {
        JDialog dialog1 = (JDialog)win;
        if (style == StageStyle.TRANSPARENT || style == StageStyle.UNDECORATED) {
            dialog1.setUndecorated(true);
        }
        super.initializeStyle(win, style);
    }

    public void setResizable(boolean resizable) {
        if (this.dialog.isResizable() != resizable) {
            this.dialog.setResizable(resizable);
        }
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.dialog.setTitle(title);
    }

    public void setScene(TKScene scene) {
    }

    public void setJavaFXScene(Scene scene) {
        super.setScene((TKScene)WindowHelper.setTransparentScenePeer(scene));
    }

    public void close() {
        super.close();
        try {
            int windowCount = 0;
            Method getWindowsMethod = Window.class.getMethod("getWindows", null);
            if (getWindowsMethod != null) {
                for (Window window1 : (Window[])getWindowsMethod.invoke(null, new Object[0])) {
                    if (!window1.isVisible()) continue;
                    ++windowCount;
                }
            }
            if (windowCount == 0) {
                FX.exit();
            }
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DialogStage.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(DialogStage.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(DialogStage.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(DialogStage.class.getName()).log(Level.WARNING, "Dialog auto-close only supported on Java 6 or later", ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(DialogStage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

