/*
 * Decompiled with CFR 0.152.
 */
package com.jla.desc2.gui;

import com.jla.desc2.gui.mjaGui;
import com.jla.desc2.gui.spinnerControl;
import com.jla.desc2.parser.Node;
import com.jla.desc2.parser.Parser;
import com.jla.desc2.util.mjaStr;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.math.BigDecimal;
import java.util.Vector;

public class Spinner
extends Panel
implements Runnable,
MouseListener,
MouseMotionListener,
KeyListener,
FocusListener {
    public Label lb;
    public TextField tf;
    public spinnerControl sp;
    private Parser parser;
    private Node dvN;
    private Node pvN;
    private Vector listeners = new Vector();
    private Thread thr;
    private BigDecimal V;
    private BigDecimal iV;
    private BigDecimal sV;
    private BigDecimal dV0;
    private int p0;
    private Node var;
    private Node notexp;
    private volatile boolean stopRequested;

    public Spinner(Parser parser, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, String string8) {
        this.parser = parser;
        if (string2.equals("m")) {
            System.out.println("s_p=" + string3);
        }
        this.pvN = parser.Analyse(string3, 2.0);
        this.notexp = parser.Analyse(string8, 0.0);
        if (this.pvN.isANumber()) {
            this.p0 = Math.max(0, (int)Math.round(this.pvN.Evaluate(2.0)));
            this.pvN = null;
        }
        this.iV = mjaStr.hasContent(string6) ? new BigDecimal(parser.Analyse(string6).Evaluate(-1.7976931348623157E308)) : new BigDecimal(-1.7976931348623157E308);
        this.sV = mjaStr.hasContent(string7) ? new BigDecimal(parser.Analyse(string7).Evaluate(Double.MAX_VALUE)) : new BigDecimal(Double.MAX_VALUE);
        this.setName(string2);
        if (!mjaStr.osIsWindows()) {
            this.setFont(mjaGui.Arial_10);
        } else {
            this.setFont(mjaGui.Courier);
        }
        this.lb = new Label(string);
        this.lb.setBackground(Color.lightGray);
        this.lb.setForeground(Color.black);
        this.lb.setAlignment(1);
        this.tf = new TextField();
        this.tf.addKeyListener(this);
        this.tf.addFocusListener(this);
        this.tf.setBackground(Color.white);
        this.tf.setForeground(Color.black);
        if (!bl) {
            this.tf.setVisible(false);
        }
        this.sp = new spinnerControl();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.lb, gridBagConstraints);
        this.add(this.lb);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.sp, gridBagConstraints);
        this.add(this.sp);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.tf, gridBagConstraints);
        this.add(this.tf);
        this.sp.addMouseListener(this);
        this.sp.addMouseMotionListener(this);
        this.dvN = parser.Analyse(string5, 0.1);
        if (this.dvN.isANumber() && this.pvN != null && this.pvN.isANumber()) {
            this.dV0 = new BigDecimal(Math.max(mjaStr.minIncr(this.p0), this.dvN.Evaluate(0.01)));
            this.dvN = null;
        }
        this.var = parser.Var(this.getName());
        this.V = new BigDecimal(0);
        this.defineValue(string4);
    }

    public String getLabel() {
        return this.lb.getText();
    }

    public void setLabel(String string) {
        this.lb.setText(string);
    }

    public void updateFromNode() {
        BigDecimal bigDecimal = new BigDecimal(this.var.r);
        if (this.V.compareTo(bigDecimal) != 0) {
            this.setValue(bigDecimal);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    private void defineValue(String string) {
        BigDecimal bigDecimal;
        block4: {
            bigDecimal = this.V;
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (Exception exception) {
                if (!mjaStr.hasContent(string)) break block4;
                try {
                    Node node = this.parser.Analyse(string, false);
                    bigDecimal = new BigDecimal(node.Evaluate());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        this.setValue(bigDecimal);
    }

    private void setValue(BigDecimal bigDecimal) {
        if (this.V.compareTo(bigDecimal) != 0) {
            this.V = bigDecimal;
            if (this.V.compareTo(this.iV) < 0) {
                this.V = this.iV;
            }
            if (this.V.compareTo(this.sV) > 0) {
                this.V = this.sV;
            }
            this.var.r = this.V.doubleValue();
        }
        this.updateTextField();
    }

    private void updateTextField() {
        int n = this.p0;
        if (this.pvN != null) {
            n = Math.max(0, (int)Math.round(this.pvN.Evaluate(2.0)));
        }
        if (this.notexp.Evaluate(0.0) > 0.0) {
            this.tf.setText(mjaStr.notExp(this.var.r, n));
        } else {
            this.tf.setText(mjaStr.DoubleToString(this.var.r, n, true));
        }
        this.tf.paint(this.tf.getGraphics());
    }

    public void updateFromTextField() {
        this.defineValue(this.tf.getText());
    }

    private void spinStep() {
        this.updateFromTextField();
        BigDecimal bigDecimal = this.dV0;
        if (this.dvN != null) {
            int n = this.p0;
            if (this.pvN != null) {
                n = Math.max(0, (int)Math.round(this.pvN.Evaluate(2.0)));
            }
            bigDecimal = new BigDecimal(Math.max(mjaStr.minIncr(n), this.dvN.Evaluate(0.01)));
        }
        String string = "";
        BigDecimal bigDecimal2 = this.V;
        if (this.sp.up) {
            string = "up";
            if ((bigDecimal2 = bigDecimal2.add(bigDecimal)).compareTo(this.sV) > 0) {
                Toolkit.getDefaultToolkit().beep();
                bigDecimal2 = this.sV;
            }
        } else if (this.sp.down) {
            string = "down";
            if ((bigDecimal2 = bigDecimal2.subtract(bigDecimal)).compareTo(this.iV) < 0) {
                Toolkit.getDefaultToolkit().beep();
                bigDecimal2 = this.iV;
            }
        }
        this.setValue(bigDecimal2);
        this.callListeners(string);
    }

    private void callListeners(String string) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ActionListener actionListener = (ActionListener)this.listeners.elementAt(i);
            actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    private boolean stop() {
        return this.stopRequested;
    }

    public void run() {
        long l = System.currentTimeMillis() + 500L;
        this.spinStep();
        while (!this.stop()) {
            while (!this.stop() && System.currentTimeMillis() < l) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    this.stopRequested = true;
                }
            }
            if (this.stop()) break;
            this.spinStep();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                this.stopRequested = true;
            }
            l = System.currentTimeMillis() + 40L;
        }
        this.sp.up = false;
        this.sp.down = false;
        this.sp.repaint();
        this.thr = null;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        block3: {
            block2: {
                if (keyEvent.getKeyCode() == 10) break block2;
                if (keyEvent.getKeyCode() != 9) break block3;
            }
            this.defineValue(this.tf.getText());
            this.callListeners("updateSpinnersFromTextFields");
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.thr != null) {
            this.thr.stop();
            this.thr = null;
        }
        if (mouseEvent.getSource() == this.sp) {
            if (mouseEvent.getY() < this.sp.getSize().height / 2) {
                this.sp.up = true;
            } else {
                this.sp.down = true;
            }
            this.sp.repaint();
            this.stopRequested = false;
            this.thr = new Thread(this);
            this.thr.start();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.stopRequested = true;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.stopRequested = true;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.stopRequested = true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.stopRequested = true;
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }
}

