/*
 * Decompiled with CFR 0.152.
 */
package com.jla.desc2.descartes;

import com.jla.desc2.descartes.Descartes;
import com.jla.desc2.descartes.data;
import com.jla.desc2.descartes.graphConfig;
import com.jla.desc2.descartes.parametrization;
import com.jla.desc2.gui.mjaGui;
import com.jla.desc2.math.R2;
import com.jla.desc2.math.R2Newton;
import com.jla.desc2.parser.Node;
import com.jla.desc2.util.mjaStr;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.TextField;
import java.util.StringTokenizer;
import java.util.Vector;

public class mjaGraph {
    Descartes D;
    graphConfig gc;
    int size = 2;
    parametrization sparz;
    TextField TF;
    private static final double dosPi = Math.PI * 2;
    private static final double Pim = 1.5707963267948966;
    private static final double MAX_INT = 32767.0;
    private static final double epsilon = 1.0E-4;
    private static final int segment = 0;
    private static final int equation = 1;
    private static final int curve = 2;
    private static final int sequence = 3;
    private static final int line = 4;
    private static final int conic = 5;
    private static final int funcOfX = 6;
    private static final int funcOfY = 7;
    private int eqType;
    private int width = -1;
    private int spear = -1;
    private Node decimals;
    private Node cond;
    private parametrization tparz;
    private Vector[] pstr;
    private static final String[] lineEq = new String[]{"y=m*x+b", "x=m*y+a", "A*x+B*y=C"};
    private static final String[] conicEq = new String[]{"e=sqrt((x-Fx)^2+(y-Fy)^2)/(d+(x-Fx)*cos(t)+(y-Fy)*sen(t))", "e=sqrt((x-Fx)^2+(y-Fy)^2)/(d-((x-Fx)*(Dx-Fx)+(y-Fy)*(Dy-Fy))/d)"};
    private Node F;
    private Node fx;
    private Node fy;
    private int caso;
    private int w;
    private int h;
    private int Fx;
    private int Fy;
    private int x;
    private int y;
    private int z;
    private int dx;
    private int zx;
    private int zxx;
    private int dy;
    private int zy;
    private int zyy;
    private int zxy;
    private Node x1;
    private Node y1;
    private Node x2;
    private Node y2;
    private Node r;
    private Node aN;
    private Node daN;
    private Node Si;
    private Node Sf;
    private Node[] xNa;
    private Node[] yNa;
    private int segType;
    private Graphics[] g;
    static final int netsz = 16;

    public mjaGraph(Descartes descartes, graphConfig graphConfig2) {
        this.D = descartes;
        this.gc = graphConfig2;
        this.cond = descartes.p.Analyse(graphConfig2.cond, "1");
        String[] stringArray = mjaStr.toStringArray(graphConfig2.text);
        this.pstr = new Vector[stringArray.length];
        for (int i = 0; i < this.pstr.length; ++i) {
            this.pstr[i] = descartes.p.parseString(stringArray[i]);
        }
        this.size = mjaStr.parseInteger(graphConfig2.s_size, 2, 2);
        this.width = mjaStr.parseInteger(graphConfig2.s_width, 1, 1);
        this.spear = mjaStr.parseInteger(graphConfig2.s_spear, 5, this.spear);
        this.decimals = descartes.p.Analyse(graphConfig2.s_decimals, 2.0);
        if (graphConfig2.isFamily) {
            this.sparz = new parametrization(descartes.p, graphConfig2.fparam, graphConfig2.f_interval, graphConfig2.f_steps);
        }
        if (mjaStr.hasContent(graphConfig2.parameter)) {
            this.tparz = new parametrization(descartes.p, graphConfig2.parameter, graphConfig2.p_interval, graphConfig2.p_steps);
        }
        if (graphConfig2.type == 61 || graphConfig2.type == 62 || graphConfig2.type == 15) {
            this.analyse();
        } else if (graphConfig2.type == 66) {
            String[] stringArray2;
            this.eqType = 0;
            this.segType = 66;
            graphConfig2.isEditable = false;
            graphConfig2.isVisible = false;
            this.xNa = new Node[1];
            this.yNa = new Node[1];
            try {
                stringArray2 = mjaStr.getTokens(graphConfig2.s_center);
                this.xNa[0] = descartes.p.Analyse(stringArray2[0]);
                this.yNa[0] = descartes.p.Analyse(stringArray2[1]);
            }
            catch (Exception exception) {
                System.out.println("bad expression " + graphConfig2.s_center);
            }
            this.r = descartes.p.Analyse(graphConfig2.s_radius);
            if (graphConfig2.s_ini.startsWith("[") || graphConfig2.s_ini.startsWith("(")) {
                try {
                    stringArray2 = mjaStr.getTokens(graphConfig2.s_ini);
                    this.x1 = descartes.p.Analyse(stringArray2[0]);
                    this.y1 = descartes.p.Analyse(stringArray2[1]);
                    stringArray2 = mjaStr.getTokens(graphConfig2.s_end);
                    this.x2 = descartes.p.Analyse(stringArray2[0]);
                    this.y2 = descartes.p.Analyse(stringArray2[1]);
                }
                catch (Exception exception) {
                    System.out.println("bad expression " + graphConfig2.s_center);
                }
            } else {
                this.aN = descartes.p.Analyse(graphConfig2.s_ini);
                this.daN = descartes.p.Analyse("(" + graphConfig2.s_end + ")-(" + graphConfig2.s_ini + ")");
            }
        } else {
            this.eqType = 0;
            this.segType = graphConfig2.type;
            graphConfig2.isEditable = false;
            graphConfig2.isVisible = false;
            try {
                String[] stringArray3 = mjaStr.getTokens(graphConfig2.formula);
                int n = stringArray3.length / 2;
                int n2 = 0;
                this.xNa = new Node[n];
                this.yNa = new Node[n];
                for (int i = 0; i < n; ++i) {
                    this.xNa[i] = descartes.p.Analyse(stringArray3[n2++]);
                    this.yNa[i] = descartes.p.Analyse(stringArray3[n2++]);
                }
            }
            catch (Exception exception) {
                System.out.println("bad expression " + graphConfig2.formula);
            }
        }
    }

    void analyse() {
        block16: {
            if (this.gc.type != 61) {
                try {
                    String[] stringArray = mjaStr.getTokens(this.gc.formula);
                    int n = 0;
                    if (stringArray.length <= 1) break block16;
                    if (this.gc.type == 15) {
                        this.eqType = 3;
                        this.gc.isEditable = false;
                        this.gc.isVisible = false;
                        this.Si = this.D.p.Analyse("1");
                        this.Sf = this.D.p.Analyse("100");
                        try {
                            String[] stringArray2 = mjaStr.getTokens(this.gc.seqRange);
                            int n2 = 0;
                            if (stringArray2.length > 1) {
                                this.Si = this.D.p.Analyse(stringArray2[n2++].trim());
                                this.Sf = this.D.p.Analyse(stringArray2[n2++].trim());
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        this.eqType = 2;
                    }
                    this.fx = this.D.p.Analyse(stringArray[n++]);
                    this.fy = this.D.p.Analyse(stringArray[n++]);
                    return;
                }
                catch (Exception exception) {}
            } else {
                int n;
                for (n = 0; n < lineEq.length; ++n) {
                    if (!this.gc.formula.equals(lineEq[n])) continue;
                    this.eqType = 4;
                    return;
                }
                for (n = 0; n < conicEq.length; ++n) {
                    if (!this.gc.formula.equals(conicEq[n])) continue;
                    this.eqType = 5;
                    return;
                }
                if (this.gc.formula.length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(this.gc.formula, "=");
                    String string = stringTokenizer.nextToken();
                    if (string.equals("y") || string.equals("x")) {
                        this.F = this.D.p.Analyse(this.gc.formula.substring(this.gc.formula.indexOf(61) + 1, this.gc.formula.length()).trim());
                        if (string.equals("y") && !this.F.contains("y")) {
                            this.eqType = 6;
                            return;
                        }
                        if (string.equals("x") && !this.F.contains("x")) {
                            this.eqType = 7;
                            return;
                        }
                    }
                    this.eqType = 1;
                } else {
                    this.eqType = 1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void draw(Image image, Graphics[] graphicsArray) {
        if (this.cond.Evaluate(1.0) > 0.0 || this.eqType == 6 || this.eqType == 7) {
            Node node = this.D.p.Var("x");
            Node node2 = this.D.p.Var("y");
            Node node3 = node;
            synchronized (node3) {
                Node node4 = node2;
                synchronized (node4) {
                    double d = node.r;
                    double d2 = node2.r;
                    switch (this.eqType) {
                        case 0: {
                            this.drawSegment(image, graphicsArray);
                            break;
                        }
                        case 2: {
                            this.drawCurve(graphicsArray);
                            break;
                        }
                        case 3: {
                            this.drawSequence(graphicsArray);
                            break;
                        }
                        case 4: {
                            this.drawLine(graphicsArray);
                            break;
                        }
                        case 5: {
                            this.drawConic(graphicsArray);
                            break;
                        }
                        case 6: {
                            this.drawFunctionOfx(graphicsArray);
                            break;
                        }
                        case 7: {
                            this.drawFunctionOfy(graphicsArray);
                            break;
                        }
                        case 1: {
                            this.drawEquation(graphicsArray);
                        }
                    }
                    node.r = d;
                    node2.r = d2;
                }
            }
        }
    }

    static void Arc(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 < 0) {
            n5 += n6;
            n6 = -n6;
        }
        if (n == 1) {
            graphics.drawArc(n2 - n4, n3 - n4, 2 * n4, 2 * n4, n5, n6);
        } else if (n > 1) {
            double d = Math.PI / 180;
            double d2 = (double)n5 * d;
            int n7 = n2 + (int)Math.round((double)n4 * Math.cos(d2));
            int n8 = n3 - (int)Math.round((double)n4 * Math.sin(d2));
            for (int i = 1; i <= n6; ++i) {
                int n9 = n2 + (int)Math.round((double)n4 * Math.cos(d2));
                int n10 = n3 - (int)Math.round((double)n4 * Math.sin(d2));
                d2 += d;
                mjaGraph.Line(graphics, n, n7, n8, n9, n10);
                n7 = n9;
                n8 = n10;
            }
        }
    }

    static void Line(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n == 1) {
            graphics.drawLine(n2, n3, n4, n5);
        } else if (n > 1) {
            R2 r2 = new R2(n4 - n2, n5 - n3);
            int n6 = (int)Math.round(r2.norm() * 3.0 / 2.0);
            r2.div(n6);
            int n7 = n / 2;
            double d = n2;
            double d2 = n3;
            for (int i = 0; i <= n6; ++i) {
                if (n == 2) {
                    graphics.fillRect((int)Math.round(d) - n7, (int)Math.round(d2) - n7, n, n);
                    d += r2.x;
                    d2 += r2.y;
                    continue;
                }
                graphics.fillOval((int)Math.round(d) - n7, (int)Math.round(d2) - n7, n, n);
                d += r2.x;
                d2 += r2.y;
            }
        }
    }

    static void circle(Graphics graphics, int n, int n2, double d) {
        graphics.drawLine(n - (int)Math.round(d), n2, n + (int)Math.round(d), n2);
        if (d > 0.0) {
            double d2 = d;
            double d3 = d;
            double d4 = 1.0 + (d2 + d3) / 16.0;
            double d5 = d2 * d2 / d4;
            double d6 = (4.0 * (d3 * d3 - d3) + 1.0) / d4;
            double d7 = d6 * (1.0 - 4.0 * d2);
            double d8 = 8.0 * d6;
            double d9 = 32.0 * d5;
            double d10 = 4.0 * d6 * (1.0 - 2.0 * d2);
            double d11 = 16.0 * d5;
            int n3 = (int)Math.round(d2);
            int n4 = 0;
            ++n4;
            d7 += d11;
            d11 += d9;
            boolean bl = false;
            while (true) {
                if (d7 <= 0.0) {
                    if (!bl) {
                        graphics.drawLine(n - n3, n2 - n4, n + n3, n2 - n4);
                        graphics.drawLine(n - n3, n2 + n4, n + n3, n2 + n4);
                    } else {
                        bl = false;
                    }
                    ++n4;
                    d7 += d11;
                    d11 += d9;
                    continue;
                }
                while (d7 > 0.0 && n3 > 0) {
                    d7 += d10;
                    d10 += d8;
                    graphics.drawLine(n - --n3, n2 - n4, n + n3, n2 - n4);
                    graphics.drawLine(n - n3, n2 + n4, n + n3, n2 + n4);
                }
                bl = true;
                if (n3 <= 0) break;
            }
        }
    }

    static void drawPolygon(Component component, Graphics[] graphicsArray, int n, Polygon polygon, boolean bl, Color color) {
        int n2;
        if (bl) {
            for (n2 = 0; n2 < graphicsArray.length; ++n2) {
                Color color2 = graphicsArray[n2].getColor();
                graphicsArray[n2].setColor(data.adaptColor(component, color));
                graphicsArray[n2].fillPolygon(polygon);
                graphicsArray[n2].setColor(data.adaptColor(component, color2));
            }
        }
        for (n2 = 0; n2 < graphicsArray.length; ++n2) {
            for (int i = 1; i < polygon.npoints; ++i) {
                mjaGraph.Line(graphicsArray[n2], n, polygon.xpoints[i - 1], polygon.ypoints[i - 1], polygon.xpoints[i], polygon.ypoints[i]);
            }
        }
    }

    void drawSegment(Image image, Graphics[] graphicsArray) {
        if (this.segType == 66) {
            this.drawArc(graphicsArray);
        } else if (this.xNa.length <= 2) {
            R2 r2 = new R2(0.0, 0.0);
            try {
                int n;
                R2 r22;
                R2 r23 = r22 = new R2(this.xNa[0].Evaluate(), this.yNa[0].Evaluate());
                if (this.segType == 65 || this.segType == 46) {
                    r23 = new R2(this.xNa[1].Evaluate(), this.yNa[1].Evaluate());
                }
                if (this.segType != 63) {
                    r22 = this.D.cs.projection(r22);
                    r23 = this.D.cs.projection(r23);
                }
                if (r22.ix() != r23.ix() || r22.iy() != r23.iy()) {
                    for (n = 0; n < graphicsArray.length; ++n) {
                        mjaGraph.Line(graphicsArray[n], this.width, r22.ix(), r22.iy(), r23.ix(), r23.iy());
                    }
                }
                if (this.segType != 63 && this.size > 0) {
                    if (this.gc.type == 46) {
                        for (n = 0; n < graphicsArray.length; ++n) {
                            this.drawArrow(graphicsArray[n], this.gc.arrowColor, this.gc.gcolor, r22.ix(), r22.iy(), r23.ix(), r23.iy(), this.width, this.spear);
                        }
                    } else if (this.gc.type == 43) {
                        n = r22.ix();
                        int n2 = r22.iy();
                        int n3 = image.getWidth(this.D.cs);
                        int n4 = image.getHeight(this.D.cs);
                        if (0 <= n && 0 <= n2 && n < n3 && n2 < n4) {
                            int[] nArray = mjaGui.grabPixelsFromImage(this.D.cs, image);
                            mjaGui.fillShape(graphicsArray, nArray, n3, n4, n, n2);
                        }
                    } else {
                        for (n = 0; n < graphicsArray.length; ++n) {
                            if (this.D.cs.inside(r22)) {
                                mjaGraph.circle(graphicsArray[n], r22.ix(), r22.iy(), this.size);
                            }
                            if (r22.ix() == r23.ix() && r22.iy() == r23.iy() || !this.D.cs.inside(r23)) continue;
                            mjaGraph.circle(graphicsArray[n], r23.ix(), r23.iy(), this.size);
                        }
                    }
                }
                r2 = new R2((2 * r22.ix() + r23.ix()) / 3 + this.size + 1, (2 * r22.iy() + r23.iy()) / 3 - this.size - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.drawText(r2, graphicsArray);
        } else {
            Polygon polygon = new Polygon();
            try {
                for (int i = 0; i < this.xNa.length; ++i) {
                    R2 r2 = this.D.cs.projection(new R2(this.xNa[i].Evaluate(), this.yNa[i].Evaluate()));
                    polygon.addPoint(r2.ix(), r2.iy());
                }
                mjaGraph.drawPolygon(this.D, graphicsArray, this.width, polygon, this.gc.hasFill, this.gc.fillColor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void drawArc(Graphics[] graphicsArray) {
        R2 r2 = new R2(0.0, 0.0);
        try {
            Object object;
            R2 r22 = this.D.cs.projection(new R2(this.xNa[0].Evaluate(), this.yNa[0].Evaluate()));
            int n = (int)Math.round(this.D.cs.esc * this.r.Evaluate());
            int n2 = 0;
            int n3 = 360;
            if (this.aN != null && this.daN != null) {
                n2 = (int)Math.round(this.aN.Evaluate());
                n3 = (int)Math.round(this.daN.Evaluate());
            } else {
                R2 r23 = this.D.cs.projection(new R2(this.x1.Evaluate(), this.y1.Evaluate()));
                object = this.D.cs.projection(new R2(this.x2.Evaluate(), this.y2.Evaluate()));
                r23.sub(r22);
                r23.normalize();
                ((R2)object).sub(r22);
                ((R2)object).normalize();
                n2 = (int)Math.round(180.0 * Math.asin(-r23.y) / Math.PI);
                if (r23.x < 0.0) {
                    n2 = 180 - n2;
                }
                while (n2 < 0) {
                    n2 += 360;
                }
                while (n2 > 360) {
                    n2 -= 360;
                }
                double d = r23.dot((R2)object);
                n3 = (int)Math.round(180.0 * Math.acos(d) / Math.PI);
                if (r23.det((R2)object) > 0.0) {
                    n3 = -n3;
                }
            }
            if (Math.abs((double)n * (double)n3 * Math.PI / 180.0) >= 1.0 && Math.abs((double)n - r22.norm()) < 4096.0) {
                if (n3 < 0) {
                    n2 += n3;
                    n3 = -n3;
                }
                if (this.gc.hasFill) {
                    for (int i = 0; i < graphicsArray.length; ++i) {
                        object = graphicsArray[i].getColor();
                        graphicsArray[i].setColor(data.adaptColor(this.D, this.gc.fillColor));
                        graphicsArray[i].fillArc(r22.ix() - n, r22.iy() - n, 2 * n, 2 * n, n2, n3);
                        graphicsArray[i].setColor(data.adaptColor(this.D, (Color)object));
                    }
                }
                for (int i = 0; i < graphicsArray.length; ++i) {
                    mjaGraph.Arc(graphicsArray[i], this.width, r22.ix(), r22.iy(), n, n2, n3);
                }
            }
            r2 = r22;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.drawText(r2, graphicsArray);
    }

    void drawText(R2 r2, Graphics[] graphicsArray) {
        if (this.D.cs.inside(r2) || this.segType == 63) {
            for (int i = 0; i < graphicsArray.length; ++i) {
                graphicsArray[i].setFont(this.gc.font);
                FontMetrics fontMetrics = graphicsArray[i].getFontMetrics(this.gc.font);
                for (int j = 0; j < this.pstr.length; ++j) {
                    String string = "";
                    int n = 0;
                    if (this.segType == 63) {
                        n = 4 + fontMetrics.getAscent();
                    }
                    n += j * fontMetrics.getHeight();
                    int n2 = (int)Math.round(this.decimals.Evaluate(2.0));
                    for (int k = 0; k < this.pstr[j].size(); ++k) {
                        Node node = (Node)this.pstr[j].elementAt(k);
                        String string2 = node.toString(n2, this.D.language);
                        string = string + string2;
                    }
                    graphicsArray[i].drawString(string, r2.ix() + this.size, n + r2.iy() - this.size);
                }
            }
        }
    }

    private void drawArrow(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 < 0) {
            n5 = 6;
        }
        n5 = 2 * ((n5 + 1) / 2);
        if (n6 < 0) {
            n6 = n5;
        }
        n6 = 2 * ((n6 + 1) / 2);
        int n7 = n3 - n;
        int n8 = n4 - n2;
        double d = Math.sqrt(n7 * n7 + n8 * n8);
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = Math.acos((double)n7 / d);
        }
        if (n8 < 0) {
            d2 = Math.PI * 2 - d2;
        }
        graphics.setColor(data.adaptColor(this.D, color));
        graphics.fillPolygon(mjaGraph.flecha(n, n2, n5, n6, d, d2));
        graphics.setColor(data.adaptColor(this.D, color2));
        graphics.drawPolygon(mjaGraph.flecha(n, n2, n5, n6, d, d2));
    }

    private static Polygon flecha(int n, int n2, double d, double d2, double d3, double d4) {
        R2[] r2Array = new R2[]{new R2(-d / 2.0, d / 2.0), new R2(d3 - d - d2, d / 2.0), new R2(d3 - 2.0 * d2, d2 + d / 2.0), new R2(d3, 0.0), new R2(d3 - 2.0 * d2, -d2 - d / 2.0), new R2(d3 - d - d2, -d / 2.0), new R2(-d / 2.0, -d / 2.0)};
        int[] nArray = new int[r2Array.length];
        int[] nArray2 = new int[r2Array.length];
        for (int i = 0; i < r2Array.length; ++i) {
            r2Array[i].rot(-d4);
            nArray[i] = n + (int)Math.round(r2Array[i].x);
            nArray2[i] = n2 - (int)Math.round(r2Array[i].y);
        }
        return new Polygon(nArray, nArray2, r2Array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawCurve(Graphics[] graphicsArray) {
        if (this.tparz != null) {
            R2 r2 = new R2(0.0, 0.0);
            boolean bl = true;
            int n = (int)Math.round(this.tparz.NN.Evaluate(32.0));
            double d = this.tparz.Ni.Evaluate(0.0);
            double d2 = this.tparz.Nf.Evaluate(1.0);
            Polygon polygon = new Polygon();
            try {
                Node node;
                Node node2 = node = this.D.p.Var(this.tparz.name);
                synchronized (node2) {
                    double d3 = node.r;
                    for (int i = 0; i <= n; ++i) {
                        node.r = d + (d2 - d) * (double)i / (double)n;
                        R2 r22 = this.D.cs.projection(new R2(this.fx.Evaluate(), this.fy.Evaluate()));
                        polygon.addPoint(r22.ix(), r22.iy());
                    }
                    mjaGraph.drawPolygon(this.D, graphicsArray, this.width, polygon, this.gc.hasFill, this.gc.fillColor);
                    node.r = d3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawSequence(Graphics[] graphicsArray) {
        Node node;
        int n = (int)Math.round(this.Si.Evaluate(1.0));
        int n2 = (int)Math.round(this.Sf.Evaluate(1.0));
        Node node2 = node = this.D.p.Var("n");
        synchronized (node2) {
            double d = node.r;
            for (int i = n; i <= n2; ++i) {
                node.r = i;
                if (!(this.cond.Evaluate(1.0) > 0.0)) continue;
                try {
                    R2 r2 = this.D.cs.projection(new R2(this.fx.Evaluate(), this.fy.Evaluate()));
                    for (int j = 0; j < graphicsArray.length; ++j) {
                        mjaGraph.circle(graphicsArray[j], r2.ix(), r2.iy(), this.size);
                    }
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            node.r = d;
        }
    }

    private void drawLine(Graphics[] graphicsArray) {
        double d;
        double d2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.gc.formula.equals(lineEq[0])) {
            d2 = this.D.p.value("m");
            d = this.D.cs.esc * this.D.p.value("b");
            n = 0;
            n2 = this.D.cs.Oy - (int)Math.round(d + d2 * (double)(n - this.D.cs.Ox));
            n3 = this.D.cs.w;
            n4 = this.D.cs.Oy - (int)Math.round(d + d2 * (double)(n3 - this.D.cs.Ox));
        }
        if (this.gc.formula.equals(lineEq[1])) {
            d2 = this.D.p.value("m");
            d = this.D.cs.esc * this.D.p.value("a");
            n2 = 0;
            n = this.D.cs.Ox + (int)Math.round(d2 * (double)(n2 - this.D.cs.Oy) + d);
            n4 = this.D.cs.h;
            n3 = this.D.cs.Ox + (int)Math.round(d2 * (double)(n4 - this.D.cs.Oy) + d);
        } else if (this.gc.formula.equals(lineEq[2])) {
            double d3;
            double d4;
            d2 = this.D.p.value("A");
            d = this.D.p.value("B");
            double d5 = this.D.p.value("C");
            if (Math.abs(d) > Math.abs(d2)) {
                d4 = -d2 / d;
                d3 = d5 / d * this.D.cs.esc;
                n = 0;
                n2 = this.D.cs.Oy - (int)Math.round(d3 + d4 * (double)(n - this.D.cs.Ox));
                n3 = this.D.cs.w;
                n4 = this.D.cs.Oy - (int)Math.round(d3 + d4 * (double)(n3 - this.D.cs.Ox));
            } else if (Math.abs(d2) > 0.01) {
                d4 = -d / d2;
                d3 = -(d5 / d2) * this.D.cs.esc;
                n2 = 0;
                n = this.D.cs.Ox - (int)Math.round(d3 + d4 * (double)(n2 - this.D.cs.Oy));
                n4 = this.D.cs.h;
                n3 = this.D.cs.Ox - (int)Math.round(d3 + d4 * (double)(n4 - this.D.cs.Oy));
            } else {
                return;
            }
        }
        for (int i = 0; i < graphicsArray.length; ++i) {
            mjaGraph.Line(graphicsArray[i], this.width, n, n2, n3, n4);
        }
    }

    private void drawConic(Graphics[] graphicsArray) {
        double d;
        double d2;
        this.g = graphicsArray;
        boolean bl = false;
        this.w = this.D.cs.w;
        this.h = this.D.cs.h;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 0.0;
        R2 r2 = this.D.cs.projection(new R2(this.D.p.value("Fx"), this.D.p.value("Fy")));
        if (this.gc.formula.equals(conicEq[0])) {
            d4 = this.D.p.value("e");
            if (d4 > 20.0) {
                return;
            }
            d3 = this.D.cs.esc * this.D.p.value("d");
            d5 = this.D.p.value("t");
            bl = false;
        } else if (this.gc.formula.equals(conicEq[1])) {
            R2 r22 = this.D.cs.projection(new R2(this.D.p.value("Dx"), this.D.p.value("Dy")));
            R2 r23 = this.D.cs.projection(new R2(this.D.p.value("Px"), this.D.p.value("Py")));
            d3 = r22.distance(r2);
            d2 = r23.distance(r2);
            d = r23.distance(r22);
            if (d < 0.1 || d2 < 0.1 || d3 < 0.1) {
                return;
            }
            double d6 = r2.y - r22.y;
            double d7 = r2.x - r22.x;
            if (d7 == 0.0) {
                d5 = d6 >= 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            } else {
                d5 = Math.atan(-d6 / d7);
                if (d7 < 0.0) {
                    d5 += Math.PI;
                }
            }
            r23.sub(r2);
            r22.sub(r2);
            d4 = (d3 - r22.dot(r23) / d3) / d2;
            if (d4 < 0.05) {
                return;
            }
            d4 = 1.0 / d4;
            bl = false;
        }
        this.Fx = r2.ix();
        this.Fy = r2.iy();
        this.doDrawConic(d3, d4, d5);
        if (bl && d4 > 1.0) {
            double d8 = d4 * d4;
            d2 = d3 + d3;
            d = 1.0E16 / d8;
            if ((d8 - 1.0) / d2 > 1.0E-16) {
                d = d8 * d2 / (d8 - 1.0);
            }
            r2.x -= d * Math.cos(d5);
            r2.y += d * Math.sin(d5);
            this.Fx = r2.ix();
            this.Fy = r2.iy();
            this.doDrawConic(d3, d4, d5 + Math.PI);
        }
    }

    private void Plot(int n, int n2) {
        for (int i = 0; i < this.g.length; ++i) {
            mjaGraph.Line(this.g[i], this.width, n, n2, n, n2);
        }
    }

    private void Pon() {
        switch (this.caso) {
            case 0: {
                this.Plot(this.Fx + this.x, this.Fy + this.y);
                break;
            }
            case 1: {
                this.Plot(this.Fx + this.y, this.Fy - this.x);
                break;
            }
            case 2: {
                this.Plot(this.Fx - this.x, this.Fy - this.y);
                break;
            }
            case 3: {
                this.Plot(this.Fx - this.y, this.Fy + this.x);
            }
        }
    }

    private void Dx() {
        this.x += this.dx;
        this.z += this.zx;
        this.zx += this.zxx;
        this.zy += this.zxy;
    }

    private void Dy() {
        this.y += this.dy;
        this.z += this.zy;
        this.zy += this.zyy;
        this.zx += this.zxy;
    }

    private void loop() {
        if (Math.abs(this.z + this.zy) < Math.abs(this.z + this.zx)) {
            this.Dy();
            if (Math.abs(this.z) >= Math.abs(this.z + this.zx)) {
                this.Dx();
            }
        } else {
            this.Dx();
            if (Math.abs(this.z) >= Math.abs(this.z + this.zy)) {
                this.Dy();
            }
        }
        this.Pon();
    }

    private void doDrawConic(double d, double d2, double d3) {
        double d4;
        boolean bl = d2 < 1.0;
        boolean bl2 = d2 > 1.0;
        for (d4 = d3; d4 < 0.0; d4 += Math.PI * 2) {
        }
        while (d4 >= Math.PI * 2) {
            d4 -= Math.PI * 2;
        }
        this.caso = 0;
        while (d4 >= 1.5707963267948966) {
            d4 -= 1.5707963267948966;
            ++this.caso;
        }
        if (d4 > 1.5706963267948966) {
            d4 = 0.0;
            this.caso = (this.caso + 1) % 4;
        }
        if (d4 < 1.0E-4) {
            d4 = 0.0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.w;
        int n4 = this.h;
        switch (this.caso) {
            case 0: {
                n = -this.Fx;
                n2 = -this.Fy;
                n3 = this.w - this.Fx;
                n4 = this.h - this.Fy;
                break;
            }
            case 1: {
                n = this.Fy - this.h;
                n2 = -this.Fx;
                n3 = this.Fy;
                n4 = this.w - this.Fx;
                break;
            }
            case 2: {
                n = this.Fx - this.w;
                n2 = this.Fy - this.h;
                n3 = this.Fx;
                n4 = this.Fy;
                break;
            }
            case 3: {
                n = -this.Fy;
                n2 = this.Fx - this.w;
                n3 = this.h - this.Fy;
                n4 = this.Fx;
            }
        }
        double d5 = Math.cos(d4);
        double d6 = -Math.sin(d4);
        double d7 = d * d2 / (1.0 + d2);
        double d8 = d2 * d2 * 32767.0;
        this.x = -((int)Math.round(d7 * d5));
        this.y = -((int)Math.round(d7 * d6));
        int n5 = (int)Math.round(32767.0 - d8 * d5 * d5);
        int n6 = (int)Math.round(32767.0 - d8 * d6 * d6);
        int n7 = -((int)Math.round((d8 *= 2.0) * d5 * d6));
        int n8 = n5 * (this.x + this.x + 1) + n7 * this.y - (int)Math.round((d8 *= d) * d5);
        int n9 = n6 * (this.y + this.y + 1) + n7 * this.x - (int)Math.round(d8 * d6);
        this.zxx = 2 * n5;
        this.zyy = 2 * n6;
        int n10 = this.x;
        int n11 = this.y;
        this.Pon();
        this.z = 0;
        this.dx = 1;
        this.zx = n8;
        this.dy = 1;
        this.zy = n9;
        this.zxy = n7;
        do {
            this.loop();
        } while (this.zx <= 0 && this.x <= n3 && (!bl2 || this.y <= n4));
        if (this.zx > 0) {
            this.dy = -1;
            this.zy = this.zyy - this.zy;
            this.zxy = -n7;
            do {
                this.loop();
            } while (this.x <= n3 && (bl || this.y >= n2) && (!bl || this.zy <= 0));
        }
        this.x = n10;
        this.y = n11;
        this.dx = -1;
        this.zx = this.zxx - n8;
        this.dy = -1;
        this.zy = this.zyy - n9;
        this.zxy = n7;
        this.z = 0;
        do {
            this.loop();
        } while (this.zy <= 0 && this.y >= n2 && (!bl2 || this.x >= n));
        if (this.zy > 0) {
            this.dx = 1;
            this.zx = this.zxx - this.zx;
            this.zxy = -n7;
            do {
                this.loop();
            } while (this.x <= n3 && (bl || this.y >= n2) && (!bl || this.zx <= 0));
        }
        if (bl && this.x < n3) {
            this.dx = 1;
            this.dy = 1;
            this.zy = this.zyy - this.zy;
            this.zxy = n7;
            do {
                this.loop();
            } while (this.zy <= 0 && this.x <= n3 && this.y <= n4);
        }
    }

    static R2 extrapolate(Node node, Node node2, Node node3, double d, double d2) {
        double d3 = node2.r;
        double d4 = d2 / 2.0;
        double d5 = 0.0;
        double d6 = d;
        while (Math.abs(d4) > 1.0E-12) {
            node2.r += d4;
            boolean bl = true;
            if (node.Evaluate(1.0) > 0.0) {
                try {
                    double d7 = d6;
                    d6 = node3.Evaluate();
                    R2 r2 = new R2(Math.min(d7, d6), Math.max(d7, d6));
                    if (mjaGraph.hasSingularity(Math.abs(d2), node2, node3, node2.r - d4, d7, node2.r, d6, r2)) {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl) {
                d5 += d4;
            } else {
                node2.r -= d4;
            }
            d4 /= 2.0;
        }
        node2.r = d3;
        return new R2(d5 / Math.abs(d2), d6);
    }

    static boolean hasSingularity(double d, Node node, Node node2, double d2, double d3, double d4, double d5, R2 r2) {
        if (Math.abs(d4 - d2) < 1.0E-12 || Math.abs(d4 - d2) < 1.0E-8 && Math.abs(d5 - d3) > Math.abs(d)) {
            return true;
        }
        boolean bl = false;
        double d6 = node.r;
        try {
            node.r = (d2 + d4) / 2.0;
            double d7 = node2.Evaluate();
            if (r2.x <= d7 && d7 <= r2.y) {
                bl = false;
            } else {
                r2.x = Math.min(r2.x, d7);
                r2.y = Math.max(r2.y, d7);
                bl = mjaGraph.hasSingularity(d, node, node2, d2, d3, node.r, d7, r2) || mjaGraph.hasSingularity(d, node, node2, node.r, d7, d4, d5, r2);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        node.r = d6;
        return bl;
    }

    private void drawFunctionOfx(Graphics[] graphicsArray) {
        boolean bl = false;
        R2 r2 = new R2(this.D.cs.Ox, this.D.cs.Oy);
        int n = r2.iy();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 1.0 / this.D.cs.esc;
        Node node = this.D.p.Var("x");
        node.r = -d * (double)this.D.cs.Ox;
        double d2 = 0.0;
        while (n4 < this.D.cs.w) {
            int n6;
            boolean bl2 = true;
            if (this.cond.Evaluate(1.0) > 0.0) {
                try {
                    double d3 = this.F.Evaluate();
                    if (bl) {
                        double d4;
                        double d5 = Math.min(d2, d3);
                        R2 r22 = new R2(d5, d4 = Math.max(d2, d3));
                        if (!mjaGraph.hasSingularity(d, node, this.F, node.r - d, d2, node.r, d3, r22)) {
                            if (d2 <= d3) {
                                d2 = r22.x;
                                d3 = r22.y;
                            } else {
                                d3 = r22.x;
                                d2 = r22.y;
                            }
                            int n7 = this.D.cs.YY(this.width, d2);
                            n2 = this.D.cs.YY(this.width, d3);
                            for (int i = 0; i < graphicsArray.length; ++i) {
                                if (this.gc.hasFillminus && n2 > n) {
                                    graphicsArray[i].setColor(data.adaptColor(this.D, this.gc.fillminusColor));
                                    mjaGraph.Line(graphicsArray[i], this.width, n4, n + 1, n4, n2);
                                    graphicsArray[i].setColor(data.adaptColor(this.D, this.gc.gcolor));
                                }
                                if (this.gc.hasFillplus && n2 < n) {
                                    graphicsArray[i].setColor(data.adaptColor(this.D, this.gc.fillplusColor));
                                    mjaGraph.Line(graphicsArray[i], this.width, n4, n - 1, n4, n2);
                                    graphicsArray[i].setColor(data.adaptColor(this.D, this.gc.gcolor));
                                }
                                mjaGraph.Line(graphicsArray[i], this.width, n5, n3, n5, n7);
                                mjaGraph.Line(graphicsArray[i], this.width, n5, n7, n4, n2);
                            }
                        } else {
                            double d6 = node.r;
                            node.r -= d;
                            R2 r23 = mjaGraph.extrapolate(this.cond, node, this.F, d2, d);
                            n2 = this.D.cs.YY(this.width, r23.y);
                            for (int i = 0; i < graphicsArray.length; ++i) {
                                mjaGraph.Line(graphicsArray[i], this.width, n5, n3, n5 + (int)Math.round(r23.x), n2);
                            }
                            node.r = d6;
                            R2 r24 = mjaGraph.extrapolate(this.cond, node, this.F, d3, -d);
                            n3 = this.D.cs.YY(this.width, r24.y);
                            n2 = this.D.cs.YY(this.width, d3);
                            for (int i = 0; i < graphicsArray.length; ++i) {
                                mjaGraph.Line(graphicsArray[i], this.width, n4 + (int)Math.round(r24.x), n3, n4, n2);
                            }
                        }
                    } else {
                        R2 r25 = mjaGraph.extrapolate(this.cond, node, this.F, d3, -d);
                        n3 = this.D.cs.YY(this.width, r25.y);
                        n2 = this.D.cs.YY(this.width, d3);
                        for (n6 = 0; n6 < graphicsArray.length; ++n6) {
                            mjaGraph.Line(graphicsArray[n6], this.width, n4 + (int)Math.round(r25.x), n3, n4, n2);
                        }
                    }
                    d2 = d3;
                }
                catch (Exception exception) {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
            if (bl && !bl2) {
                double d7 = node.r;
                node.r -= d;
                R2 r26 = mjaGraph.extrapolate(this.cond, node, this.F, d2, d);
                n2 = this.D.cs.YY(this.width, r26.y);
                for (n6 = 0; n6 < graphicsArray.length; ++n6) {
                    mjaGraph.Line(graphicsArray[n6], this.width, n5, n3, n5 + (int)Math.round(r26.x), n2);
                }
                node.r = d7;
            }
            bl = bl2;
            node.r += d;
            n3 = n2;
            n5 = n4++;
        }
    }

    private void drawFunctionOfy(Graphics[] graphicsArray) {
        int n = this.D.cs.getSize().width;
        boolean bl = false;
        R2 r2 = new R2(this.D.cs.Ox, this.D.cs.Oy);
        int n2 = r2.ix();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d = 1.0 / this.D.cs.esc;
        Node node = this.D.p.Var("y");
        node.r = d * (double)this.D.cs.Oy;
        double d2 = 0.0;
        while (n3 < this.D.cs.h) {
            int n7;
            boolean bl2 = true;
            if (this.cond.Evaluate(1.0) > 0.0) {
                try {
                    double d3 = this.F.Evaluate();
                    if (bl) {
                        double d4;
                        double d5 = Math.min(d2, d3);
                        R2 r22 = new R2(d5, d4 = Math.max(d2, d3));
                        if (!mjaGraph.hasSingularity(d, node, this.F, node.r + d, d2, node.r, d3, r22)) {
                            if (d2 <= d3) {
                                d2 = r22.x;
                                d3 = r22.y;
                            } else {
                                d3 = r22.x;
                                d2 = r22.y;
                            }
                            int n8 = this.D.cs.XX(this.width, d2);
                            n5 = this.D.cs.XX(this.width, d3);
                            for (int i = 0; i < graphicsArray.length; ++i) {
                                if (this.gc.hasFillplus && n5 > n2) {
                                    graphicsArray[i].setColor(data.adaptColor(this.D, this.gc.fillplusColor));
                                    mjaGraph.Line(graphicsArray[i], this.width, n2 + 1, n3, n5, n3);
                                    graphicsArray[i].setColor(data.adaptColor(this.D, this.gc.gcolor));
                                }
                                if (this.gc.hasFillminus && n5 < n2) {
                                    graphicsArray[i].setColor(data.adaptColor(this.D, this.gc.fillminusColor));
                                    mjaGraph.Line(graphicsArray[i], this.width, n2 - 1, n3, n5, n3);
                                    graphicsArray[i].setColor(data.adaptColor(this.D, this.gc.gcolor));
                                }
                                mjaGraph.Line(graphicsArray[i], this.width, n6, n4, n8, n4);
                                mjaGraph.Line(graphicsArray[i], this.width, n8, n4, n5, n3);
                            }
                        } else {
                            double d6 = node.r;
                            node.r += d;
                            R2 r23 = mjaGraph.extrapolate(this.cond, node, this.F, d2, -d);
                            n5 = this.D.cs.XX(this.width, r23.y);
                            for (int i = 0; i < graphicsArray.length; ++i) {
                                mjaGraph.Line(graphicsArray[i], this.width, n6, n4, n5, n3 + (int)Math.round(r23.x));
                            }
                            node.r = d6;
                            R2 r24 = mjaGraph.extrapolate(this.cond, node, this.F, d3, d);
                            n6 = this.D.cs.XX(this.width, r24.y);
                            n5 = this.D.cs.XX(this.width, d3);
                            for (int i = 0; i < graphicsArray.length; ++i) {
                                mjaGraph.Line(graphicsArray[i], this.width, n6, n4 + (int)Math.round(r24.x), n5, n3);
                            }
                        }
                    } else {
                        R2 r25 = mjaGraph.extrapolate(this.cond, node, this.F, d3, d);
                        n6 = this.D.cs.XX(this.width, r25.y);
                        n5 = this.D.cs.XX(this.width, d3);
                        for (n7 = 0; n7 < graphicsArray.length; ++n7) {
                            mjaGraph.Line(graphicsArray[n7], this.width, n6, n4 + (int)Math.round(r25.x), n5, n3);
                        }
                    }
                    d2 = d3;
                }
                catch (Exception exception) {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
            if (bl && !bl2) {
                double d7 = node.r;
                node.r += d;
                R2 r26 = mjaGraph.extrapolate(this.cond, node, this.F, d2, -d);
                n5 = this.D.cs.XX(this.width, r26.y);
                for (n7 = 0; n7 < graphicsArray.length; ++n7) {
                    mjaGraph.Line(graphicsArray[n7], this.width, n6, n4, n5, n3 + (int)Math.round(r26.x));
                }
                node.r = d7;
            }
            bl = bl2;
            node.r -= d;
            n6 = n5;
            n4 = n3++;
        }
    }

    private void drawEquation(Graphics[] graphicsArray) {
        try {
            int n;
            R2Newton r2Newton = new R2Newton(this.D.p, this.gc.formula);
            int n2 = this.D.cs.w / 16;
            if (n2 < 3) {
                n2 = 3;
            }
            if ((n = this.D.cs.h / 16) < 3) {
                n = 3;
            }
            boolean[][] blArray = new boolean[this.D.cs.w][this.D.cs.h];
            R2 r2 = new R2();
            R2 r22 = new R2();
            R2 r23 = new R2();
            for (int i = n / 2; i < this.D.cs.h; i += n) {
                block3: for (int j = n2 / 2; j < this.D.cs.w; j += n2) {
                    R2 r24 = r2Newton.findZero(this.D.cs.injection(j, i));
                    R2 r25 = this.D.cs.projection(r24);
                    int n3 = r25.ix();
                    int n4 = r25.iy();
                    if (n3 < 0 || n3 >= this.D.cs.w || n4 < 0 || n4 >= this.D.cs.h || blArray[n3][n4]) continue;
                    blArray[n3][n4] = true;
                    if (r2Newton.rangeOK()) {
                        for (int k = 0; k < graphicsArray.length; ++k) {
                            mjaGraph.Line(graphicsArray[k], this.width, n3, n4, n3, n4);
                        }
                    }
                    r2.x = r24.x;
                    r2.y = r24.y;
                    r22.x = r24.x;
                    r22.y = r24.y;
                    R2 r26 = r2Newton.getUnitNormal();
                    if (r26.x == 0.0 && r26.y == 0.0) continue;
                    r26.rotL90();
                    r23.x = r26.x;
                    r23.y = r26.y;
                    int n5 = 0;
                    int n6 = 0;
                    boolean bl = false;
                    while (n6 < 2) {
                        if (bl) {
                            r23.x = -r26.x;
                            r23.y = -r26.y;
                            r24.x = r2.x;
                            r24.y = r2.y;
                            r22.x = r24.x;
                            r22.y = r24.y;
                            r25 = this.D.cs.projection(r24);
                            n3 = r25.ix();
                            n4 = r25.iy();
                            bl = false;
                            n5 = 0;
                        }
                        r24.x += r23.x / this.D.cs.esc;
                        r24.y += r23.y / this.D.cs.esc;
                        r24 = r2Newton.findZero(r24);
                        r23.x = r24.x - r22.x;
                        r23.y = r24.y - r22.y;
                        r23.normalize();
                        if (r23.x == 0.0 && r23.y == 0.0) continue block3;
                        r22.x = r24.x;
                        r22.y = r24.y;
                        r25 = this.D.cs.projection(r24);
                        int n7 = r25.ix();
                        int n8 = r25.iy();
                        if (n7 != n3 || n8 != n4) {
                            n3 = n7;
                            n4 = n8;
                            if (0 <= n3 && n3 < this.D.cs.w && 0 <= n4 && n4 < this.D.cs.h) {
                                n5 = 0;
                                if (blArray[n3][n4]) continue block3;
                                blArray[n3][n4] = true;
                                if (!r2Newton.rangeOK()) continue;
                                for (int k = 0; k < graphicsArray.length; ++k) {
                                    mjaGraph.Line(graphicsArray[k], this.width, n3, n4, n3, n4);
                                }
                                continue;
                            }
                            bl = true;
                            ++n6;
                            continue;
                        }
                        if (++n5 <= 4) continue;
                        bl = true;
                        ++n6;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

