/*
 * Decompiled with CFR 0.152.
 */
package com.mja.math3D;

public class R3 {
    public static final double epsilon = 1.0E-8;
    public double x;
    public double y;
    public double z;

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public R3(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public R3 cloneR3() {
        return new R3(this.x, this.y, this.z);
    }

    public void add(R3 r3) {
        this.x += r3.x;
        this.y += r3.y;
        this.z += r3.z;
    }

    public void subtract(R3 r3) {
        this.x -= r3.x;
        this.y -= r3.y;
        this.z -= r3.z;
    }

    public void rotX(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.y;
        this.y = this.y * d2 - this.z * d3;
        this.z = d4 * d3 + this.z * d2;
    }

    public void rotY(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.z;
        this.z = this.z * d2 - this.x * d3;
        this.x = d4 * d3 + this.x * d2;
    }

    public void rotZ(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.x;
        this.x = this.x * d2 - this.y * d3;
        this.y = d4 * d3 + this.y * d2;
    }

    public boolean equals(R3 r3) {
        return this.x == r3.x && this.y == r3.y && this.z == r3.z;
    }

    public boolean almostEquals(R3 r3) {
        return this.equals(r3, 1.0E-8);
    }

    public boolean equals(R3 r3, double d) {
        return Math.abs(this.x - r3.x) <= d && Math.abs(this.y - r3.y) <= d && Math.abs(this.z - r3.z) <= d;
    }

    public double Norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public R3 Negative() {
        return new R3(-this.x, -this.y, -this.z);
    }

    public R3 Add(R3 r3) {
        return new R3(this.x + r3.x, this.y + r3.y, this.z + r3.z);
    }

    public R3 Subtract(R3 r3) {
        return new R3(this.x - r3.x, this.y - r3.y, this.z - r3.z);
    }

    public R3 ScalarProduct(double d) {
        return new R3(d * this.x, d * this.y, d * this.z);
    }

    public R3 CrossProduct(R3 r3) {
        return new R3(this.y * r3.z - this.z * r3.y, this.z * r3.x - this.x * r3.z, this.x * r3.y - this.y * r3.x);
    }

    public double DotProduct(R3 r3) {
        return this.x * r3.x + this.y * r3.y + this.z * r3.z;
    }

    public static double DotProduct(R3 r3, R3 r32) {
        return r3.x * r32.x + r3.y * r32.y + r3.z * r32.z;
    }

    public static double Determinant(R3 r3, R3 r32, R3 r33) {
        return r3.DotProduct(r32.CrossProduct(r33));
    }

    public R3 RotX(double d) {
        R3 r3 = new R3(this.x, this.y, this.z);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        r3.y = this.y * d2 - this.z * d3;
        r3.z = this.y * d3 + this.z * d2;
        return r3;
    }

    public R3 RotY(double d) {
        R3 r3 = new R3(this.x, this.y, this.z);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        r3.z = this.z * d2 - this.x * d3;
        r3.x = this.z * d3 + this.x * d2;
        return r3;
    }

    public R3 RotZ(double d) {
        R3 r3 = new R3(this.x, this.y, this.z);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        r3.x = this.x * d2 - this.y * d3;
        r3.y = this.x * d3 + this.y * d2;
        return r3;
    }

    public static R3 reflectedRay(R3 r3, R3 r32) {
        R3 r33 = r3.Subtract(r32.ScalarProduct(r3.DotProduct(r32)));
        R3 r34 = r3.Add(r33.ScalarProduct(-2.0));
        double d = r34.Norm();
        if (d != 0.0) {
            return r34.ScalarProduct(1.0 / d);
        }
        return r3.Negative();
    }
}

