var piezas = {
	triang_gr_1: {
		w: 237,
		h: 120,
		fig0: {
			left: 208,
			top: 144,
			rot: 0,
			scaleX: 1
		},
		fig1: {
			left: 218,
			top: 388,
			rot: -45,
			scaleX: 1
		},
		fig2: {
			left: 342,
			top: 258,
			rot: -135,
			scaleX: 1
		},
		fig3: {
			left: 245,
			top: 240,
			rot: -45,
			scaleX: 1
		},
		fig4: {
			left: 300,
			top: 330,
			rot: 0,
			scaleX: 1
		},
		fig5: {
			left: 305,
			top: 210,
			rot: 180,
			scaleX: 1
		},
		fig6: {
			left: 50,
			top: 192,
			rot: 90,
			scaleX: 1
		},
		fig7: {
			left: 190,
			top: 160,
			rot: 0,
			scaleX: 1
		},
		fig8: {
			left: 380,
			top: 310,
			rot: -45,
			scaleX: 1
		},
		fig9: {
			left: 208,
			top: 144,
			rot: 0,
			scaleX: 1
		},
		fig10: {
			left: 208,
			top: 45,
			rot: 0,
			scaleX: 1
		}
	},
	triang_gr_2: {
		w: 119,
		h: 239,
		fig0: {
			left: 206,
			top: 144,
			rot: 0,
			scaleX: 1
		},
		fig1: {
			left: 260,
			top: 198,
			rot: 0,
			scaleX: 1
		},
		fig2: {
			left: 270,
			top: 214,
			rot: 0,
			scaleX: 1
		},
		fig3: {
			left: 218,
			top: 264,
			rot: -135,
			scaleX: 1
		},
		fig4: {
			left: 236,
			top: 292,
			rot: 135,
			scaleX: 1
		},
		fig5: {
			left: 307,
			top: 92,
			rot: 0,
			scaleX: 1
		},
		fig6: {
			left: 315,
			top: 132,
			rot: 0,
			scaleX: 1
		},
		fig7: {
			left: 305,
			top: 164,
			rot: -90,
			scaleX: 1
		},
		fig8: {
			left: 196,
			top: 234,
			rot: -90,
			scaleX: 1
		},
		fig9: {
			left: 206,
			top: 144,
			rot: 0,
			scaleX: 1
		},
		fig10: {
			left: 106,
			top: 144,
			rot: 0,
			scaleX: 1
		}
	},
	triang_med: {
		w: 118,
		h: 118,
		fig0: {
			left: 327,
			top: 265,
			rot: 0,
			scaleX: 1
		},
		fig1: {
			left: 200,
			top: 223,
			rot: 135,
			scaleX: 1
		},
		fig2: {
			left: 357,
			top: 215,
			rot: -135,
			scaleX: 1
		},
		fig3: {
			left: 236,
			top: 391,
			rot: 0,
			scaleX: 1
		},
		fig4: {
			left: 195,
			top: 305,
			rot: 135,
			scaleX: 1
		},
		fig5: {
			left: 300,
			top: 300,
			rot: 45,
			scaleX: 1
		},
		fig6: {
			left: 457,
			top: 192,
			rot: 135,
			scaleX: 1
		},
		fig7: {
			left: 246,
			top: 344,
			rot: 180,
			scaleX: 1
		},
		fig8: {
			left: 450,
			top: 100,
			rot: -120,
			scaleX: 1
		},
		fig9: {
			left: 327,
			top: 265,
			rot: 0,
			scaleX: 1
		},
		fig10: {
			left: 427,
			top: 365,
			rot: 0,
			scaleX: 1
		}
	},
	triang_pq_1: {
		w: 121,
		h: 60,
		fig0: {
			left: 266,
			top: 264,
			rot: 0,
			scaleX: 1
		},
		fig1: {
			left: 140,
			top: 74,
			rot: 90,
			scaleX: 1
		},
		fig2: {
			left: 150,
			top: 100,
			rot: 180,
			scaleX: 1
		},
		fig3: {
			left: 325,
			top: 422,
			rot: 90,
			scaleX: 1
		},
		fig4: {
			left: 150,
			top: 100,
			rot: 135,
			scaleX: 1
		},
		fig5: {
			left: 120,
			top: 280,
			rot: 135,
			scaleX: 1
		},
		fig6: {
			left: 233,
			top: 326,
			rot: 135,
			scaleX: 1
		},
		fig7: {
			left: 211,
			top: 445,
			rot: 135,
			scaleX: 1
		},
		fig8: {
			left: 80,
			top: 410,
			rot: 180,
			scaleX: 1
		},
		fig9: {
			left: 266,
			top: 264,
			rot: 0,
			scaleX: 1
		},
		fig10: {
			left: 266,
			top: 314,
			rot: 0,
			scaleX: 1
		}
	},
	triang_pq_2: {
		w: 60,
		h: 119,
		fig0: {
			left: 385,
			top: 144,
			rot: 0,
			scaleX: 1
		},
		fig1: {
			left: 233,
			top: 46,
			rot: 0,
			scaleX: 1
		},
		fig2: {
			left: 210,
			top: 100,
			rot: 0,
			scaleX: 1
		},
		fig3: {
			left: 405,
			top: 300,
			rot: 180,
			scaleX: 1
		},
		fig4: {
			left: 170,
			top: 248,
			rot: 180,
			scaleX: 1
		},
		fig5: {
			left: 230,
			top: 170,
			rot: -135,
			scaleX: 1
		},
		fig6: {
			left: 220,
			top: 173,
			rot: 45,
			scaleX: 1
		},
		fig7: {
			left: 530,
			top: 352,
			rot: 135,
			scaleX: 1
		},
		fig8: {
			left: 328,
			top: 381,
			rot: -90,
			scaleX: 1
		},
		fig9: {
			left: 385,
			top: 144,
			rot: 0,
			scaleX: 1
		},
		fig10: {
			left: 485,
			top: 144,
			rot: 0,
			scaleX: 1
		}
	},
	cuadrado: {
		w: 119,
		h: 120,
		fig0: {
			left: 325,
			top: 204,
			rot: 0,
			scaleX: 1
		},
		fig1: {
			left: 171,
			top: 104,
			rot: 0,
			scaleX: 1
		},
		fig2: {
			left: 270,
			top: 153,
			rot: 0,
			scaleX: 1
		},
		fig3: {
			left: 390,
			top: 100,
			rot: 45,
			scaleX: 1
		},
		fig4: {
			left: 169,
			top: 188,
			rot: 0,
			scaleX: 1
		},
		fig5: {
			left: 180,
			top: 230,
			rot: 45,
			scaleX: 1
		},
		fig6: {
			left: 213,
			top: 110,
			rot: 45,
			scaleX: 1
		},
		fig7: {
			left: 250,
			top: 40,
			rot: 0,
			scaleX: 1
		},
		fig8: {
			left: 430,
			top: 144,
			rot: 60,
			scaleX: 1
		},
		fig9: {
			left: 325,
			top: 204,
			rot: 0,
			scaleX: 1
		},
		fig10: {
			left: 340,
			top: 220,
			rot: 0,
			scaleX: 1
		}
	},
	paralelograma: {
		w: 178,
		h: 58,
		fig0: {
			left: 208,
			top: 325,
			rot: 0,
			scaleX: 1
		},
		fig1: {
			left: 379,
			top: 431,
			rot: 0,
			scaleX: 1
		},
		fig2: {
			left: 152,
			top: 221,
			rot: 90,
			scaleX: 1
		},
		fig3: {
			left: 300,
			top: 47,
			rot: -135,
			scaleX: 1
		},
		fig4: {
			left: 170,
			top: 127,
			rot: 90,
			scaleX: 1
		},
		fig5: {
			left: 188,
			top: 372,
			rot: -135,
			scaleX: 1
		},
		fig6: {
			left: 183,
			top: 265,
			rot: 135,
			scaleX: 1
		},
		fig7: {
			left: 365,
			top: 356,
			rot: 45,
			scaleX: 1
		},
		fig8: {
			left: 360,
			top: 410,
			rot: 0,
			scaleX: 1
		},
		fig9: {
			left: 208,
			top: 325,
			rot: 0,
			scaleX: 1
		},
		fig10: {
			left: 208,
			top: 425,
			rot: 0,
			scaleX: 1
		}
	}
}

function Animacion(piezas,id){
	
	this.piezas = $.extend({}, piezas);
	this.mwId = id;
	this.numFig = 0;
	/* fig9 = cuadrado sin bts
	  fig10 = piezas separadas sin bts */
	this.totFigs = 8;
	this.inicio = true;
}

Animacion.prototype = {
	
		init:function(){
			
			var _this = this;
			
			this.overlay = $('.js-overlay').addClass('e-oculto');
		    
			/*$('.js-btn-instr').on('click', function(){
				$('.js-instrucciones').removeClass('e-oculto');
				_this.overlay.removeClass('e-oculto');
			});*/
	    
		    
			// init windows
			var vntns = $('.vntn').addClass('e-oculto');
			var vntnsNumber = vntns.length;
		    
		    
			for(var i=0; i<vntnsNumber; i++){
			    
			    var vtn = $(vntns.get(i));

			    var closeBtn = $('<button class="vntn--btn-cerrar">X</button>');
			    closeBtn.on('click', function(){
				    var vtn = $(this).closest('.vntn');
				    
				    vtn.addClass('e-oculto');
				    
				    _this.overlay.addClass('e-oculto');  
			    });
			    vtn.append(closeBtn);
			    
			}
			
			this.buildPiezas();
		    
		},
		
		activate: function(){
			$('.js-btn-ant').removeClass('e-oculto');
			$('.js-btn-sig').removeClass('e-oculto');
			this.activarBtSig();	
		},
		
		activarBtSig: function(){
			var _this = this;
			$('.js-btn-sig').on('click', function(){
				_this.numFig++;
				_this.showFigura();
				if(_this.numFig==8){
					$(this).off();
					$(this).addClass('e-inactivo');
					if(_this.inicio){
						_this.inicio = false;
						_this.gotoNextQuestion(2500);
						_this.addMwSettings('inicio','false');
					}
				}
				if($('.js-btn-ant').hasClass('e-inactivo')){
					$('.js-btn-ant').removeClass('e-inactivo');
					_this.activarBtAnt();
				}
			});
		},
		
		activarBtAnt: function(){
			var _this = this;
			$('.js-btn-ant').on('click', function(){
				_this.numFig--;
				_this.showFigura();
				if(_this.numFig==0){
					$(this).off();
					$(this).addClass('e-inactivo');
				}
				if($('.js-btn-sig').hasClass('e-inactivo')){
					$('.js-btn-sig').removeClass('e-inactivo');
					_this.activarBtSig();
				}
			});
			
		},
		
		buildPiezas: function(){
			
			var $marco = $("<img>", {
				class: 'marco',
				src:  'img/marco.jpg'
			});
			$('.content').append($marco);
			
			for(var pieza in this.piezas){
				var left = this.piezas[pieza]['fig0']['left'];
				var top = this.piezas[pieza]['fig0']['top'];
				var w = this.piezas[pieza]['w'];
				var h = this.piezas[pieza]['h'];
				var coorStr = 'top : ' + top + 'px ; left: ' + left + 'px;';
				var dimStr = 'width: ' + w + 'px ; height: ' + h + 'px ;';
				var bckgrdStr = 'background-image : url("img/' + pieza + '.png")';
				
				var $pieza = $("<div>", {
					id: pieza,
					class: 'pieza',
					style:  coorStr + dimStr + bckgrdStr
				});
				$('.content').append($pieza);
			}
		},
		
		
		showFigura: function(){
			for(var pieza in this.piezas){
				var key = 'fig'+this.numFig;
				var left = this.piezas[pieza][key]['left'];
				var top = this.piezas[pieza][key]['top'];
				var rot = this.piezas[pieza][key]['rot'];
				
				$('#'+pieza).css( {
					'top' : top,
					'left': left,
					'-ms-transform': 'rotate('+rot+'deg)',
					'-webkit-transform': 'rotate('+rot+'deg)',
					'transform': 'rotate('+rot+'deg)'
				});
				
				var scaleX = this.piezas[pieza][key]['scaleX'];
				if(scaleX!=1){
					$('#'+pieza).css( {
						'-webkit-transform': 'scaleX('+scaleX+')',
						'transform': 'scaleX('+scaleX+')'
					});
				}
			}
			if(!$('.marco').hasClass('e-oculto')){
				$('.marco').addClass('e-oculto');
			}
		},
		
		/** mensajes a chat **/
		
		setAnswer: function(str){
			var padre = window.parent;
			var mensajeTipoSet = { command: "setAnswer", params: {id: this.mwId, value: str } };
			padre.postMessage(mensajeTipoSet, "*");	
		},
		
		showTutorIntervention: function(text,emotion){
			var padre = window.parent;
			var mensajeTipoSet = { command: "showTutorIntervention", params: {id: this.mwId , text: text, emotion: emotion } };
			padre.postMessage(mensajeTipoSet, "*");	
		},
		
		gotoNextQuestion: function(delay){
			setTimeout(function(){
				var padre = window.parent;
				var mensajeTipoSet = { command: "gotoNextQuestion", params: {id: this.mwId } };
				padre.postMessage(mensajeTipoSet, "*");	
			},delay);
		},
		
		addMwSettings: function(name,value){
			//alert('setting name: '+name+'& value: '+value);
			var padre = window.parent;
			var mensajeTipoSet = { command: "addMicroworldSettings", params: {id: this.mwId, name: name, value: value } };
			padre.postMessage(mensajeTipoSet, "*");	
		},
		
		disableChat: function(){
			var mensajeTipoSet = {
				command: "disableChat", 
				params: { 
					id: this.mwId
				}
			};
			var padre = window.parent;
			padre.postMessage(mensajeTipoSet, "*");
		}
		

};

var mwId = 'cap1_tangrama';
var animacion = new Animacion(piezas,mwId);

$(document).ready(function(){
	
	animacion.init();
	
	var padre = window.parent;
	var mensajeTipoSet = { command: "microWorldReady", params: {id: mwId } };
	padre.postMessage(mensajeTipoSet, "*");	
});

window.addEventListener("message", receiveMessage, false);

function receiveMessage(evt) {
	// mensaje tipo set
	if (evt.data && evt.data.type === "set") {
		if(evt.data.name=="activar"){
			if(evt.data.value==1){
				//animacion.disableChat();
				animacion.activate();
			}
		} else
		if(evt.data.name=="figura"){
			animacion.numFig=evt.data.value;
			animacion.showFigura();
			if(animacion.numFig>8){
				//cuadrado y piezas separadas sin bts
				$('.js-btn-ant').off();
				$('.js-btn-ant').addClass('e-inactivo');
				$('.js-btn-ant').addClass('e-oculto');
				$('.js-btn-sig').off();
				$('.js-btn-sig').addClass('e-oculto');
			} else if(animacion.numFig==0){
				$('.js-btn-ant').off();
				$('.js-btn-ant').addClass('e-inactivo');
			} else if(animacion.numFig==8){
				$('.js-btn-sig').off();
				$('.js-btn-sig').addClass('e-inactivo');
			}
			//animacion.gotoNextQuestion(2000);
		} else
		if(evt.data.name=="desdeInicio"){
			animacion.numFig=0;
			$('.js-btn-ant').removeClass('e-oculto');
			$('.js-btn-sig').removeClass('e-oculto e-inactivo');
			animacion.activarBtSig();
		} else
		if(evt.data.name=="inicio"){
			if(evt.data.value == 0 && animacion.inicio){
				animacion.inicio = false;
				animacion.addMwSettings('inicio','false');
			}
		} else
		/* FUNCIN DE CAJN PARA TODOS LOS MMS CON INTERACTIVIDAD QUE SE TENGA QUE RECUPERAR
		  EVT.DATA.VALUE = '' AL INICIAR A PARTIR DE UN CAPTULO
		  EVT.DATA.VALUE = STRING CON NAME-VALUE PAIRS AL HABER HISTORIAL LOCALSTORAGE*/
		if(evt.data.name=="mwReconstruction"){
			if(evt.data.value=='default'){
				//lo que se tenga que hacer por omisin / sin info especfica del localstorage
				// Sucede cuando se inicia desde un captulo determinado y el micromundo debe encontrarse en cierto estado
				animacion.activate();
				
			} else {
				var arrPairs = evt.data.value.split(',');
				for(var i=0;i<arrPairs.length;i++){
					var pair = arrPairs[i].split(':');
					if(pair[0]=='inicio' && pair[1]=='false'){
						animacion.inicio = false;
						//alert('inicio false');
					}
				}
				
			}
			//esto SIEMPRE debe ir
			var padre = window.parent;
			var mensajeTipoSet = { command: "mwReconstructed", params: {id: mwId } };
			padre.postMessage(mensajeTipoSet, "*");	
		} 
	}
}
