/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descartes;

import com.mja.descartes.Descartes;
import com.mja.descartes.Space;
import com.mja.descartes.graphR3Config;
import com.mja.descartes.parametrization;
import com.mja.descartes.spaceConfig;
import com.mja.gui.mjaColor;
import com.mja.lang.data;
import com.mja.lang.translator;
import com.mja.math.R2;
import com.mja.math3D.LinearTransformation;
import com.mja.math3D.R3;
import com.mja.parser.Node;
import com.mja.poly.Surface;
import com.mja.poly.SurfaceFactory;
import com.mja.poly.mjaSurface;
import com.mja.poly.viewR3;
import com.mja.text.MathText;
import com.mja.util.BasicStr;
import com.mja.util.TFont;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Vector;

public class SpaceR3
extends Space
implements Runnable {
    static final mjaColor dfc = new mjaColor(Color.white);
    static final mjaColor dbc = new mjaColor(Color.pink);
    static final double oneDegree = Math.PI / 180;
    private mjaSurface[][] pS;
    private Vector text;
    private Vector text_par;
    private Vector tx;
    private Vector ty;
    private Vector tfont;
    private Vector tcol;
    private Vector tcond;
    private Surface Poly;
    private viewR3 view;
    private R3 rot;
    private R3 vr = new R3(0.0, 0.0, 0.0);
    private Graphics[] bga = new Graphics[0];
    private Graphics[] fga = new Graphics[1];
    static final int sortAndPaint = 0;
    static final int painterAlgorithm = 1;
    static final int rayTracing = 2;
    private int renderMethod;
    private Node NRotx;
    private Node NRoty;
    private Node NRotz;
    private Node Ndepth;
    private Node NUIx;
    private Node NUIy;
    private Node NUIz;
    private Node NUIdim;
    private Node NUIInt;
    private parametrization[] par;
    private boolean allFixed;
    private LinearTransformation SR = SpaceR3.R3SpaceRotation(new R3(0.0, 0.0, 0.0));
    boolean dragEnhanced = false;

    public SpaceR3(Descartes descartes, spaceConfig spaceConfig2) {
        super(descartes, spaceConfig2);
        this.initUI();
    }

    public SpaceR3(Descartes descartes, int n) {
        super(descartes, n);
        this.initUI();
        this.renderMethod = 0;
    }

    void initUI() {
        String string = this.spcfg.prefix() + "userIlum.dim";
        if (!this.D.p.isVar(string)) {
            this.D.p.Var(string).setDouble(1.0);
        }
        this.NUIdim = this.D.p.Var(string);
        this.NUIx = this.D.p.Var(this.spcfg.prefix() + "userIlum.x");
        this.NUIy = this.D.p.Var(this.spcfg.prefix() + "userIlum.y");
        this.NUIz = this.D.p.Var(this.spcfg.prefix() + "userIlum.z");
        this.NUIInt = this.D.p.Var(this.spcfg.prefix() + "userIlum.I");
    }

    @Override
    void getSpaceParameters(Dimension dimension) {
        double d;
        super.getSpaceParameters(dimension);
        String string = this.spcfg.prefix() + "observador";
        d = this.D.p.isVar(string) || this.D.p.isAux(string) ? ((d = this.D.p.rvalue(string)) < 0.25 * (double)(this.w + this.h) ? 2.5 * (double)(this.w + this.h) : d) : 2.5 * (double)(this.w + this.h);
        this.Ndepth = this.D.p.Var(string);
        this.Ndepth.setDouble(this.correctedDepth(d));
        this.view = new viewR3(this.Ox, this.Oy, this.Ndepth.getDouble(), this.Nesc.getDouble());
        this.NRotx = this.D.p.Var(this.spcfg.prefix() + "rot.x");
        this.NRoty = this.D.p.Var(this.spcfg.prefix() + "rot.y");
        this.NRotz = this.D.p.Var(this.spcfg.prefix() + "rot.z");
        this.rot = new R3(this.NRotx.getDouble(), this.NRoty.getDouble(), this.NRotz.getDouble());
    }

    @Override
    public void start() {
        if (this.isVisible()) {
            super.start();
            this.pS = new mjaSurface[this.D.cfg.allgR3c.length][1];
            this.tx = new Vector();
            this.ty = new Vector();
            this.text = new Vector();
            this.text_par = new Vector();
            this.tfont = new Vector();
            this.tcol = new Vector();
            this.tcond = new Vector();
            this.par = new parametrization[this.pS.length];
            for (int i = 0; i < this.pS.length; ++i) {
                Object object;
                Object object2;
                int n;
                graphR3Config graphR3Config2 = this.D.cfg.allgR3c[i];
                if (graphR3Config2 == null || graphR3Config2.s_value == null || graphR3Config2.s_value[graphR3Config.space] == null || !graphR3Config2.s_value[graphR3Config.space].equals(this.spcfg.getName())) continue;
                this.par[i] = new parametrization(this.D.p, "s", "[0,0]", "0");
                double d = this.par[i].Np.getDouble();
                if (graphR3Config2.isFamily) {
                    this.par[i] = new parametrization(this.D.p, graphR3Config2.s_value[graphR3Config.ixf_parameter], graphR3Config2.s_value[graphR3Config.ixf_interval], graphR3Config2.s_value[graphR3Config.ixf_steps]);
                    this.par[i].Np.setDouble(this.par[i].Ni.Evaluate(0.0));
                }
                double d2 = this.par[i].Ni.Evaluate(0.0);
                double d3 = this.par[i].Nf.Evaluate(1.0);
                int n2 = (int)Math.round(this.par[i].NN.Evaluate(0.0));
                translator cfr_ignored_0 = this.D.Tr;
                if (translator.equals(graphR3Config2.s_value[graphR3Config.type], 63)) {
                    for (n = 0; n <= n2; ++n) {
                        this.par[i].Np.setDouble(d2 + (double)n * (d3 - d2) / (double)n2);
                        try {
                            object2 = BasicStr.getTokens(graphR3Config2.s_value[graphR3Config.expr]);
                            this.tx.addElement(this.D.p.Analyse(object2[0]));
                            this.ty.addElement(this.D.p.Analyse(object2[1]));
                            object = this.D.Tr.parseColor(graphR3Config2.s_value[graphR3Config.color], new mjaColor(Color.gray), null);
                            translator cfr_ignored_1 = this.D.Tr;
                            MathText mathText = new MathText(this.D.p, this.D.Tr, graphR3Config2.s_value[graphR3Config.text], this.D.p.Analyse(graphR3Config2.s_value[graphR3Config.dec], 2.0), translator.isNotFalse(graphR3Config2.s_value[graphR3Config.fixed]), graphR3Config2.font, ((mjaColor)object).getAdaptedColor());
                            this.text.addElement(mathText);
                            this.text_par.addElement(this.par[i]);
                            this.tfont.addElement(graphR3Config2.font);
                            ((mjaColor)object).analyse(this.D.p);
                            this.tcol.addElement(object);
                            this.tcond.addElement(this.D.p.Analyse(graphR3Config2.getCondition(), 1.0));
                            continue;
                        }
                        catch (Exception exception) {
                            System.out.println("bad expression " + graphR3Config2.s_value[graphR3Config.expr]);
                        }
                    }
                    continue;
                }
                this.pS[i] = new mjaSurface[n2 + 1];
                for (n = 0; n <= n2; ++n) {
                    this.par[i].Np.setDouble(d2 + (double)n * (d3 - d2) / (double)n2);
                    translator cfr_ignored_2 = this.D.Tr;
                    translator cfr_ignored_3 = this.D.Tr;
                    this.pS[i][n] = SurfaceFactory.getMjaSurface(this.D.p, SpaceR3.canonicType(this.D.Tr, graphR3Config2.s_value[graphR3Config.type]), graphR3Config2.s_value[graphR3Config.expr], graphR3Config2.s_value[graphR3Config.Nu], graphR3Config2.s_value[graphR3Config.Nv], graphR3Config2.s_value[graphR3Config.grueso], graphR3Config2.s_value[graphR3Config.ancho], graphR3Config2.s_value[graphR3Config.largo], graphR3Config2.s_value[graphR3Config.alto], this.D.Tr.parseColor(graphR3Config2.s_value[graphR3Config.color], dfc, null), this.D.Tr.parseColor(graphR3Config2.s_value[graphR3Config.backColor], dbc, null), translator.isNotFalse(graphR3Config2.s_value[graphR3Config.edges]), graphR3Config2.s_value[graphR3Config.inirot], graphR3Config2.s_value[graphR3Config.inipos], graphR3Config2.s_value[graphR3Config.finrot], graphR3Config2.s_value[graphR3Config.finpos], graphR3Config2.s_value[graphR3Config.rotation], graphR3Config2.s_value[graphR3Config.location], SpaceR3.getModel(this.D.Tr, graphR3Config2.s_value[graphR3Config.model]), graphR3Config2.s_value[graphR3Config.ixcond], translator.isTrue(graphR3Config2.s_value[graphR3Config.ixbackground]));
                    translator cfr_ignored_4 = this.D.Tr;
                    this.pS[i][n].split = translator.isTrue(graphR3Config2.s_value[graphR3Config.split]);
                    translator cfr_ignored_5 = this.D.Tr;
                    if (!translator.equals(graphR3Config2.s_value[graphR3Config.type], 64)) continue;
                    try {
                        object2 = this.D.Tr.parseColor(graphR3Config2.s_value[graphR3Config.color], new mjaColor(Color.gray), null);
                        translator cfr_ignored_6 = this.D.Tr;
                        object = new MathText(this.D.p, this.D.Tr, graphR3Config2.s_value[graphR3Config.text], this.D.p.Analyse(graphR3Config2.s_value[graphR3Config.dec], 2.0), translator.isNotFalse(graphR3Config2.s_value[graphR3Config.fixed]), graphR3Config2.font, ((mjaColor)object2).getAdaptedColor());
                        this.pS[i][n].setMathText((MathText)object);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("bad expression " + graphR3Config2.s_value[graphR3Config.expr]);
                    }
                }
                this.par[i].Np.setDouble(d);
            }
            translator cfr_ignored_7 = this.D.Tr;
            if (translator.equals(this.spcfg.s_value[21], 173)) {
                this.renderMethod = 1;
            } else {
                translator cfr_ignored_8 = this.D.Tr;
                this.renderMethod = translator.equals(this.spcfg.s_value[21], 174) ? 2 : 0;
            }
            this.fga[0] = this.gmain;
            this.thr = new Thread(this);
            this.thr.setPriority(1);
            this.thr.start();
        }
    }

    @Override
    public void run() {
        this.updateSpace(true, false);
        if (this.main != null) {
            this.paintSpace();
        }
        this.pleaseStop = false;
        try {
            while (!this.pleaseStop()) {
                Thread.sleep(50L);
                if (!this.isMoving() || this.isDragging()) continue;
                this.moveOneStep();
                this.D.updateTextFieldsFromNodes(false);
                if (this.isStopping()) continue;
                this.updateSpace(false, false);
                if (this.main == null) continue;
                this.paintSpace();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.thr = null;
    }

    @Override
    protected R2 injection(double d, double d2) {
        this.view.setView(this.Ox, this.Oy, this.view.getDepth());
        R3 r3 = this.view.getView();
        return new R2((d - r3.x) / this.view.getScale(), (r3.y - d2) / this.view.getScale());
    }

    @Override
    protected R2 projection(R2 r2) {
        this.view.setView(this.Ox, this.Oy, this.view.getDepth());
        R3 r3 = this.view.getView();
        return new R2(r3.x + this.view.getScale() * r2.x, r3.y - this.view.getScale() * r2.y);
    }

    @Override
    protected void flushImages() {
    }

    @Override
    protected void stopMoving() {
        this.vr.x = 0.0;
        this.vr.y = 0.0;
        this.vr.z = 0.0;
    }

    @Override
    protected boolean isMoving() {
        return this.vr.x != 0.0 || this.vr.y != 0.0 || this.vr.z != 0.0;
    }

    private void drawTexts() {
        if (this.text != null) {
            for (int i = 0; i < this.text.size(); ++i) {
                parametrization parametrization2 = (parametrization)this.text_par.elementAt(i);
                double d = parametrization2.Np.getDouble();
                double d2 = parametrization2.Ni.Evaluate(0.0);
                double d3 = parametrization2.Nf.Evaluate(1.0);
                int n = (int)Math.round(parametrization2.NN.Evaluate(0.0));
                for (int j = 0; j <= n; ++j) {
                    parametrization2.Np.setDouble(d2 + (double)j * (d3 - d2) / (double)n);
                    Node node = (Node)this.tcond.elementAt(i);
                    if (!(node.Evaluate(1.0) > 0.0)) continue;
                    mjaColor mjaColor3 = (mjaColor)this.tcol.elementAt(i);
                    this.gmain.setColor(mjaColor3.getAdaptedColor());
                    MathText mathText = (MathText)this.text.elementAt(i);
                    Node node2 = (Node)this.tx.elementAt(i);
                    Node node3 = (Node)this.ty.elementAt(i);
                    int n2 = (int)Math.round(node2.Evaluate(20.0));
                    int n3 = (int)Math.round(node3.Evaluate(20.0));
                    Font font = (Font)this.tfont.elementAt(i);
                    this.gmain.setFont(font);
                    TFont tFont = new TFont(font);
                    Graphics[] graphicsArray = new Graphics[]{this.gmain};
                    R2 r2 = new R2(n2, n3 - tFont.getAscent());
                    mathText.draw((Component)this, r2.ix(), r2.iy(), graphicsArray);
                }
                parametrization2.Np.setDouble(d);
            }
        }
    }

    @Override
    protected synchronized void doCalc() {
        if (!this.allFixed) {
            this.Poly = null;
            Surface surface = null;
            this.allFixed = true;
            for (int i = 0; i < this.pS.length; ++i) {
                int n;
                if (this.par[i] == null || this.par[i].Np == null || this.D.cfg == null || this.D.cfg.allgR3c[i] == null) continue;
                double d = this.par[i].Np.getDouble();
                double d2 = this.par[i].Ni.Evaluate(0.0);
                double d3 = this.par[i].Nf.Evaluate(1.0);
                graphR3Config graphR3Config2 = this.D.cfg.allgR3c[i];
                translator cfr_ignored_0 = this.D.Tr;
                if (!translator.equals(graphR3Config2.s_value[graphR3Config.type], 63) && (n = (int)Math.round(this.par[i].NN.Evaluate(0.0))) + 1 != this.pS[i].length && graphR3Config2.s_value[graphR3Config.space].equals(this.spcfg.getName())) {
                    this.pS[i] = new mjaSurface[n + 1];
                    for (int j = 0; j <= n; ++j) {
                        this.par[i].Np.setDouble(d2 + (double)j * (d3 - d2) / (double)n);
                        translator cfr_ignored_1 = this.D.Tr;
                        translator cfr_ignored_2 = this.D.Tr;
                        this.pS[i][j] = SurfaceFactory.getMjaSurface(this.D.p, SpaceR3.canonicType(this.D.Tr, graphR3Config2.s_value[graphR3Config.type]), graphR3Config2.s_value[graphR3Config.expr], graphR3Config2.s_value[graphR3Config.Nu], graphR3Config2.s_value[graphR3Config.Nv], graphR3Config2.s_value[graphR3Config.grueso], graphR3Config2.s_value[graphR3Config.ancho], graphR3Config2.s_value[graphR3Config.largo], graphR3Config2.s_value[graphR3Config.alto], this.D.Tr.parseColor(graphR3Config2.s_value[graphR3Config.color], dfc, null), this.D.Tr.parseColor(graphR3Config2.s_value[graphR3Config.backColor], dbc, null), translator.isNotFalse(graphR3Config2.s_value[graphR3Config.edges]), graphR3Config2.s_value[graphR3Config.inirot], graphR3Config2.s_value[graphR3Config.inipos], graphR3Config2.s_value[graphR3Config.finrot], graphR3Config2.s_value[graphR3Config.finpos], graphR3Config2.s_value[graphR3Config.rotation], graphR3Config2.s_value[graphR3Config.location], SpaceR3.getModel(this.D.Tr, graphR3Config2.s_value[graphR3Config.model]), graphR3Config2.s_value[graphR3Config.ixcond], translator.isTrue(graphR3Config2.s_value[graphR3Config.ixbackground]));
                        translator cfr_ignored_3 = this.D.Tr;
                        this.pS[i][j].split = translator.isTrue(graphR3Config2.s_value[graphR3Config.split]);
                        translator cfr_ignored_4 = this.D.Tr;
                        if (!translator.equals(graphR3Config2.s_value[graphR3Config.type], 64)) continue;
                        try {
                            mjaColor mjaColor3 = this.D.Tr.parseColor(graphR3Config2.s_value[graphR3Config.color], new mjaColor(Color.gray), null);
                            translator cfr_ignored_5 = this.D.Tr;
                            MathText mathText = new MathText(this.D.p, this.D.Tr, graphR3Config2.s_value[graphR3Config.text], this.D.p.Analyse(graphR3Config2.s_value[graphR3Config.dec], 2.0), translator.isNotFalse(graphR3Config2.s_value[graphR3Config.fixed]), graphR3Config2.font, mjaColor3.getAdaptedColor());
                            this.pS[i][j].setMathText(mathText);
                            continue;
                        }
                        catch (Exception exception) {
                            System.out.println("bad expression " + graphR3Config2.s_value[graphR3Config.expr]);
                        }
                    }
                }
                for (n = 0; n < this.pS[i].length; ++n) {
                    if (this.pS[i][n] == null) continue;
                    this.par[i].Np.setDouble(d2 + (double)n * (d3 - d2) / (double)(this.pS[i].length - 1));
                    this.allFixed &= this.pS[i][n].isFixed();
                    if (!(this.pS[i][n].cond.Evaluate(1.0) > 0.0)) continue;
                    Surface surface2 = this.pS[i][n].create();
                    surface2.setSNode(this.par[i].Np);
                    surface2.setSValue(this.par[i].Np.getDouble());
                    if (surface2 == null) continue;
                    if (this.spcfg.split || this.pS[i][n].split) {
                        if (surface != null) {
                            surface2 = surface.split(surface2);
                        }
                        surface = Surface.add(surface, surface2);
                        continue;
                    }
                    this.Poly = Surface.add(this.Poly, surface2);
                }
                this.par[i].Np.setDouble(d);
            }
            this.Poly = this.Poly != null ? Surface.add(this.Poly, surface) : surface;
        }
    }

    @Override
    protected synchronized void doFront(boolean bl) {
        if (this.isVisible()) {
            this.correctScale();
            this.view.setView(this.Ox, this.Oy, this.view.getDepth());
            this.view.setScale(this.Nesc.getDouble());
            this.Ndepth.setDouble(this.correctedDepth(this.Ndepth.getDouble()));
            this.view.setDepth(this.Ndepth.getDouble());
            this.prepareMainImage();
            this.drawTexts();
            this.adjustControls();
            if (bl) {
                this.doCalc();
            }
            if (this.Poly != null) {
                this.Poly.setUserLightPos((int)this.NUIx.getDouble(), (int)this.NUIy.getDouble(), (int)this.NUIz.getDouble());
                this.Poly.setUserIllumination(this.NUIdim.getDouble(), this.NUIInt.getDouble());
                this.Poly.resetInitialPosition();
                try {
                    if (this.dragEnhanced) {
                        this.SR = LinearTransformation.Multiply(SpaceR3.R3SpaceRotation(this.vr), this.SR);
                        this.Poly.apply(this.SR);
                    } else {
                        this.Poly.resetInitialPosition();
                        this.rot.x = this.NRotx.getDouble() * Math.PI / 180.0;
                        this.rot.y = this.NRoty.getDouble() * Math.PI / 180.0;
                        this.rot.z = this.NRotz.getDouble() * Math.PI / 180.0;
                        this.Poly.apply(SpaceR3.R3SpaceRotation(this.rot));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.Poly.updateView(this.view);
                Graphics2D graphics2D = this.gmain;
                if (BasicStr.antialias) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                    graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                if (this.renderMethod == 0) {
                    this.Poly.sortAndPaint(this.D, graphics2D);
                } else if (this.renderMethod == 1) {
                    this.Poly.painterAlgorithm(this.D, graphics2D);
                } else if (this.renderMethod == 2) {
                    this.Poly.rayTrace(this.D, graphics2D, this.w, this.h);
                }
                if (BasicStr.antialias) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                    graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
                    graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT);
                    graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
            }
            this.drawBackControls();
            super.doFront(bl);
        }
    }

    private synchronized void moveOneStep() {
        if (!this.dragEnhanced) {
            this.NRotx.setDouble(this.NRotx.getDouble() + this.vr.x * 180.0 / Math.PI);
            this.NRoty.setDouble(this.NRoty.getDouble() + this.vr.y * 180.0 / Math.PI);
            this.NRotz.setDouble(this.NRotz.getDouble() + this.vr.z * 180.0 / Math.PI);
        }
    }

    double correctedDepth(double d) {
        return Math.max(d, 0.25 * (double)(this.w + this.h));
    }

    @Override
    protected boolean onDrag(boolean bl, int n, int n2) {
        if (bl) {
            this.Nesc.setDouble(this.Nesc.getDouble() * ((double)this.h - (double)n2) / (double)this.h);
            this.correctScale();
            this.view.setScale(this.Nesc.getDouble());
            this.Ndepth.setDouble(this.correctedDepth(this.Ndepth.getDouble() * ((double)this.w + (double)n) / (double)this.w));
            this.view.setView(this.Ox, this.Oy, this.Ndepth.getDouble());
            this.D.updateTextFieldsFromNodes();
            return this.backColor.variable();
        }
        if (n * n + n2 * n2 > 0) {
            this.vr.x = 0.0;
            this.vr.y = (double)n2 * (Math.PI / 180) / 2.0;
            this.vr.z = (double)n * (Math.PI / 180) / 2.0;
            this.moveOneStep();
            return true;
        }
        return false;
    }

    @Override
    protected void writeCoordinates(Graphics graphics, int n, int n2) {
    }

    private static LinearTransformation R3SpaceRotation(R3 r3) {
        LinearTransformation linearTransformation = LinearTransformation.Rotation(1, r3.y);
        LinearTransformation linearTransformation2 = LinearTransformation.Rotation(2, r3.z);
        return LinearTransformation.Multiply(linearTransformation, linearTransformation2);
    }

    public static String canonicType(translator translator2, String string) {
        for (int i = 0; i < data.gtR3ix.length; ++i) {
            if (!translator.equals(string, data.gtR3ix[i])) continue;
            return translator2.getTr(data.gtR3ix[i], 1);
        }
        return string;
    }

    static int getModel(translator translator2, String string) {
        if (translator.equals(string, 167)) {
            return 1;
        }
        if (translator.equals(string, 168)) {
            return 2;
        }
        if (translator.equals(string, 169)) {
            return 3;
        }
        return 0;
    }
}

