/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descgui;

import com.mja.descartes.Descartes;
import com.mja.descartes.controlConfig;
import com.mja.descgui.NumericControl;
import com.mja.util.BasicStr;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusListener;
import javax.swing.JScrollBar;

public class ScrollBarControl
extends NumericControl
implements AdjustmentListener,
FocusListener {
    private JScrollBar sb;
    private double value_ant;
    private volatile boolean fireAdjustmentEvent = true;
    private volatile boolean adjust = true;
    private volatile boolean updating = false;
    private double pos_ant = Double.MIN_VALUE;

    public ScrollBarControl(Descartes descartes, controlConfig controlConfig2, String string, String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, boolean bl2, String string8, boolean bl3, String string9, String string10) {
        this.vertical = bl3;
        this.sb = this.vertical ? new JScrollBar(1, 0, 10, 0, 110) : new JScrollBar(0, 0, 10, 0, 110);
        this.init(descartes, controlConfig2, string, string2, string3, bl, string4, string5, string6, string7, bl2, string8, string9, string10);
        this.value_ant = this.getDoubleValue();
        this.TF.addFocusListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        if (this.vertical) {
            int n = 0;
            if (bl2) {
                gridBagConstraints.gridy = n++;
                gridBagConstraints.weighty = 0.05;
                gridBagLayout.setConstraints(this.TF, gridBagConstraints);
                this.add(this.TF);
            }
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weighty = 0.9;
            gridBagLayout.setConstraints(this.sb, gridBagConstraints);
            this.add(this.sb);
            if (BasicStr.hasContent(this.getTitle())) {
                gridBagConstraints.gridy = n++;
                gridBagConstraints.weighty = 0.05;
                gridBagLayout.setConstraints(this.lb, gridBagConstraints);
                this.add(this.lb);
            }
        } else {
            int n = 0;
            gridBagConstraints.insets = new Insets(0, 4, 0, 4);
            if (BasicStr.hasContent(this.getTitle())) {
                gridBagConstraints.gridx = n++;
                gridBagConstraints.weightx = 0.1;
                gridBagLayout.setConstraints(this.lb, gridBagConstraints);
                this.add(this.lb);
            }
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.weightx = 0.6;
            gridBagLayout.setConstraints(this.sb, gridBagConstraints);
            this.add(this.sb);
            if (bl2) {
                gridBagConstraints.gridx = n++;
                gridBagConstraints.weightx = 0.3;
                gridBagLayout.setConstraints(this.TF, gridBagConstraints);
                this.add(this.TF);
            }
        }
        this.updateScrollBarPos();
        this.sb.addAdjustmentListener(this);
        this.sb.addMouseListener(this);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (!this.vertical) {
            int n5;
            this.setLayout(null);
            int n6 = 58;
            int n7 = this.minlbw;
            int n8 = this.minTFw;
            if (!BasicStr.hasContent(this.getTitle())) {
                n7 = 0;
            }
            if (!this.TF.isVisible()) {
                n8 = 0;
            }
            for (n5 = n3 - n8 - n7; n5 < n6 && n7 > 0; --n7, ++n5) {
            }
            while (n5 < n6 && n8 > 0) {
                --n8;
                ++n5;
            }
            int n9 = n7;
            int n10 = n9 + n5;
            n8 = n3 - n10;
            this.lb.setBounds(0, 0, n7, n4);
            this.sb.setBounds(n9, 0, n5, n4);
            this.TF.setBounds(n10, 0, n8, n4);
        }
    }

    @Override
    public void stop() {
    }

    void updateScrollBarPos() {
        double d = this.var.getDouble();
        int n = (int)Math.round(100.0 * (d - this.getMin()) / (this.getMax() - this.getMin()));
        if (this.vertical) {
            n = 100 - n;
        }
        if (this.sb.getValue() != n) {
            this.adjust = false;
            this.fireAdjustmentEvent = false;
            this.sb.setValue(n);
            this.fireAdjustmentEvent = true;
            this.adjust = true;
        }
    }

    @Override
    protected void defineTextValue(String string) {
    }

    @Override
    public void updateVisualComponent() {
        if (this.TF != null && !this.getStringValue().equals(this.TF.getText())) {
            this.TF.setText(this.getStringValue());
            this.var.setDouble(this.getDoubleValue());
        }
        this.updateScrollBarPos();
    }

    private boolean isUpdating() {
        return this.updating;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.isActive() && adjustmentEvent.getSource() == this.sb && this.adjust && adjustmentEvent.getSource() == this.sb) {
            double d = this.sb.getValue();
            if (!this.isUpdating() && d != this.pos_ant) {
                this.updating = true;
                double d2 = d;
                if (this.vertical) {
                    d2 = 100.0 - d2;
                }
                double d3 = this.getMin() + (this.getMax() - this.getMin()) * d2 / 100.0;
                double d4 = BasicStr.minIncr(this.precision());
                if ((d3 = d3 > this.value_ant ? Math.max(d3, this.value_ant + d4) : Math.min(d3, this.value_ant - d4)) != this.var.getDouble()) {
                    this.defineValue(d3);
                    this.D.updateTextFieldsFromNodes();
                    this.executeAction();
                    if (this.fireAdjustmentEvent) {
                        this.callListeners("");
                    }
                }
                this.value_ant = this.getDoubleValue();
                this.pos_ant = d;
                this.updating = false;
            }
        }
    }

    boolean isVertical() {
        return this.vertical;
    }

    @Override
    public boolean isActive() {
        boolean bl = this.activityN.Evaluate(1.0) > 0.0;
        this.sb.setEnabled(bl);
        return super.isActive();
    }

    @Override
    public void locate() {
        if (this.vertical) {
            this.setVisible(this.visibilityN.Evaluate(1.0) > 0.0);
            if (this.isInterior() && this.xN != null && this.yN != null && this.wN != null && this.hN != null) {
                double d = this.wN.Evaluate(100.0);
                double d2 = this.hN.Evaluate(23.0);
                int n = (int)Math.round(this.xN.Evaluate(0.0));
                int n2 = (int)Math.round(this.yN.Evaluate(0.0));
                int n3 = (int)Math.round(d);
                int n4 = (int)Math.round(d2);
                Point point = this.getLocation();
                Dimension dimension = this.getSize();
                if (point.x != n || point.y != n2 || dimension.width != n3 || dimension.height != n4) {
                    this.setBounds(n, n2, n3, n4);
                }
            }
        } else {
            super.locate();
        }
    }
}

